/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import java.util.Properties;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcStreamingToPublicCacheTest
extends GridCommonAbstractTest {
    private static final String BASE_URL = "jdbc:ignite:cfg://cache=%s@modules/clients/src/test/config/jdbc-config.xml";

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        CacheConfiguration cache = JdbcStreamingToPublicCacheTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        cfg.setLocalHost("127.0.0.1");
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        TcpDiscoveryVmIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
        ipFinder.setAddresses(Collections.singleton("127.0.0.1:47500..47501"));
        disco.setIpFinder((TcpDiscoveryIpFinder)ipFinder);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(2);
    }

    private Connection createConnection(String cacheName, boolean streaming) throws Exception {
        Properties props = new Properties();
        if (streaming) {
            props.setProperty("ignite.jdbc.streaming", "true");
            props.setProperty("ignite.jdbc.streamingFlushFrequency", "500");
        }
        return DriverManager.getConnection(String.format(BASE_URL, cacheName), props);
    }

    protected void afterTest() throws Exception {
        this.ignite(0).cache("default").clear();
        super.afterTest();
    }

    @Test
    public void testStreamedInsert() throws Exception {
        try (Connection conn = this.createConnection("default", false);){
            Statement stmt = conn.createStatement();
            stmt.execute("create table PUBLIC.STREAM_TEST (ID int primary key, str_val varchar)");
        }
        conn = this.createConnection("SQL_PUBLIC_STREAM_TEST", true);
        var2_2 = null;
        try {
            PreparedStatement pstmt = conn.prepareStatement("insert into STREAM_TEST(id, str_val) values (?, ?)");
            for (int i = 1; i <= 100; ++i) {
                pstmt.setInt(1, i);
                pstmt.setString(2, "val_" + i);
                pstmt.executeUpdate();
            }
        }
        catch (Throwable pstmt) {
            var2_2 = pstmt;
            throw pstmt;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable pstmt) {
                        var2_2.addSuppressed(pstmt);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = this.createConnection("SQL_PUBLIC_STREAM_TEST", false);
        var2_2 = null;
        try {
            ResultSet rs = conn.createStatement().executeQuery("select id, str_val from STREAM_TEST");
            int cnt = 0;
            while (rs.next()) {
                JdbcStreamingToPublicCacheTest.assertEquals((String)("val_" + rs.getInt(1)), (String)rs.getString(2));
                ++cnt;
            }
            JdbcStreamingToPublicCacheTest.assertEquals((int)100, (int)cnt);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }
}

