/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.BatchUpdateException;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.jdbc2.JdbcAbstractDmlStatementSelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class JdbcStatementBatchingSelfTest
extends JdbcAbstractDmlStatementSelfTest {
    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.jcache(0).clear();
    }

    @Test
    public void testDatabaseMetadataBatchSupportFlag() throws SQLException {
        DatabaseMetaData meta = this.conn.getMetaData();
        JdbcStatementBatchingSelfTest.assertNotNull((Object)meta);
        JdbcStatementBatchingSelfTest.assertTrue((boolean)meta.supportsBatchUpdates());
    }

    @Test
    public void testBatch() throws SQLException {
        try (Statement stmt = this.conn.createStatement();){
            stmt.addBatch("INSERT INTO Person(_key, id, firstName, lastName, age, data) VALUES ('p1', 0, 'J', 'W', 250, RAWTOHEX('W'))");
            stmt.addBatch("MERGE INTO Person(_key, id, firstName, lastName, age, data) VALUES ('p1', 1, 'John', 'White', 25, RAWTOHEX('White')), ('p2', 2, 'Joe', 'Black', 35, RAWTOHEX('Black')), ('p3', 0, 'M', 'G', 4, RAWTOHEX('G'))");
            stmt.addBatch("UPDATE Person SET id = 3, firstName = 'Mike', lastName = 'Green', age = 40, data = RAWTOHEX('Green') WHERE _key = 'p3'");
            stmt.addBatch("DELETE FROM Person WHERE _key = 'p1'");
            int[] res = stmt.executeBatch();
            JdbcStatementBatchingSelfTest.assertEquals((int)4, (int)res.length);
            JdbcStatementBatchingSelfTest.assertEquals((int)1, (int)res[0]);
            JdbcStatementBatchingSelfTest.assertEquals((int)3, (int)res[1]);
            JdbcStatementBatchingSelfTest.assertEquals((int)1, (int)res[2]);
            JdbcStatementBatchingSelfTest.assertEquals((int)1, (int)res[3]);
        }
    }

    @Test
    public void testErrorAmidstBatch() throws SQLException {
        BatchUpdateException reason = (BatchUpdateException)GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try (Statement stmt = JdbcStatementBatchingSelfTest.this.conn.createStatement();){
                    stmt.addBatch("INSERT INTO Person(_key, id, firstName, lastName, age, data) VALUES ('p1', 0, 'J', 'W', 250, RAWTOHEX('W'))");
                    stmt.addBatch("UPDATE Person SET id = 3, firstName = 'Mike', lastName = 'Green', age = 40, data = RAWTOHEX('Green') WHERE _key = 'p3'");
                    stmt.addBatch("SELECT id FROM Person WHERE _key = 'p1'");
                    int[] nArray = stmt.executeBatch();
                    return nArray;
                }
            }
        }, BatchUpdateException.class, (String)"Given statement type does not match that declared by JDBC driver");
        int[] counts = reason.getUpdateCounts();
        JdbcStatementBatchingSelfTest.assertEquals((int)2, (int)counts.length);
        JdbcStatementBatchingSelfTest.assertEquals((int)1, (int)counts[0]);
        JdbcStatementBatchingSelfTest.assertEquals((int)0, (int)counts[1]);
    }

    @Test
    public void testClearBatch() throws Exception {
        try (final Statement stmt = this.conn.createStatement();){
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws SQLException {
                    return stmt.executeBatch();
                }
            }, SQLException.class, (String)"Batch is empty");
            stmt.addBatch("INSERT INTO Person(_key, id, firstName, lastName, age, data) VALUES ('p1', 0, 'J', 'W', 250, RAWTOHEX('W'))");
            stmt.clearBatch();
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws SQLException {
                    return stmt.executeBatch();
                }
            }, SQLException.class, (String)"Batch is empty");
        }
    }
}

