/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.affinity.AffinityKey;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.processors.query.QueryEntityEx;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class JdbcMetadataSelfTest
extends GridCommonAbstractTest {
    private static final String BASE_URL = "jdbc:ignite:cfg://cache=pers@modules/clients/src/test/config/jdbc-config.xml";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        LinkedHashMap<String, Boolean> persFields = new LinkedHashMap<String, Boolean>();
        persFields.put("name", true);
        persFields.put("age", false);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("pers").setQueryEntities(Arrays.asList(new QueryEntityEx(new QueryEntity(AffinityKey.class.getName(), Person.class.getName()).addQueryField("name", String.class.getName(), null).addQueryField("age", Integer.class.getName(), null).addQueryField("orgId", Integer.class.getName(), null).setIndexes(Arrays.asList(new QueryIndex("orgId"), new QueryIndex().setFields(persFields)))).setNotNullFields(new HashSet<String>(Arrays.asList("age", "name"))))), this.cacheConfiguration("org").setQueryEntities(Arrays.asList(new QueryEntity(AffinityKey.class, Organization.class))), this.cacheConfiguration("metaTest").setQueryEntities(Arrays.asList(new QueryEntity(AffinityKey.class, MetaTest.class)))});
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        cfg.setSqlConfiguration(new SqlConfiguration().setSqlSchemas(new String[]{"PREDEFINED_SCHEMAS_1", "PREDEFINED_SCHEMAS_2"}));
        return cfg;
    }

    protected CacheConfiguration cacheConfiguration(@NotNull String name) {
        CacheConfiguration cache = JdbcMetadataSelfTest.defaultCacheConfiguration();
        cache.setName(name);
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        return cache;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3);
        IgniteCache orgCache = this.grid(0).cache("org");
        orgCache.put((Object)"o1", (Object)new Organization(1, "A"));
        orgCache.put((Object)"o2", (Object)new Organization(2, "B"));
        IgniteCache personCache = this.grid(0).cache("pers");
        personCache.put((Object)new AffinityKey((Object)"p1", (Object)"o1"), (Object)new Person("John White", 25, 1));
        personCache.put((Object)new AffinityKey((Object)"p2", (Object)"o1"), (Object)new Person("Joe Black", 35, 1));
        personCache.put((Object)new AffinityKey((Object)"p3", (Object)"o2"), (Object)new Person("Mike Green", 40, 2));
        this.jcache((Ignite)this.grid(0), JdbcMetadataSelfTest.defaultCacheConfiguration().setIndexedTypes(new Class[]{Integer.class, Department.class}), "dep");
        try (Connection conn = DriverManager.getConnection(BASE_URL);){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE PUBLIC.TEST (ID INT, NAME VARCHAR(50) default 'default name', age int default 21, VAL VARCHAR(50), PRIMARY KEY (ID, NAME))");
            stmt.execute("CREATE TABLE PUBLIC.\"Quoted\" (\"Id\" INT primary key, \"Name\" VARCHAR(50)) WITH WRAP_KEY");
            stmt.execute("CREATE INDEX \"MyTestIndex quoted\" on PUBLIC.\"Quoted\" (\"Id\" DESC)");
            stmt.execute("CREATE INDEX IDX ON PUBLIC.TEST (ID ASC)");
            stmt.execute("CREATE TABLE PUBLIC.TEST_DECIMAL_COLUMN (ID INT primary key, DEC_COL DECIMAL(8, 3))");
        }
    }

    @Test
    public void testResultSetMetaData() throws Exception {
        try (Connection conn = DriverManager.getConnection(BASE_URL);){
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select p.name, o.id as orgId from \"pers\".Person p, \"org\".Organization o where p.orgId = o.id");
            JdbcMetadataSelfTest.assertNotNull((Object)rs);
            ResultSetMetaData meta = rs.getMetaData();
            JdbcMetadataSelfTest.assertNotNull((Object)meta);
            JdbcMetadataSelfTest.assertEquals((int)2, (int)meta.getColumnCount());
            JdbcMetadataSelfTest.assertTrue((boolean)"Person".equalsIgnoreCase(meta.getTableName(1)));
            JdbcMetadataSelfTest.assertTrue((boolean)"name".equalsIgnoreCase(meta.getColumnName(1)));
            JdbcMetadataSelfTest.assertTrue((boolean)"name".equalsIgnoreCase(meta.getColumnLabel(1)));
            JdbcMetadataSelfTest.assertEquals((int)12, (int)meta.getColumnType(1));
            JdbcMetadataSelfTest.assertEquals((String)"VARCHAR", (String)meta.getColumnTypeName(1));
            JdbcMetadataSelfTest.assertEquals((String)"java.lang.String", (String)meta.getColumnClassName(1));
            JdbcMetadataSelfTest.assertTrue((boolean)"Organization".equalsIgnoreCase(meta.getTableName(2)));
            JdbcMetadataSelfTest.assertTrue((boolean)"orgId".equalsIgnoreCase(meta.getColumnName(2)));
            JdbcMetadataSelfTest.assertTrue((boolean)"orgId".equalsIgnoreCase(meta.getColumnLabel(2)));
            JdbcMetadataSelfTest.assertEquals((int)4, (int)meta.getColumnType(2));
            JdbcMetadataSelfTest.assertEquals((String)"INTEGER", (String)meta.getColumnTypeName(2));
            JdbcMetadataSelfTest.assertEquals((String)"java.lang.Integer", (String)meta.getColumnClassName(2));
        }
    }

    @Test
    public void testPreparedStatementMetaData() throws Exception {
        for (int i = 0; i < 3; ++i) {
            try (Connection conn = DriverManager.getConnection(BASE_URL);){
                String select = "select p.name, o.id as orgId from \"pers\".Person p, \"org\".Organization o where p.orgId = o.id";
                ResultSetMetaData rsMeta = conn.createStatement().executeQuery(select).getMetaData();
                ResultSetMetaData psMeta = conn.prepareStatement(select).getMetaData();
                JdbcMetadataSelfTest.assertEquals((int)rsMeta.getColumnCount(), (int)rsMeta.getColumnCount());
                for (int j = 1; j <= rsMeta.getColumnCount(); ++j) {
                    JdbcMetadataSelfTest.assertEquals((String)rsMeta.getTableName(j), (String)psMeta.getTableName(j));
                    JdbcMetadataSelfTest.assertEquals((String)rsMeta.getColumnName(j), (String)psMeta.getColumnName(j));
                    JdbcMetadataSelfTest.assertEquals((String)rsMeta.getColumnLabel(j), (String)psMeta.getColumnLabel(j));
                    JdbcMetadataSelfTest.assertEquals((int)rsMeta.getColumnType(j), (int)psMeta.getColumnType(j));
                    JdbcMetadataSelfTest.assertEquals((String)rsMeta.getColumnTypeName(j), (String)psMeta.getColumnTypeName(j));
                    JdbcMetadataSelfTest.assertEquals((String)rsMeta.getColumnClassName(j), (String)psMeta.getColumnClassName(j));
                }
                continue;
            }
        }
    }

    @Test
    public void testPreparedStatementMetaDataNegative() throws Exception {
        for (int i = 0; i < 3; ++i) {
            ResultSetMetaData psMeta;
            String update;
            try (Connection conn = DriverManager.getConnection(BASE_URL);){
                update = "update \"pers\".Person set name = 'weird' where orgId < 0";
                psMeta = conn.prepareStatement(update).getMetaData();
                JdbcMetadataSelfTest.assertNull((Object)psMeta);
            }
            conn = DriverManager.getConnection(BASE_URL);
            var3_3 = null;
            try {
                update = "CREATE TABLE DDL_METADATA_TAB (ID INT PRIMARY KEY, VAL INT)";
                psMeta = conn.prepareStatement(update).getMetaData();
                JdbcMetadataSelfTest.assertNull((Object)psMeta);
            }
            catch (Throwable update2) {
                var3_3 = update2;
                throw update2;
            }
            finally {
                if (conn != null) {
                    if (var3_3 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable update2) {
                            var3_3.addSuppressed(update2);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
            conn = DriverManager.getConnection(BASE_URL);
            var3_3 = null;
            try {
                String nativeCmd = "create index my_idx on PUBLIC.TEST(name)";
                psMeta = conn.prepareStatement(nativeCmd).getMetaData();
                JdbcMetadataSelfTest.assertNull((Object)psMeta);
            }
            catch (Throwable nativeCmd) {
                var3_3 = nativeCmd;
                throw nativeCmd;
            }
            finally {
                if (conn != null) {
                    if (var3_3 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable nativeCmd) {
                            var3_3.addSuppressed(nativeCmd);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
            conn = DriverManager.getConnection(BASE_URL);
            var3_3 = null;
            try {
                conn.setSchema("\"pers\"");
                PreparedStatement notCorrect = conn.prepareStatement("select * from NotExistingTable;");
                GridTestUtils.assertThrows((IgniteLogger)this.log(), notCorrect::getMetaData, SQLException.class, (String)"Table \"NOTEXISTINGTABLE\" not found");
                continue;
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (conn != null) {
                    if (var3_3 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
    }

    @Test
    public void testDecimalAndDateTypeMetaData() throws Exception {
        try (Connection conn = DriverManager.getConnection(BASE_URL);){
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select t.decimal, t.date from \"metaTest\".MetaTest as t");
            assert (rs != null);
            ResultSetMetaData meta = rs.getMetaData();
            assert (meta != null);
            assert (meta.getColumnCount() == 2);
            assert ("METATEST".equalsIgnoreCase(meta.getTableName(1)));
            assert ("DECIMAL".equalsIgnoreCase(meta.getColumnName(1)));
            assert ("DECIMAL".equalsIgnoreCase(meta.getColumnLabel(1)));
            assert (meta.getColumnType(1) == 3);
            assert ("DECIMAL".equals(meta.getColumnTypeName(1)));
            assert ("java.math.BigDecimal".equals(meta.getColumnClassName(1)));
            assert ("METATEST".equalsIgnoreCase(meta.getTableName(2)));
            assert ("DATE".equalsIgnoreCase(meta.getColumnName(2)));
            assert ("DATE".equalsIgnoreCase(meta.getColumnLabel(2)));
            assert (meta.getColumnType(2) == 91);
            assert ("DATE".equals(meta.getColumnTypeName(2)));
            assert ("java.sql.Date".equals(meta.getColumnClassName(2)));
        }
    }

    @Test
    public void testGetTableTypes() throws Exception {
        try (Connection conn = DriverManager.getConnection(BASE_URL);){
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getTableTypes();
            JdbcMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcMetadataSelfTest.assertEquals((String)"TABLE", (String)rs.getString("TABLE_TYPE"));
            JdbcMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcMetadataSelfTest.assertEquals((String)"VIEW", (String)rs.getString("TABLE_TYPE"));
        }
    }

    @Test
    public void testGetAllView() throws Exception {
        HashSet<String> expViews = new HashSet<String>(Arrays.asList("BASELINE_NODES", "BASELINE_NODE_ATTRIBUTES", "CACHES", "CACHE_GROUPS", "INDEXES", "LOCAL_CACHE_GROUPS_IO", "SQL_QUERIES_HISTORY", "SQL_QUERIES", "SCAN_QUERIES", "NODES", "NODE_ATTRIBUTES", "CONFIGURATION", "NODE_METRICS", "SCHEMAS", "TABLES", "TASKS", "JOBS", "SERVICES", "CLIENT_CONNECTIONS", "CLIENT_CONNECTION_ATTRIBUTES", "TRANSACTIONS", "VIEWS", "TABLE_COLUMNS", "VIEW_COLUMNS", "CONTINUOUS_QUERIES", "STRIPED_THREADPOOL_QUEUE", "DATASTREAM_THREADPOOL_QUEUE", "CACHE_GROUP_PAGE_LISTS", "PARTITION_STATES", "CACHE_GROUP_PAGE_LISTS", "METRICS", "STATISTICS_CONFIGURATION", "STATISTICS_PARTITION_DATA", "STATISTICS_LOCAL_DATA", "DS_QUEUES", "DS_SETS", "DS_ATOMICSEQUENCES", "DS_ATOMICLONGS", "DS_ATOMICREFERENCES", "DS_ATOMICSTAMPED", "DS_COUNTDOWNLATCHES", "DS_SEMAPHORES", "DS_REENTRANTLOCKS", "BINARY_METADATA", "DISTRIBUTED_METASTORAGE"));
        HashSet<String> actViews = new HashSet<String>();
        try (Connection conn = DriverManager.getConnection(BASE_URL);){
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getTables(null, null, "%", new String[]{"VIEW"});
            while (rs.next()) {
                JdbcMetadataSelfTest.assertEquals((String)"VIEW", (String)rs.getString("TABLE_TYPE"));
                JdbcMetadataSelfTest.assertEquals((String)"IGNITE", (String)rs.getString("TABLE_CAT"));
                JdbcMetadataSelfTest.assertEquals((String)QueryUtils.sysSchemaName(), (String)rs.getString("TABLE_SCHEM"));
                actViews.add(rs.getString("TABLE_NAME"));
            }
            JdbcMetadataSelfTest.assertFalse((boolean)rs.next());
            JdbcMetadataSelfTest.assertEquals(expViews, actViews);
        }
    }

    @Test
    public void testGetTables() throws Exception {
        try (Connection conn = DriverManager.getConnection(BASE_URL);){
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getTables(null, "pers", "%", new String[]{"TABLE"});
            JdbcMetadataSelfTest.assertNotNull((Object)rs);
            JdbcMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcMetadataSelfTest.assertEquals((String)"TABLE", (String)rs.getString("TABLE_TYPE"));
            JdbcMetadataSelfTest.assertEquals((String)"IGNITE", (String)rs.getString("TABLE_CAT"));
            JdbcMetadataSelfTest.assertEquals((String)"PERSON", (String)rs.getString("TABLE_NAME"));
            rs = meta.getTables(null, "org", "%", new String[]{"TABLE"});
            JdbcMetadataSelfTest.assertNotNull((Object)rs);
            JdbcMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcMetadataSelfTest.assertEquals((String)"TABLE", (String)rs.getString("TABLE_TYPE"));
            JdbcMetadataSelfTest.assertEquals((String)"IGNITE", (String)rs.getString("TABLE_CAT"));
            JdbcMetadataSelfTest.assertEquals((String)"ORGANIZATION", (String)rs.getString("TABLE_NAME"));
            rs = meta.getTables(null, "pers", "%", null);
            JdbcMetadataSelfTest.assertNotNull((Object)rs);
            JdbcMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcMetadataSelfTest.assertEquals((String)"TABLE", (String)rs.getString("TABLE_TYPE"));
            JdbcMetadataSelfTest.assertEquals((String)"IGNITE", (String)rs.getString("TABLE_CAT"));
            JdbcMetadataSelfTest.assertEquals((String)"PERSON", (String)rs.getString("TABLE_NAME"));
            rs = meta.getTables(null, "org", "%", null);
            JdbcMetadataSelfTest.assertNotNull((Object)rs);
            JdbcMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcMetadataSelfTest.assertEquals((String)"TABLE", (String)rs.getString("TABLE_TYPE"));
            JdbcMetadataSelfTest.assertEquals((String)"IGNITE", (String)rs.getString("TABLE_CAT"));
            JdbcMetadataSelfTest.assertEquals((String)"ORGANIZATION", (String)rs.getString("TABLE_NAME"));
            rs = meta.getTables(null, "PUBLIC", "", new String[]{"WRONG"});
            JdbcMetadataSelfTest.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testCatalogWithNotExistingName() throws SQLException {
        this.checkNoEntitiesFoundForCatalog("");
        this.checkNoEntitiesFoundForCatalog("NOT_EXISTING_CATALOG");
    }

    private void checkNoEntitiesFoundForCatalog(String invalidCat) throws SQLException {
        try (Connection conn = DriverManager.getConnection(BASE_URL);){
            DatabaseMetaData meta = conn.getMetaData();
            JdbcMetadataSelfTest.assertIsEmpty(meta.getTables(invalidCat, null, "%", new String[]{"TABLE"}));
            JdbcMetadataSelfTest.assertIsEmpty(meta.getColumns(invalidCat, null, "%", "%"));
            JdbcMetadataSelfTest.assertIsEmpty(meta.getColumnPrivileges(invalidCat, "pers", "PERSON", "%"));
            JdbcMetadataSelfTest.assertIsEmpty(meta.getTablePrivileges(invalidCat, null, "%"));
            JdbcMetadataSelfTest.assertIsEmpty(meta.getPrimaryKeys(invalidCat, "pers", "PERSON"));
            JdbcMetadataSelfTest.assertIsEmpty(meta.getImportedKeys(invalidCat, "pers", "PERSON"));
            JdbcMetadataSelfTest.assertIsEmpty(meta.getExportedKeys(invalidCat, "pers", "PERSON"));
            JdbcMetadataSelfTest.assertIsEmpty(meta.getIndexInfo(invalidCat, null, "%", false, true));
            JdbcMetadataSelfTest.assertIsEmpty(meta.getSuperTables(invalidCat, "%", "%"));
            JdbcMetadataSelfTest.assertIsEmpty(meta.getSchemas(invalidCat, null));
            JdbcMetadataSelfTest.assertIsEmpty(meta.getPseudoColumns(invalidCat, null, "%", ""));
        }
    }

    @Test
    public void testCheckSupports() throws SQLException {
        try (Connection conn = DriverManager.getConnection(BASE_URL);){
            DatabaseMetaData meta = conn.getMetaData();
            JdbcMetadataSelfTest.assertTrue((boolean)meta.supportsANSI92EntryLevelSQL());
            JdbcMetadataSelfTest.assertTrue((boolean)meta.supportsAlterTableWithAddColumn());
            JdbcMetadataSelfTest.assertTrue((boolean)meta.supportsAlterTableWithDropColumn());
            JdbcMetadataSelfTest.assertTrue((boolean)meta.nullPlusNonNullIsNull());
        }
    }

    private static void assertIsEmpty(ResultSet rs) throws SQLException {
        try {
            boolean empty = !rs.next();
            JdbcMetadataSelfTest.assertTrue((String)"Result should be empty because invalid catalog is specified.", (boolean)empty);
        }
        finally {
            rs.close();
        }
    }

    @Test
    public void testGetColumns() throws Exception {
        try (Connection conn = DriverManager.getConnection(BASE_URL);){
            String name;
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getColumns(null, "pers", "PERSON", "%");
            JdbcMetadataSelfTest.assertNotNull((Object)rs);
            JdbcMetadataSelfTest.assertEquals((int)24, (int)rs.getMetaData().getColumnCount());
            ArrayList<String> names = new ArrayList<String>(2);
            names.add("NAME");
            names.add("AGE");
            names.add("ORGID");
            int cnt = 0;
            while (rs.next()) {
                name = rs.getString("COLUMN_NAME");
                JdbcMetadataSelfTest.assertTrue((boolean)names.remove(name));
                if ("NAME".equals(name)) {
                    JdbcMetadataSelfTest.assertEquals((int)12, (int)rs.getInt("DATA_TYPE"));
                    JdbcMetadataSelfTest.assertEquals((String)"VARCHAR", (String)rs.getString("TYPE_NAME"));
                    JdbcMetadataSelfTest.assertEquals((int)0, (int)rs.getInt("NULLABLE"));
                    JdbcMetadataSelfTest.assertEquals((int)0, (int)rs.getInt(11));
                    JdbcMetadataSelfTest.assertEquals((String)"NO", (String)rs.getString("IS_NULLABLE"));
                } else if ("AGE".equals(name)) {
                    JdbcMetadataSelfTest.assertEquals((int)4, (int)rs.getInt("DATA_TYPE"));
                    JdbcMetadataSelfTest.assertEquals((String)"INTEGER", (String)rs.getString("TYPE_NAME"));
                    JdbcMetadataSelfTest.assertEquals((int)0, (int)rs.getInt("NULLABLE"));
                    JdbcMetadataSelfTest.assertEquals((int)0, (int)rs.getInt(11));
                    JdbcMetadataSelfTest.assertEquals((String)"NO", (String)rs.getString("IS_NULLABLE"));
                } else if ("ORGID".equals(name)) {
                    JdbcMetadataSelfTest.assertEquals((int)4, (int)rs.getInt("DATA_TYPE"));
                    JdbcMetadataSelfTest.assertEquals((String)"INTEGER", (String)rs.getString("TYPE_NAME"));
                    JdbcMetadataSelfTest.assertEquals((int)1, (int)rs.getInt("NULLABLE"));
                    JdbcMetadataSelfTest.assertEquals((int)1, (int)rs.getInt(11));
                    JdbcMetadataSelfTest.assertEquals((String)"YES", (String)rs.getString("IS_NULLABLE"));
                }
                ++cnt;
            }
            JdbcMetadataSelfTest.assertTrue((boolean)names.isEmpty());
            JdbcMetadataSelfTest.assertEquals((int)3, (int)cnt);
            rs = meta.getColumns(null, "org", "ORGANIZATION", "%");
            JdbcMetadataSelfTest.assertNotNull((Object)rs);
            names.add("ID");
            names.add("NAME");
            cnt = 0;
            while (rs.next()) {
                name = rs.getString("COLUMN_NAME");
                JdbcMetadataSelfTest.assertTrue((boolean)names.remove(name));
                if ("id".equals(name)) {
                    JdbcMetadataSelfTest.assertEquals((int)4, (int)rs.getInt("DATA_TYPE"));
                    JdbcMetadataSelfTest.assertEquals((String)"INTEGER", (String)rs.getString("TYPE_NAME"));
                    JdbcMetadataSelfTest.assertEquals((int)0, (int)rs.getInt("NULLABLE"));
                    JdbcMetadataSelfTest.assertEquals((int)0, (int)rs.getInt(11));
                    JdbcMetadataSelfTest.assertEquals((String)"NO", (String)rs.getString("IS_NULLABLE"));
                } else if ("name".equals(name)) {
                    JdbcMetadataSelfTest.assertEquals((int)12, (int)rs.getInt("DATA_TYPE"));
                    JdbcMetadataSelfTest.assertEquals((String)"VARCHAR", (String)rs.getString("TYPE_NAME"));
                    JdbcMetadataSelfTest.assertEquals((int)1, (int)rs.getInt("NULLABLE"));
                    JdbcMetadataSelfTest.assertEquals((int)1, (int)rs.getInt(11));
                    JdbcMetadataSelfTest.assertEquals((String)"YES", (String)rs.getString("IS_NULLABLE"));
                }
                ++cnt;
            }
            JdbcMetadataSelfTest.assertTrue((boolean)names.isEmpty());
            JdbcMetadataSelfTest.assertEquals((int)2, (int)cnt);
        }
    }

    @Test
    public void testMetadataResultSetClose() throws Exception {
        try (Connection conn = DriverManager.getConnection(BASE_URL);
             ResultSet tbls = conn.getMetaData().getTables(null, null, "%", null);){
            int colCnt = tbls.getMetaData().getColumnCount();
            while (tbls.next()) {
                for (int i = 0; i < colCnt; ++i) {
                    tbls.getObject(i + 1);
                }
            }
        }
        catch (Exception ignored) {
            JdbcMetadataSelfTest.fail();
        }
    }

    @Test
    public void testIndexMetadata() throws Exception {
        try (Connection conn = DriverManager.getConnection(BASE_URL);
             ResultSet rs = conn.getMetaData().getIndexInfo(null, "pers", "PERSON", false, false);){
            int cnt = 0;
            while (rs.next()) {
                String idxName = rs.getString("INDEX_NAME");
                String field = rs.getString("COLUMN_NAME");
                String ascOrDesc = rs.getString("ASC_OR_DESC");
                JdbcMetadataSelfTest.assertEquals((int)3, (int)rs.getInt("TYPE"));
                if ("PERSON_ORGID_ASC_IDX".equals(idxName)) {
                    JdbcMetadataSelfTest.assertEquals((String)"ORGID", (String)field);
                    JdbcMetadataSelfTest.assertEquals((String)"A", (String)ascOrDesc);
                } else if ("PERSON_NAME_ASC_AGE_DESC_IDX".equals(idxName)) {
                    if ("NAME".equals(field)) {
                        JdbcMetadataSelfTest.assertEquals((String)"A", (String)ascOrDesc);
                    } else if ("AGE".equals(field)) {
                        JdbcMetadataSelfTest.assertEquals((String)"D", (String)ascOrDesc);
                    } else {
                        JdbcMetadataSelfTest.fail((String)("Unexpected field: " + field));
                    }
                } else {
                    JdbcMetadataSelfTest.fail((String)("Unexpected index: " + idxName));
                }
                ++cnt;
            }
            JdbcMetadataSelfTest.assertEquals((int)3, (int)cnt);
        }
    }

    @Test
    public void testPrimaryKeyMetadata() throws Exception {
        try (Connection conn = DriverManager.getConnection(BASE_URL);){
            ResultSet rs = conn.getMetaData().getPrimaryKeys(null, null, null);
            HashSet<String> expectedPks = new HashSet<String>(Arrays.asList("org.ORGANIZATION.PK_org_ORGANIZATION._KEY", "pers.PERSON.PK_pers_PERSON._KEY", "dep.DEPARTMENT.PK_dep_DEPARTMENT._KEY", "PUBLIC.TEST.PK_PUBLIC_TEST.ID", "PUBLIC.TEST.PK_PUBLIC_TEST.NAME", "PUBLIC.Quoted.PK_PUBLIC_Quoted.Id", "PUBLIC.TEST_DECIMAL_COLUMN.ID.ID", "metaTest.METATEST.PK_metaTest_METATEST._KEY"));
            HashSet<String> actualPks = new HashSet<String>(expectedPks.size());
            while (rs.next()) {
                actualPks.add(rs.getString("TABLE_SCHEM") + '.' + rs.getString("TABLE_NAME") + '.' + rs.getString("PK_NAME") + '.' + rs.getString("COLUMN_NAME"));
            }
            JdbcMetadataSelfTest.assertEquals((String)"Metadata contains unexpected primary keys info.", expectedPks, actualPks);
        }
    }

    @Test
    public void testParametersMetadata() throws Exception {
        for (int i = 0; i < 3; ++i) {
            ParameterMetaData meta;
            try (Connection conn = DriverManager.getConnection(BASE_URL);){
                conn.setSchema("\"pers\"");
                PreparedStatement noParams = conn.prepareStatement("select * from Person;");
                ParameterMetaData params = noParams.getParameterMetaData();
                JdbcMetadataSelfTest.assertEquals((String)"Parameters should be empty.", (int)0, (int)params.getParameterCount());
            }
            conn = DriverManager.getConnection(BASE_URL);
            var3_3 = null;
            try {
                conn.setSchema("\"pers\"");
                PreparedStatement selectStmt = conn.prepareStatement("select orgId from Person p where p.name > ? and p.orgId > ?");
                meta = selectStmt.getParameterMetaData();
                JdbcMetadataSelfTest.assertNotNull((Object)meta);
                JdbcMetadataSelfTest.assertEquals((int)2, (int)meta.getParameterCount());
                JdbcMetadataSelfTest.assertEquals((int)12, (int)meta.getParameterType(1));
                JdbcMetadataSelfTest.assertEquals((int)2, (int)meta.isNullable(1));
                JdbcMetadataSelfTest.assertEquals((int)Integer.MAX_VALUE, (int)meta.getPrecision(1));
                JdbcMetadataSelfTest.assertEquals((int)4, (int)meta.getParameterType(2));
                JdbcMetadataSelfTest.assertEquals((int)2, (int)meta.isNullable(2));
            }
            catch (Throwable selectStmt) {
                var3_3 = selectStmt;
                throw selectStmt;
            }
            finally {
                if (conn != null) {
                    if (var3_3 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable selectStmt) {
                            var3_3.addSuppressed(selectStmt);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
            conn = DriverManager.getConnection(BASE_URL);
            var3_3 = null;
            try {
                conn.setSchema("\"pers\"");
                PreparedStatement updateStmt = conn.prepareStatement("update Person p set orgId = 42 where p.name > ? and p.orgId > ?");
                meta = updateStmt.getParameterMetaData();
                JdbcMetadataSelfTest.assertNotNull((Object)meta);
                JdbcMetadataSelfTest.assertEquals((int)2, (int)meta.getParameterCount());
                JdbcMetadataSelfTest.assertEquals((int)12, (int)meta.getParameterType(1));
                JdbcMetadataSelfTest.assertEquals((int)2, (int)meta.isNullable(1));
                JdbcMetadataSelfTest.assertEquals((int)Integer.MAX_VALUE, (int)meta.getPrecision(1));
                JdbcMetadataSelfTest.assertEquals((int)4, (int)meta.getParameterType(2));
                JdbcMetadataSelfTest.assertEquals((int)2, (int)meta.isNullable(2));
                continue;
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (conn != null) {
                    if (var3_3 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
    }

    @Test
    public void testParametersMetadataNegative() throws Exception {
        try (Connection conn = DriverManager.getConnection(BASE_URL);){
            conn.setSchema("\"pers\"");
            PreparedStatement notCorrect = conn.prepareStatement("select * from NotExistingTable;");
            GridTestUtils.assertThrows((IgniteLogger)this.log(), notCorrect::getParameterMetaData, SQLException.class, (String)"Table \"NOTEXISTINGTABLE\" not found");
        }
    }

    @Test
    public void testSchemasMetadata() throws Exception {
        try (Connection conn = DriverManager.getConnection(BASE_URL);){
            ResultSet rs = conn.getMetaData().getSchemas();
            HashSet<String> expSchemas = new HashSet<String>(Arrays.asList("pers", "org", "metaTest", "dep", "PUBLIC", QueryUtils.sysSchemaName(), "PREDEFINED_CLIENT_SCHEMA"));
            HashSet<String> schemas = new HashSet<String>();
            while (rs.next()) {
                schemas.add(rs.getString(1));
                JdbcMetadataSelfTest.assertEquals((String)"There is only one possible catalog.", (String)"IGNITE", (String)rs.getString(2));
            }
            JdbcMetadataSelfTest.assertEquals(expSchemas, schemas);
        }
    }

    @Test
    public void testVersions() throws Exception {
        try (Connection conn = DriverManager.getConnection(BASE_URL);){
            JdbcMetadataSelfTest.assertEquals((String)"Apache Ignite", (String)conn.getMetaData().getDatabaseProductName());
            JdbcMetadataSelfTest.assertEquals((String)"Apache Ignite JDBC Driver", (String)conn.getMetaData().getDriverName());
            JdbcMetadataSelfTest.assertEquals((String)IgniteVersionUtils.VER.toString(), (String)conn.getMetaData().getDatabaseProductVersion());
            JdbcMetadataSelfTest.assertEquals((String)IgniteVersionUtils.VER.toString(), (String)conn.getMetaData().getDriverVersion());
            JdbcMetadataSelfTest.assertEquals((int)IgniteVersionUtils.VER.major(), (int)conn.getMetaData().getDatabaseMajorVersion());
            JdbcMetadataSelfTest.assertEquals((int)IgniteVersionUtils.VER.major(), (int)conn.getMetaData().getDriverMajorVersion());
            JdbcMetadataSelfTest.assertEquals((int)IgniteVersionUtils.VER.minor(), (int)conn.getMetaData().getDatabaseMinorVersion());
            JdbcMetadataSelfTest.assertEquals((int)IgniteVersionUtils.VER.minor(), (int)conn.getMetaData().getDriverMinorVersion());
            JdbcMetadataSelfTest.assertEquals((int)4, (int)conn.getMetaData().getJDBCMajorVersion());
            JdbcMetadataSelfTest.assertEquals((int)1, (int)conn.getMetaData().getJDBCMinorVersion());
        }
    }

    private static class Department
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField(precision=43)
        private final String name;

        private Department(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    private static class MetaTest
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField
        private final Date date;
        @QuerySqlField
        private final BigDecimal decimal;

        private MetaTest(int id, Date date, BigDecimal decimal) {
            this.id = id;
            this.date = date;
            this.decimal = decimal;
        }
    }

    private static class Organization
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField(index=false)
        private final String name;

        private Organization(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    private static class Person
    implements Serializable {
        @QuerySqlField(index=false)
        private final String name;
        @QuerySqlField
        private final int age;
        @QuerySqlField
        private final int orgId;

        private Person(String name, int age, int orgId) {
            assert (!F.isEmpty((String)name));
            assert (age > 0);
            assert (orgId > 0);
            this.name = name;
            this.age = age;
            this.orgId = orgId;
        }
    }
}

