/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.internal.jdbc2.JdbcAbstractDmlStatementSelfTest;
import org.junit.Test;

public class JdbcMergeStatementSelfTest
extends JdbcAbstractDmlStatementSelfTest {
    private static final String SQL = "merge into Person(_key, id, firstName, lastName, age, data) values ('p1', 1, 'John', 'White', 25, RAWTOHEX('White')), ('p2', 2, 'Joe', 'Black', 35, RAWTOHEX('Black')), ('p3', 3, 'Mike', 'Green', 40, RAWTOHEX('Green'))";
    protected static final String SQL_PREPARED = "merge into Person(_key, id, firstName, lastName, age, data) values (?, ?, ?, ?, ?, ?), (?, ?, ?, ?, ?, ?)";
    protected Statement stmt;
    protected PreparedStatement prepStmt;

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stmt = this.conn.createStatement();
        this.prepStmt = this.conn.prepareStatement(SQL_PREPARED);
        JdbcMergeStatementSelfTest.assertNotNull((Object)this.stmt);
        JdbcMergeStatementSelfTest.assertFalse((boolean)this.stmt.isClosed());
        JdbcMergeStatementSelfTest.assertNotNull((Object)this.prepStmt);
        JdbcMergeStatementSelfTest.assertFalse((boolean)this.prepStmt.isClosed());
    }

    @Override
    protected void afterTest() throws Exception {
        try (Statement selStmt = this.conn.createStatement();){
            JdbcMergeStatementSelfTest.assertTrue((boolean)selStmt.execute("select _key, id, firstName, lastName, age, data from Person"));
            ResultSet rs = selStmt.getResultSet();
            assert (rs != null);
            block15: while (rs.next()) {
                int id = rs.getInt("id");
                switch (id) {
                    case 1: {
                        JdbcMergeStatementSelfTest.assertEquals((String)"p1", (String)rs.getString("_key"));
                        JdbcMergeStatementSelfTest.assertEquals((String)"John", (String)rs.getString("firstName"));
                        JdbcMergeStatementSelfTest.assertEquals((String)"White", (String)rs.getString("lastName"));
                        JdbcMergeStatementSelfTest.assertEquals((int)25, (int)rs.getInt("age"));
                        JdbcMergeStatementSelfTest.assertEquals((String)"White", (String)JdbcMergeStatementSelfTest.str(JdbcMergeStatementSelfTest.getBytes(rs.getBlob("data"))));
                        continue block15;
                    }
                    case 2: {
                        JdbcMergeStatementSelfTest.assertEquals((String)"p2", (String)rs.getString("_key"));
                        JdbcMergeStatementSelfTest.assertEquals((String)"Joe", (String)rs.getString("firstName"));
                        JdbcMergeStatementSelfTest.assertEquals((String)"Black", (String)rs.getString("lastName"));
                        JdbcMergeStatementSelfTest.assertEquals((int)35, (int)rs.getInt("age"));
                        JdbcMergeStatementSelfTest.assertEquals((String)"Black", (String)JdbcMergeStatementSelfTest.str(JdbcMergeStatementSelfTest.getBytes(rs.getBlob("data"))));
                        continue block15;
                    }
                    case 3: {
                        JdbcMergeStatementSelfTest.assertEquals((String)"p3", (String)rs.getString("_key"));
                        JdbcMergeStatementSelfTest.assertEquals((String)"Mike", (String)rs.getString("firstName"));
                        JdbcMergeStatementSelfTest.assertEquals((String)"Green", (String)rs.getString("lastName"));
                        JdbcMergeStatementSelfTest.assertEquals((int)40, (int)rs.getInt("age"));
                        JdbcMergeStatementSelfTest.assertEquals((String)"Green", (String)JdbcMergeStatementSelfTest.str(JdbcMergeStatementSelfTest.getBytes(rs.getBlob("data"))));
                        continue block15;
                    }
                    case 4: {
                        JdbcMergeStatementSelfTest.assertEquals((String)"p4", (String)rs.getString("_key"));
                        JdbcMergeStatementSelfTest.assertEquals((String)"Leah", (String)rs.getString("firstName"));
                        JdbcMergeStatementSelfTest.assertEquals((String)"Grey", (String)rs.getString("lastName"));
                        JdbcMergeStatementSelfTest.assertEquals((int)22, (int)rs.getInt("age"));
                        JdbcMergeStatementSelfTest.assertEquals((String)"Grey", (String)JdbcMergeStatementSelfTest.str(JdbcMergeStatementSelfTest.getBytes(rs.getBlob("data"))));
                        continue block15;
                    }
                }
                assert (false) : "Invalid ID: " + id;
            }
        }
        this.grid(0).cache("default").clear();
        JdbcMergeStatementSelfTest.assertEquals((int)0, (int)this.grid(0).cache("default").size(new CachePeekMode[]{CachePeekMode.ALL}));
        super.afterTest();
        if (this.stmt != null && !this.stmt.isClosed()) {
            this.stmt.close();
        }
        if (this.prepStmt != null && !this.prepStmt.isClosed()) {
            this.prepStmt.close();
        }
        this.conn.close();
        JdbcMergeStatementSelfTest.assertTrue((boolean)this.prepStmt.isClosed());
        JdbcMergeStatementSelfTest.assertTrue((boolean)this.stmt.isClosed());
        JdbcMergeStatementSelfTest.assertTrue((boolean)this.conn.isClosed());
    }

    @Test
    public void testExecuteUpdate() throws SQLException {
        int res = this.stmt.executeUpdate(SQL);
        JdbcMergeStatementSelfTest.assertEquals((int)3, (int)res);
    }

    @Test
    public void testExecute() throws SQLException {
        boolean res = this.stmt.execute(SQL);
        JdbcMergeStatementSelfTest.assertEquals((boolean)false, (boolean)res);
    }

    @Test
    public void testBatch() throws SQLException {
        this.prepStmt.setString(1, "p1");
        this.prepStmt.setInt(2, 1);
        this.prepStmt.setString(3, "John");
        this.prepStmt.setString(4, "White");
        this.prepStmt.setInt(5, 25);
        this.prepStmt.setBytes(6, JdbcMergeStatementSelfTest.getBytes("White"));
        this.prepStmt.setString(7, "p2");
        this.prepStmt.setInt(8, 2);
        this.prepStmt.setString(9, "Joe");
        this.prepStmt.setString(10, "Black");
        this.prepStmt.setInt(11, 35);
        this.prepStmt.setBytes(12, JdbcMergeStatementSelfTest.getBytes("Black"));
        this.prepStmt.addBatch();
        this.prepStmt.setString(1, "p3");
        this.prepStmt.setInt(2, 3);
        this.prepStmt.setString(3, "Mike");
        this.prepStmt.setString(4, "Green");
        this.prepStmt.setInt(5, 40);
        this.prepStmt.setBytes(6, JdbcMergeStatementSelfTest.getBytes("Green"));
        this.prepStmt.setString(7, "p4");
        this.prepStmt.setInt(8, 4);
        this.prepStmt.setString(9, "Leah");
        this.prepStmt.setString(10, "Grey");
        this.prepStmt.setInt(11, 22);
        this.prepStmt.setBytes(12, JdbcMergeStatementSelfTest.getBytes("Grey"));
        this.prepStmt.addBatch();
        int[] res = this.prepStmt.executeBatch();
        JdbcMergeStatementSelfTest.assertTrue((boolean)Arrays.equals(new int[]{2, 2}, res));
    }
}

