/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.internal.jdbc2.JdbcAbstractDmlStatementSelfTest;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class JdbcInsertStatementSelfTest
extends JdbcAbstractDmlStatementSelfTest {
    private static final String SQL = "insert into Person(_key, id, firstName, lastName, age, data) values ('p1', 1, 'John', 'White', 25, RAWTOHEX('White')), ('p2', 2, 'Joe', 'Black', 35, RAWTOHEX('Black')), ('p3', 3, 'Mike', 'Green', 40, RAWTOHEX('Green'))";
    private static final String SQL_PREPARED = "insert into Person(_key, id, firstName, lastName, age, data) values (?, ?, ?, ?, ?, ?), (?, ?, ?, ?, ?, ?)";
    private Statement stmt;
    private PreparedStatement prepStmt;

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stmt = this.conn.createStatement();
        this.prepStmt = this.conn.prepareStatement(SQL_PREPARED);
        JdbcInsertStatementSelfTest.assertNotNull((Object)this.stmt);
        JdbcInsertStatementSelfTest.assertFalse((boolean)this.stmt.isClosed());
        JdbcInsertStatementSelfTest.assertNotNull((Object)this.prepStmt);
        JdbcInsertStatementSelfTest.assertFalse((boolean)this.prepStmt.isClosed());
    }

    @Override
    protected void afterTest() throws Exception {
        try (Statement selStmt = this.conn.createStatement();){
            JdbcInsertStatementSelfTest.assertTrue((boolean)selStmt.execute("select _key, id, firstName, lastName, age, data from Person"));
            ResultSet rs = selStmt.getResultSet();
            assert (rs != null);
            block15: while (rs.next()) {
                int id = rs.getInt("id");
                switch (id) {
                    case 1: {
                        JdbcInsertStatementSelfTest.assertEquals((String)"p1", (String)rs.getString("_key"));
                        JdbcInsertStatementSelfTest.assertEquals((String)"John", (String)rs.getString("firstName"));
                        JdbcInsertStatementSelfTest.assertEquals((String)"White", (String)rs.getString("lastName"));
                        JdbcInsertStatementSelfTest.assertEquals((int)25, (int)rs.getInt("age"));
                        JdbcInsertStatementSelfTest.assertEquals((String)"White", (String)JdbcInsertStatementSelfTest.str(JdbcInsertStatementSelfTest.getBytes(rs.getBlob("data"))));
                        continue block15;
                    }
                    case 2: {
                        JdbcInsertStatementSelfTest.assertEquals((String)"p2", (String)rs.getString("_key"));
                        JdbcInsertStatementSelfTest.assertEquals((String)"Joe", (String)rs.getString("firstName"));
                        JdbcInsertStatementSelfTest.assertEquals((String)"Black", (String)rs.getString("lastName"));
                        JdbcInsertStatementSelfTest.assertEquals((int)35, (int)rs.getInt("age"));
                        JdbcInsertStatementSelfTest.assertEquals((String)"Black", (String)JdbcInsertStatementSelfTest.str(JdbcInsertStatementSelfTest.getBytes(rs.getBlob("data"))));
                        continue block15;
                    }
                    case 3: {
                        JdbcInsertStatementSelfTest.assertEquals((String)"p3", (String)rs.getString("_key"));
                        JdbcInsertStatementSelfTest.assertEquals((String)"Mike", (String)rs.getString("firstName"));
                        JdbcInsertStatementSelfTest.assertEquals((String)"Green", (String)rs.getString("lastName"));
                        JdbcInsertStatementSelfTest.assertEquals((int)40, (int)rs.getInt("age"));
                        JdbcInsertStatementSelfTest.assertEquals((String)"Green", (String)JdbcInsertStatementSelfTest.str(JdbcInsertStatementSelfTest.getBytes(rs.getBlob("data"))));
                        continue block15;
                    }
                    case 4: {
                        JdbcInsertStatementSelfTest.assertEquals((String)"p4", (String)rs.getString("_key"));
                        JdbcInsertStatementSelfTest.assertEquals((String)"Leah", (String)rs.getString("firstName"));
                        JdbcInsertStatementSelfTest.assertEquals((String)"Grey", (String)rs.getString("lastName"));
                        JdbcInsertStatementSelfTest.assertEquals((int)22, (int)rs.getInt("age"));
                        JdbcInsertStatementSelfTest.assertEquals((String)"Grey", (String)JdbcInsertStatementSelfTest.str(JdbcInsertStatementSelfTest.getBytes(rs.getBlob("data"))));
                        continue block15;
                    }
                }
                assert (false) : "Invalid ID: " + id;
            }
        }
        this.grid(0).cache("default").clear();
        JdbcInsertStatementSelfTest.assertEquals((int)0, (int)this.grid(0).cache("default").size(new CachePeekMode[]{CachePeekMode.ALL}));
        super.afterTest();
        if (this.stmt != null && !this.stmt.isClosed()) {
            this.stmt.close();
        }
        if (this.prepStmt != null && !this.prepStmt.isClosed()) {
            this.prepStmt.close();
        }
        this.conn.close();
        JdbcInsertStatementSelfTest.assertTrue((boolean)this.prepStmt.isClosed());
        JdbcInsertStatementSelfTest.assertTrue((boolean)this.stmt.isClosed());
        JdbcInsertStatementSelfTest.assertTrue((boolean)this.conn.isClosed());
    }

    @Test
    public void testExecuteUpdate() throws SQLException {
        int res = this.stmt.executeUpdate(SQL);
        JdbcInsertStatementSelfTest.assertEquals((int)3, (int)res);
    }

    @Test
    public void testExecute() throws SQLException {
        boolean res = this.stmt.execute(SQL);
        JdbcInsertStatementSelfTest.assertEquals((boolean)false, (boolean)res);
    }

    @Test
    public void testDuplicateKeys() {
        this.jcache(0).put((Object)"p2", (Object)new JdbcAbstractDmlStatementSelfTest.Person(2, "Joe", "Black", 35));
        Throwable reason = GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return JdbcInsertStatementSelfTest.this.stmt.execute(JdbcInsertStatementSelfTest.SQL);
            }
        }, SQLException.class, null);
        reason = reason.getCause();
        JdbcInsertStatementSelfTest.assertNotNull((Object)reason);
        JdbcInsertStatementSelfTest.assertTrue((boolean)reason.getMessage().contains("Failed to INSERT some keys because they are already in cache [keys=[p2]]"));
        JdbcInsertStatementSelfTest.assertEquals((int)3, (int)this.jcache(0).withKeepBinary().getAll(new HashSet<String>(Arrays.asList("p1", "p2", "p3"))).size());
    }

    @Test
    public void testBatch() throws SQLException {
        this.formBatch(1, 2);
        this.formBatch(3, 4);
        int[] res = this.prepStmt.executeBatch();
        JdbcInsertStatementSelfTest.assertTrue((boolean)Arrays.equals(new int[]{2, 2}, res));
    }

    @Test
    public void testSingleItemBatch() throws SQLException {
        this.formBatch(1, 2);
        int[] res = this.prepStmt.executeBatch();
        JdbcInsertStatementSelfTest.assertTrue((boolean)Arrays.equals(new int[]{2}, res));
    }

    @Test
    public void testSingleItemBatchError() throws SQLException {
        this.formBatch(1, 2);
        this.prepStmt.executeBatch();
        this.formBatch(1, 2);
        BatchUpdateException reason = (BatchUpdateException)GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return JdbcInsertStatementSelfTest.this.prepStmt.executeBatch();
            }
        }, BatchUpdateException.class, (String)"Failed to INSERT some keys because they are already in cache");
        JdbcInsertStatementSelfTest.assertTrue((boolean)F.isEmpty((int[])reason.getUpdateCounts()));
    }

    @Test
    public void testErrorAmidstBatch() throws SQLException {
        this.formBatch(1, 2);
        this.formBatch(3, 1);
        BatchUpdateException reason = (BatchUpdateException)GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return JdbcInsertStatementSelfTest.this.prepStmt.executeBatch();
            }
        }, BatchUpdateException.class, (String)"Failed to INSERT some keys because they are already in cache");
        int[] counts = reason.getUpdateCounts();
        JdbcInsertStatementSelfTest.assertNotNull((Object)counts);
        JdbcInsertStatementSelfTest.assertEquals((int)1, (int)counts.length);
        JdbcInsertStatementSelfTest.assertEquals((int)2, (int)counts[0]);
    }

    @Test
    public void testClearBatch() throws Exception {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws SQLException {
                return JdbcInsertStatementSelfTest.this.prepStmt.executeBatch();
            }
        }, SQLException.class, (String)"Batch is empty");
        this.formBatch(1, 2);
        this.prepStmt.clearBatch();
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws SQLException {
                return JdbcInsertStatementSelfTest.this.prepStmt.executeBatch();
            }
        }, SQLException.class, (String)"Batch is empty");
    }

    private void formBatch(int id1, int id2) throws SQLException {
        int[] ids = new int[]{id1, id2};
        int arg = 0;
        for (int id : ids) {
            String key = "p" + id;
            switch (id) {
                case 1: {
                    this.prepStmt.setString(arg + 1, key);
                    this.prepStmt.setInt(arg + 2, 1);
                    this.prepStmt.setString(arg + 3, "John");
                    this.prepStmt.setString(arg + 4, "White");
                    this.prepStmt.setInt(arg + 5, 25);
                    this.prepStmt.setBytes(arg + 6, JdbcInsertStatementSelfTest.getBytes("White"));
                    break;
                }
                case 2: {
                    this.prepStmt.setString(arg + 1, key);
                    this.prepStmt.setInt(arg + 2, 2);
                    this.prepStmt.setString(arg + 3, "Joe");
                    this.prepStmt.setString(arg + 4, "Black");
                    this.prepStmt.setInt(arg + 5, 35);
                    this.prepStmt.setBytes(arg + 6, JdbcInsertStatementSelfTest.getBytes("Black"));
                    break;
                }
                case 3: {
                    this.prepStmt.setString(arg + 1, key);
                    this.prepStmt.setInt(arg + 2, 3);
                    this.prepStmt.setString(arg + 3, "Mike");
                    this.prepStmt.setString(arg + 4, "Green");
                    this.prepStmt.setInt(arg + 5, 40);
                    this.prepStmt.setBytes(arg + 6, JdbcInsertStatementSelfTest.getBytes("Green"));
                    break;
                }
                case 4: {
                    this.prepStmt.setString(arg + 1, key);
                    this.prepStmt.setInt(arg + 2, 4);
                    this.prepStmt.setString(arg + 3, "Leah");
                    this.prepStmt.setString(arg + 4, "Grey");
                    this.prepStmt.setInt(arg + 5, 22);
                    this.prepStmt.setBytes(arg + 6, JdbcInsertStatementSelfTest.getBytes("Grey"));
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            arg += 6;
        }
        this.prepStmt.addBatch();
    }
}

