/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.io.Serializable;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityKey;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class JdbcComplexQuerySelfTest
extends GridCommonAbstractTest {
    private static final String BASE_URL = "jdbc:ignite:cfg://cache=pers@modules/clients/src/test/config/jdbc-config.xml";
    private Statement stmt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("pers", AffinityKey.class, Person.class), this.cacheConfiguration("org", String.class, Organization.class)});
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        return cfg;
    }

    protected CacheConfiguration cacheConfiguration(@NotNull String name, Class<?> clsK, Class<?> clsV) {
        CacheConfiguration cache = JdbcComplexQuerySelfTest.defaultCacheConfiguration();
        cache.setName(name);
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cache.setIndexedTypes(new Class[]{clsK, clsV});
        return cache;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(3);
        IgniteCache orgCache = this.grid(0).cache("org");
        assert (orgCache != null);
        orgCache.put((Object)"o1", (Object)new Organization(1, "A"));
        orgCache.put((Object)"o2", (Object)new Organization(2, "B"));
        IgniteCache personCache = this.grid(0).cache("pers");
        assert (personCache != null);
        personCache.put((Object)new AffinityKey((Object)"p1", (Object)"o1"), (Object)new Person(1, "John White", 25, 1));
        personCache.put((Object)new AffinityKey((Object)"p2", (Object)"o1"), (Object)new Person(2, "Joe Black", 35, 1));
        personCache.put((Object)new AffinityKey((Object)"p3", (Object)"o2"), (Object)new Person(3, "Mike Green", 40, 2));
    }

    protected void beforeTest() throws Exception {
        this.stmt = DriverManager.getConnection(BASE_URL).createStatement();
        assert (this.stmt != null);
        assert (!this.stmt.isClosed());
    }

    protected void afterTest() throws Exception {
        if (this.stmt != null) {
            this.stmt.getConnection().close();
            this.stmt.close();
            assert (this.stmt.isClosed());
        }
    }

    @Test
    public void testJoin() throws Exception {
        ResultSet rs = this.stmt.executeQuery("select p.id, p.name, o.name as orgName from \"pers\".Person p, \"org\".Organization o where p.orgId = o.id");
        assert (rs != null);
        int cnt = 0;
        while (rs.next()) {
            int id = rs.getInt("id");
            if (id == 1) {
                assert ("John White".equals(rs.getString("name")));
                assert ("A".equals(rs.getString("orgName")));
            } else if (id == 2) {
                assert ("Joe Black".equals(rs.getString("name")));
                assert ("A".equals(rs.getString("orgName")));
            } else if (id == 3) {
                assert ("Mike Green".equals(rs.getString("name")));
                assert ("B".equals(rs.getString("orgName")));
            } else assert (false) : "Wrong ID: " + id;
            ++cnt;
        }
        assert (cnt == 3);
    }

    @Test
    public void testJoinWithoutAlias() throws Exception {
        ResultSet rs = this.stmt.executeQuery("select p.id, p.name, o.name from \"pers\".Person p, \"org\".Organization o where p.orgId = o.id");
        assert (rs != null);
        int cnt = 0;
        while (rs.next()) {
            int id = rs.getInt(1);
            if (id == 1) {
                assert ("John White".equals(rs.getString("name")));
                assert ("John White".equals(rs.getString(2)));
                assert ("A".equals(rs.getString(3)));
            } else if (id == 2) {
                assert ("Joe Black".equals(rs.getString("name")));
                assert ("Joe Black".equals(rs.getString(2)));
                assert ("A".equals(rs.getString(3)));
            } else if (id == 3) {
                assert ("Mike Green".equals(rs.getString("name")));
                assert ("Mike Green".equals(rs.getString(2)));
                assert ("B".equals(rs.getString(3)));
            } else assert (false) : "Wrong ID: " + id;
            ++cnt;
        }
        assert (cnt == 3);
    }

    @Test
    public void testIn() throws Exception {
        ResultSet rs = this.stmt.executeQuery("select name from \"pers\".Person where age in (25, 35)");
        assert (rs != null);
        int cnt = 0;
        while (rs.next()) {
            assert ("John White".equals(rs.getString("name")) || "Joe Black".equals(rs.getString("name")));
            ++cnt;
        }
        assert (cnt == 2);
    }

    @Test
    public void testBetween() throws Exception {
        ResultSet rs = this.stmt.executeQuery("select name from \"pers\".Person where age between 24 and 36");
        assert (rs != null);
        int cnt = 0;
        while (rs.next()) {
            assert ("John White".equals(rs.getString("name")) || "Joe Black".equals(rs.getString("name")));
            ++cnt;
        }
        assert (cnt == 2);
    }

    @Test
    public void testCalculatedValue() throws Exception {
        ResultSet rs = this.stmt.executeQuery("select age * 2 from \"pers\".Person");
        assert (rs != null);
        int cnt = 0;
        while (rs.next()) {
            assert (rs.getInt(1) == 50 || rs.getInt(1) == 70 || rs.getInt(1) == 80);
            ++cnt;
        }
        assert (cnt == 3);
    }

    private static class Organization
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField(index=false)
        private final String name;

        private Organization(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    private static class Person
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField(index=false)
        private final String name;
        @QuerySqlField
        private final int age;
        @QuerySqlField
        private final int orgId;

        private Person(int id, String name, int age, int orgId) {
            assert (!F.isEmpty((String)name));
            assert (age > 0);
            assert (orgId > 0);
            this.id = id;
            this.name = name;
            this.age = age;
            this.orgId = orgId;
        }
    }
}

