/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcBulkLoadSelfTest
extends GridCommonAbstractTest {
    private static final String BASE_URL = "jdbc:ignite:cfg://cache=default@modules/clients/src/test/config/jdbc-config.xml";
    protected Connection conn;
    protected transient IgniteLogger log;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        return this.getConfiguration0(gridName);
    }

    private IgniteConfiguration getConfiguration0(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        CacheConfiguration cache = JdbcBulkLoadSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setIndexedTypes(new Class[]{Integer.class, Person.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        cfg.setLocalHost("127.0.0.1");
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        TcpDiscoveryVmIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
        ipFinder.setAddresses(Collections.singleton("127.0.0.1:47500..47501"));
        disco.setIpFinder((TcpDiscoveryIpFinder)ipFinder);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(2);
    }

    private Connection createConnection() throws Exception {
        Properties props = new Properties();
        return DriverManager.getConnection(BASE_URL, props);
    }

    protected void afterTest() throws Exception {
        U.closeQuiet((AutoCloseable)this.conn);
        this.ignite(0).cache("default").clear();
        super.afterTest();
    }

    @Test
    public void testBulkLoadThrows() throws Exception {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcBulkLoadSelfTest.this.conn = JdbcBulkLoadSelfTest.this.createConnection();
                try (Statement stmt = JdbcBulkLoadSelfTest.this.conn.createStatement();){
                    stmt.executeUpdate("copy from 'dummy.csv' into Person (_key, id, firstName, lastName) format csv");
                    Object var3_3 = null;
                    return var3_3;
                }
            }
        }, SQLException.class, (String)"COPY command is currently supported only in thin JDBC driver.");
    }

    private static class Person
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField(index=false)
        private final String firstName;
        @QuerySqlField(index=false)
        private final String lastName;
        @QuerySqlField
        private final int age;

        private Person(int id, String firstName, String lastName, int age) {
            assert (!F.isEmpty((String)firstName));
            assert (!F.isEmpty((String)lastName));
            assert (age > 0);
            this.id = id;
            this.firstName = firstName;
            this.lastName = lastName;
            this.age = age;
        }
    }
}

