/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.client.router.GridRouterFactory;
import org.apache.ignite.internal.client.router.GridTcpRouter;
import org.apache.ignite.internal.client.router.GridTcpRouterConfiguration;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RouterFactorySelfTest
extends GridCommonAbstractTest {
    private static final int GRID_HTTP_PORT = 11087;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        TcpDiscoverySpi discoSpi = new TcpDiscoverySpi();
        discoSpi.setIpFinder(sharedStaticIpFinder);
        IgniteConfiguration cfg = new IgniteConfiguration();
        cfg.setDiscoverySpi((DiscoverySpi)discoSpi);
        cfg.setIgniteInstanceName(igniteInstanceName);
        return cfg;
    }

    @Before
    public void setup() throws Exception {
        System.setProperty("IGNITE_JETTY_PORT", String.valueOf(11087));
        try {
            this.startGrid();
        }
        finally {
            System.clearProperty("IGNITE_JETTY_PORT");
        }
    }

    @After
    public void tearDown() {
        GridRouterFactory.stopAllRouters();
        this.stopAllGrids();
    }

    @Test
    public void testRouterFactory() throws Exception {
        int size = 20;
        ArrayList<GridTcpRouter> tcpRouters = new ArrayList<GridTcpRouter>(20);
        GridTcpRouterConfiguration tcpCfg = new GridTcpRouterConfiguration();
        tcpCfg.setPortRange(20);
        for (int i = 0; i < 20; ++i) {
            tcpRouters.add(GridRouterFactory.startTcpRouter((GridTcpRouterConfiguration)tcpCfg));
        }
        for (GridTcpRouter tcpRouter : tcpRouters) {
            RouterFactorySelfTest.assertEquals((Object)tcpCfg, (Object)tcpRouter.configuration());
            RouterFactorySelfTest.assertEquals((Object)tcpRouter, (Object)GridRouterFactory.tcpRouter((UUID)tcpRouter.id()));
        }
        RouterFactorySelfTest.assertEquals((String)"Validate all started tcp routers.", new HashSet(tcpRouters), new HashSet(GridRouterFactory.allTcpRouters()));
        Iterator it = tcpRouters.iterator();
        while (it.hasNext()) {
            GridTcpRouter tcpRouter;
            tcpRouter = (GridTcpRouter)it.next();
            RouterFactorySelfTest.assertEquals((String)"Validate all started tcp routers.", new HashSet(tcpRouters), new HashSet(GridRouterFactory.allTcpRouters()));
            it.remove();
            GridRouterFactory.stopTcpRouter((UUID)tcpRouter.id());
            RouterFactorySelfTest.assertEquals((String)"Validate all started tcp routers.", new HashSet(tcpRouters), new HashSet(GridRouterFactory.allTcpRouters()));
        }
        RouterFactorySelfTest.assertEquals(Collections.emptyList(), (Object)GridRouterFactory.allTcpRouters());
    }
}

