/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.marshaller.GridClientMarshaller;
import org.apache.ignite.internal.client.marshaller.optimized.GridClientOptimizedMarshaller;
import org.apache.ignite.internal.processors.rest.client.message.GridClientAuthenticationRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientHandshakeRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientHandshakeResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridClientMessage;
import org.apache.ignite.internal.processors.rest.client.message.GridClientNodeBean;
import org.apache.ignite.internal.processors.rest.client.message.GridClientPingPacket;
import org.apache.ignite.internal.processors.rest.client.message.GridClientResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridClientTopologyRequest;
import org.apache.ignite.internal.processors.rest.protocols.tcp.GridTcpRestParser;
import org.apache.ignite.internal.util.nio.GridNioAsyncNotifyFilter;
import org.apache.ignite.internal.util.nio.GridNioCodecFilter;
import org.apache.ignite.internal.util.nio.GridNioFilter;
import org.apache.ignite.internal.util.nio.GridNioParser;
import org.apache.ignite.internal.util.nio.GridNioServer;
import org.apache.ignite.internal.util.nio.GridNioServerListener;
import org.apache.ignite.internal.util.nio.GridNioServerListenerAdapter;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.jetbrains.annotations.Nullable;

public class ClientTestRestServer {
    public static final int FIRST_SERVER_PORT = 11000;
    public static final int SERVERS_CNT = 5;
    private static final byte[] EMPTY_SES_TOKEN = new byte[0];
    private static final Collection<GridClientNodeBean> top = new ArrayList<GridClientNodeBean>();
    private final int port;
    private volatile boolean failOnConnect;
    private final IgniteLogger log;
    private final AtomicInteger connCnt = new AtomicInteger();
    private final AtomicInteger succConnCnt = new AtomicInteger();
    private final AtomicInteger disconnCnt = new AtomicInteger();
    private GridNioServer<GridClientMessage> srv;
    private volatile GridNioSession lastSes;

    public ClientTestRestServer(int port, boolean failOnConnect, IgniteLogger log) {
        this.port = port;
        this.failOnConnect = failOnConnect;
        this.log = log;
    }

    public int getPort() {
        return this.port;
    }

    public void start() throws IgniteCheckedException {
        try {
            String igniteInstanceName = "test";
            this.srv = GridNioServer.builder().address(InetAddress.getByName("127.0.0.1")).port(this.port).listener((GridNioServerListener)new TestListener()).logger(this.log).selectorCount(2).igniteInstanceName(igniteInstanceName).byteOrder(ByteOrder.nativeOrder()).tcpNoDelay(true).directBuffer(false).filters(new GridNioFilter[]{new GridNioAsyncNotifyFilter(igniteInstanceName, (Executor)Executors.newFixedThreadPool(2), this.log), new GridNioCodecFilter((GridNioParser)new TestParser(), this.log, false)}).build();
        }
        catch (UnknownHostException e) {
            throw new IgniteCheckedException("Failed to determine localhost address.", (Throwable)e);
        }
        this.srv.start();
    }

    public void stop() {
        assert (this.srv != null);
        this.srv.stop();
    }

    public int getConnectCount() {
        return this.connCnt.get();
    }

    public int getSuccessfulConnectCount() {
        return this.succConnCnt.get();
    }

    public int getDisconnectCount() {
        return this.disconnCnt.get();
    }

    public void fail() {
        assert (this.lastSes != null);
        this.lastSes.close();
        this.failOnConnect = true;
        this.resetCounters();
    }

    public void repair() {
        this.failOnConnect = false;
    }

    public void resetCounters() {
        this.connCnt.set(0);
        this.succConnCnt.set(0);
        this.disconnCnt.set(0);
    }

    private static GridClientResponse makeResponseFor(GridClientMessage msg) {
        GridClientResponse res = new GridClientResponse();
        res.clientId(msg.clientId());
        res.requestId(msg.requestId());
        res.successStatus(0);
        res.sessionToken(EMPTY_SES_TOKEN);
        return res;
    }

    static {
        for (int port = 11000; port < 11005; ++port) {
            GridClientNodeBean node = new GridClientNodeBean();
            node.setNodeId(UUID.randomUUID());
            node.setConsistentId((Object)("127.0.0.1:" + port));
            node.setTcpPort(port);
            node.setTcpAddresses(Arrays.asList("127.0.0.1"));
            top.add(node);
        }
    }

    private static class TestParser
    extends GridTcpRestParser {
        private final GridClientMarshaller marsh = new GridClientOptimizedMarshaller();

        public TestParser() {
            super(false);
        }

        protected GridClientMarshaller marshaller(GridNioSession ses) {
            return this.marsh;
        }
    }

    private class TestListener
    extends GridNioServerListenerAdapter<GridClientMessage> {
        private TestListener() {
        }

        public void onConnected(GridNioSession ses) {
            ClientTestRestServer.this.lastSes = ses;
            ClientTestRestServer.this.connCnt.incrementAndGet();
            if (ClientTestRestServer.this.failOnConnect) {
                ses.close();
            } else {
                ClientTestRestServer.this.succConnCnt.incrementAndGet();
            }
        }

        public void onDisconnected(GridNioSession ses, @Nullable Exception e) {
            ClientTestRestServer.this.disconnCnt.incrementAndGet();
        }

        public void onMessage(GridNioSession ses, GridClientMessage msg) {
            if (msg == GridClientPingPacket.PING_MESSAGE) {
                ses.send((Object)GridClientPingPacket.PING_MESSAGE);
            } else if (msg instanceof GridClientAuthenticationRequest) {
                ses.send((Object)ClientTestRestServer.makeResponseFor(msg));
            } else if (msg instanceof GridClientTopologyRequest) {
                GridClientResponse res = ClientTestRestServer.makeResponseFor(msg);
                res.result((Object)top);
                ses.send((Object)res);
            } else if (msg instanceof GridClientHandshakeRequest) {
                ses.send((Object)GridClientHandshakeResponse.OK);
            }
        }

        public void onSessionWriteTimeout(GridNioSession ses) {
            ses.close();
        }

        public void onSessionIdleTimeout(GridNioSession ses) {
            ses.close();
        }
    }
}

