/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskSplitAdapter;

public class ClientTcpTask
extends ComputeTaskSplitAdapter<List<String>, Integer> {
    protected Collection<? extends ComputeJob> split(int gridSize, List<String> list) {
        ArrayList<1> jobs = new ArrayList<1>();
        if (list != null) {
            for (final String val : list) {
                jobs.add(new ComputeJobAdapter(){

                    public Object execute() {
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException ignored) {
                            Thread.currentThread().interrupt();
                        }
                        return val == null ? 0 : val.length();
                    }
                });
            }
        }
        return jobs;
    }

    public Integer reduce(List<ComputeJobResult> results) {
        int sum = 0;
        for (ComputeJobResult res : results) {
            sum += ((Integer)res.getData()).intValue();
        }
        return sum;
    }

    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        if (res.getException() != null) {
            return ComputeJobResultPolicy.FAILOVER;
        }
        return ComputeJobResultPolicy.WAIT;
    }
}

