/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.loadtests.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.client.marshaller.GridClientMarshaller;
import org.apache.ignite.internal.client.marshaller.jdk.GridClientJdkMarshaller;
import org.apache.ignite.internal.client.marshaller.optimized.GridClientOptimizedMarshaller;
import org.apache.ignite.internal.processors.rest.client.message.GridClientCacheRequest;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class ClientMarshallerBenchmarkTest
extends GridCommonAbstractTest {
    private GridClientMarshaller[] marshallers;

    public ClientMarshallerBenchmarkTest() {
        try {
            this.marshallers = new GridClientMarshaller[]{new GridClientJdkMarshaller(MarshallerUtils.classNameFilter((ClassLoader)((Object)((Object)this)).getClass().getClassLoader())), new GridClientOptimizedMarshaller()};
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    @Test
    public void testCacheRequestTime() throws Exception {
        GridClientCacheRequest req = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.CAS);
        req.clientId(UUID.randomUUID());
        req.cacheName("CacheName");
        req.requestId(1024L);
        req.key((Object)"key");
        req.value((Object)1L);
        req.value2((Object)2L);
        HashMap<String, Long> additional = new HashMap<String, Long>();
        for (int i = 0; i < 1000; ++i) {
            additional.put("key" + i, Long.valueOf(i));
        }
        req.values(additional);
        for (GridClientMarshaller marshaller : this.marshallers) {
            GridClientCacheRequest res = this.runMarshallUnmarshalLoop(req, 1, marshaller);
            ClientMarshallerBenchmarkTest.assertEquals((Object)req.operation(), (Object)res.operation());
            ClientMarshallerBenchmarkTest.assertEquals((long)0L, (long)res.requestId());
            ClientMarshallerBenchmarkTest.assertEquals(null, (Object)res.clientId());
            ClientMarshallerBenchmarkTest.assertEquals(null, (Object)res.destinationId());
            ClientMarshallerBenchmarkTest.assertEquals((String)req.cacheName(), (String)res.cacheName());
            ClientMarshallerBenchmarkTest.assertEquals((Object)req.key(), (Object)res.key());
            ClientMarshallerBenchmarkTest.assertEquals((Object)req.value(), (Object)res.value());
            ClientMarshallerBenchmarkTest.assertEquals((Object)req.value2(), (Object)res.value2());
            for (Map.Entry e : req.values().entrySet()) {
                ClientMarshallerBenchmarkTest.assertEquals(e.getValue(), res.values().get(e.getKey()));
            }
        }
        for (GridClientMarshaller marshaller : this.marshallers) {
            this.runMarshallUnmarshalLoop(req, 1000, marshaller);
        }
    }

    private <T> T runMarshallUnmarshalLoop(T obj, int iterCnt, GridClientMarshaller marshaller) throws IOException {
        if (iterCnt == 1) {
            ByteBuffer buf = marshaller.marshal(obj, 0);
            byte[] arr = new byte[buf.remaining()];
            buf.get(arr);
            Object res = marshaller.unmarshal(arr);
            ClientMarshallerBenchmarkTest.assertNotNull((String)("Failed for marshaller: " + marshaller.getClass().getSimpleName()), (Object)res);
            return (T)res;
        }
        long marshallingTime = 0L;
        long unmarshallingTime = 0L;
        long start = System.currentTimeMillis();
        Object res = null;
        for (int i = 0; i < iterCnt; ++i) {
            ByteBuffer buf = marshaller.marshal(obj, 0);
            byte[] raw = new byte[buf.remaining()];
            buf.get(raw);
            long end = System.currentTimeMillis();
            marshallingTime += end - start;
            start = end;
            res = marshaller.unmarshal(raw);
            ClientMarshallerBenchmarkTest.assertNotNull((Object)res);
            end = System.currentTimeMillis();
            unmarshallingTime += end - start;
            start = end;
        }
        X.println((String)("Marshalling statistics gathered [marshallerClass=" + marshaller.getClass().getSimpleName() + ", objClass=" + obj.getClass().getSimpleName() + ", marshallingTime=" + marshallingTime + ", unmarshallingTime=" + unmarshallingTime + "]"), (Object[])new Object[0]);
        assert (res != null);
        return (T)res;
    }
}

