/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.junit.Assert;
import org.junit.Test;

@WithSystemProperty(key="IGNITE_SQL_SYSTEM_SCHEMA_NAME_IGNITE", value="true")
public class JdbcThinSystemSchemaDurabilityTest
extends JdbcThinAbstractSelfTest {
    protected static final String BASE_URL = "jdbc:ignite:thin://127.0.0.1/";

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
    }

    @Test
    public void testMetaAvailableAfterSysNameChanged() throws Exception {
        Throwable throwable;
        Statement stmt;
        GridTestUtils.setFieldValue(QueryUtils.class, (String)"schemaSys", null);
        this.startAndActivateGrid();
        try (Connection conn = DriverManager.getConnection(BASE_URL);){
            stmt = conn.createStatement();
            throwable = null;
            try {
                stmt.execute("CREATE TABLE TTT (id int primary key, a long)");
                this.ensureTblPresent(stmt, "IGNITE", "TTT");
                stmt.execute(" INSERT INTO TTT (id, a) VALUES (0, 1)");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        this.stopGrid(0);
        System.clearProperty("IGNITE_SQL_SYSTEM_SCHEMA_NAME_IGNITE");
        GridTestUtils.setFieldValue(QueryUtils.class, (String)"schemaSys", null);
        this.startAndActivateGrid();
        conn = DriverManager.getConnection(BASE_URL);
        var2_2 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                this.ensureTblPresent(stmt, "SYS", "TTT");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var2_2 = throwable6;
            throw throwable6;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable7) {
                        var2_2.addSuppressed(throwable7);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    private void startAndActivateGrid() throws Exception {
        this.startGrid(0);
        this.grid(0).cluster().active(true);
    }

    private void ensureTblPresent(Statement stmt, String sysSchemaName, String tblName) throws SQLException {
        ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM " + sysSchemaName + ".tables WHERE TABLE_NAME = '" + tblName + "'");
        Assert.assertTrue((String)("Table \"" + tblName + "\" not found"), (boolean)rs.next());
        Assert.assertEquals((String)("Found more than 1 table with name \"" + tblName + "\""), (long)1L, (long)rs.getInt(1));
    }
}

