/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryManager;
import org.apache.ignite.internal.processors.query.oom.AbstractQueryMemoryTrackerSelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JdbcThinQueryMemoryTrackerWithOffloadingSelfTest
extends AbstractQueryMemoryTrackerSelfTest {
    @Parameterized.Parameter
    public boolean lazy;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setSqlConfiguration(new SqlConfiguration().setSqlOffloadingEnabled(true).setSqlGlobalMemoryQuota(Long.toString(this.globalQuotaSize())));
    }

    @Parameterized.Parameters(name="lazy = {0}")
    public static Iterable<Object[]> valuesForAsync() {
        return Arrays.asList({true}, {false});
    }

    @Test
    public void testCorrectCloseMemoryTrackerWithOffloading() throws Throwable {
        this.maxMem = 102400L;
        LogListener logLsnr = LogListener.matches((String)"Offloading started for query").build();
        this.testLog(this.grid(0)).registerListener(logLsnr);
        try (Connection conn = this.createConnection(this.lazy);
             Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT TOP 1 * FROM (SELECT T.id, T.ref_key, T.name FROM T inner join T k2 ON T.ref_key=k2.ref_key where T.id > 0 group by T.id) X");
            JdbcThinQueryMemoryTrackerWithOffloadingSelfTest.assertTrue((boolean)rs.next());
        }
        JdbcThinQueryMemoryTrackerWithOffloadingSelfTest.assertTrue((boolean)logLsnr.check());
    }

    private ListeningTestLogger testLog(IgniteEx node) {
        ListeningTestLogger testLog = new ListeningTestLogger(log);
        GridTestUtils.setFieldValue((Object)this.memoryManager(node), (String)"log", (Object)testLog);
        return testLog;
    }

    private QueryMemoryManager memoryManager(IgniteEx node) {
        IgniteH2Indexing h2 = (IgniteH2Indexing)node.context().query().getIndexing();
        return h2.memoryManager();
    }

    protected boolean isLocal() {
        return false;
    }

    protected Connection createConnection(boolean lazy) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800..10802?queryMaxMemory=" + this.maxMem + "&lazy=" + lazy);
        conn.setSchema("\"PUBLIC\"");
        return conn;
    }
}

