/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcThinFeature;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class JdbcThinPreparedStatementSelfTest
extends JdbcThinAbstractSelfTest {
    private static final String URL = "jdbc:ignite:thin://127.0.0.1";
    private static final String SQL_PART = "select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject ";
    private Connection conn;
    private PreparedStatement stmt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcThinPreparedStatementSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setIndexedTypes(new Class[]{Integer.class, TestObject.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(3);
        IgniteCache cache = this.grid(0).cache("default");
        assert (cache != null);
        TestObject o = new TestObject(1);
        o.boolVal = true;
        o.byteVal = (byte)1;
        o.shortVal = (short)1;
        o.intVal = 1;
        o.longVal = 1L;
        o.floatVal = Float.valueOf(1.0f);
        o.doubleVal = 1.0;
        o.bigVal = new BigDecimal(1);
        o.strVal = "str";
        TestObject.access$1002(o, new byte[]{1});
        o.dateVal = new Date(1L);
        o.timeVal = new Time(1L);
        o.tsVal = new Timestamp(1L);
        o.urlVal = new URL("http://abc.com/");
        o.objVal = new TestObjectField(100, "AAAA");
        cache.put((Object)1, (Object)o);
        cache.put((Object)2, (Object)new TestObject(2));
    }

    protected void beforeTest() throws Exception {
        this.conn = this.createConnection(false);
        assert (this.conn != null);
        assert (!this.conn.isClosed());
    }

    protected void afterTest() throws Exception {
        if (this.stmt != null) {
            this.stmt.close();
            assert (this.stmt.isClosed());
        }
        if (this.conn != null) {
            this.conn.close();
            assert (this.conn.isClosed());
        }
    }

    private Connection createConnection(boolean keepBinary) throws SQLException {
        String url = keepBinary ? "jdbc:ignite:thin://127.0.0.1?keepBinary=true" : URL;
        Connection conn = DriverManager.getConnection(url);
        conn.setSchema("\"default\"");
        return conn;
    }

    private Connection createConnection(JdbcThinFeature ... disabledFeatues) throws SQLException {
        String url = "jdbc:ignite:thin://127.0.0.1?disabledFeatures=" + Arrays.stream(disabledFeatues).map(Enum::name).collect(Collectors.joining(","));
        Connection conn = DriverManager.getConnection(url);
        conn.setSchema("\"default\"");
        return conn;
    }

    @Test
    public void testRepeatableUsage() throws Exception {
        this.stmt = this.conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where id = ?");
        this.stmt.setInt(1, 1);
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                JdbcThinPreparedStatementSelfTest.assertEquals((int)1, (int)rs.getInt(1));
            }
            ++cnt;
        }
        JdbcThinPreparedStatementSelfTest.assertEquals((int)1, (int)cnt);
        cnt = 0;
        rs = this.stmt.executeQuery();
        while (rs.next()) {
            if (cnt == 0) {
                JdbcThinPreparedStatementSelfTest.assertEquals((int)1, (int)rs.getInt(1));
            }
            ++cnt;
        }
        JdbcThinPreparedStatementSelfTest.assertEquals((int)1, (int)cnt);
    }

    @Test
    public void testObjectDifferentConnections() throws SQLException {
        TestObjectField exp = new TestObjectField(42, "BBBB");
        this.conn.createStatement().execute("CREATE TABLE test(id INT PRIMARY KEY, objVal OTHER)");
        this.stmt = this.conn.prepareStatement("INSERT INTO test(id, objVal) VALUES (?, ?)");
        this.stmt.setInt(1, exp.a);
        this.stmt.setObject(2, exp);
        this.stmt.execute();
        try (Connection anotherConn = this.createConnection(false);
             PreparedStatement stmt = anotherConn.prepareStatement("SELECT id, objVal FROM test WHERE id = ?");){
            stmt.setInt(1, exp.a);
            int cnt = 0;
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                if (cnt == 0) {
                    Assert.assertTrue((String)"Result's value type mismatch", (boolean)(rs.getObject("objVal") instanceof TestObjectField));
                    Assert.assertEquals((String)"Result's value mismatch", (Object)exp, (Object)rs.getObject("objVal", TestObjectField.class));
                }
                ++cnt;
            }
            Assert.assertEquals((String)"There should be exactly 1 result", (long)1L, (long)cnt);
        }
    }

    @Test
    public void testObjectConnectionWithKeepBinaryFlag() throws SQLException {
        try (Connection anotherConn = this.createConnection(true);){
            this.stmt = anotherConn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where objVal is not distinct from ?");
            this.stmt.setObject(1, new TestObjectField(100, "AAAA"));
            int cnt = 0;
            ResultSet rs = this.stmt.executeQuery();
            while (rs.next()) {
                if (cnt == 0) {
                    Assert.assertEquals((String)"Result's id mismatch", (long)1L, (long)rs.getInt("id"));
                    Assert.assertTrue((boolean)(rs.getObject("objVal") instanceof BinaryObject));
                    Assert.assertEquals((String)"Result's value mismatch", (Object)100, (Object)rs.getObject("objVal", BinaryObject.class).field("a"));
                }
                ++cnt;
            }
            Assert.assertEquals((String)"There should be exactly 1 result", (long)1L, (long)cnt);
        }
    }

    @Test
    public void testObject() throws Exception {
        this.stmt = this.conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where objVal is not distinct from ?");
        this.stmt.setObject(1, new TestObjectField(100, "AAAA"));
        int cnt = 0;
        ResultSet rs = this.stmt.executeQuery();
        while (rs.next()) {
            if (cnt == 0) {
                Assert.assertEquals((String)"Result's id mismatch", (long)1L, (long)rs.getInt("id"));
                Assert.assertTrue((String)"Result's value type mismatch", (boolean)(rs.getObject("objVal") instanceof TestObjectField));
                Assert.assertEquals((String)"Result's value mismatch", (long)100L, (long)rs.getObject((String)"objVal", TestObjectField.class).a);
            }
            ++cnt;
        }
        Assert.assertEquals((String)"There should be exactly 1 result", (long)1L, (long)cnt);
        this.stmt.setNull(1, 2000);
        this.stmt.execute();
        cnt = 0;
        rs = this.stmt.getResultSet();
        while (rs.next()) {
            if (cnt == 0) {
                Assert.assertEquals((String)"Result's id mismatch", (long)2L, (long)rs.getInt("id"));
                Assert.assertNull((String)"Result's value should be null", (Object)rs.getObject("objVal"));
            }
            ++cnt;
        }
        Assert.assertEquals((String)"There should be exactly 1 result", (long)1L, (long)cnt);
    }

    @Test
    public void testCustomObjectSupportCanBeDisabled() throws SQLException {
        try (Connection conn = this.createConnection(JdbcThinFeature.CUSTOM_OBJECT);
             final PreparedStatement stmt = conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where objVal is not distinct from ?");){
            Throwable t = GridTestUtils.assertThrowsWithCause((Runnable)new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    stmt.setObject(1, new TestObjectField(100, "AAAA"));
                }
            }, SQLException.class);
            Assert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.containsString((String)"Custom objects are not supported")));
        }
    }

    @Test
    public void testQueryExecuteException() throws Exception {
        this.stmt = this.conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where boolVal is not distinct from ?");
        this.stmt.setBoolean(1, true);
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.executeQuery("select 1");
                return null;
            }
        }, SQLException.class, (String)"The method 'executeQuery(String)' is called on PreparedStatement instance.");
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.execute("select 1");
                return null;
            }
        }, SQLException.class, (String)"The method 'execute(String)' is called on PreparedStatement instance.");
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.execute("select 1", 2);
                return null;
            }
        }, SQLException.class, (String)"The method 'execute(String)' is called on PreparedStatement instance.");
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.executeUpdate("select 1", 2);
                return null;
            }
        }, SQLException.class, (String)"The method 'executeUpdate(String, int)' is called on PreparedStatement instance.");
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.executeUpdate("select 1", new int[]{1});
                return null;
            }
        }, SQLException.class, (String)"The method 'executeUpdate(String, int[])' is called on PreparedStatement instance.");
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.executeUpdate("select 1 as a", new String[]{"a"});
                return null;
            }
        }, SQLException.class, (String)"The method 'executeUpdate(String, String[])' is called on PreparedStatement instance.");
    }

    @Test
    public void testBoolean() throws Exception {
        this.stmt = this.conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where boolVal is not distinct from ?");
        this.stmt.setBoolean(1, true);
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 16);
        this.stmt.execute();
        rs = this.stmt.getResultSet();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testByte() throws Exception {
        this.stmt = this.conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where byteVal is not distinct from ?");
        this.stmt.setByte(1, (byte)1);
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, -6);
        this.stmt.execute();
        rs = this.stmt.getResultSet();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testShort() throws Exception {
        this.stmt = this.conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where shortVal is not distinct from ?");
        this.stmt.setShort(1, (short)1);
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 5);
        this.stmt.execute();
        rs = this.stmt.getResultSet();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testInteger() throws Exception {
        this.stmt = this.conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where intVal is not distinct from ?");
        this.stmt.setInt(1, 1);
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 4);
        this.stmt.execute();
        rs = this.stmt.getResultSet();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testLong() throws Exception {
        this.stmt = this.conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where longVal is not distinct from ?");
        this.stmt.setLong(1, 1L);
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, -5);
        this.stmt.execute();
        rs = this.stmt.getResultSet();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testFloat() throws Exception {
        this.stmt = this.conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where floatVal is not distinct from ?");
        this.stmt.setFloat(1, 1.0f);
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 6);
        this.stmt.execute();
        rs = this.stmt.getResultSet();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testDouble() throws Exception {
        this.stmt = this.conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where doubleVal is not distinct from ?");
        this.stmt.setDouble(1, 1.0);
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 8);
        this.stmt.execute();
        rs = this.stmt.getResultSet();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testBigDecimal() throws Exception {
        this.stmt = this.conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where bigVal is not distinct from ?");
        this.stmt.setBigDecimal(1, new BigDecimal(1));
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 1111);
        this.stmt.execute();
        rs = this.stmt.getResultSet();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testString() throws Exception {
        this.stmt = this.conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where strVal is not distinct from ?");
        this.stmt.setString(1, "str");
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 12);
        this.stmt.execute();
        rs = this.stmt.getResultSet();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testArray() throws Exception {
        this.stmt = this.conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where arrVal is not distinct from ?");
        this.stmt.setBytes(1, new byte[]{1});
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, -2);
        this.stmt.execute();
        rs = this.stmt.getResultSet();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testDate() throws Exception {
        this.stmt = this.conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where dateVal is not distinct from ?");
        this.stmt.setObject(1, new Date(1L));
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 91);
        this.stmt.execute();
        rs = this.stmt.getResultSet();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testTime() throws Exception {
        this.stmt = this.conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where timeVal is not distinct from ?");
        this.stmt.setTime(1, new Time(1L));
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 92);
        this.stmt.execute();
        rs = this.stmt.getResultSet();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testTimestamp() throws Exception {
        this.stmt = this.conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where tsVal is not distinct from ?");
        this.stmt.setTimestamp(1, new Timestamp(1L));
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 93);
        this.stmt.execute();
        rs = this.stmt.getResultSet();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testClearParameter() throws Exception {
        this.stmt = this.conn.prepareStatement("select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject  where boolVal is not distinct from ?");
        this.stmt.setString(1, "");
        this.stmt.setLong(2, 1L);
        this.stmt.setInt(5, 1);
        this.stmt.clearParameters();
        this.stmt.setBoolean(1, true);
        ResultSet rs = this.stmt.executeQuery();
        boolean hasNext = rs.next();
        assert (hasNext);
        assert (rs.getInt("id") == 1);
    }

    @Test
    public void testNotSupportedTypes() throws Exception {
        this.stmt = this.conn.prepareStatement("");
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setArray(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setAsciiStream(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setAsciiStream(1, (InputStream)null, 0);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setAsciiStream(1, null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setBinaryStream(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setBinaryStream(1, (InputStream)null, 0);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setBinaryStream(1, null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setBlob(1, (Blob)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setBlob(1, (InputStream)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setBlob(1, null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setCharacterStream(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setCharacterStream(1, (Reader)null, 0);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setCharacterStream(1, null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setClob(1, (Clob)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setClob(1, (Reader)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setClob(1, null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setNCharacterStream(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setNCharacterStream(1, null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setNClob(1, (NClob)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setNClob(1, (Reader)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setNClob(1, null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setRowId(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setRef(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setSQLXML(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinPreparedStatementSelfTest.this.stmt.setURL(1, new URL("http://test"));
            }
        });
    }

    private static class TestObjectField
    implements Serializable {
        final int a;
        final String b;

        private TestObjectField(int a, String b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestObjectField that = (TestObjectField)o;
            return this.a == that.a && !(this.b == null ? that.b != null : !this.b.equals(that.b));
        }

        public int hashCode() {
            int res = this.a;
            res = 31 * res + (this.b != null ? this.b.hashCode() : 0);
            return res;
        }

        public String toString() {
            return S.toString(TestObjectField.class, (Object)this);
        }
    }

    private static class TestObject
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField
        private Boolean boolVal;
        @QuerySqlField
        private Byte byteVal;
        @QuerySqlField
        private Short shortVal;
        @QuerySqlField
        private Integer intVal;
        @QuerySqlField
        private Long longVal;
        @QuerySqlField
        private Float floatVal;
        @QuerySqlField
        private Double doubleVal;
        @QuerySqlField
        private BigDecimal bigVal;
        @QuerySqlField
        private String strVal;
        @QuerySqlField
        private byte[] arrVal;
        @QuerySqlField
        private Date dateVal;
        @QuerySqlField
        private Time timeVal;
        @QuerySqlField
        private Timestamp tsVal;
        @QuerySqlField
        private URL urlVal;
        @QuerySqlField
        private TestObjectField objVal;

        private TestObject(int id) {
            this.id = id;
        }

        static /* synthetic */ byte[] access$1002(TestObject x0, byte[] x1) {
            x0.arrVal = x1;
            return x1;
        }
    }
}

