/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.affinity.AffinityKey;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.processors.query.QueryEntityEx;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class JdbcThinMetadataSelfTest
extends JdbcThinAbstractSelfTest {
    private static final String URL = "jdbc:ignite:thin://127.0.0.1/";
    public static final String URL_PARTITION_AWARENESS = "jdbc:ignite:thin://127.0.0.1:10800..10801?partitionAwareness=true";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setSqlConfiguration(new SqlConfiguration().setSqlSchemas(new String[]{"PREDEFINED_SCHEMAS_1", "PREDEFINED_SCHEMAS_2"}));
    }

    protected CacheConfiguration cacheConfiguration(QueryEntity qryEntity) {
        CacheConfiguration cache = JdbcThinMetadataSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setQueryEntities(Collections.singletonList(qryEntity));
        return cache;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(3);
        HashMap<String, Integer> orgPrecision = new HashMap<String, Integer>();
        orgPrecision.put("name", 42);
        IgniteCache orgCache = this.jcache((Ignite)this.grid(0), this.cacheConfiguration(new QueryEntity(String.class.getName(), Organization.class.getName()).addQueryField("id", Integer.class.getName(), null).addQueryField("name", String.class.getName(), null).setFieldsPrecision(orgPrecision).setIndexes(Arrays.asList(new QueryIndex("id"), new QueryIndex("name", false, "org_name_index")))), "org");
        assert (orgCache != null);
        orgCache.put((Object)"o1", (Object)new Organization(1, "A"));
        orgCache.put((Object)"o2", (Object)new Organization(2, "B"));
        LinkedHashMap<String, Boolean> persFields = new LinkedHashMap<String, Boolean>();
        persFields.put("name", true);
        persFields.put("age", false);
        IgniteCache personCache = this.jcache((Ignite)this.grid(0), this.cacheConfiguration(new QueryEntityEx(new QueryEntity(AffinityKey.class.getName(), Person.class.getName()).addQueryField("name", String.class.getName(), null).addQueryField("age", Integer.class.getName(), null).addQueryField("orgId", Integer.class.getName(), null).setIndexes(Arrays.asList(new QueryIndex("orgId"), new QueryIndex().setFields(persFields)))).setNotNullFields(new HashSet<String>(Arrays.asList("age", "name")))), "pers");
        assert (personCache != null);
        personCache.put((Object)new AffinityKey((Object)"p1", (Object)"o1"), (Object)new Person("John White", 25, 1));
        personCache.put((Object)new AffinityKey((Object)"p2", (Object)"o1"), (Object)new Person("Joe Black", 35, 1));
        personCache.put((Object)new AffinityKey((Object)"p3", (Object)"o2"), (Object)new Person("Mike Green", 40, 2));
        this.jcache((Ignite)this.grid(0), JdbcThinMetadataSelfTest.defaultCacheConfiguration().setIndexedTypes(new Class[]{Integer.class, Department.class}), "dep");
        try (Connection conn = DriverManager.getConnection(URL);){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE TEST (ID INT, NAME VARCHAR(50) default 'default name', age int default 21, VAL VARCHAR(50), PRIMARY KEY (ID, NAME))");
            stmt.execute("CREATE TABLE \"Quoted\" (\"Id\" INT primary key, \"Name\" VARCHAR(50)) WITH WRAP_KEY");
            stmt.execute("CREATE INDEX \"MyTestIndex quoted\" on \"Quoted\" (\"Id\" DESC)");
            stmt.execute("CREATE INDEX IDX ON TEST (ID ASC)");
            stmt.execute("CREATE TABLE TEST_DECIMAL_COLUMN (ID INT primary key, DEC_COL DECIMAL(8, 3))");
            stmt.execute("CREATE TABLE TEST_DECIMAL_COLUMN_PRECISION (ID INT primary key, DEC_COL DECIMAL(8))");
            stmt.execute("CREATE TABLE TEST_DECIMAL_DATE_COLUMN_META (ID INT primary key, DEC_COL DECIMAL(8), DATE_COL DATE)");
        }
    }

    @Test
    public void testResultSetMetaData() throws Exception {
        Connection conn = DriverManager.getConnection(URL);
        conn.setSchema("\"pers\"");
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("select p.name, o.id as orgId from \"pers\".Person p, \"org\".Organization o where p.orgId = o.id");
        assert (rs != null);
        ResultSetMetaData meta = rs.getMetaData();
        assert (meta != null);
        assert (meta.getColumnCount() == 2);
        assert ("Person".equalsIgnoreCase(meta.getTableName(1)));
        assert ("name".equalsIgnoreCase(meta.getColumnName(1)));
        assert ("name".equalsIgnoreCase(meta.getColumnLabel(1)));
        assert (meta.getColumnType(1) == 12);
        assert ("VARCHAR".equals(meta.getColumnTypeName(1)));
        assert ("java.lang.String".equals(meta.getColumnClassName(1)));
        assert ("Organization".equalsIgnoreCase(meta.getTableName(2)));
        assert ("orgId".equalsIgnoreCase(meta.getColumnName(2)));
        assert ("orgId".equalsIgnoreCase(meta.getColumnLabel(2)));
        assert (meta.getColumnType(2) == 4);
        assert ("INTEGER".equals(meta.getColumnTypeName(2)));
        assert ("java.lang.Integer".equals(meta.getColumnClassName(2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadataPresentedForAutogeneratedColumns() throws SQLException {
        String cacheName = "testCache";
        IgniteCache cache = this.grid(0).createCache(new CacheConfiguration("testCache").setIndexedTypes(new Class[]{Integer.class, String.class}));
        try (Connection conn = DriverManager.getConnection(URL);){
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getColumns(null, "testCache", null, null);
            JdbcThinMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcThinMetadataSelfTest.assertEquals((String)"testCache", (String)rs.getString(MetadataColumn.TABLE_SCHEMA.columnName()));
            JdbcThinMetadataSelfTest.assertEquals((String)"_KEY", (String)rs.getString(MetadataColumn.COLUMN_NAME.columnName()));
            JdbcThinMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcThinMetadataSelfTest.assertEquals((String)"testCache", (String)rs.getString(MetadataColumn.TABLE_SCHEMA.columnName()));
            JdbcThinMetadataSelfTest.assertEquals((String)"_VAL", (String)rs.getString(MetadataColumn.COLUMN_NAME.columnName()));
            JdbcThinMetadataSelfTest.assertFalse((boolean)rs.next());
        }
        finally {
            cache.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadataNotDublicatedIfFieldsSetExplicitly() throws SQLException {
        String cacheName = "testCache";
        IgniteCache cache = this.grid(0).createCache(new CacheConfiguration("testCache").setQueryEntities(Collections.singleton(new QueryEntity().setKeyType(Integer.class.getName()).setKeyFieldName("my_key").setValueType(String.class.getName()).setFields(new LinkedHashMap(IgniteUtils.map((Object)"my_key", (Object)Integer.class.getName()))))).setIndexedTypes(new Class[]{Integer.class, String.class}));
        try (Connection conn = DriverManager.getConnection(URL);){
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getColumns(null, "testCache", null, null);
            JdbcThinMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcThinMetadataSelfTest.assertEquals((String)"testCache", (String)rs.getString(MetadataColumn.TABLE_SCHEMA.columnName()));
            JdbcThinMetadataSelfTest.assertEquals((String)"MY_KEY", (String)rs.getString(MetadataColumn.COLUMN_NAME.columnName()));
            JdbcThinMetadataSelfTest.assertFalse((boolean)rs.next());
        }
        finally {
            cache.destroy();
        }
    }

    @Test
    public void testDecimalAndDateTypeMetaData() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select t.dec_col, t.date_col from TEST_DECIMAL_DATE_COLUMN_META as t");
            assert (rs != null);
            ResultSetMetaData meta = rs.getMetaData();
            assert (meta != null);
            assert (meta.getColumnCount() == 2);
            assert ("TEST_DECIMAL_DATE_COLUMN_META".equalsIgnoreCase(meta.getTableName(1)));
            assert ("DEC_COL".equalsIgnoreCase(meta.getColumnName(1)));
            assert ("DEC_COL".equalsIgnoreCase(meta.getColumnLabel(1)));
            assert (meta.getColumnType(1) == 3);
            assert ("DECIMAL".equals(meta.getColumnTypeName(1)));
            assert ("java.math.BigDecimal".equals(meta.getColumnClassName(1)));
            assert ("TEST_DECIMAL_DATE_COLUMN_META".equalsIgnoreCase(meta.getTableName(2)));
            assert ("DATE_COL".equalsIgnoreCase(meta.getColumnName(2)));
            assert ("DATE_COL".equalsIgnoreCase(meta.getColumnLabel(2)));
            assert (meta.getColumnType(2) == 91);
            assert ("DATE".equals(meta.getColumnTypeName(2)));
            assert ("java.sql.Date".equals(meta.getColumnClassName(2)));
        }
    }

    @Test
    public void testGetTableTypes() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getTableTypes();
            JdbcThinMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcThinMetadataSelfTest.assertEquals((String)"TABLE", (String)rs.getString("TABLE_TYPE"));
            JdbcThinMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcThinMetadataSelfTest.assertEquals((String)"VIEW", (String)rs.getString("TABLE_TYPE"));
        }
    }

    @Test
    public void testGetTables() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getTables(null, "pers", "%", new String[]{"TABLE"});
            JdbcThinMetadataSelfTest.assertNotNull((Object)rs);
            JdbcThinMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcThinMetadataSelfTest.assertEquals((String)"TABLE", (String)rs.getString("TABLE_TYPE"));
            JdbcThinMetadataSelfTest.assertEquals((String)"IGNITE", (String)rs.getString("TABLE_CAT"));
            JdbcThinMetadataSelfTest.assertEquals((String)"PERSON", (String)rs.getString("TABLE_NAME"));
            JdbcThinMetadataSelfTest.assertFalse((boolean)rs.next());
            rs = meta.getTables(null, "org", "%", new String[]{"TABLE"});
            JdbcThinMetadataSelfTest.assertNotNull((Object)rs);
            JdbcThinMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcThinMetadataSelfTest.assertEquals((String)"TABLE", (String)rs.getString("TABLE_TYPE"));
            JdbcThinMetadataSelfTest.assertEquals((String)"IGNITE", (String)rs.getString("TABLE_CAT"));
            JdbcThinMetadataSelfTest.assertEquals((String)"ORGANIZATION", (String)rs.getString("TABLE_NAME"));
            JdbcThinMetadataSelfTest.assertFalse((boolean)rs.next());
            rs = meta.getTables(null, "pers", "%", null);
            JdbcThinMetadataSelfTest.assertNotNull((Object)rs);
            JdbcThinMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcThinMetadataSelfTest.assertEquals((String)"TABLE", (String)rs.getString("TABLE_TYPE"));
            JdbcThinMetadataSelfTest.assertEquals((String)"IGNITE", (String)rs.getString("TABLE_CAT"));
            JdbcThinMetadataSelfTest.assertEquals((String)"PERSON", (String)rs.getString("TABLE_NAME"));
            JdbcThinMetadataSelfTest.assertFalse((boolean)rs.next());
            rs = meta.getTables(null, "org", "%", null);
            JdbcThinMetadataSelfTest.assertNotNull((Object)rs);
            JdbcThinMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcThinMetadataSelfTest.assertEquals((String)"TABLE", (String)rs.getString("TABLE_TYPE"));
            JdbcThinMetadataSelfTest.assertEquals((String)"IGNITE", (String)rs.getString("TABLE_CAT"));
            JdbcThinMetadataSelfTest.assertEquals((String)"ORGANIZATION", (String)rs.getString("TABLE_NAME"));
            JdbcThinMetadataSelfTest.assertFalse((boolean)rs.next());
            rs = meta.getTables(null, "PUBLIC", "", new String[]{"WRONG"});
            JdbcThinMetadataSelfTest.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testGetAllTables() throws Exception {
        this.testGetTables(new String[]{"TABLE"}, new HashSet<String>(Arrays.asList("org.ORGANIZATION", "pers.PERSON", "dep.DEPARTMENT", "PUBLIC.TEST", "PUBLIC.Quoted", "PUBLIC.TEST_DECIMAL_COLUMN", "PUBLIC.TEST_DECIMAL_COLUMN_PRECISION", "PUBLIC.TEST_DECIMAL_DATE_COLUMN_META")));
    }

    @Test
    public void testGetAllView() throws Exception {
        HashSet<String> expViews = new HashSet<String>(Arrays.asList(QueryUtils.sysSchemaName() + ".METRICS", QueryUtils.sysSchemaName() + ".SERVICES", QueryUtils.sysSchemaName() + ".CACHE_GROUPS", QueryUtils.sysSchemaName() + ".CACHES", QueryUtils.sysSchemaName() + ".TASKS", QueryUtils.sysSchemaName() + ".JOBS", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY", QueryUtils.sysSchemaName() + ".NODES", QueryUtils.sysSchemaName() + ".CONFIGURATION", QueryUtils.sysSchemaName() + ".SCHEMAS", QueryUtils.sysSchemaName() + ".NODE_METRICS", QueryUtils.sysSchemaName() + ".BASELINE_NODES", QueryUtils.sysSchemaName() + ".BASELINE_NODE_ATTRIBUTES", QueryUtils.sysSchemaName() + ".INDEXES", QueryUtils.sysSchemaName() + ".LOCAL_CACHE_GROUPS_IO", QueryUtils.sysSchemaName() + ".SQL_QUERIES", QueryUtils.sysSchemaName() + ".SCAN_QUERIES", QueryUtils.sysSchemaName() + ".NODE_ATTRIBUTES", QueryUtils.sysSchemaName() + ".TABLES", QueryUtils.sysSchemaName() + ".CLIENT_CONNECTIONS", QueryUtils.sysSchemaName() + ".CLIENT_CONNECTION_ATTRIBUTES", QueryUtils.sysSchemaName() + ".TRANSACTIONS", QueryUtils.sysSchemaName() + ".VIEWS", QueryUtils.sysSchemaName() + ".TABLE_COLUMNS", QueryUtils.sysSchemaName() + ".VIEW_COLUMNS", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES", QueryUtils.sysSchemaName() + ".STRIPED_THREADPOOL_QUEUE", QueryUtils.sysSchemaName() + ".DATASTREAM_THREADPOOL_QUEUE", QueryUtils.sysSchemaName() + ".CACHE_GROUP_PAGE_LISTS", QueryUtils.sysSchemaName() + ".DATA_REGION_PAGE_LISTS", QueryUtils.sysSchemaName() + ".STATISTICS_LOCAL_DATA", QueryUtils.sysSchemaName() + ".STATISTICS_PARTITION_DATA", QueryUtils.sysSchemaName() + ".STATISTICS_CONFIGURATION", QueryUtils.sysSchemaName() + ".DS_QUEUES", QueryUtils.sysSchemaName() + ".DS_SETS", QueryUtils.sysSchemaName() + ".DS_ATOMICSEQUENCES", QueryUtils.sysSchemaName() + ".DS_ATOMICLONGS", QueryUtils.sysSchemaName() + ".DS_ATOMICREFERENCES", QueryUtils.sysSchemaName() + ".DS_ATOMICSTAMPED", QueryUtils.sysSchemaName() + ".DS_COUNTDOWNLATCHES", QueryUtils.sysSchemaName() + ".DS_SEMAPHORES", QueryUtils.sysSchemaName() + ".DS_REENTRANTLOCKS", QueryUtils.sysSchemaName() + ".BINARY_METADATA", QueryUtils.sysSchemaName() + ".DISTRIBUTED_METASTORAGE", QueryUtils.sysSchemaName() + ".PARTITION_STATES"));
        this.testGetTables(new String[]{"VIEW"}, expViews);
    }

    private void testGetTables(String[] tblTypes, Set<String> expTbls) throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getTables(null, null, null, tblTypes);
            HashSet<String> actualTbls = new HashSet<String>(expTbls.size());
            while (rs.next()) {
                actualTbls.add(rs.getString("TABLE_SCHEM") + '.' + rs.getString("TABLE_NAME"));
            }
            assert (expTbls.equals(actualTbls)) : "expectedTbls=" + expTbls + ", actualTbls" + actualTbls;
        }
    }

    @Test
    public void testGetColumns() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            String name;
            conn.setSchema("pers");
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getColumns(null, "pers", "PERSON", "%");
            ResultSetMetaData rsMeta = rs.getMetaData();
            assert (rsMeta.getColumnCount() == 24) : "Invalid columns count: " + rsMeta.getColumnCount();
            assert (rs != null);
            ArrayList<String> names = new ArrayList<String>(2);
            names.add("NAME");
            names.add("AGE");
            names.add("ORGID");
            int cnt = 0;
            while (rs.next()) {
                name = rs.getString("COLUMN_NAME");
                assert (names.remove(name)) : "Unexpected column name " + name;
                if ("NAME".equals(name)) {
                    assert (rs.getInt("DATA_TYPE") == 12);
                    assert ("VARCHAR".equals(rs.getString("TYPE_NAME")));
                    assert (rs.getInt("NULLABLE") == 0);
                    assert (rs.getInt(11) == 0);
                    assert (rs.getString("IS_NULLABLE").equals("NO"));
                } else if ("ORGID".equals(name)) {
                    assert (rs.getInt("DATA_TYPE") == 4);
                    assert ("INTEGER".equals(rs.getString("TYPE_NAME")));
                    assert (rs.getInt("NULLABLE") == 1);
                    assert (rs.getInt(11) == 1);
                    assert (rs.getString("IS_NULLABLE").equals("YES"));
                } else if ("AGE".equals(name)) {
                    assert (rs.getInt("DATA_TYPE") == 4);
                    assert ("INTEGER".equals(rs.getString("TYPE_NAME")));
                    assert (rs.getInt("NULLABLE") == 0);
                    assert (rs.getInt(11) == 0);
                    assert (rs.getString("IS_NULLABLE").equals("NO"));
                } else if ("_KEY".equals(name)) {
                    assert (rs.getInt("DATA_TYPE") == 1111);
                    assert ("OTHER".equals(rs.getString("TYPE_NAME")));
                    assert (rs.getInt("NULLABLE") == 0);
                    assert (rs.getInt(11) == 0);
                    assert (rs.getString("IS_NULLABLE").equals("NO"));
                } else if ("_VAL".equals(name)) {
                    assert (rs.getInt("DATA_TYPE") == 1111);
                    assert ("OTHER".equals(rs.getString("TYPE_NAME")));
                    assert (rs.getInt("NULLABLE") == 0);
                    assert (rs.getInt(11) == 0);
                    assert (rs.getString("IS_NULLABLE").equals("NO"));
                }
                ++cnt;
            }
            assert (names.isEmpty());
            assert (cnt == 3);
            rs = meta.getColumns(null, "org", "ORGANIZATION", "%");
            assert (rs != null);
            names.add("ID");
            names.add("NAME");
            cnt = 0;
            while (rs.next()) {
                name = rs.getString("COLUMN_NAME");
                assert (names.remove(name));
                if ("id".equals(name)) {
                    assert (rs.getInt("DATA_TYPE") == 4);
                    assert ("INTEGER".equals(rs.getString("TYPE_NAME")));
                    assert (rs.getInt("NULLABLE") == 0);
                } else if ("name".equals(name)) {
                    assert (rs.getInt("DATA_TYPE") == 12);
                    assert ("VARCHAR".equals(rs.getString("TYPE_NAME")));
                    assert (rs.getInt("NULLABLE") == 1);
                }
                if ("_KEY".equals(name)) {
                    assert (rs.getInt("DATA_TYPE") == 12);
                    assert ("VARCHAR".equals(rs.getString("TYPE_NAME")));
                    assert (rs.getInt("NULLABLE") == 0);
                }
                if ("_VAL".equals(name)) {
                    assert (rs.getInt("DATA_TYPE") == 1111);
                    assert ("OTHER".equals(rs.getString("TYPE_NAME")));
                    assert (rs.getInt("NULLABLE") == 0);
                }
                ++cnt;
            }
            assert (names.isEmpty());
            assert (cnt == 2);
        }
    }

    @Test
    public void testGetAllColumns() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getColumns(null, null, null, null);
            HashSet<String> expectedCols = new HashSet<String>(Arrays.asList("PUBLIC.Quoted.Id.null.10", "PUBLIC.Quoted.Name.null.50", "PUBLIC.TEST.ID.null.10", "PUBLIC.TEST.NAME.'default name'.50", "PUBLIC.TEST.AGE.21.10", "PUBLIC.TEST.VAL.null.50", "PUBLIC.TEST_DECIMAL_COLUMN.ID.null.10", "PUBLIC.TEST_DECIMAL_COLUMN.DEC_COL.null.8.3", "PUBLIC.TEST_DECIMAL_COLUMN_PRECISION.ID.null.10", "PUBLIC.TEST_DECIMAL_COLUMN_PRECISION.DEC_COL.null.8", "PUBLIC.TEST_DECIMAL_DATE_COLUMN_META.ID.null.10", "PUBLIC.TEST_DECIMAL_DATE_COLUMN_META.DEC_COL.null.8", "PUBLIC.TEST_DECIMAL_DATE_COLUMN_META.DATE_COL.null.10", "dep.DEPARTMENT.ID.null.10", "dep.DEPARTMENT.NAME.null.43", "org.ORGANIZATION.ID.null.10", "org.ORGANIZATION.NAME.null.42", "pers.PERSON.NAME.null.2147483647", "pers.PERSON.AGE.null.10", "pers.PERSON.ORGID.null.10"));
            HashSet<String> actualUserCols = new HashSet<String>(expectedCols.size());
            HashSet<String> actualSystemCols = new HashSet<String>();
            while (rs.next()) {
                int precision = rs.getInt("COLUMN_SIZE");
                int scale = rs.getInt("DECIMAL_DIGITS");
                String schemaName = rs.getString("TABLE_SCHEM");
                String colDefinition = schemaName + '.' + rs.getString("TABLE_NAME") + "." + rs.getString("COLUMN_NAME") + "." + rs.getString("COLUMN_DEF") + (precision == 0 ? "" : "." + precision) + (scale == 0 ? "" : "." + scale);
                if (!schemaName.equals(QueryUtils.sysSchemaName())) {
                    actualUserCols.add(colDefinition);
                    continue;
                }
                actualSystemCols.add(colDefinition);
            }
            Assert.assertEquals(expectedCols, actualUserCols);
            expectedCols = new HashSet<String>(Arrays.asList(QueryUtils.sysSchemaName() + ".BASELINE_NODES.CONSISTENT_ID.null.2147483647", QueryUtils.sysSchemaName() + ".BASELINE_NODES.ONLINE.null.1", QueryUtils.sysSchemaName() + ".BASELINE_NODE_ATTRIBUTES.NODE_CONSISTENT_ID.null.2147483647", QueryUtils.sysSchemaName() + ".BASELINE_NODE_ATTRIBUTES.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".BASELINE_NODE_ATTRIBUTES.VALUE.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.CACHE_GROUP_ID.null.10", QueryUtils.sysSchemaName() + ".CACHES.CACHE_GROUP_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.CACHE_ID.null.10", QueryUtils.sysSchemaName() + ".CACHES.CACHE_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.CACHE_TYPE.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.CACHE_MODE.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.ATOMICITY_MODE.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.IS_ONHEAP_CACHE_ENABLED.null.1", QueryUtils.sysSchemaName() + ".CACHES.IS_COPY_ON_READ.null.1", QueryUtils.sysSchemaName() + ".CACHES.IS_LOAD_PREVIOUS_VALUE.null.1", QueryUtils.sysSchemaName() + ".CACHES.IS_READ_FROM_BACKUP.null.1", QueryUtils.sysSchemaName() + ".CACHES.PARTITION_LOSS_POLICY.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.NODE_FILTER.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.TOPOLOGY_VALIDATOR.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.IS_EAGER_TTL.null.1", QueryUtils.sysSchemaName() + ".CACHES.WRITE_SYNCHRONIZATION_MODE.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.IS_INVALIDATE.null.1", QueryUtils.sysSchemaName() + ".CACHES.IS_EVENTS_DISABLED.null.1", QueryUtils.sysSchemaName() + ".CACHES.IS_STATISTICS_ENABLED.null.1", QueryUtils.sysSchemaName() + ".CACHES.IS_MANAGEMENT_ENABLED.null.1", QueryUtils.sysSchemaName() + ".CACHES.BACKUPS.null.10", QueryUtils.sysSchemaName() + ".CACHES.AFFINITY.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.AFFINITY_MAPPER.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.REBALANCE_MODE.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.REBALANCE_BATCH_SIZE.null.10", QueryUtils.sysSchemaName() + ".CACHES.REBALANCE_TIMEOUT.null.19", QueryUtils.sysSchemaName() + ".CACHES.REBALANCE_DELAY.null.19", QueryUtils.sysSchemaName() + ".CACHES.REBALANCE_THROTTLE.null.19", QueryUtils.sysSchemaName() + ".CACHES.REBALANCE_BATCHES_PREFETCH_COUNT.null.19", QueryUtils.sysSchemaName() + ".CACHES.REBALANCE_ORDER.null.10", QueryUtils.sysSchemaName() + ".CACHES.EVICTION_FILTER.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.EVICTION_POLICY_FACTORY.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.IS_NEAR_CACHE_ENABLED.null.1", QueryUtils.sysSchemaName() + ".CACHES.NEAR_CACHE_EVICTION_POLICY_FACTORY.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.NEAR_CACHE_START_SIZE.null.10", QueryUtils.sysSchemaName() + ".CACHES.DEFAULT_LOCK_TIMEOUT.null.19", QueryUtils.sysSchemaName() + ".CACHES.INTERCEPTOR.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.CACHE_STORE_FACTORY.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.IS_STORE_KEEP_BINARY.null.1", QueryUtils.sysSchemaName() + ".CACHES.IS_READ_THROUGH.null.1", QueryUtils.sysSchemaName() + ".CACHES.IS_WRITE_THROUGH.null.1", QueryUtils.sysSchemaName() + ".CACHES.IS_WRITE_BEHIND_ENABLED.null.1", QueryUtils.sysSchemaName() + ".CACHES.WRITE_BEHIND_COALESCING.null.1", QueryUtils.sysSchemaName() + ".CACHES.WRITE_BEHIND_FLUSH_SIZE.null.10", QueryUtils.sysSchemaName() + ".CACHES.WRITE_BEHIND_FLUSH_FREQUENCY.null.19", QueryUtils.sysSchemaName() + ".CACHES.WRITE_BEHIND_FLUSH_THREAD_COUNT.null.10", QueryUtils.sysSchemaName() + ".CACHES.WRITE_BEHIND_BATCH_SIZE.null.10", QueryUtils.sysSchemaName() + ".CACHES.MAX_CONCURRENT_ASYNC_OPERATIONS.null.10", QueryUtils.sysSchemaName() + ".CACHES.CACHE_LOADER_FACTORY.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.CACHE_WRITER_FACTORY.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.EXPIRY_POLICY_FACTORY.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.IS_SQL_ESCAPE_ALL.null.1", QueryUtils.sysSchemaName() + ".CACHES.IS_ENCRYPTION_ENABLED.null.1", QueryUtils.sysSchemaName() + ".CACHES.SQL_SCHEMA.null.2147483647", QueryUtils.sysSchemaName() + ".CACHES.SQL_INDEX_MAX_INLINE_SIZE.null.10", QueryUtils.sysSchemaName() + ".CACHES.IS_SQL_ONHEAP_CACHE_ENABLED.null.1", QueryUtils.sysSchemaName() + ".CACHES.SQL_ONHEAP_CACHE_MAX_SIZE.null.10", QueryUtils.sysSchemaName() + ".CACHES.QUERY_DETAIL_METRICS_SIZE.null.10", QueryUtils.sysSchemaName() + ".CACHES.QUERY_PARALLELISM.null.10", QueryUtils.sysSchemaName() + ".CACHES.MAX_QUERY_ITERATORS_COUNT.null.10", QueryUtils.sysSchemaName() + ".CACHES.DATA_REGION_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".CACHE_GROUPS.CACHE_GROUP_ID.null.10", QueryUtils.sysSchemaName() + ".CACHE_GROUPS.CACHE_GROUP_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".CACHE_GROUPS.IS_SHARED.null.1", QueryUtils.sysSchemaName() + ".CACHE_GROUPS.CACHE_COUNT.null.10", QueryUtils.sysSchemaName() + ".CACHE_GROUPS.CACHE_MODE.null.2147483647", QueryUtils.sysSchemaName() + ".CACHE_GROUPS.ATOMICITY_MODE.null.2147483647", QueryUtils.sysSchemaName() + ".CACHE_GROUPS.AFFINITY.null.2147483647", QueryUtils.sysSchemaName() + ".CACHE_GROUPS.PARTITIONS_COUNT.null.10", QueryUtils.sysSchemaName() + ".CACHE_GROUPS.NODE_FILTER.null.2147483647", QueryUtils.sysSchemaName() + ".CACHE_GROUPS.DATA_REGION_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".CACHE_GROUPS.TOPOLOGY_VALIDATOR.null.2147483647", QueryUtils.sysSchemaName() + ".CACHE_GROUPS.PARTITION_LOSS_POLICY.null.2147483647", QueryUtils.sysSchemaName() + ".CACHE_GROUPS.REBALANCE_MODE.null.2147483647", QueryUtils.sysSchemaName() + ".CACHE_GROUPS.REBALANCE_DELAY.null.19", QueryUtils.sysSchemaName() + ".CACHE_GROUPS.REBALANCE_ORDER.null.10", QueryUtils.sysSchemaName() + ".CACHE_GROUPS.BACKUPS.null.10", QueryUtils.sysSchemaName() + ".INDEXES.CACHE_GROUP_ID.null.10", QueryUtils.sysSchemaName() + ".INDEXES.CACHE_GROUP_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".INDEXES.CACHE_ID.null.10", QueryUtils.sysSchemaName() + ".INDEXES.CACHE_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".INDEXES.SCHEMA_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".INDEXES.TABLE_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".INDEXES.INDEX_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".INDEXES.INDEX_TYPE.null.2147483647", QueryUtils.sysSchemaName() + ".INDEXES.COLUMNS.null.2147483647", QueryUtils.sysSchemaName() + ".INDEXES.IS_PK.null.1", QueryUtils.sysSchemaName() + ".INDEXES.IS_UNIQUE.null.1", QueryUtils.sysSchemaName() + ".INDEXES.INLINE_SIZE.null.10", QueryUtils.sysSchemaName() + ".LOCAL_CACHE_GROUPS_IO.CACHE_GROUP_ID.null.10", QueryUtils.sysSchemaName() + ".LOCAL_CACHE_GROUPS_IO.CACHE_GROUP_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".LOCAL_CACHE_GROUPS_IO.PHYSICAL_READS.null.19", QueryUtils.sysSchemaName() + ".LOCAL_CACHE_GROUPS_IO.LOGICAL_READS.null.19", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY.SCHEMA_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY.SQL.null.2147483647", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY.LOCAL.null.1", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY.EXECUTIONS.null.19", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY.FAILURES.null.19", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY.DURATION_MIN.null.19", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY.DURATION_MAX.null.19", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY.LAST_START_TIME.null.29.9", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY.MEMORY_MIN.null.19", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY.MEMORY_MAX.null.19", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY.DISK_ALLOCATION_MIN.null.19", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY.DISK_ALLOCATION_MAX.null.19", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY.DISK_ALLOCATION_TOTAL_MIN.null.19", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY.DISK_ALLOCATION_TOTAL_MAX.null.19", QueryUtils.sysSchemaName() + ".SQL_QUERIES.ORIGIN_NODE_ID.null.16", QueryUtils.sysSchemaName() + ".SQL_QUERIES.QUERY_ID.null.2147483647", QueryUtils.sysSchemaName() + ".SQL_QUERIES.SQL.null.2147483647", QueryUtils.sysSchemaName() + ".SQL_QUERIES.SCHEMA_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".SQL_QUERIES.LOCAL.null.1", QueryUtils.sysSchemaName() + ".SQL_QUERIES.START_TIME.null.29.9", QueryUtils.sysSchemaName() + ".SQL_QUERIES.DURATION.null.19", QueryUtils.sysSchemaName() + ".SQL_QUERIES.MEMORY_CURRENT.null.19", QueryUtils.sysSchemaName() + ".SQL_QUERIES.MEMORY_MAX.null.19", QueryUtils.sysSchemaName() + ".SQL_QUERIES.DISK_ALLOCATION_CURRENT.null.19", QueryUtils.sysSchemaName() + ".SQL_QUERIES.DISK_ALLOCATION_MAX.null.19", QueryUtils.sysSchemaName() + ".SQL_QUERIES.DISK_ALLOCATION_TOTAL.null.19", QueryUtils.sysSchemaName() + ".SQL_QUERIES.INITIATOR_ID.null.2147483647", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.START_TIME.null.19", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.TRANSFORMER.null.2147483647", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.LOCAL.null.1", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.QUERY_ID.null.19", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.PARTITION.null.10", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.CACHE_GROUP_ID.null.10", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.CACHE_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.TOPOLOGY.null.2147483647", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.CACHE_GROUP_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.TASK_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.DURATION.null.19", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.KEEP_BINARY.null.1", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.FILTER.null.2147483647", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.SUBJECT_ID.null.16", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.CANCELED.null.1", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.CACHE_ID.null.10", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.PAGE_SIZE.null.10", QueryUtils.sysSchemaName() + ".SCAN_QUERIES.ORIGIN_NODE_ID.null.16", QueryUtils.sysSchemaName() + ".NODES.NODE_ID.null.16", QueryUtils.sysSchemaName() + ".NODES.CONSISTENT_ID.null.2147483647", QueryUtils.sysSchemaName() + ".NODES.VERSION.null.2147483647", QueryUtils.sysSchemaName() + ".NODES.IS_CLIENT.null.1", QueryUtils.sysSchemaName() + ".NODES.IS_DAEMON.null.1", QueryUtils.sysSchemaName() + ".NODES.IS_LOCAL.null.1", QueryUtils.sysSchemaName() + ".NODES.NODE_ORDER.null.19", QueryUtils.sysSchemaName() + ".NODES.ADDRESSES.null.2147483647", QueryUtils.sysSchemaName() + ".NODES.HOSTNAMES.null.2147483647", QueryUtils.sysSchemaName() + ".NODE_ATTRIBUTES.NODE_ID.null.16", QueryUtils.sysSchemaName() + ".NODE_ATTRIBUTES.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".NODE_ATTRIBUTES.VALUE.null.2147483647", QueryUtils.sysSchemaName() + ".CONFIGURATION.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".CONFIGURATION.VALUE.null.2147483647", QueryUtils.sysSchemaName() + ".NODE_METRICS.NODE_ID.null.16", QueryUtils.sysSchemaName() + ".NODE_METRICS.LAST_UPDATE_TIME.null.29.9", QueryUtils.sysSchemaName() + ".NODE_METRICS.MAX_ACTIVE_JOBS.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.CUR_ACTIVE_JOBS.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.AVG_ACTIVE_JOBS.null.7", QueryUtils.sysSchemaName() + ".NODE_METRICS.MAX_WAITING_JOBS.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.CUR_WAITING_JOBS.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.AVG_WAITING_JOBS.null.7", QueryUtils.sysSchemaName() + ".NODE_METRICS.MAX_REJECTED_JOBS.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.CUR_REJECTED_JOBS.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.AVG_REJECTED_JOBS.null.7", QueryUtils.sysSchemaName() + ".NODE_METRICS.TOTAL_REJECTED_JOBS.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.MAX_CANCELED_JOBS.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.CUR_CANCELED_JOBS.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.AVG_CANCELED_JOBS.null.7", QueryUtils.sysSchemaName() + ".NODE_METRICS.TOTAL_CANCELED_JOBS.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.MAX_JOBS_WAIT_TIME.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.CUR_JOBS_WAIT_TIME.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.AVG_JOBS_WAIT_TIME.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.MAX_JOBS_EXECUTE_TIME.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.CUR_JOBS_EXECUTE_TIME.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.AVG_JOBS_EXECUTE_TIME.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.TOTAL_JOBS_EXECUTE_TIME.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.TOTAL_EXECUTED_JOBS.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.TOTAL_EXECUTED_TASKS.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.TOTAL_BUSY_TIME.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.TOTAL_IDLE_TIME.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.CUR_IDLE_TIME.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.BUSY_TIME_PERCENTAGE.null.7", QueryUtils.sysSchemaName() + ".NODE_METRICS.IDLE_TIME_PERCENTAGE.null.7", QueryUtils.sysSchemaName() + ".NODE_METRICS.TOTAL_CPU.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.CUR_CPU_LOAD.null.17", QueryUtils.sysSchemaName() + ".NODE_METRICS.AVG_CPU_LOAD.null.17", QueryUtils.sysSchemaName() + ".NODE_METRICS.CUR_GC_CPU_LOAD.null.17", QueryUtils.sysSchemaName() + ".NODE_METRICS.HEAP_MEMORY_INIT.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.HEAP_MEMORY_USED.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.HEAP_MEMORY_COMMITED.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.HEAP_MEMORY_MAX.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.HEAP_MEMORY_TOTAL.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.NONHEAP_MEMORY_INIT.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.NONHEAP_MEMORY_USED.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.NONHEAP_MEMORY_COMMITED.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.NONHEAP_MEMORY_MAX.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.NONHEAP_MEMORY_TOTAL.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.UPTIME.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.JVM_START_TIME.null.29.9", QueryUtils.sysSchemaName() + ".NODE_METRICS.NODE_START_TIME.null.29.9", QueryUtils.sysSchemaName() + ".NODE_METRICS.LAST_DATA_VERSION.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.CUR_THREAD_COUNT.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.MAX_THREAD_COUNT.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.TOTAL_THREAD_COUNT.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.CUR_DAEMON_THREAD_COUNT.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.SENT_MESSAGES_COUNT.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.SENT_BYTES_COUNT.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.RECEIVED_MESSAGES_COUNT.null.10", QueryUtils.sysSchemaName() + ".NODE_METRICS.RECEIVED_BYTES_COUNT.null.19", QueryUtils.sysSchemaName() + ".NODE_METRICS.OUTBOUND_MESSAGES_QUEUE.null.10", QueryUtils.sysSchemaName() + ".SCHEMAS.SCHEMA_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".SCHEMAS.PREDEFINED.null.1", QueryUtils.sysSchemaName() + ".TABLES.CACHE_GROUP_ID.null.10", QueryUtils.sysSchemaName() + ".TABLES.CACHE_GROUP_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".TABLES.CACHE_ID.null.10", QueryUtils.sysSchemaName() + ".TABLES.CACHE_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".TABLES.SCHEMA_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".TABLES.TABLE_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".TABLES.AFFINITY_KEY_COLUMN.null.2147483647", QueryUtils.sysSchemaName() + ".TABLES.KEY_ALIAS.null.2147483647", QueryUtils.sysSchemaName() + ".TABLES.VALUE_ALIAS.null.2147483647", QueryUtils.sysSchemaName() + ".TABLES.KEY_TYPE_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".TABLES.VALUE_TYPE_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".TABLES.IS_INDEX_REBUILD_IN_PROGRESS.null.1", QueryUtils.sysSchemaName() + ".METRICS.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".METRICS.VALUE.null.2147483647", QueryUtils.sysSchemaName() + ".METRICS.DESCRIPTION.null.2147483647", QueryUtils.sysSchemaName() + ".TASKS.AFFINITY_CACHE_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".TASKS.INTERNAL.null.1", QueryUtils.sysSchemaName() + ".TASKS.END_TIME.null.19", QueryUtils.sysSchemaName() + ".TASKS.START_TIME.null.19", QueryUtils.sysSchemaName() + ".TASKS.USER_VERSION.null.2147483647", QueryUtils.sysSchemaName() + ".TASKS.TASK_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".TASKS.TASK_NODE_ID.null.16", QueryUtils.sysSchemaName() + ".TASKS.JOB_ID.null.2147483647", QueryUtils.sysSchemaName() + ".TASKS.ID.null.2147483647", QueryUtils.sysSchemaName() + ".TASKS.SESSION_ID.null.2147483647", QueryUtils.sysSchemaName() + ".TASKS.AFFINITY_PARTITION_ID.null.10", QueryUtils.sysSchemaName() + ".TASKS.TASK_CLASS_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".TASKS.EXEC_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".JOBS.IS_STARTED.null.1", QueryUtils.sysSchemaName() + ".JOBS.EXECUTOR_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".JOBS.IS_TIMED_OUT.null.1", QueryUtils.sysSchemaName() + ".JOBS.ID.null.2147483647", QueryUtils.sysSchemaName() + ".JOBS.FINISH_TIME.null.19", QueryUtils.sysSchemaName() + ".JOBS.IS_INTERNAL.null.1", QueryUtils.sysSchemaName() + ".JOBS.CREATE_TIME.null.19", QueryUtils.sysSchemaName() + ".JOBS.AFFINITY_PARTITION_ID.null.10", QueryUtils.sysSchemaName() + ".JOBS.ORIGIN_NODE_ID.null.16", QueryUtils.sysSchemaName() + ".JOBS.TASK_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".JOBS.TASK_CLASS_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".JOBS.SESSION_ID.null.2147483647", QueryUtils.sysSchemaName() + ".JOBS.IS_FINISHING.null.1", QueryUtils.sysSchemaName() + ".JOBS.START_TIME.null.19", QueryUtils.sysSchemaName() + ".JOBS.AFFINITY_CACHE_IDS.null.2147483647", QueryUtils.sysSchemaName() + ".JOBS.STATE.null.2147483647", QueryUtils.sysSchemaName() + ".CLIENT_CONNECTIONS.CONNECTION_ID.null.19", QueryUtils.sysSchemaName() + ".CLIENT_CONNECTIONS.LOCAL_ADDRESS.null.2147483647", QueryUtils.sysSchemaName() + ".CLIENT_CONNECTIONS.REMOTE_ADDRESS.null.2147483647", QueryUtils.sysSchemaName() + ".CLIENT_CONNECTIONS.TYPE.null.2147483647", QueryUtils.sysSchemaName() + ".CLIENT_CONNECTIONS.USER.null.2147483647", QueryUtils.sysSchemaName() + ".CLIENT_CONNECTIONS.VERSION.null.2147483647", QueryUtils.sysSchemaName() + ".CLIENT_CONNECTION_ATTRIBUTES.CONNECTION_ID.null.19", QueryUtils.sysSchemaName() + ".CLIENT_CONNECTION_ATTRIBUTES.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".CLIENT_CONNECTION_ATTRIBUTES.VALUE.null.2147483647", QueryUtils.sysSchemaName() + ".TRANSACTIONS.LOCAL_NODE_ID.null.16", QueryUtils.sysSchemaName() + ".TRANSACTIONS.STATE.null.2147483647", QueryUtils.sysSchemaName() + ".TRANSACTIONS.XID.null.2147483647", QueryUtils.sysSchemaName() + ".TRANSACTIONS.LABEL.null.2147483647", QueryUtils.sysSchemaName() + ".TRANSACTIONS.START_TIME.null.19", QueryUtils.sysSchemaName() + ".TRANSACTIONS.ISOLATION.null.2147483647", QueryUtils.sysSchemaName() + ".TRANSACTIONS.CONCURRENCY.null.2147483647", QueryUtils.sysSchemaName() + ".TRANSACTIONS.COLOCATED.null.1", QueryUtils.sysSchemaName() + ".TRANSACTIONS.DHT.null.1", QueryUtils.sysSchemaName() + ".TRANSACTIONS.IMPLICIT.null.1", QueryUtils.sysSchemaName() + ".TRANSACTIONS.IMPLICIT_SINGLE.null.1", QueryUtils.sysSchemaName() + ".TRANSACTIONS.INTERNAL.null.1", QueryUtils.sysSchemaName() + ".TRANSACTIONS.LOCAL.null.1", QueryUtils.sysSchemaName() + ".TRANSACTIONS.NEAR.null.1", QueryUtils.sysSchemaName() + ".TRANSACTIONS.ONE_PHASE_COMMIT.null.1", QueryUtils.sysSchemaName() + ".TRANSACTIONS.SUBJECT_ID.null.16", QueryUtils.sysSchemaName() + ".TRANSACTIONS.SYSTEM.null.1", QueryUtils.sysSchemaName() + ".TRANSACTIONS.THREAD_ID.null.19", QueryUtils.sysSchemaName() + ".TRANSACTIONS.TIMEOUT.null.19", QueryUtils.sysSchemaName() + ".TRANSACTIONS.DURATION.null.19", QueryUtils.sysSchemaName() + ".TRANSACTIONS.ORIGINATING_NODE_ID.null.16", QueryUtils.sysSchemaName() + ".TRANSACTIONS.OTHER_NODE_ID.null.16", QueryUtils.sysSchemaName() + ".TRANSACTIONS.TOP_VER.null.2147483647", QueryUtils.sysSchemaName() + ".TRANSACTIONS.KEYS_COUNT.null.10", QueryUtils.sysSchemaName() + ".TRANSACTIONS.CACHE_IDS.null.2147483647", QueryUtils.sysSchemaName() + ".VIEWS.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".VIEWS.DESCRIPTION.null.2147483647", QueryUtils.sysSchemaName() + ".VIEWS.SCHEMA.null.2147483647", QueryUtils.sysSchemaName() + ".TABLE_COLUMNS.AFFINITY_COLUMN.null.1", QueryUtils.sysSchemaName() + ".TABLE_COLUMNS.COLUMN_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".TABLE_COLUMNS.SCALE.null.10", QueryUtils.sysSchemaName() + ".TABLE_COLUMNS.PK.null.1", QueryUtils.sysSchemaName() + ".TABLE_COLUMNS.TYPE.null.2147483647", QueryUtils.sysSchemaName() + ".TABLE_COLUMNS.DEFAULT_VALUE.null.2147483647", QueryUtils.sysSchemaName() + ".TABLE_COLUMNS.SCHEMA_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".TABLE_COLUMNS.TABLE_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".TABLE_COLUMNS.NULLABLE.null.1", QueryUtils.sysSchemaName() + ".TABLE_COLUMNS.PRECISION.null.10", QueryUtils.sysSchemaName() + ".TABLE_COLUMNS.AUTO_INCREMENT.null.1", QueryUtils.sysSchemaName() + ".VIEW_COLUMNS.NULLABLE.null.1", QueryUtils.sysSchemaName() + ".VIEW_COLUMNS.SCHEMA_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".VIEW_COLUMNS.COLUMN_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".VIEW_COLUMNS.TYPE.null.2147483647", QueryUtils.sysSchemaName() + ".VIEW_COLUMNS.PRECISION.null.19", QueryUtils.sysSchemaName() + ".VIEW_COLUMNS.DEFAULT_VALUE.null.2147483647", QueryUtils.sysSchemaName() + ".VIEW_COLUMNS.SCALE.null.10", QueryUtils.sysSchemaName() + ".VIEW_COLUMNS.VIEW_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.NOTIFY_EXISTING.null.1", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.OLD_VALUE_REQUIRED.null.1", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.KEEP_BINARY.null.1", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.IS_MESSAGING.null.1", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.AUTO_UNSUBSCRIBE.null.1", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.LAST_SEND_TIME.null.19", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.LOCAL_TRANSFORMED_LISTENER.null.2147483647", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.TOPIC.null.2147483647", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.BUFFER_SIZE.null.10", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.REMOTE_TRANSFORMER.null.2147483647", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.DELAYED_REGISTER.null.1", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.IS_QUERY.null.1", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.NODE_ID.null.16", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.INTERVAL.null.19", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.IS_EVENTS.null.1", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.ROUTINE_ID.null.16", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.REMOTE_FILTER.null.2147483647", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.CACHE_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES.LOCAL_LISTENER.null.2147483647", QueryUtils.sysSchemaName() + ".STRIPED_THREADPOOL_QUEUE.STRIPE_INDEX.null.10", QueryUtils.sysSchemaName() + ".STRIPED_THREADPOOL_QUEUE.DESCRIPTION.null.2147483647", QueryUtils.sysSchemaName() + ".STRIPED_THREADPOOL_QUEUE.THREAD_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".STRIPED_THREADPOOL_QUEUE.TASK_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DATASTREAM_THREADPOOL_QUEUE.STRIPE_INDEX.null.10", QueryUtils.sysSchemaName() + ".DATASTREAM_THREADPOOL_QUEUE.DESCRIPTION.null.2147483647", QueryUtils.sysSchemaName() + ".DATASTREAM_THREADPOOL_QUEUE.THREAD_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DATASTREAM_THREADPOOL_QUEUE.TASK_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".CACHE_GROUP_PAGE_LISTS.CACHE_GROUP_ID.null.10", QueryUtils.sysSchemaName() + ".CACHE_GROUP_PAGE_LISTS.PARTITION_ID.null.10", QueryUtils.sysSchemaName() + ".CACHE_GROUP_PAGE_LISTS.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".CACHE_GROUP_PAGE_LISTS.BUCKET_NUMBER.null.10", QueryUtils.sysSchemaName() + ".CACHE_GROUP_PAGE_LISTS.BUCKET_SIZE.null.19", QueryUtils.sysSchemaName() + ".CACHE_GROUP_PAGE_LISTS.STRIPES_COUNT.null.10", QueryUtils.sysSchemaName() + ".CACHE_GROUP_PAGE_LISTS.CACHED_PAGES_COUNT.null.10", QueryUtils.sysSchemaName() + ".DATA_REGION_PAGE_LISTS.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DATA_REGION_PAGE_LISTS.BUCKET_NUMBER.null.10", QueryUtils.sysSchemaName() + ".DATA_REGION_PAGE_LISTS.BUCKET_SIZE.null.19", QueryUtils.sysSchemaName() + ".DATA_REGION_PAGE_LISTS.STRIPES_COUNT.null.10", QueryUtils.sysSchemaName() + ".DATA_REGION_PAGE_LISTS.CACHED_PAGES_COUNT.null.10", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY.ENFORCE_JOIN_ORDER.null.1", QueryUtils.sysSchemaName() + ".SQL_QUERIES.LAZY.null.1", QueryUtils.sysSchemaName() + ".SQL_QUERIES.LABEL.null.2147483647", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY.DISTRIBUTED_JOINS.null.1", QueryUtils.sysSchemaName() + ".SQL_QUERIES.DISTRIBUTED_JOINS.null.1", QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY.LAZY.null.1", QueryUtils.sysSchemaName() + ".SQL_QUERIES.ENFORCE_JOIN_ORDER.null.1", QueryUtils.sysSchemaName() + ".STATISTICS_LOCAL_DATA.LAST_UPDATE_TIME.null.2147483647", QueryUtils.sysSchemaName() + ".STATISTICS_LOCAL_DATA.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".STATISTICS_LOCAL_DATA.TOTAL.null.19", QueryUtils.sysSchemaName() + ".STATISTICS_PARTITION_DATA.VERSION.null.19", QueryUtils.sysSchemaName() + ".STATISTICS_CONFIGURATION.TYPE.null.2147483647", QueryUtils.sysSchemaName() + ".STATISTICS_PARTITION_DATA.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".STATISTICS_CONFIGURATION.COLUMN.null.2147483647", QueryUtils.sysSchemaName() + ".STATISTICS_LOCAL_DATA.ROWS_COUNT.null.19", QueryUtils.sysSchemaName() + ".STATISTICS_PARTITION_DATA.TYPE.null.2147483647", QueryUtils.sysSchemaName() + ".STATISTICS_LOCAL_DATA.DISTINCT.null.19", QueryUtils.sysSchemaName() + ".STATISTICS_LOCAL_DATA.SIZE.null.10", QueryUtils.sysSchemaName() + ".STATISTICS_PARTITION_DATA.LAST_UPDATE_TIME.null.19", QueryUtils.sysSchemaName() + ".STATISTICS_CONFIGURATION.MAX_PARTITION_OBSOLESCENCE_PERCENT.null.3", QueryUtils.sysSchemaName() + ".STATISTICS_LOCAL_DATA.VERSION.null.19", QueryUtils.sysSchemaName() + ".STATISTICS_LOCAL_DATA.COLUMN.null.2147483647", QueryUtils.sysSchemaName() + ".STATISTICS_CONFIGURATION.SCHEMA.null.2147483647", QueryUtils.sysSchemaName() + ".STATISTICS_PARTITION_DATA.TOTAL.null.19", QueryUtils.sysSchemaName() + ".STATISTICS_PARTITION_DATA.PARTITION.null.10", QueryUtils.sysSchemaName() + ".STATISTICS_PARTITION_DATA.SCHEMA.null.2147483647", QueryUtils.sysSchemaName() + ".STATISTICS_PARTITION_DATA.ROWS_COUNT.null.19", QueryUtils.sysSchemaName() + ".STATISTICS_PARTITION_DATA.SIZE.null.10", QueryUtils.sysSchemaName() + ".STATISTICS_PARTITION_DATA.UPDATE_COUNTER.null.19", QueryUtils.sysSchemaName() + ".STATISTICS_CONFIGURATION.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".STATISTICS_PARTITION_DATA.DISTINCT.null.19", QueryUtils.sysSchemaName() + ".STATISTICS_LOCAL_DATA.NULLS.null.19", QueryUtils.sysSchemaName() + ".STATISTICS_CONFIGURATION.VERSION.null.19", QueryUtils.sysSchemaName() + ".STATISTICS_CONFIGURATION.MANUAL_SIZE.null.10", QueryUtils.sysSchemaName() + ".STATISTICS_CONFIGURATION.MANUAL_DISTINCT.null.19", QueryUtils.sysSchemaName() + ".STATISTICS_CONFIGURATION.MANUAL_NULLS.null.19", QueryUtils.sysSchemaName() + ".STATISTICS_CONFIGURATION.MANUAL_TOTAL.null.19", QueryUtils.sysSchemaName() + ".STATISTICS_LOCAL_DATA.TYPE.null.2147483647", QueryUtils.sysSchemaName() + ".STATISTICS_PARTITION_DATA.NULLS.null.19", QueryUtils.sysSchemaName() + ".STATISTICS_PARTITION_DATA.COLUMN.null.2147483647", QueryUtils.sysSchemaName() + ".STATISTICS_LOCAL_DATA.SCHEMA.null.2147483647", QueryUtils.sysSchemaName() + ".DS_ATOMICLONGS.GROUP_ID.null.10", QueryUtils.sysSchemaName() + ".DS_ATOMICLONGS.GROUP_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_ATOMICLONGS.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_ATOMICLONGS.REMOVED.null.1", QueryUtils.sysSchemaName() + ".DS_ATOMICLONGS.VALUE.null.19", QueryUtils.sysSchemaName() + ".DS_ATOMICREFERENCES.GROUP_ID.null.10", QueryUtils.sysSchemaName() + ".DS_ATOMICREFERENCES.GROUP_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_ATOMICREFERENCES.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_ATOMICREFERENCES.REMOVED.null.1", QueryUtils.sysSchemaName() + ".DS_ATOMICREFERENCES.VALUE.null.2147483647", QueryUtils.sysSchemaName() + ".DS_ATOMICSEQUENCES.BATCH_SIZE.null.19", QueryUtils.sysSchemaName() + ".DS_ATOMICSEQUENCES.GROUP_ID.null.10", QueryUtils.sysSchemaName() + ".DS_ATOMICSEQUENCES.GROUP_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_ATOMICSEQUENCES.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_ATOMICSEQUENCES.REMOVED.null.1", QueryUtils.sysSchemaName() + ".DS_ATOMICSEQUENCES.VALUE.null.19", QueryUtils.sysSchemaName() + ".DS_ATOMICSTAMPED.GROUP_ID.null.10", QueryUtils.sysSchemaName() + ".DS_ATOMICSTAMPED.GROUP_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_ATOMICSTAMPED.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_ATOMICSTAMPED.REMOVED.null.1", QueryUtils.sysSchemaName() + ".DS_ATOMICSTAMPED.STAMP.null.2147483647", QueryUtils.sysSchemaName() + ".DS_ATOMICSTAMPED.VALUE.null.2147483647", QueryUtils.sysSchemaName() + ".DS_COUNTDOWNLATCHES.AUTO_DELETE.null.1", QueryUtils.sysSchemaName() + ".DS_COUNTDOWNLATCHES.COUNT.null.10", QueryUtils.sysSchemaName() + ".DS_COUNTDOWNLATCHES.GROUP_ID.null.10", QueryUtils.sysSchemaName() + ".DS_COUNTDOWNLATCHES.GROUP_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_COUNTDOWNLATCHES.INITIAL_COUNT.null.10", QueryUtils.sysSchemaName() + ".DS_COUNTDOWNLATCHES.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_COUNTDOWNLATCHES.REMOVED.null.1", QueryUtils.sysSchemaName() + ".DS_QUEUES.BOUNDED.null.1", QueryUtils.sysSchemaName() + ".DS_QUEUES.CAPACITY.null.10", QueryUtils.sysSchemaName() + ".DS_QUEUES.SIZE.null.10", QueryUtils.sysSchemaName() + ".DS_QUEUES.COLLOCATED.null.1", QueryUtils.sysSchemaName() + ".DS_QUEUES.GROUP_ID.null.10", QueryUtils.sysSchemaName() + ".DS_QUEUES.GROUP_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_QUEUES.ID.null.2147483647", QueryUtils.sysSchemaName() + ".DS_QUEUES.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_QUEUES.REMOVED.null.1", QueryUtils.sysSchemaName() + ".DS_REENTRANTLOCKS.BROKEN.null.1", QueryUtils.sysSchemaName() + ".DS_REENTRANTLOCKS.FAILOVER_SAFE.null.1", QueryUtils.sysSchemaName() + ".DS_REENTRANTLOCKS.FAIR.null.1", QueryUtils.sysSchemaName() + ".DS_REENTRANTLOCKS.GROUP_ID.null.10", QueryUtils.sysSchemaName() + ".DS_REENTRANTLOCKS.GROUP_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_REENTRANTLOCKS.HAS_QUEUED_THREADS.null.1", QueryUtils.sysSchemaName() + ".DS_REENTRANTLOCKS.LOCKED.null.1", QueryUtils.sysSchemaName() + ".DS_REENTRANTLOCKS.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_REENTRANTLOCKS.REMOVED.null.1", QueryUtils.sysSchemaName() + ".DS_SEMAPHORES.AVAILABLE_PERMITS.null.19", QueryUtils.sysSchemaName() + ".DS_SEMAPHORES.BROKEN.null.1", QueryUtils.sysSchemaName() + ".DS_SEMAPHORES.FAILOVER_SAFE.null.1", QueryUtils.sysSchemaName() + ".DS_SEMAPHORES.GROUP_ID.null.10", QueryUtils.sysSchemaName() + ".DS_SEMAPHORES.GROUP_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_SEMAPHORES.HAS_QUEUED_THREADS.null.1", QueryUtils.sysSchemaName() + ".DS_SEMAPHORES.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_SEMAPHORES.QUEUE_LENGTH.null.10", QueryUtils.sysSchemaName() + ".DS_SEMAPHORES.REMOVED.null.1", QueryUtils.sysSchemaName() + ".DS_SETS.COLLOCATED.null.1", QueryUtils.sysSchemaName() + ".DS_SETS.GROUP_ID.null.10", QueryUtils.sysSchemaName() + ".DS_SETS.GROUP_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_SETS.ID.null.2147483647", QueryUtils.sysSchemaName() + ".DS_SETS.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DS_SETS.REMOVED.null.1", QueryUtils.sysSchemaName() + ".DS_SETS.SIZE.null.10", QueryUtils.sysSchemaName() + ".BINARY_METADATA.FIELDS.null.2147483647", QueryUtils.sysSchemaName() + ".BINARY_METADATA.AFF_KEY_FIELD_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".BINARY_METADATA.SCHEMAS_IDS.null.2147483647", QueryUtils.sysSchemaName() + ".BINARY_METADATA.TYPE_ID.null.10", QueryUtils.sysSchemaName() + ".BINARY_METADATA.IS_ENUM.null.1", QueryUtils.sysSchemaName() + ".BINARY_METADATA.FIELDS_COUNT.null.10", QueryUtils.sysSchemaName() + ".BINARY_METADATA.TYPE_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DISTRIBUTED_METASTORAGE.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".DISTRIBUTED_METASTORAGE.VALUE.null.2147483647", QueryUtils.sysSchemaName() + ".PARTITION_STATES.CACHE_GROUP_ID.null.10", QueryUtils.sysSchemaName() + ".PARTITION_STATES.PARTITION_ID.null.10", QueryUtils.sysSchemaName() + ".PARTITION_STATES.NODE_ID.null.16", QueryUtils.sysSchemaName() + ".PARTITION_STATES.STATE.null.2147483647", QueryUtils.sysSchemaName() + ".PARTITION_STATES.IS_PRIMARY.null.1"));
            expectedCols.addAll(Arrays.asList(QueryUtils.sysSchemaName() + ".SERVICES.SERVICE_ID.null.2147483647", QueryUtils.sysSchemaName() + ".SERVICES.NAME.null.2147483647", QueryUtils.sysSchemaName() + ".SERVICES.SERVICE_CLASS.null.2147483647", QueryUtils.sysSchemaName() + ".SERVICES.CACHE_NAME.null.2147483647", QueryUtils.sysSchemaName() + ".SERVICES.ORIGIN_NODE_ID.null.16", QueryUtils.sysSchemaName() + ".SERVICES.TOTAL_COUNT.null.10", QueryUtils.sysSchemaName() + ".SERVICES.MAX_PER_NODE_COUNT.null.10", QueryUtils.sysSchemaName() + ".SERVICES.AFFINITY_KEY.null.2147483647", QueryUtils.sysSchemaName() + ".SERVICES.NODE_FILTER.null.2147483647", QueryUtils.sysSchemaName() + ".SERVICES.STATICALLY_CONFIGURED.null.1", QueryUtils.sysSchemaName() + ".SERVICES.SERVICE_ID.null.2147483647"));
            Assert.assertEquals(expectedCols, actualSystemCols);
        }
    }

    @Test
    public void testInvalidCatalog() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getSchemas("q", null);
            assert (!rs.next()) : "Results must be empty";
            rs = meta.getTables("q", null, null, null);
            assert (!rs.next()) : "Results must be empty";
            rs = meta.getColumns("q", null, null, null);
            assert (!rs.next()) : "Results must be empty";
            rs = meta.getIndexInfo("q", null, null, false, false);
            assert (!rs.next()) : "Results must be empty";
            rs = meta.getPrimaryKeys("q", null, null);
            assert (!rs.next()) : "Results must be empty";
        }
    }

    @Test
    public void testIndexMetadata() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);
             ResultSet rs = conn.getMetaData().getIndexInfo(null, "pers", "PERSON", false, false);){
            int cnt = 0;
            while (rs.next()) {
                String idxName = rs.getString("INDEX_NAME");
                String field = rs.getString("COLUMN_NAME");
                String ascOrDesc = rs.getString("ASC_OR_DESC");
                assert (rs.getShort("TYPE") == 3);
                if ("PERSON_ORGID_ASC_IDX".equals(idxName)) {
                    assert ("ORGID".equals(field));
                    assert ("A".equals(ascOrDesc));
                } else if ("PERSON_NAME_ASC_AGE_DESC_IDX".equals(idxName)) {
                    if ("NAME".equals(field)) {
                        assert ("A".equals(ascOrDesc));
                    } else if ("AGE".equals(field)) {
                        assert ("D".equals(ascOrDesc));
                    } else {
                        JdbcThinMetadataSelfTest.fail((String)("Unexpected field: " + field));
                    }
                } else {
                    JdbcThinMetadataSelfTest.fail((String)("Unexpected index: " + idxName));
                }
                ++cnt;
            }
            assert (cnt == 3);
        }
    }

    @Test
    public void testGetAllIndexes() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            ResultSet rs = conn.getMetaData().getIndexInfo(null, null, null, false, false);
            HashSet<String> expectedIdxs = new HashSet<String>(Arrays.asList("org.ORGANIZATION.ORGANIZATION_ID_ASC_IDX", "org.ORGANIZATION.ORG_NAME_INDEX", "pers.PERSON.PERSON_ORGID_ASC_IDX", "pers.PERSON.PERSON_NAME_ASC_AGE_DESC_IDX", "PUBLIC.TEST.IDX", "PUBLIC.Quoted.MyTestIndex quoted"));
            HashSet<String> actualIdxs = new HashSet<String>(expectedIdxs.size());
            while (rs.next()) {
                actualIdxs.add(rs.getString("TABLE_SCHEM") + '.' + rs.getString("TABLE_NAME") + '.' + rs.getString("INDEX_NAME"));
            }
            assert (expectedIdxs.equals(actualIdxs)) : "expectedIdxs=" + expectedIdxs + ", actualIdxs" + actualIdxs;
        }
    }

    @Test
    public void testPrimaryKeyMetadata() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);
             ResultSet rs = conn.getMetaData().getPrimaryKeys(null, "pers", "PERSON");){
            int cnt = 0;
            while (rs.next()) {
                assert ("_KEY".equals(rs.getString("COLUMN_NAME")));
                ++cnt;
            }
            assert (cnt == 1);
        }
    }

    @Test
    public void testGetAllPrimaryKeys() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            ResultSet rs = conn.getMetaData().getPrimaryKeys(null, null, null);
            HashSet<String> expectedPks = new HashSet<String>(Arrays.asList("org.ORGANIZATION.PK_org_ORGANIZATION._KEY", "pers.PERSON.PK_pers_PERSON._KEY", "dep.DEPARTMENT.PK_dep_DEPARTMENT._KEY", "PUBLIC.TEST.PK_PUBLIC_TEST.ID", "PUBLIC.TEST.PK_PUBLIC_TEST.NAME", "PUBLIC.Quoted.PK_PUBLIC_Quoted.Id", "PUBLIC.TEST_DECIMAL_COLUMN.ID.ID", "PUBLIC.TEST_DECIMAL_COLUMN_PRECISION.ID.ID", "PUBLIC.TEST_DECIMAL_DATE_COLUMN_META.ID.ID"));
            HashSet<String> actualPks = new HashSet<String>(expectedPks.size());
            while (rs.next()) {
                actualPks.add(rs.getString("TABLE_SCHEM") + '.' + rs.getString("TABLE_NAME") + '.' + rs.getString("PK_NAME") + '.' + rs.getString("COLUMN_NAME"));
            }
            JdbcThinMetadataSelfTest.assertEquals((String)"Metadata contains unexpected primary keys info.", expectedPks, actualPks);
        }
    }

    @Test
    public void testParametersMetadata() throws Exception {
        for (int i = 0; i < 3; ++i) {
            PreparedStatement updateStmt2;
            ParameterMetaData meta;
            try (Connection conn = DriverManager.getConnection(URL);){
                conn.setSchema("\"pers\"");
                PreparedStatement noParams = conn.prepareStatement("select * from Person;");
                ParameterMetaData params = noParams.getParameterMetaData();
                JdbcThinMetadataSelfTest.assertEquals((String)"Parameters should be empty.", (int)0, (int)params.getParameterCount());
            }
            conn = DriverManager.getConnection(URL);
            var3_3 = null;
            try {
                conn.setSchema("\"pers\"");
                PreparedStatement selectStmt = conn.prepareStatement("select orgId from Person p where p.name > ? and p.orgId > ?");
                meta = selectStmt.getParameterMetaData();
                JdbcThinMetadataSelfTest.assertNotNull((Object)meta);
                JdbcThinMetadataSelfTest.assertEquals((int)2, (int)meta.getParameterCount());
                JdbcThinMetadataSelfTest.assertEquals((int)12, (int)meta.getParameterType(1));
                JdbcThinMetadataSelfTest.assertEquals((int)2, (int)meta.isNullable(1));
                JdbcThinMetadataSelfTest.assertEquals((int)Integer.MAX_VALUE, (int)meta.getPrecision(1));
                JdbcThinMetadataSelfTest.assertEquals((int)4, (int)meta.getParameterType(2));
                JdbcThinMetadataSelfTest.assertEquals((int)2, (int)meta.isNullable(2));
            }
            catch (Throwable selectStmt) {
                var3_3 = selectStmt;
                throw selectStmt;
            }
            finally {
                if (conn != null) {
                    if (var3_3 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable selectStmt) {
                            var3_3.addSuppressed(selectStmt);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
            conn = DriverManager.getConnection(URL);
            var3_3 = null;
            try {
                conn.setSchema("\"pers\"");
                updateStmt2 = conn.prepareStatement("update Person p set orgId = 42 where p.name > ? and p.orgId > ?");
                meta = updateStmt2.getParameterMetaData();
                JdbcThinMetadataSelfTest.assertNotNull((Object)meta);
                JdbcThinMetadataSelfTest.assertEquals((int)2, (int)meta.getParameterCount());
                JdbcThinMetadataSelfTest.assertEquals((int)12, (int)meta.getParameterType(1));
                JdbcThinMetadataSelfTest.assertEquals((int)2, (int)meta.isNullable(1));
                JdbcThinMetadataSelfTest.assertEquals((int)Integer.MAX_VALUE, (int)meta.getPrecision(1));
                JdbcThinMetadataSelfTest.assertEquals((int)4, (int)meta.getParameterType(2));
                JdbcThinMetadataSelfTest.assertEquals((int)2, (int)meta.isNullable(2));
            }
            catch (Throwable updateStmt2) {
                var3_3 = updateStmt2;
                throw updateStmt2;
            }
            finally {
                if (conn != null) {
                    if (var3_3 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable updateStmt2) {
                            var3_3.addSuppressed(updateStmt2);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
            conn = DriverManager.getConnection(URL);
            var3_3 = null;
            try {
                conn.setSchema("\"pers\"");
                updateStmt2 = conn.prepareStatement("update Person p set orgId = 42 where p.name > ? and p.orgId > ?;select orgId from Person p where p.name > ? and p.orgId > ?");
                meta = updateStmt2.getParameterMetaData();
                JdbcThinMetadataSelfTest.assertNotNull((Object)meta);
                JdbcThinMetadataSelfTest.assertEquals((int)4, (int)meta.getParameterCount());
                JdbcThinMetadataSelfTest.assertEquals((int)12, (int)meta.getParameterType(1));
                JdbcThinMetadataSelfTest.assertEquals((int)2, (int)meta.isNullable(1));
                JdbcThinMetadataSelfTest.assertEquals((int)Integer.MAX_VALUE, (int)meta.getPrecision(1));
                JdbcThinMetadataSelfTest.assertEquals((int)4, (int)meta.getParameterType(2));
                JdbcThinMetadataSelfTest.assertEquals((int)2, (int)meta.isNullable(2));
                JdbcThinMetadataSelfTest.assertEquals((int)12, (int)meta.getParameterType(3));
                JdbcThinMetadataSelfTest.assertEquals((int)2, (int)meta.isNullable(3));
                JdbcThinMetadataSelfTest.assertEquals((int)Integer.MAX_VALUE, (int)meta.getPrecision(3));
                JdbcThinMetadataSelfTest.assertEquals((int)4, (int)meta.getParameterType(4));
                JdbcThinMetadataSelfTest.assertEquals((int)2, (int)meta.isNullable(4));
                continue;
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (conn != null) {
                    if (var3_3 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
    }

    @Test
    public void testParametersMetadataNegative() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            conn.setSchema("\"pers\"");
            PreparedStatement notCorrect = conn.prepareStatement("select * from NotExistingTable;");
            GridTestUtils.assertThrows((IgniteLogger)this.log(), notCorrect::getParameterMetaData, SQLException.class, (String)"Table \"NOTEXISTINGTABLE\" not found");
        }
    }

    @Test
    public void testSchemasMetadata() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            ResultSet rs = conn.getMetaData().getSchemas();
            HashSet<String> expectedSchemas = new HashSet<String>(Arrays.asList(QueryUtils.sysSchemaName(), "PUBLIC", "pers", "org", "dep", "PREDEFINED_SCHEMAS_1", "PREDEFINED_SCHEMAS_2"));
            HashSet<String> schemas = new HashSet<String>();
            while (rs.next()) {
                schemas.add(rs.getString(1));
                JdbcThinMetadataSelfTest.assertEquals((String)"There is only one possible catalog.", (String)"IGNITE", (String)rs.getString(2));
            }
            assert (expectedSchemas.equals(schemas)) : "Unexpected schemas: " + schemas + ". Expected schemas: " + expectedSchemas;
        }
    }

    @Test
    public void testColumnsPrecisionAndScale() throws SQLException {
        this.doTestColumnsPrecisionsAndScale("TEST_COLUMN_TYPES", false);
    }

    @Test
    public void testDynamicColumnsPrecisionAndScale() throws SQLException {
        this.doTestColumnsPrecisionsAndScale("TEST_DYNAMIC_COLUMN_TYPES", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestColumnsPrecisionsAndScale(String tblName, boolean alterTableAddColumns) throws SQLException {
        PrecicsionAndScaleTestPatameters params = PrecicsionAndScaleTestPatameters.builder().table(tblName).addColumn("INTEGER").addColumn("BOOLEAN").addColumn("TINYINT").addColumn("SMALLINT").addColumn("BIGINT").addColumn("DECIMAL").addColumn("DECIMAL", 10, 2).addColumn("REAL").addColumn("FLOAT").addColumn("DOUBLE").addColumn("TIME").addColumn("DATE").addColumn("DATETIME").addColumn("TIMESTAMP").addColumn("CHAR").addColumn("CHAR", 22).addColumn("VARCHAR").addColumn("VARCHAR", 21).addColumn("BINARY").addColumn("VARBINARY").addColumn("UUID").build();
        try (Connection conn = DriverManager.getConnection(URL);){
            try {
                Statement stmt = conn.createStatement();
                stmt.executeUpdate(params.tableCreateStatement(alterTableAddColumns));
                ResultSet rs = conn.getMetaData().getColumns(null, null, tblName, null);
                this.validateColumnsResultSet(rs, params);
                rs = stmt.executeQuery(String.format("SELECT COLUMN_NAME, PRECISION as COLUMN_SIZE, SCALE as DECIMAL_DIGITS FROM " + QueryUtils.sysSchemaName() + ".TABLE_COLUMNS WHERE TABLE_NAME='%s'", tblName));
                this.validateColumnsResultSet(rs, params);
            }
            finally {
                conn.createStatement().executeUpdate("DROP TABLE IF EXISTS " + tblName);
            }
        }
    }

    private void validateColumnsResultSet(ResultSet rs, PrecicsionAndScaleTestPatameters params) throws SQLException {
        int columnsCount = 0;
        while (rs.next()) {
            String columnName = rs.getString("COLUMN_NAME");
            if (!params.columns.containsKey(columnName)) continue;
            ++columnsCount;
            int precision = rs.getInt("COLUMN_SIZE");
            int scale = rs.getInt("DECIMAL_DIGITS");
            JdbcThinMetadataSelfTest.assertEquals((String)columnName, (int)params.precision(columnName), (int)precision);
            JdbcThinMetadataSelfTest.assertEquals((String)columnName, (int)params.scale(columnName), (int)scale);
        }
        JdbcThinMetadataSelfTest.assertEquals((int)params.columns.size(), (int)columnsCount);
    }

    @Test
    public void testCatalogWithNotExistingName() throws SQLException {
        this.checkNoEntitiesFoundForCatalog("");
        this.checkNoEntitiesFoundForCatalog("NOT_EXISTING_CATALOG");
    }

    private void checkNoEntitiesFoundForCatalog(String invalidCat) throws SQLException {
        try (Connection conn = DriverManager.getConnection(URL);){
            DatabaseMetaData meta = conn.getMetaData();
            JdbcThinMetadataSelfTest.assertIsEmpty(meta.getTables(invalidCat, null, "%", new String[]{"TABLE"}));
            JdbcThinMetadataSelfTest.assertIsEmpty(meta.getColumns(invalidCat, null, "%", "%"));
            JdbcThinMetadataSelfTest.assertIsEmpty(meta.getColumnPrivileges(invalidCat, "pers", "PERSON", "%"));
            JdbcThinMetadataSelfTest.assertIsEmpty(meta.getTablePrivileges(invalidCat, null, "%"));
            JdbcThinMetadataSelfTest.assertIsEmpty(meta.getPrimaryKeys(invalidCat, "pers", "PERSON"));
            JdbcThinMetadataSelfTest.assertIsEmpty(meta.getImportedKeys(invalidCat, "pers", "PERSON"));
            JdbcThinMetadataSelfTest.assertIsEmpty(meta.getExportedKeys(invalidCat, "pers", "PERSON"));
            JdbcThinMetadataSelfTest.assertIsEmpty(meta.getIndexInfo(invalidCat, null, "%", false, true));
            JdbcThinMetadataSelfTest.assertIsEmpty(meta.getSuperTables(invalidCat, "%", "%"));
            JdbcThinMetadataSelfTest.assertIsEmpty(meta.getSchemas(invalidCat, null));
            JdbcThinMetadataSelfTest.assertIsEmpty(meta.getPseudoColumns(invalidCat, null, "%", ""));
        }
    }

    private static void assertIsEmpty(ResultSet rs) throws SQLException {
        try {
            boolean empty = !rs.next();
            JdbcThinMetadataSelfTest.assertTrue((String)"Result should be empty because invalid catalog is specified.", (boolean)empty);
        }
        finally {
            rs.close();
        }
    }

    @Test
    public void testEmptySchemasMetadata() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            ResultSet rs = conn.getMetaData().getSchemas(null, "qqq");
            assert (!rs.next()) : "Empty result set is expected";
        }
    }

    @Test
    public void testVersions() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            JdbcThinMetadataSelfTest.assertEquals((String)"Unexpected ignite database product version.", (String)conn.getMetaData().getDatabaseProductVersion(), (String)IgniteVersionUtils.VER.toString());
            JdbcThinMetadataSelfTest.assertEquals((String)"Unexpected ignite driver version.", (String)conn.getMetaData().getDriverVersion(), (String)IgniteVersionUtils.VER.toString());
        }
        conn = DriverManager.getConnection(URL_PARTITION_AWARENESS);
        var2_2 = null;
        try {
            JdbcThinMetadataSelfTest.assertEquals((String)"Unexpected ignite database product version.", (String)conn.getMetaData().getDatabaseProductVersion(), (String)IgniteVersionUtils.VER.toString());
            JdbcThinMetadataSelfTest.assertEquals((String)"Unexpected ignite driver version.", (String)conn.getMetaData().getDriverVersion(), (String)IgniteVersionUtils.VER.toString());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testCheckSupports() throws SQLException {
        try (Connection conn = DriverManager.getConnection(URL);){
            DatabaseMetaData meta = conn.getMetaData();
            JdbcThinMetadataSelfTest.assertTrue((boolean)meta.supportsANSI92EntryLevelSQL());
            JdbcThinMetadataSelfTest.assertTrue((boolean)meta.supportsAlterTableWithAddColumn());
            JdbcThinMetadataSelfTest.assertTrue((boolean)meta.supportsAlterTableWithDropColumn());
            JdbcThinMetadataSelfTest.assertTrue((boolean)meta.nullPlusNonNullIsNull());
        }
    }

    private static class PrecicsionAndScaleTestPatameters {
        private final Map<String, TestColumnData> columns;
        private final String tableName;

        PrecicsionAndScaleTestPatameters(Map<String, TestColumnData> columns, String tableName) {
            this.columns = columns;
            this.tableName = tableName;
        }

        String tableCreateStatement(boolean alterTable) {
            SB buf = new SB();
            for (Map.Entry<String, TestColumnData> e : this.columns.entrySet()) {
                String colName = e.getKey();
                TestColumnData col = e.getValue();
                if (buf.length() > 0) {
                    buf.a(", ");
                }
                String customPrecisionAndScale = col.precision != null ? "(" + col.precision + (col.scale != null ? ", " + col.scale : "") + ")" : "";
                buf.a(String.format("%s %s%s", colName, col.type, customPrecisionAndScale));
            }
            String columnList = buf.toString();
            if (alterTable) {
                return String.format("CREATE TABLE %s (ID INT PRIMARY KEY, VAL INT); ALTER TABLE %s add column(%s)", this.tableName, this.tableName, columnList);
            }
            return String.format("CREATE TABLE %s (ID INT PRIMARY KEY, %s)", this.tableName, columnList);
        }

        int precision(String column) {
            TestColumnData data = this.columns.get(column);
            if (data.precision == null) {
                return this.defaultPrecision(data.type);
            }
            return data.precision;
        }

        int scale(String column) {
            TestColumnData data = this.columns.get(column);
            if (data.scale == null) {
                return this.defaultScale(data.type);
            }
            return data.scale;
        }

        private int defaultPrecision(String type) {
            switch (type) {
                case "BOOLEAN": {
                    return 1;
                }
                case "TINYINT": {
                    return 3;
                }
                case "SMALLINT": {
                    return 5;
                }
                case "INTEGER": {
                    return 10;
                }
                case "BIGINT": {
                    return 19;
                }
                case "DECIMAL": {
                    return 65535;
                }
                case "REAL": {
                    return 7;
                }
                case "FLOAT": 
                case "DOUBLE": {
                    return 17;
                }
                case "TIME": {
                    return 8;
                }
                case "DATE": {
                    return 10;
                }
                case "DATETIME": 
                case "TIMESTAMP": {
                    return 26;
                }
                case "BINARY": 
                case "VARBINARY": {
                    return Integer.MAX_VALUE;
                }
                case "CHAR": 
                case "VARCHAR": {
                    return Integer.MAX_VALUE;
                }
                case "UUID": {
                    return 16;
                }
            }
            throw new IllegalArgumentException("Unknown type " + type);
        }

        private int defaultScale(String type) {
            switch (type) {
                case "DECIMAL": {
                    return Short.MAX_VALUE;
                }
                case "DATETIME": 
                case "TIMESTAMP": {
                    return 6;
                }
            }
            return 0;
        }

        static PrecicsionAndScaleTestParamtersBuilder builder() {
            return new PrecicsionAndScaleTestParamtersBuilder();
        }

        static class PrecicsionAndScaleTestParamtersBuilder {
            private final Map<String, TestColumnData> columns = new HashMap<String, TestColumnData>();
            private String tblName;
            int columnCnt;

            PrecicsionAndScaleTestParamtersBuilder() {
            }

            PrecicsionAndScaleTestParamtersBuilder table(String name) {
                this.tblName = name;
                return this;
            }

            PrecicsionAndScaleTestParamtersBuilder addColumn(String type) {
                return this.addColumn(type, null, null);
            }

            PrecicsionAndScaleTestParamtersBuilder addColumn(String type, int precision) {
                return this.addColumn(type, precision, null);
            }

            private PrecicsionAndScaleTestParamtersBuilder addColumn(String type, Integer precision, Integer scale) {
                String type0 = type.toUpperCase();
                String colName = String.format("COL_%d_%s", ++this.columnCnt, type0);
                this.columns.put(colName, new TestColumnData(type0, precision, scale));
                return this;
            }

            PrecicsionAndScaleTestPatameters build() {
                return new PrecicsionAndScaleTestPatameters(this.columns, this.tblName);
            }
        }

        static class TestColumnData {
            final String type;
            final Integer precision;
            final Integer scale;

            public TestColumnData(String type, Integer precision, Integer scale) {
                this.type = type;
                this.precision = precision;
                this.scale = scale;
            }
        }
    }

    private static enum MetadataColumn {
        TABLE_SCHEMA("TABLE_SCHEM"),
        COLUMN_NAME("COLUMN_NAME");

        private final String colName;

        private MetadataColumn(String colName) {
            this.colName = colName;
        }

        public String columnName() {
            return this.colName;
        }
    }

    private static class Department
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField(precision=43)
        private final String name;

        private Department(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    private static class Organization
    implements Serializable {
        private final int id;
        private final String name;

        private Organization(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    private static class Person
    implements Serializable {
        private final String name;
        private final int age;
        private final int orgId;

        private Person(String name, int age, int orgId) {
            assert (!F.isEmpty((String)name));
            assert (age > 0);
            assert (orgId > 0);
            this.name = name;
            this.age = age;
            this.orgId = orgId;
        }
    }
}

