/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;
import javax.cache.configuration.Factory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.ssl.SslContextFactory;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class JdbcThinConnectionSSLTest
extends JdbcThinAbstractSelfTest {
    private static final String CLI_KEY_STORE_PATH = U.getIgniteHome() + "/modules/clients/src/test/keystore/client.jks";
    private static final String SRV_KEY_STORE_PATH = U.getIgniteHome() + "/modules/clients/src/test/keystore/server.jks";
    private static final String TRUST_KEY_STORE_PATH = U.getIgniteHome() + "/modules/clients/src/test/keystore/trust-one.jks";
    private static Factory<SSLContext> sslCtxFactory;
    private static boolean setSslCtxFactoryToCli;
    private static boolean setSslCtxFactoryToIgnite;
    private static boolean sslClientAuth;
    private static String[] supportedCiphers;

    protected void beforeTest() throws Exception {
        setSslCtxFactoryToCli = false;
        setSslCtxFactoryToIgnite = false;
        sslClientAuth = true;
        supportedCiphers = null;
        sslCtxFactory = null;
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        cfg.setClientConnectorConfiguration(new ClientConnectorConfiguration().setSslEnabled(true).setUseIgniteSslContextFactory(setSslCtxFactoryToIgnite).setSslClientAuth(sslClientAuth).setSslContextFactory(setSslCtxFactoryToCli ? sslCtxFactory : null));
        cfg.setSslContextFactory(setSslCtxFactoryToIgnite ? sslCtxFactory : null);
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnection() throws Exception {
        setSslCtxFactoryToCli = true;
        sslCtxFactory = JdbcThinConnectionSSLTest.getTestSslContextFactory();
        this.startGrids(1);
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");){
            this.checkConnection(conn);
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionTrustAll() throws Exception {
        setSslCtxFactoryToCli = true;
        sslCtxFactory = JdbcThinConnectionSSLTest.getTestSslContextFactory();
        this.startGrids(1);
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustAll=true");){
            this.checkConnection(conn);
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionUseIgniteFactory() throws Exception {
        setSslCtxFactoryToIgnite = true;
        sslCtxFactory = JdbcThinConnectionSSLTest.getTestSslContextFactory();
        this.startGrids(1);
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");){
            this.checkConnection(conn);
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultContext() throws Exception {
        SSLContext dfltSslCtx = SSLContext.getDefault();
        SSLContext.setDefault((SSLContext)JdbcThinConnectionSSLTest.getTestSslContextFactory().create());
        setSslCtxFactoryToCli = true;
        sslCtxFactory = new Factory<SSLContext>(){

            public SSLContext create() {
                try {
                    return SSLContext.getDefault();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IgniteException((Throwable)e);
                }
            }
        };
        this.startGrids(1);
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require");){
            this.checkConnection(conn);
        }
        finally {
            this.stopAllGrids();
            SSLContext.setDefault(dfltSslCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultContextOneWay() throws Exception {
        setSslCtxFactoryToCli = true;
        sslCtxFactory = JdbcThinConnectionSSLTest.getTestSslContextFactory();
        sslClientAuth = false;
        this.startGrids(1);
        SSLContext defaultContext = SSLContext.getDefault();
        try {
            SSLContext.setDefault((SSLContext)JdbcThinConnectionSSLTest.getTestSslContextFactoryNoKey().create());
            try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require");){
                this.checkConnection(conn);
            }
        }
        finally {
            this.stopAllGrids();
            SSLContext.setDefault(defaultContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContextFactory() throws Exception {
        setSslCtxFactoryToCli = true;
        sslCtxFactory = JdbcThinConnectionSSLTest.getTestSslContextFactory();
        this.startGrids(1);
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslFactory=" + TestSSLFactory.class.getName());){
            this.checkConnection(conn);
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomCiphersOnClient() throws Exception {
        setSslCtxFactoryToCli = true;
        sslCtxFactory = JdbcThinConnectionSSLTest.getTestSslContextFactory();
        this.startGrids(1);
        try {
            try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");){
                this.checkConnection(conn);
            }
            conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslCipherSuites=TLS_RSA_WITH_AES_256_CBC_SHA256&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");
            var2_2 = null;
            try {
                this.checkConnection(conn);
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (conn != null) {
                    if (var2_2 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
            conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslCipherSuites=TLS_RSA_WITH_NULL_SHA256,TLS_RSA_WITH_AES_256_CBC_SHA256&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");
            var2_2 = null;
            try {
                this.checkConnection(conn);
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (conn != null) {
                    if (var2_2 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomCiphersOnServer() throws Exception {
        setSslCtxFactoryToCli = true;
        supportedCiphers = new String[]{"TLS_RSA_WITH_AES_256_CBC_SHA256"};
        sslCtxFactory = JdbcThinConnectionSSLTest.getTestSslContextFactory();
        this.startGrids(1);
        try {
            try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");){
                this.checkConnection(conn);
            }
            conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslCipherSuites=TLS_RSA_WITH_AES_256_CBC_SHA256&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");
            var2_2 = null;
            try {
                this.checkConnection(conn);
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (conn != null) {
                    if (var2_2 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
            GridTestUtils.assertThrows((IgniteLogger)log, () -> DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslCipherSuites=TLS_RSA_WITH_NULL_SHA256&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456"), SQLException.class, (String)"Failed to SSL connect to server");
            conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslCipherSuites=TLS_RSA_WITH_NULL_SHA256,TLS_RSA_WITH_AES_256_CBC_SHA256&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");
            var2_2 = null;
            try {
                this.checkConnection(conn);
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (conn != null) {
                    if (var2_2 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisabledCustomCipher() throws Exception {
        setSslCtxFactoryToCli = true;
        supportedCiphers = new String[]{"TLS_RSA_WITH_NULL_SHA256"};
        sslCtxFactory = JdbcThinConnectionSSLTest.getTestSslContextFactory();
        this.startGrids(1);
        try {
            try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslCipherSuites=TLS_RSA_WITH_NULL_SHA256&sslTrustAll=true&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");){
                this.checkConnection(conn);
            }
            GridTestUtils.assertThrows((IgniteLogger)log, () -> DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456"), SQLException.class, (String)"Failed to SSL connect to server");
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnsupportedCustomCipher() throws Exception {
        setSslCtxFactoryToCli = true;
        supportedCiphers = new String[]{"TLS_RSA_WITH_NULL_SHA256", "TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA"};
        sslCtxFactory = JdbcThinConnectionSSLTest.getTestSslContextFactory();
        this.startGrids(1);
        try {
            GridTestUtils.assertThrows((IgniteLogger)log, () -> DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslCipherSuites=TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA&sslTrustAll=true&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456"), SQLException.class, (String)"Failed to SSL connect to server");
            try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslCipherSuites=TLS_RSA_WITH_NULL_SHA256&sslTrustAll=true&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");){
                this.checkConnection(conn);
            }
            GridTestUtils.assertThrows((IgniteLogger)log, () -> DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456"), SQLException.class, (String)"Failed to SSL connect to server");
        }
        finally {
            this.stopAllGrids();
        }
    }

    @Test
    public void testInvalidCustomCipher() throws Exception {
        setSslCtxFactoryToCli = true;
        supportedCiphers = new String[]{"TLS_RSA_WITH_INVALID_SHA256"};
        sslCtxFactory = JdbcThinConnectionSSLTest.getTestSslContextFactory();
        this.startGrids(1);
        try {
            GridTestUtils.assertThrows((IgniteLogger)log, () -> DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslCipherSuites=TLS_RSA_WITH_INVALID_SHA256&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456"), SQLException.class, (String)"Failed to connect to server");
            GridTestUtils.assertThrows((IgniteLogger)log, () -> DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456"), SQLException.class, (String)"Failed to SSL connect to server");
        }
        finally {
            this.stopAllGrids();
        }
    }

    @Test
    public void testSslServerAndPlainClient() throws Exception {
        setSslCtxFactoryToCli = true;
        sslCtxFactory = JdbcThinConnectionSSLTest.getTestSslContextFactory();
        this.startGrids(1);
        try {
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1");
                    return null;
                }
            }, SQLException.class, (String)"Failed to connect to Ignite cluster");
        }
        finally {
            this.stopAllGrids();
        }
    }

    @Test
    public void testInvalidKeystoreConfig() throws Exception {
        setSslCtxFactoryToCli = true;
        sslCtxFactory = JdbcThinConnectionSSLTest.getTestSslContextFactory();
        this.startGrids(1);
        try {
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslClientCertificateKeyStoreUrl=invalid_client_keystore_path&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");
                    return null;
                }
            }, SQLException.class, (String)"Failed to initialize key store (key store file was not found):");
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=invalid_cli_passwd&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");
                    return null;
                }
            }, SQLException.class, (String)"Failed to initialize key store (I/O error occurred):");
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=invalid_trust_keystore_path&sslTrustCertificateKeyStorePassword=123456");
                    return null;
                }
            }, SQLException.class, (String)"Failed to initialize key store (key store file was not found):");
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=invalid_trust_passwd");
                    return null;
                }
            }, SQLException.class, (String)"Failed to initialize key store (I/O error occurred):");
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslClientCertificateKeyStoreType=INVALID&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");
                    return null;
                }
            }, SQLException.class, (String)"Failed to initialize key store (security exception occurred) [type=INVALID,");
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStoreType=INVALID&sslTrustCertificateKeyStorePassword=123456");
                    return null;
                }
            }, SQLException.class, (String)"Failed to initialize key store (security exception occurred) [type=INVALID,");
        }
        finally {
            this.stopAllGrids();
        }
    }

    @Test
    public void testUnknownClientCertificate() throws Exception {
        setSslCtxFactoryToCli = true;
        sslCtxFactory = JdbcThinConnectionSSLTest.getTestSslContextFactory();
        this.startGrids(1);
        try {
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Connection c = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslClientCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");
                    return null;
                }
            }, SQLException.class, (String)"connect to");
        }
        finally {
            this.stopAllGrids();
        }
    }

    @Test
    public void testUnsupportedSslProtocol() throws Exception {
        setSslCtxFactoryToCli = true;
        sslCtxFactory = JdbcThinConnectionSSLTest.getTestSslContextFactory();
        this.startGrids(1);
        try {
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Connection c = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslProtocol=TLSv1.13&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");
                    return null;
                }
            }, SQLException.class, (String)"Unsupported SSL protocol: TLSv1.13");
        }
        finally {
            this.stopAllGrids();
        }
    }

    @Test
    public void testInvalidKeyAlgorithm() throws Exception {
        setSslCtxFactoryToCli = true;
        sslCtxFactory = JdbcThinConnectionSSLTest.getTestSslContextFactory();
        this.startGrids(1);
        try {
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Connection c = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslKeyAlgorithm=INVALID&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");
                    return null;
                }
            }, SQLException.class, (String)"Unsupported keystore algorithm: INVALID");
        }
        finally {
            this.stopAllGrids();
        }
    }

    @Test
    public void testInvalidKeyStoreType() throws Exception {
        setSslCtxFactoryToCli = true;
        sslCtxFactory = JdbcThinConnectionSSLTest.getTestSslContextFactory();
        this.startGrids(1);
        try {
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Connection c = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslClientCertificateKeyStoreType=INVALID_TYPE&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");
                    return null;
                }
            }, SQLException.class, (String)"Failed to initialize key store (security exception occurred) [type=INVALID_TYPE");
        }
        finally {
            this.stopAllGrids();
        }
    }

    public void checkConnection(Connection conn) throws SQLException {
        JdbcThinConnectionSSLTest.assertEquals((String)"PUBLIC", (String)conn.getSchema());
        try (Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT 1");
            JdbcThinConnectionSSLTest.assertTrue((boolean)rs.next());
            JdbcThinConnectionSSLTest.assertEquals((int)1, (int)rs.getInt(1));
        }
    }

    private static Factory<SSLContext> getTestSslContextFactory() {
        SslContextFactory factory = new SslContextFactory();
        factory.setCipherSuites(supportedCiphers);
        factory.setKeyStoreFilePath(SRV_KEY_STORE_PATH);
        factory.setKeyStorePassword("123456".toCharArray());
        factory.setTrustStoreFilePath(TRUST_KEY_STORE_PATH);
        factory.setTrustStorePassword("123456".toCharArray());
        return factory;
    }

    private static Factory<SSLContext> getTestSslContextFactoryNoKey() {
        SslContextFactory factory = new SslContextFactory();
        factory.setTrustStoreFilePath(TRUST_KEY_STORE_PATH);
        factory.setTrustStorePassword("123456".toCharArray());
        return factory;
    }

    public static class TestSSLFactory
    implements Factory<SSLSocketFactory> {
        public SSLSocketFactory create() {
            return ((SSLContext)JdbcThinConnectionSSLTest.getTestSslContextFactory().create()).getSocketFactory();
        }
    }
}

