/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.ignite.internal.jdbc.thin.ConnectionPropertiesImpl;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.junit.Test;

public class JdbcThinConnectionPropertiesTest
extends JdbcThinAbstractSelfTest {
    @Test
    public void testNamePrefixDriverPropertyInfo() {
        ConnectionPropertiesImpl connProps = new ConnectionPropertiesImpl();
        DriverPropertyInfo[] propsInfo = connProps.getDriverPropertyInfo();
        String propName = propsInfo[0].name;
        JdbcThinConnectionPropertiesTest.assertTrue((boolean)propName.startsWith("ignite.jdbc."));
    }

    @Test
    public void testPrefixedPropertiesApplicable() throws SQLException {
        String TEST_PROP_NAME = "ignite.jdbc.enforceJoinOrder";
        Properties props = new Properties();
        props.setProperty("ignite.jdbc.enforceJoinOrder", Boolean.TRUE.toString());
        ConnectionPropertiesImpl connPropsTrue = new ConnectionPropertiesImpl();
        connPropsTrue.init("", props);
        props.setProperty("ignite.jdbc.enforceJoinOrder", Boolean.FALSE.toString());
        ConnectionPropertiesImpl connPropsFalse = new ConnectionPropertiesImpl();
        connPropsFalse.init("", props);
        JdbcThinConnectionPropertiesTest.assertTrue((boolean)connPropsTrue.isEnforceJoinOrder());
        JdbcThinConnectionPropertiesTest.assertFalse((boolean)connPropsFalse.isEnforceJoinOrder());
    }
}

