/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.model;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.visor.compute.VisorGatewayTask;
import org.apache.ignite.lang.IgniteClosure;
import org.jetbrains.annotations.NotNull;

public class VisorGatewayArgument
extends HashMap<String, String> {
    private static final String CHARSET = StandardCharsets.UTF_8.name();
    private int idx = 3;

    public VisorGatewayArgument(Class cls) {
        super(F.asMap((Object)"cmd", (Object)GridRestCommand.EXE.key(), (Object)"name", (Object)VisorGatewayTask.class.getName(), (Object)"p1", (Object)"null", (Object)"p2", (Object)cls.getName()));
    }

    public VisorGatewayArgument setNode(ClusterNode node) {
        this.put("p1", node != null ? node.id().toString() : null);
        return this;
    }

    public VisorGatewayArgument setNodes(Collection<ClusterNode> nodes) {
        this.put("p1", VisorGatewayArgument.concat(F.transform(nodes, (IgniteClosure)new C1<ClusterNode, UUID>(){

            public UUID apply(ClusterNode node) {
                return node.id();
            }
        }).toArray(), ";"));
        return this;
    }

    public VisorGatewayArgument addArguments(Object ... vals) {
        if (this.idx == 3) {
            throw new IllegalStateException("Task argument class should be declared before adding of additional arguments. Use VisorGatewayArgument.setTaskArgument first");
        }
        if (vals != null && F.isEmpty((Object[])vals)) {
            throw new IllegalArgumentException("Additional arguments should be configured as null or not empty array of arguments");
        }
        if (vals != null) {
            for (Object val : vals) {
                this.put("p" + this.idx++, String.valueOf(val));
            }
        } else {
            this.put("p" + this.idx++, null);
        }
        return this;
    }

    public VisorGatewayArgument setTaskArgument(Class cls, Object ... vals) {
        if (this.idx != 3) {
            throw new IllegalStateException("Task argument class should be declared before adding of additional arguments");
        }
        this.put("p" + this.idx++, cls.getName());
        if (vals != null) {
            for (Object val : vals) {
                this.put("p" + this.idx++, val != null ? val.toString() : null);
            }
        } else {
            this.put("p" + this.idx++, null);
        }
        return this;
    }

    public VisorGatewayArgument addCollectionArgument(Class cls, Object ... vals) {
        if (this.idx == 3) {
            throw new IllegalStateException("Task argument class should be declared before adding of additional arguments. Use VisorGatewayArgument.setTaskArgument first");
        }
        this.put("p" + this.idx++, Collection.class.getName());
        this.put("p" + this.idx++, cls.getName());
        this.put("p" + this.idx++, VisorGatewayArgument.concat(vals, ";"));
        return this;
    }

    public VisorGatewayArgument addSetArgument(Class cls, Object ... vals) {
        if (this.idx == 3) {
            throw new IllegalStateException("Task argument class should be declared before adding of additional argument. Use VisorGatewayArgument.setTaskArgument first");
        }
        this.put("p" + this.idx++, Set.class.getName());
        this.put("p" + this.idx++, cls.getName());
        this.put("p" + this.idx++, VisorGatewayArgument.concat(vals, ";"));
        return this;
    }

    public VisorGatewayArgument addMapArgument(Class keyCls, Class valCls, @NotNull Map<?, ?> map) throws UnsupportedEncodingException {
        if (this.idx == 3) {
            throw new IllegalStateException("Task argument class should be declared before adding of additional arguments. Use VisorGatewayArgument.setTaskArgument first");
        }
        if (map == null) {
            throw new IllegalArgumentException("Map argument should be specified");
        }
        this.put("p" + this.idx++, Map.class.getName());
        this.put("p" + this.idx++, keyCls.getName());
        this.put("p" + this.idx++, valCls.getName());
        SB sb = new SB();
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!first) {
                sb.a(";");
            }
            sb.a(entry.getKey());
            if (entry.getValue() != null) {
                sb.a("=").a(entry.getValue());
            }
            first = false;
        }
        this.put("p" + this.idx++, URLEncoder.encode(sb.toString(), CHARSET));
        return this;
    }

    private static String concat(Object[] vals, String delim) {
        SB sb = new SB();
        boolean first = true;
        if (vals != null) {
            for (Object val : vals) {
                if (!first) {
                    sb.a(delim);
                }
                sb.a(val);
                first = false;
            }
        } else {
            sb.a((Object)vals);
        }
        return sb.toString();
    }
}

