/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskSplitAdapter;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDataConfiguration;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.task.GridTaskCommandHandler;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.jsr166.ConcurrentLinkedHashMap;
import org.junit.Test;

public class TaskCommandHandlerSelfTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "cache";
    public static final String HOST = "127.0.0.1";
    public static final int BINARY_PORT = 11212;
    private static final int MAX_TASK_RESULTS = 10;
    private GridClient client;

    protected void beforeTestsStarted() throws Exception {
        System.setProperty("IGNITE_REST_MAX_TASK_RESULTS", String.valueOf(10));
        this.startGrid(0);
    }

    protected void afterTestsStopped() throws Exception {
        System.clearProperty("IGNITE_REST_MAX_TASK_RESULTS");
    }

    protected void beforeTest() throws Exception {
        this.client = GridClientFactory.start((GridClientConfiguration)this.clientConfiguration());
    }

    protected void afterTest() throws Exception {
        GridClientFactory.stop((UUID)this.client.id());
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setLocalHost(HOST);
        assert (cfg.getConnectorConfiguration() == null);
        ConnectorConfiguration clientCfg = new ConnectorConfiguration();
        clientCfg.setPort(11212);
        cfg.setConnectorConfiguration(clientCfg);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("default"), this.cacheConfiguration("replicated"), this.cacheConfiguration("partitioned"), this.cacheConfiguration(CACHE_NAME)});
        return cfg;
    }

    private CacheConfiguration cacheConfiguration(@NotNull String cacheName) throws Exception {
        CacheConfiguration cfg = TaskCommandHandlerSelfTest.defaultCacheConfiguration();
        cfg.setCacheMode("default".equals(cacheName) || CACHE_NAME.equals(cacheName) ? CacheMode.LOCAL : ("replicated".equals(cacheName) ? CacheMode.REPLICATED : CacheMode.PARTITIONED));
        cfg.setName(cacheName);
        cfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        return cfg;
    }

    private GridClientConfiguration clientConfiguration() {
        GridClientConfiguration cfg = new GridClientConfiguration();
        GridClientDataConfiguration nullCache = new GridClientDataConfiguration();
        GridClientDataConfiguration cache = new GridClientDataConfiguration();
        cache.setName(CACHE_NAME);
        cfg.setDataConfigurations(Arrays.asList(nullCache, cache));
        cfg.setProtocol(GridClientProtocol.TCP);
        cfg.setServers(Arrays.asList("localhost:11212"));
        return cfg;
    }

    @Test
    public void testManyTasksRun() throws Exception {
        GridClientCompute compute = this.client.compute();
        for (int i = 0; i < 1000; ++i) {
            TaskCommandHandlerSelfTest.assertEquals((Object)new Integer("executing".length()), (Object)compute.execute(TestTask.class.getName(), (Object)"executing"));
        }
        GridClientFactory.stop((UUID)this.client.id(), (boolean)true);
        IgniteKernal g = (IgniteKernal)this.grid(0);
        Map handlers = (Map)U.field((Object)g.context().rest(), (String)"handlers");
        GridTaskCommandHandler taskHnd = (GridTaskCommandHandler)F.find(handlers.values(), null, (IgnitePredicate[])new IgnitePredicate[]{new P1<GridRestCommandHandler>(){

            public boolean apply(GridRestCommandHandler e) {
                return e instanceof GridTaskCommandHandler;
            }
        }});
        TaskCommandHandlerSelfTest.assertNotNull((String)"GridTaskCommandHandler was not found", (Object)taskHnd);
        ConcurrentLinkedHashMap taskDesc = (ConcurrentLinkedHashMap)U.field((Object)taskHnd, (String)"taskDescs");
        TaskCommandHandlerSelfTest.assertTrue((String)("Task result map size exceeded max value [mapSize=" + taskDesc.sizex() + ", maxSize=" + 10 + ']'), (taskDesc.sizex() <= 10 ? 1 : 0) != 0);
    }

    private static class TestTask
    extends ComputeTaskSplitAdapter<String, Integer> {
        private TestTask() {
        }

        protected Collection<? extends ComputeJob> split(int gridSize, final String arg) {
            return Collections.singletonList(new ComputeJobAdapter(){

                public Object execute() {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                    }
                    return arg.length();
                }
            });
        }

        public Integer reduce(List<ComputeJobResult> results) {
            int sum = 0;
            for (ComputeJobResult res : results) {
                sum += ((Integer)res.getData()).intValue();
            }
            return sum;
        }
    }
}

