/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskSplitAdapter;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.rest.GridRestProcessor;
import org.apache.ignite.internal.processors.rest.TestBinaryClient;
import org.apache.ignite.internal.processors.rest.client.message.GridClientNodeBean;
import org.apache.ignite.internal.processors.rest.client.message.GridClientTaskResultBean;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class RestBinaryProtocolSelfTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "cache";
    private static final String HOST = "127.0.0.1";
    private static final int PORT = 11212;
    private TestBinaryClient client;

    protected void beforeTestsStarted() throws Exception {
        this.startGrid();
    }

    protected void beforeTest() throws Exception {
        this.client = this.client();
    }

    protected void afterTest() throws Exception {
        this.client.shutdown();
        this.grid().cache("default").clear();
        this.grid().cache(CACHE_NAME).clear();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setLocalHost(HOST);
        assert (cfg.getConnectorConfiguration() == null);
        ConnectorConfiguration clientCfg = new ConnectorConfiguration();
        clientCfg.setPort(11212);
        cfg.setConnectorConfiguration(clientCfg);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("default"), this.cacheConfiguration(CACHE_NAME)});
        return cfg;
    }

    private CacheConfiguration cacheConfiguration(@NotNull String cacheName) throws Exception {
        CacheConfiguration cfg = RestBinaryProtocolSelfTest.defaultCacheConfiguration();
        cfg.setCacheMode(CacheMode.LOCAL);
        cfg.setName(cacheName);
        cfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cfg.setStatisticsEnabled(true);
        return cfg;
    }

    private TestBinaryClient client() throws IgniteCheckedException {
        return new TestBinaryClient(HOST, 11212);
    }

    @Test
    public void testPut() throws Exception {
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cachePut("default", "key1", "val1"));
        RestBinaryProtocolSelfTest.assertEquals((Object)"val1", (Object)this.grid().cache("default").get((Object)"key1"));
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cachePut(CACHE_NAME, "key1", "val1"));
        RestBinaryProtocolSelfTest.assertEquals((Object)"val1", (Object)this.grid().cache(CACHE_NAME).get((Object)"key1"));
    }

    @Test
    public void testPutAll() throws Exception {
        this.client.cachePutAll("default", F.asMap((Object)"key1", (Object)"val1", (Object)"key2", (Object)"val2"));
        Map map = this.grid().cache("default").getAll(F.asSet((Object[])new String[]{"key1", "key2"}));
        RestBinaryProtocolSelfTest.assertEquals((int)2, (int)map.size());
        RestBinaryProtocolSelfTest.assertEquals((String)"val1", (String)((String)map.get("key1")));
        RestBinaryProtocolSelfTest.assertEquals((String)"val2", (String)((String)map.get("key2")));
        this.client.cachePutAll(CACHE_NAME, F.asMap((Object)"key1", (Object)"val1", (Object)"key2", (Object)"val2"));
        map = this.grid().cache(CACHE_NAME).getAll(F.asSet((Object[])new String[]{"key1", "key2"}));
        RestBinaryProtocolSelfTest.assertEquals((int)2, (int)map.size());
        RestBinaryProtocolSelfTest.assertEquals((String)"val1", (String)((String)map.get("key1")));
        RestBinaryProtocolSelfTest.assertEquals((String)"val2", (String)((String)map.get("key2")));
    }

    @Test
    public void testGet() throws Exception {
        this.grid().cache("default").put((Object)"key", (Object)"val");
        RestBinaryProtocolSelfTest.assertEquals((String)"val", (String)((String)this.client.cacheGet("default", "key")));
        this.grid().cache(CACHE_NAME).put((Object)"key", (Object)"val");
        RestBinaryProtocolSelfTest.assertEquals((String)"val", (String)((String)this.client.cacheGet(CACHE_NAME, "key")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailure() throws Exception {
        IgniteKernal kernal = (IgniteKernal)this.grid();
        GridRestProcessor proc = kernal.context().rest();
        Field hndField = proc.getClass().getDeclaredField("handlers");
        hndField.setAccessible(true);
        Map handlers = (Map)hndField.get(proc);
        HashMap cp = new HashMap(handlers);
        handlers.clear();
        try {
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return RestBinaryProtocolSelfTest.this.client.cacheGet("default", "key");
                }
            }, IgniteCheckedException.class, (String)"Failed to process client request: Failed to find registered handler for command: CACHE_GET");
        }
        finally {
            handlers.putAll(cp);
        }
    }

    @Test
    public void testGetAll() throws Exception {
        IgniteCache jcacheDflt = this.grid().cache("default");
        IgniteCache jcacheName = this.grid().cache(CACHE_NAME);
        jcacheDflt.put((Object)"key1", (Object)"val1");
        jcacheDflt.put((Object)"key2", (Object)"val2");
        Map map = this.client.cacheGetAll("default", "key1", "key2");
        RestBinaryProtocolSelfTest.assertEquals((int)2, (int)map.size());
        RestBinaryProtocolSelfTest.assertEquals((String)"val1", (String)((String)map.get("key1")));
        RestBinaryProtocolSelfTest.assertEquals((String)"val2", (String)((String)map.get("key2")));
        jcacheDflt.put((Object)"key3", (Object)"val3");
        jcacheDflt.put((Object)"key4", (Object)"val4");
        map = this.client.cacheGetAll("default", "key3", "key4");
        RestBinaryProtocolSelfTest.assertEquals((int)2, (int)map.size());
        RestBinaryProtocolSelfTest.assertEquals((String)"val3", (String)((String)map.get("key3")));
        RestBinaryProtocolSelfTest.assertEquals((String)"val4", (String)((String)map.get("key4")));
        jcacheName.put((Object)"key1", (Object)"val1");
        jcacheName.put((Object)"key2", (Object)"val2");
        map = this.client.cacheGetAll(CACHE_NAME, "key1", "key2");
        RestBinaryProtocolSelfTest.assertEquals((int)2, (int)map.size());
        RestBinaryProtocolSelfTest.assertEquals((String)"val1", (String)((String)map.get("key1")));
        RestBinaryProtocolSelfTest.assertEquals((String)"val2", (String)((String)map.get("key2")));
        jcacheName.put((Object)"key3", (Object)"val3");
        jcacheName.put((Object)"key4", (Object)"val4");
        map = this.client.cacheGetAll(CACHE_NAME, "key3", "key4");
        RestBinaryProtocolSelfTest.assertEquals((int)2, (int)map.size());
        RestBinaryProtocolSelfTest.assertEquals((String)"val3", (String)((String)map.get("key3")));
        RestBinaryProtocolSelfTest.assertEquals((String)"val4", (String)((String)map.get("key4")));
    }

    @Test
    public void testRemove() throws Exception {
        IgniteCache jcacheDflt = this.grid().cache("default");
        IgniteCache jcacheName = this.grid().cache(CACHE_NAME);
        jcacheDflt.put((Object)"key", (Object)"val");
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cacheRemove("default", "key"));
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheRemove("default", "wrongKey"));
        RestBinaryProtocolSelfTest.assertNull((Object)jcacheDflt.get((Object)"key"));
        jcacheName.put((Object)"key", (Object)"val");
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cacheRemove(CACHE_NAME, "key"));
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheRemove(CACHE_NAME, "wrongKey"));
        RestBinaryProtocolSelfTest.assertNull((Object)jcacheName.get((Object)"key"));
    }

    @Test
    public void testRemoveAll() throws Exception {
        IgniteCache jcacheDflt = this.grid().cache("default");
        jcacheDflt.put((Object)"key1", (Object)"val1");
        jcacheDflt.put((Object)"key2", (Object)"val2");
        jcacheDflt.put((Object)"key3", (Object)"val3");
        jcacheDflt.put((Object)"key4", (Object)"val4");
        this.client.cacheRemoveAll("default", "key1", "key2");
        RestBinaryProtocolSelfTest.assertNull((Object)jcacheDflt.get((Object)"key1"));
        RestBinaryProtocolSelfTest.assertNull((Object)jcacheDflt.get((Object)"key2"));
        RestBinaryProtocolSelfTest.assertNotNull((Object)jcacheDflt.get((Object)"key3"));
        RestBinaryProtocolSelfTest.assertNotNull((Object)jcacheDflt.get((Object)"key4"));
        IgniteCache jcacheName = this.grid().cache(CACHE_NAME);
        jcacheName.put((Object)"key1", (Object)"val1");
        jcacheName.put((Object)"key2", (Object)"val2");
        jcacheName.put((Object)"key3", (Object)"val3");
        jcacheName.put((Object)"key4", (Object)"val4");
        this.client.cacheRemoveAll(CACHE_NAME, "key1", "key2");
        RestBinaryProtocolSelfTest.assertNull((Object)jcacheName.get((Object)"key1"));
        RestBinaryProtocolSelfTest.assertNull((Object)jcacheName.get((Object)"key2"));
        RestBinaryProtocolSelfTest.assertNotNull((Object)jcacheName.get((Object)"key3"));
        RestBinaryProtocolSelfTest.assertNotNull((Object)jcacheName.get((Object)"key4"));
    }

    @Test
    public void testReplace() throws Exception {
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheReplace("default", "key1", "val1"));
        IgniteCache jcacheDflt = this.grid().cache("default");
        jcacheDflt.put((Object)"key1", (Object)"val1");
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cacheReplace("default", "key1", "val2"));
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheReplace("default", "key2", "val1"));
        jcacheDflt.put((Object)"key2", (Object)"val1");
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cacheReplace("default", "key2", "val2"));
        jcacheDflt.clear();
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheReplace(CACHE_NAME, "key1", "val1"));
        this.grid().cache(CACHE_NAME).put((Object)"key1", (Object)"val1");
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cacheReplace(CACHE_NAME, "key1", "val2"));
    }

    @Test
    public void testCompareAndSet() throws Exception {
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheCompareAndSet("default", "key", null, null));
        IgniteCache jcache = this.grid().cache("default");
        jcache.put((Object)"key", (Object)"val");
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cacheCompareAndSet("default", "key", null, null));
        RestBinaryProtocolSelfTest.assertNull((Object)jcache.get((Object)"key"));
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheCompareAndSet("default", "key", null, "val"));
        jcache.put((Object)"key", (Object)"val");
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheCompareAndSet("default", "key", null, "wrongVal"));
        RestBinaryProtocolSelfTest.assertEquals((Object)"val", (Object)jcache.get((Object)"key"));
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cacheCompareAndSet("default", "key", null, "val"));
        RestBinaryProtocolSelfTest.assertNull((Object)jcache.get((Object)"key"));
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cacheCompareAndSet("default", "key", "val", null));
        RestBinaryProtocolSelfTest.assertEquals((Object)"val", (Object)jcache.get((Object)"key"));
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheCompareAndSet("default", "key", "newVal", null));
        RestBinaryProtocolSelfTest.assertEquals((Object)"val", (Object)jcache.get((Object)"key"));
        jcache.remove((Object)"key");
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheCompareAndSet("default", "key", "val1", "val2"));
        jcache.put((Object)"key", (Object)"val2");
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheCompareAndSet("default", "key", "val1", "wrongVal"));
        RestBinaryProtocolSelfTest.assertEquals((Object)"val2", (Object)jcache.get((Object)"key"));
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cacheCompareAndSet("default", "key", "val1", "val2"));
        RestBinaryProtocolSelfTest.assertEquals((Object)"val1", (Object)jcache.get((Object)"key"));
        jcache.remove((Object)"key");
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheCompareAndSet(CACHE_NAME, "key", null, null));
        IgniteCache jcacheName = this.grid().cache(CACHE_NAME);
        jcacheName.put((Object)"key", (Object)"val");
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cacheCompareAndSet(CACHE_NAME, "key", null, null));
        RestBinaryProtocolSelfTest.assertNull((Object)jcacheName.get((Object)"key"));
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheCompareAndSet(CACHE_NAME, "key", null, "val"));
        jcacheName.put((Object)"key", (Object)"val");
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheCompareAndSet(CACHE_NAME, "key", null, "wrongVal"));
        RestBinaryProtocolSelfTest.assertEquals((Object)"val", (Object)jcacheName.get((Object)"key"));
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cacheCompareAndSet(CACHE_NAME, "key", null, "val"));
        RestBinaryProtocolSelfTest.assertNull((Object)jcacheName.get((Object)"key"));
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cacheCompareAndSet(CACHE_NAME, "key", "val", null));
        RestBinaryProtocolSelfTest.assertEquals((Object)"val", (Object)jcacheName.get((Object)"key"));
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheCompareAndSet(CACHE_NAME, "key", "newVal", null));
        RestBinaryProtocolSelfTest.assertEquals((Object)"val", (Object)jcacheName.get((Object)"key"));
        jcacheName.remove((Object)"key");
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheCompareAndSet(CACHE_NAME, "key", "val1", "val2"));
        jcacheName.put((Object)"key", (Object)"val2");
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheCompareAndSet(CACHE_NAME, "key", "val1", "wrongVal"));
        RestBinaryProtocolSelfTest.assertEquals((Object)"val2", (Object)jcacheName.get((Object)"key"));
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cacheCompareAndSet(CACHE_NAME, "key", "val1", "val2"));
        RestBinaryProtocolSelfTest.assertEquals((Object)"val1", (Object)jcacheName.get((Object)"key"));
        jcacheName.remove((Object)"key");
    }

    @Test
    public void testMetrics() throws Exception {
        IgniteCache jcacheDft = this.grid().cache("default");
        IgniteCache jcacheName = this.grid().cache(CACHE_NAME);
        jcacheDft.localMxBean().clear();
        jcacheName.localMxBean().clear();
        jcacheDft.put((Object)"key1", (Object)"val");
        jcacheDft.put((Object)"key2", (Object)"val");
        jcacheDft.put((Object)"key2", (Object)"val");
        jcacheDft.get((Object)"key1");
        jcacheDft.get((Object)"key2");
        jcacheDft.get((Object)"key2");
        jcacheName.put((Object)"key1", (Object)"val");
        jcacheName.put((Object)"key2", (Object)"val");
        jcacheName.put((Object)"key2", (Object)"val");
        jcacheName.get((Object)"key1");
        jcacheName.get((Object)"key2");
        jcacheName.get((Object)"key2");
        Map<String, Long> m = this.client.cacheMetrics("default");
        RestBinaryProtocolSelfTest.assertNotNull(m);
        RestBinaryProtocolSelfTest.assertEquals((int)4, (int)m.size());
        RestBinaryProtocolSelfTest.assertEquals((long)3L, (long)m.get("reads"));
        RestBinaryProtocolSelfTest.assertEquals((long)3L, (long)m.get("writes"));
        m = this.client.cacheMetrics(CACHE_NAME);
        RestBinaryProtocolSelfTest.assertNotNull(m);
        RestBinaryProtocolSelfTest.assertEquals((int)4, (int)m.size());
        RestBinaryProtocolSelfTest.assertEquals((long)3L, (long)m.get("reads"));
        RestBinaryProtocolSelfTest.assertEquals((long)3L, (long)m.get("writes"));
    }

    @Test
    public void testAppend() throws Exception {
        this.grid().cache("default").remove((Object)"key");
        this.grid().cache(CACHE_NAME).remove((Object)"key");
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheAppend("default", "key", ".val"));
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cacheAppend(CACHE_NAME, "key", ".val"));
        this.grid().cache("default").put((Object)"key", (Object)"orig");
        this.grid().cache(CACHE_NAME).put((Object)"key", (Object)"orig");
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cacheAppend("default", "key", ".val"));
        RestBinaryProtocolSelfTest.assertEquals((Object)"orig.val", (Object)this.grid().cache("default").get((Object)"key"));
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cacheAppend("default", "key", ".newVal"));
        RestBinaryProtocolSelfTest.assertEquals((Object)"orig.val.newVal", (Object)this.grid().cache("default").get((Object)"key"));
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cacheAppend(CACHE_NAME, "key", ".val"));
        RestBinaryProtocolSelfTest.assertEquals((Object)"orig.val", (Object)this.grid().cache(CACHE_NAME).get((Object)"key"));
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cacheAppend(CACHE_NAME, "key", ".newVal"));
        RestBinaryProtocolSelfTest.assertEquals((Object)"orig.val.newVal", (Object)this.grid().cache(CACHE_NAME).get((Object)"key"));
    }

    @Test
    public void testPrepend() throws Exception {
        this.grid().cache("default").remove((Object)"key");
        this.grid().cache(CACHE_NAME).remove((Object)"key");
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cachePrepend("default", "key", ".val"));
        RestBinaryProtocolSelfTest.assertFalse((boolean)this.client.cachePrepend(CACHE_NAME, "key", ".val"));
        this.grid().cache("default").put((Object)"key", (Object)"orig");
        this.grid().cache(CACHE_NAME).put((Object)"key", (Object)"orig");
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cachePrepend("default", "key", "val."));
        RestBinaryProtocolSelfTest.assertEquals((Object)"val.orig", (Object)this.grid().cache("default").get((Object)"key"));
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cachePrepend("default", "key", "newVal."));
        RestBinaryProtocolSelfTest.assertEquals((Object)"newVal.val.orig", (Object)this.grid().cache("default").get((Object)"key"));
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cachePrepend(CACHE_NAME, "key", "val."));
        RestBinaryProtocolSelfTest.assertEquals((Object)"val.orig", (Object)this.grid().cache(CACHE_NAME).get((Object)"key"));
        RestBinaryProtocolSelfTest.assertTrue((boolean)this.client.cachePrepend(CACHE_NAME, "key", "newVal."));
        RestBinaryProtocolSelfTest.assertEquals((Object)"newVal.val.orig", (Object)this.grid().cache(CACHE_NAME).get((Object)"key"));
    }

    @Test
    public void testExecute() throws Exception {
        GridClientTaskResultBean res = this.client.execute(TestTask.class.getName(), Arrays.asList("executing", 3, "test", 5, "task"));
        RestBinaryProtocolSelfTest.assertTrue((boolean)res.isFinished());
        RestBinaryProtocolSelfTest.assertEquals((Object)new Integer(25), (Object)res.getResult());
    }

    @Test
    public void testNode() throws Exception {
        RestBinaryProtocolSelfTest.assertNull((Object)this.client.node(UUID.randomUUID(), false, false));
        RestBinaryProtocolSelfTest.assertNull((Object)this.client.node("wrongHost", false, false));
        GridClientNodeBean node = this.client.node(this.grid().localNode().id(), true, true);
        RestBinaryProtocolSelfTest.assertNotNull((Object)node);
        RestBinaryProtocolSelfTest.assertFalse((boolean)node.getAttributes().isEmpty());
        RestBinaryProtocolSelfTest.assertNotNull((Object)node.getMetrics());
        RestBinaryProtocolSelfTest.assertNotNull((Object)node.getTcpAddresses());
        RestBinaryProtocolSelfTest.assertEquals((int)11212, (int)node.getTcpPort());
        RestBinaryProtocolSelfTest.assertEquals((Object)this.grid().localNode().id(), (Object)node.getNodeId());
        node = this.client.node(this.grid().localNode().id(), false, false);
        RestBinaryProtocolSelfTest.assertNotNull((Object)node);
        RestBinaryProtocolSelfTest.assertNull((Object)node.getAttributes());
        RestBinaryProtocolSelfTest.assertNull((Object)node.getMetrics());
        RestBinaryProtocolSelfTest.assertNotNull((Object)node.getTcpAddresses());
        RestBinaryProtocolSelfTest.assertEquals((int)11212, (int)node.getTcpPort());
        RestBinaryProtocolSelfTest.assertEquals((Object)this.grid().localNode().id(), (Object)node.getNodeId());
        node = this.client.node(HOST, true, true);
        RestBinaryProtocolSelfTest.assertNotNull((Object)node);
        RestBinaryProtocolSelfTest.assertFalse((boolean)node.getAttributes().isEmpty());
        RestBinaryProtocolSelfTest.assertNotNull((Object)node.getMetrics());
        RestBinaryProtocolSelfTest.assertNotNull((Object)node.getTcpAddresses());
        RestBinaryProtocolSelfTest.assertEquals((int)11212, (int)node.getTcpPort());
        RestBinaryProtocolSelfTest.assertEquals((Object)this.grid().localNode().id(), (Object)node.getNodeId());
        node = this.client.node(HOST, false, false);
        RestBinaryProtocolSelfTest.assertNotNull((Object)node);
        RestBinaryProtocolSelfTest.assertNull((Object)node.getAttributes());
        RestBinaryProtocolSelfTest.assertNull((Object)node.getMetrics());
        RestBinaryProtocolSelfTest.assertNotNull((Object)node.getTcpAddresses());
        RestBinaryProtocolSelfTest.assertEquals((int)11212, (int)node.getTcpPort());
        RestBinaryProtocolSelfTest.assertEquals((Object)this.grid().localNode().id(), (Object)node.getNodeId());
    }

    @Test
    public void testTopology() throws Exception {
        List<GridClientNodeBean> top = this.client.topology(true, true);
        RestBinaryProtocolSelfTest.assertNotNull(top);
        RestBinaryProtocolSelfTest.assertEquals((int)1, (int)top.size());
        GridClientNodeBean node = (GridClientNodeBean)F.first(top);
        RestBinaryProtocolSelfTest.assertNotNull((Object)node);
        RestBinaryProtocolSelfTest.assertFalse((boolean)node.getAttributes().isEmpty());
        RestBinaryProtocolSelfTest.assertNotNull((Object)node.getMetrics());
        RestBinaryProtocolSelfTest.assertNotNull((Object)node.getTcpAddresses());
        RestBinaryProtocolSelfTest.assertEquals((Object)this.grid().localNode().id(), (Object)node.getNodeId());
        top = this.client.topology(false, false);
        RestBinaryProtocolSelfTest.assertNotNull(top);
        RestBinaryProtocolSelfTest.assertEquals((int)1, (int)top.size());
        node = (GridClientNodeBean)F.first(top);
        RestBinaryProtocolSelfTest.assertNotNull((Object)node);
        RestBinaryProtocolSelfTest.assertNull((Object)node.getAttributes());
        RestBinaryProtocolSelfTest.assertNull((Object)node.getMetrics());
        RestBinaryProtocolSelfTest.assertNotNull((Object)node.getTcpAddresses());
        RestBinaryProtocolSelfTest.assertEquals((Object)this.grid().localNode().id(), (Object)node.getNodeId());
    }

    private static class TestTask
    extends ComputeTaskSplitAdapter<List<Object>, Integer> {
        private TestTask() {
        }

        protected Collection<? extends ComputeJob> split(int gridSize, List<Object> args) {
            ArrayList<1> jobs = new ArrayList<1>(args.size());
            for (final Object arg : args) {
                jobs.add(new ComputeJobAdapter(){

                    public Object execute() {
                        try {
                            return ((String)arg).length();
                        }
                        catch (ClassCastException ignored) {
                            assert (arg instanceof Integer);
                            return arg;
                        }
                    }
                });
            }
            return jobs;
        }

        public Integer reduce(List<ComputeJobResult> results) {
            int sum = 0;
            for (ComputeJobResult res : results) {
                sum += ((Integer)res.getData()).intValue();
            }
            return sum;
        }
    }
}

