/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.JettyRestProcessorCommonSelfTest;
import org.apache.ignite.internal.util.typedef.F;
import org.junit.Test;

public class JettyRestProcessorGetAllAsArrayTest
extends JettyRestProcessorCommonSelfTest {
    @Override
    protected void beforeTestsStarted() throws Exception {
        System.setProperty("IGNITE_REST_GETALL_AS_ARRAY", "true");
        super.beforeTestsStarted();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        System.clearProperty("IGNITE_REST_GETALL_AS_ARRAY");
    }

    @Test
    public void testGetAll() throws Exception {
        Map entries = F.asMap((Object)"getKey1", (Object)"getVal1", (Object)"getKey2", (Object)"getVal2");
        this.jcache().putAll(entries);
        String ret = this.content("default", GridRestCommand.CACHE_GET_ALL, "k1", "getKey1", "k2", "getKey2");
        this.info("Get all command result: " + ret);
        JettyRestProcessorGetAllAsArrayTest.assertNotNull((Object)ret);
        JettyRestProcessorGetAllAsArrayTest.assertFalse((boolean)ret.isEmpty());
        JsonNode node = JSON_MAPPER.readTree(ret);
        JettyRestProcessorGetAllAsArrayTest.assertEquals((int)0, (int)node.get("successStatus").asInt());
        JettyRestProcessorGetAllAsArrayTest.assertTrue((boolean)node.get("error").isNull());
        JsonNode res = node.get("response");
        JettyRestProcessorGetAllAsArrayTest.assertTrue((boolean)res.isArray());
        HashSet<Map> returnValue = new HashSet<Map>();
        returnValue.add(F.asMap((Object)"key", (Object)"getKey1", (Object)"value", (Object)"getVal1"));
        returnValue.add(F.asMap((Object)"key", (Object)"getKey2", (Object)"value", (Object)"getVal2"));
        JettyRestProcessorGetAllAsArrayTest.assertEquals(returnValue, (Object)JSON_MAPPER.treeToValue((TreeNode)res, Set.class));
    }

    @Override
    protected String signature() {
        return null;
    }
}

