/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public abstract class AbstractRestProcessorSelfTest
extends GridCommonAbstractTest {
    protected static final String LOC_HOST = "127.0.0.1";

    protected abstract int gridCount();

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.cleanPersistenceDir();
        this.startGrids(this.gridCount());
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        assert (this.grid(0).cluster().nodes().size() == this.gridCount());
    }

    protected void afterTest() throws Exception {
        this.jcache().clear();
        AbstractRestProcessorSelfTest.assertEquals((int)0, (int)this.jcache().localSize(new CachePeekMode[0]));
        super.afterTest();
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTestsStopped();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setLocalHost(LOC_HOST);
        assert (cfg.getConnectorConfiguration() == null);
        ConnectorConfiguration clientCfg = new ConnectorConfiguration();
        clientCfg.setJettyPath("modules/clients/src/test/resources/jetty/rest-jetty.xml");
        clientCfg.setIdleQueryCursorTimeout(5000L);
        clientCfg.setIdleQueryCursorCheckFrequency(5000L);
        cfg.setConnectorConfiguration(clientCfg);
        CacheConfiguration ccfg = AbstractRestProcessorSelfTest.defaultCacheConfiguration();
        ccfg.setStatisticsEnabled(true);
        ccfg.setIndexedTypes(new Class[]{String.class, String.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    protected <K, V> IgniteCache<K, V> jcache() {
        return this.grid(0).cache("default");
    }
}

