/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.integration;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public abstract class ClientAbstractConnectivitySelfTest
extends GridCommonAbstractTest {
    private static final String WILDCARD_IP = "0.0.0.0";
    private static final String LOOPBACK_IP = "127.0.0.1";

    private static IgniteBiTuple<Collection<String>, Collection<String>> getAllIps() throws Exception {
        return U.resolveLocalAddresses((InetAddress)InetAddress.getByName(WILDCARD_IP));
    }

    protected void afterTest() throws Exception {
        GridClientFactory.stopAll();
        G.stopAll((boolean)true);
    }

    protected abstract Ignite startRestNode(String var1, @Nullable String var2, @Nullable Integer var3) throws Exception;

    protected abstract int defaultRestPort();

    protected abstract String restAddressAttributeName();

    protected abstract String restHostNameAttributeName();

    protected abstract String restPortAttributeName();

    protected abstract GridClientProtocol protocol();

    protected GridClient startClient(String addr, int port) throws GridClientException {
        GridClientConfiguration cliCfg = new GridClientConfiguration();
        cliCfg.setServers(Collections.singleton(addr + ":" + port));
        cliCfg.setProtocol(this.protocol());
        return GridClientFactory.start((GridClientConfiguration)cliCfg);
    }

    @Test
    public void testOneNodeDefaultHostAndPort() throws Exception {
        this.startRestNode("grid1", null, null);
        this.checkConnectivityByIp(LOOPBACK_IP, ClientAbstractConnectivitySelfTest.getAllIps());
        String extIp = (String)F.find((Iterable)U.allLocalIps(), null, (IgnitePredicate[])new IgnitePredicate[]{new IpV4AddressPredicate()});
        this.checkConnectivityByIp(extIp, ClientAbstractConnectivitySelfTest.getAllIps());
    }

    @Test
    public void testResolveReachableOneAddress() throws Exception {
        InetAddress addr = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        List filtered = IgniteUtils.filterReachable(Collections.singletonList(addr));
        ClientAbstractConnectivitySelfTest.assertEquals((int)1, (int)filtered.size());
        ClientAbstractConnectivitySelfTest.assertEquals((Object)addr, filtered.get(0));
    }

    @Test
    public void testOneNodeLoopbackHost() throws Exception {
        this.startRestNode("grid1", LOOPBACK_IP, this.defaultRestPort());
        this.checkConnectivityByIp(LOOPBACK_IP, (IgniteBiTuple<Collection<String>, Collection<String>>)F.t(Collections.singleton(LOOPBACK_IP), Collections.emptySet()));
    }

    @Test
    public void testOneNodeZeroIpv4Address() throws Exception {
        this.startRestNode("grid1", WILDCARD_IP, this.defaultRestPort());
        LinkedList<String> addrs = new LinkedList<String>();
        addrs.add(LOOPBACK_IP);
        Collection nonLoopbackAddrs = U.allLocalIps();
        ClientAbstractConnectivitySelfTest.assertNotNull((Object)nonLoopbackAddrs);
        addrs.addAll(F.view((Collection)nonLoopbackAddrs, (IgnitePredicate[])new IgnitePredicate[]{new IpV4AddressPredicate()}));
        for (String addr : addrs) {
            log.info("Trying address: " + addr);
            GridClient cli = this.startClient(addr, this.defaultRestPort());
            List nodes = cli.compute().refreshTopology(true, false);
            ClientAbstractConnectivitySelfTest.assertEquals((int)1, (int)nodes.size());
            GridClientNode node = (GridClientNode)F.first((List)nodes);
            ClientAbstractConnectivitySelfTest.assertNotNull((Object)node);
            ClientAbstractConnectivitySelfTest.assertEquals((Object)ClientAbstractConnectivitySelfTest.getAllIps().get1(), (Object)node.attribute(this.restAddressAttributeName()));
            ClientAbstractConnectivitySelfTest.assertEquals((Object)ClientAbstractConnectivitySelfTest.getAllIps().get2(), (Object)node.attribute(this.restHostNameAttributeName()));
            List nodeAddrs = node.tcpAddresses();
            ClientAbstractConnectivitySelfTest.assertTrue((boolean)nodeAddrs.contains(LOOPBACK_IP));
            ClientAbstractConnectivitySelfTest.assertTrue((boolean)F.containsAll((Collection)nodeAddrs, addrs));
        }
    }

    @Test
    public void testTwoNodesDefaultHostAndPort() throws Exception {
        this.startRestNode("grid1", null, null);
        this.startRestNode("grid2", null, null);
        GridClient cli = this.startClient(LOOPBACK_IP, this.defaultRestPort());
        List nodes = cli.compute().refreshTopology(true, false);
        ClientAbstractConnectivitySelfTest.assertEquals((int)2, (int)nodes.size());
        ClientAbstractConnectivitySelfTest.assertTrue((boolean)F.forAll((Iterable)nodes, (IgnitePredicate[])new IgnitePredicate[]{new P1<GridClientNode>(){

            public boolean apply(GridClientNode node) {
                return node.tcpAddresses().contains(ClientAbstractConnectivitySelfTest.LOOPBACK_IP);
            }
        }}));
        GridTestUtils.assertOneToOne((Iterable)nodes, (IgnitePredicate[])new IgnitePredicate[]{new P1<GridClientNode>(){

            public boolean apply(GridClientNode node) {
                try {
                    return ClientAbstractConnectivitySelfTest.this.eqAddresses((IgniteBiTuple<Collection<String>, Collection<String>>)ClientAbstractConnectivitySelfTest.getAllIps(), node) && Integer.valueOf(ClientAbstractConnectivitySelfTest.this.defaultRestPort()).equals(node.attribute(ClientAbstractConnectivitySelfTest.this.restPortAttributeName()));
                }
                catch (Exception ignored) {
                    return false;
                }
            }
        }, new P1<GridClientNode>(){

            public boolean apply(GridClientNode node) {
                try {
                    return ClientAbstractConnectivitySelfTest.this.eqAddresses((IgniteBiTuple<Collection<String>, Collection<String>>)ClientAbstractConnectivitySelfTest.getAllIps(), node) && Integer.valueOf(ClientAbstractConnectivitySelfTest.this.defaultRestPort() + 1).equals(node.attribute(ClientAbstractConnectivitySelfTest.this.restPortAttributeName()));
                }
                catch (Exception ignored) {
                    return false;
                }
            }
        }});
    }

    @Test
    public void testRefreshTopologyOnNodeLeft() throws Exception {
        this.startRestNode("grid1", null, null);
        this.startRestNode("grid2", null, null);
        GridClient cli = this.startClient(LOOPBACK_IP, this.defaultRestPort());
        List nodes = cli.compute().refreshTopology(true, false);
        ClientAbstractConnectivitySelfTest.assertEquals((int)2, (int)nodes.size());
        this.stopGrid("grid1");
        nodes = cli.compute().refreshTopology(true, false);
        ClientAbstractConnectivitySelfTest.assertEquals((int)1, (int)nodes.size());
        this.startRestNode("grid3", null, null);
        nodes = cli.compute().refreshTopology(true, false);
        ClientAbstractConnectivitySelfTest.assertEquals((int)2, (int)nodes.size());
        this.stopGrid("grid2");
        nodes = cli.compute().refreshTopology(true, false);
        ClientAbstractConnectivitySelfTest.assertEquals((int)1, (int)nodes.size());
    }

    private void checkConnectivityByIp(String connectIp, IgniteBiTuple<Collection<String>, Collection<String>> nodeIp) throws GridClientException {
        GridClient cli = this.startClient(connectIp, this.defaultRestPort());
        List nodes = cli.compute().refreshTopology(true, false);
        ClientAbstractConnectivitySelfTest.assertEquals((int)1, (int)nodes.size());
        GridClientNode node = (GridClientNode)F.first((List)nodes);
        ClientAbstractConnectivitySelfTest.assertNotNull((Object)node);
        ClientAbstractConnectivitySelfTest.assertTrue((boolean)this.eqAddresses(nodeIp, node));
    }

    private boolean eqAddresses(IgniteBiTuple<Collection<String>, Collection<String>> nodeIp, GridClientNode node) {
        return F.eqOrdered((Collection)((Collection)nodeIp.get1()), (Collection)((Collection)node.attribute(this.restAddressAttributeName()))) && F.eqOrdered((Collection)((Collection)nodeIp.get2()), (Collection)((Collection)node.attribute(this.restHostNameAttributeName())));
    }

    private static class IpV4AddressPredicate
    implements P1<String> {
        private IpV4AddressPredicate() {
        }

        public boolean apply(String s) {
            return s.matches("\\d+\\.\\d+\\.\\d+\\.\\d+");
        }
    }
}

