/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.CustomQueryProcessor;
import org.apache.ignite.internal.processors.platform.client.ThinClientCustomQueryRegistry;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ThinClientCustomQueryRegistryTest {
    private static final AtomicInteger TEST_VAL = new AtomicInteger();
    public static final String TEST_QUERY_PROCESSOR_ID = "TEST_QUERY_PROCESSOR";
    CustomQueryProcessor qp1 = new TestQueryProcessor(1);
    CustomQueryProcessor qp2 = new TestQueryProcessor(2);

    @Before
    public void setUp() throws Exception {
        TEST_VAL.set(0);
    }

    @After
    public void tearDown() throws Exception {
        ThinClientCustomQueryRegistry.unregister((CustomQueryProcessor)this.qp1);
        ThinClientCustomQueryRegistry.unregister((CustomQueryProcessor)this.qp2);
    }

    @Test
    public void testRegisterAndCall() {
        ThinClientCustomQueryRegistry.registerIfAbsent((CustomQueryProcessor)this.qp1);
        ThinClientCustomQueryRegistry.call((long)0L, (String)TEST_QUERY_PROCESSOR_ID, (byte)0, null);
        Assert.assertEquals((long)1L, (long)TEST_VAL.get());
    }

    @Test
    public void testRepeatedRegister() {
        Assert.assertTrue((boolean)ThinClientCustomQueryRegistry.registerIfAbsent((CustomQueryProcessor)this.qp1));
        Assert.assertFalse((boolean)ThinClientCustomQueryRegistry.registerIfAbsent((CustomQueryProcessor)this.qp2));
    }

    @Test
    public void testUregister() {
        ThinClientCustomQueryRegistry.registerIfAbsent((CustomQueryProcessor)this.qp1);
        ThinClientCustomQueryRegistry.unregister((CustomQueryProcessor)this.qp1);
        ThinClientCustomQueryRegistry.registerIfAbsent((CustomQueryProcessor)this.qp2);
        ThinClientCustomQueryRegistry.call((long)0L, (String)TEST_QUERY_PROCESSOR_ID, (byte)0, null);
        Assert.assertEquals((long)2L, (long)TEST_VAL.get());
    }

    private static class TestQueryProcessor
    implements CustomQueryProcessor {
        private final int testValue;

        public TestQueryProcessor(int testValue) {
            this.testValue = testValue;
        }

        public String id() {
            return ThinClientCustomQueryRegistryTest.TEST_QUERY_PROCESSOR_ID;
        }

        public ClientResponse call(long requestId, byte methodId, BinaryRawReader reader) {
            TEST_VAL.set(this.testValue);
            return new ClientResponse((long)this.testValue);
        }
    }
}

