/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.common;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Supplier;
import javax.cache.configuration.Factory;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.Ignition;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.client.SslMode;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.rest.protocols.tcp.GridTcpRestProtocol;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.metric.BooleanMetric;
import org.apache.ignite.spi.metric.HistogramMetric;
import org.apache.ignite.spi.metric.IntMetric;
import org.apache.ignite.spi.metric.LongMetric;
import org.apache.ignite.ssl.SslContextFactory;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class NodeSslConnectionMetricTest
extends GridCommonAbstractTest {
    private static final String CIPHER_SUITE = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";
    private static final String UNSUPPORTED_CIPHER_SUITE = "TLS_RSA_WITH_AES_128_GCM_SHA256";
    private static final long TIMEOUT = 7000L;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        GridClientFactory.stopAll((boolean)false);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids(true);
    }

    @Test
    public void testSslDisabled() throws Exception {
        IgniteEx srv = this.startGrid();
        MetricRegistry discoReg = this.mreg(srv, TcpDiscoverySpi.DISCO_METRICS);
        NodeSslConnectionMetricTest.assertFalse((boolean)((BooleanMetric)discoReg.findMetric("SslEnabled")).value());
        NodeSslConnectionMetricTest.assertEquals((int)0, (int)((IntMetric)discoReg.findMetric("RejectedSslConnectionsCount")).value());
        MetricRegistry commReg = this.mreg(srv, TcpCommunicationSpi.COMMUNICATION_METRICS_GROUP_NAME);
        NodeSslConnectionMetricTest.assertFalse((boolean)((BooleanMetric)commReg.findMetric("SslEnabled")).value());
        NodeSslConnectionMetricTest.assertNull((Object)commReg.findMetric("RejectedSslSessionsCount"));
        NodeSslConnectionMetricTest.assertNull((Object)commReg.findMetric("SslHandshakeDurationHistogram"));
        NodeSslConnectionMetricTest.assertEquals((int)0, (int)((IntMetric)commReg.findMetric("ActiveSessionsCount")).value());
        MetricRegistry cliConnReg = this.mreg(srv, GridMetricManager.CLIENT_CONNECTOR_METRICS);
        NodeSslConnectionMetricTest.assertFalse((boolean)((BooleanMetric)cliConnReg.findMetric("SslEnabled")).value());
        NodeSslConnectionMetricTest.assertNull((Object)cliConnReg.findMetric("RejectedSslSessionsCount"));
        NodeSslConnectionMetricTest.assertNull((Object)cliConnReg.findMetric("SslHandshakeDurationHistogram"));
        NodeSslConnectionMetricTest.assertEquals((int)0, (int)((IntMetric)cliConnReg.findMetric("ActiveSessionsCount")).value());
        MetricRegistry restConnReg = this.mreg(srv, GridTcpRestProtocol.REST_CONNECTOR_METRIC_REGISTRY_NAME);
        NodeSslConnectionMetricTest.assertNull((Object)restConnReg.findMetric("SslEnabled"));
        NodeSslConnectionMetricTest.assertNull((Object)restConnReg.findMetric("RejectedSslSessionsCount"));
        NodeSslConnectionMetricTest.assertNull((Object)restConnReg.findMetric("SslHandshakeDurationHistogram"));
        NodeSslConnectionMetricTest.assertNull((Object)restConnReg.findMetric("ActiveSessionsCount"));
        this.stopAllGrids();
        srv = this.startGrid(this.getConfiguration().setConnectorConfiguration(new ConnectorConfiguration()));
        restConnReg = this.mreg(srv, GridTcpRestProtocol.REST_CONNECTOR_METRIC_REGISTRY_NAME);
        NodeSslConnectionMetricTest.assertFalse((boolean)((BooleanMetric)restConnReg.findMetric("SslEnabled")).value());
        NodeSslConnectionMetricTest.assertEquals((int)0, (int)((IntMetric)restConnReg.findMetric("ActiveSessionsCount")).value());
    }

    @Test
    public void testJdbc() throws Exception {
        MetricRegistry reg = this.mreg(this.startClusterNode(0), GridMetricManager.CLIENT_CONNECTOR_METRICS);
        NodeSslConnectionMetricTest.assertEquals((long)0L, (long)((LongMetric)reg.findMetric("sentBytes")).value());
        NodeSslConnectionMetricTest.assertEquals((long)0L, (long)((LongMetric)reg.findMetric("receivedBytes")).value());
        try (Connection ignored = DriverManager.getConnection(this.jdbcConfiguration("thinClient", "trusttwo", CIPHER_SUITE, "TLSv1.2"));){
            this.checkSslCommunicationMetrics(reg, 1, 1, 0);
        }
        NodeSslConnectionMetricTest.assertTrue((((LongMetric)reg.findMetric("sentBytes")).value() > 0L ? 1 : 0) != 0);
        NodeSslConnectionMetricTest.assertTrue((((LongMetric)reg.findMetric("receivedBytes")).value() > 0L ? 1 : 0) != 0);
        this.checkSslCommunicationMetrics(reg, 1, 0, 0);
        GridTestUtils.assertThrowsWithCause(() -> DriverManager.getConnection(this.jdbcConfiguration("client", "trusttwo", CIPHER_SUITE, "TLSv1.2")), SQLException.class);
        this.checkSslCommunicationMetrics(reg, 2, 0, 1);
        GridTestUtils.assertThrowsWithCause(() -> DriverManager.getConnection(this.jdbcConfiguration("thinClient", "trusttwo", UNSUPPORTED_CIPHER_SUITE, "TLSv1.2")), SQLException.class);
        this.checkSslCommunicationMetrics(reg, 3, 0, 2);
        GridTestUtils.assertThrowsWithCause(() -> DriverManager.getConnection(this.jdbcConfiguration("thinClient", "trusttwo", null, "TLSv1.1")), SQLException.class);
        this.checkSslCommunicationMetrics(reg, 4, 0, 3);
    }

    @Test
    public void testRestClientConnector() throws Exception {
        MetricRegistry reg = this.mreg(this.startClusterNode(0), GridTcpRestProtocol.REST_CONNECTOR_METRIC_REGISTRY_NAME);
        NodeSslConnectionMetricTest.assertEquals((long)0L, (long)((LongMetric)reg.findMetric("sentBytes")).value());
        NodeSslConnectionMetricTest.assertEquals((long)0L, (long)((LongMetric)reg.findMetric("receivedBytes")).value());
        try (GridClient ignored = GridClientFactory.start((GridClientConfiguration)this.gridClientConfiguration("connectorClient", "trustthree", CIPHER_SUITE, "TLSv1.2"));){
            this.checkSslCommunicationMetrics(reg, 1, 1, 0);
        }
        NodeSslConnectionMetricTest.assertTrue((((LongMetric)reg.findMetric("sentBytes")).value() > 0L ? 1 : 0) != 0);
        NodeSslConnectionMetricTest.assertTrue((((LongMetric)reg.findMetric("receivedBytes")).value() > 0L ? 1 : 0) != 0);
        this.checkSslCommunicationMetrics(reg, 1, 0, 0);
        ignored = GridClientFactory.start((GridClientConfiguration)this.gridClientConfiguration("client", "trustthree", CIPHER_SUITE, "TLSv1.2"));
        var3_3 = null;
        if (ignored != null) {
            if (var3_3 != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable) {
                    var3_3.addSuppressed(throwable);
                }
            } else {
                ignored.close();
            }
        }
        this.checkSslCommunicationMetrics(reg, 4, 0, 3);
        ignored = GridClientFactory.start((GridClientConfiguration)this.gridClientConfiguration("connectorClient", "trustthree", UNSUPPORTED_CIPHER_SUITE, "TLSv1.2"));
        var3_3 = null;
        if (ignored != null) {
            if (var3_3 != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable) {
                    var3_3.addSuppressed(throwable);
                }
            } else {
                ignored.close();
            }
        }
        this.checkSslCommunicationMetrics(reg, 7, 0, 6);
        ignored = GridClientFactory.start((GridClientConfiguration)this.gridClientConfiguration("connectorClient", "trustthree", null, "TLSv1.1"));
        var3_3 = null;
        if (ignored != null) {
            if (var3_3 != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable) {
                    var3_3.addSuppressed(throwable);
                }
            } else {
                ignored.close();
            }
        }
        this.checkSslCommunicationMetrics(reg, 10, 0, 9);
    }

    @Test
    public void testDiscovery() throws Exception {
        MetricRegistry reg = this.mreg(this.startClusterNode(0), TcpDiscoverySpi.DISCO_METRICS);
        this.startGrid(this.nodeConfiguration(1, true, "client", "trustone", CIPHER_SUITE, "TLSv1.2"));
        NodeSslConnectionMetricTest.assertTrue((boolean)((BooleanMetric)reg.findMetric("SslEnabled")).value());
        NodeSslConnectionMetricTest.assertEquals((int)0, (int)((IntMetric)reg.findMetric("RejectedSslConnectionsCount")).value());
        this.checkNodeJoinFails(2, true, "thinClient", "trusttwo", CIPHER_SUITE, "TLSv1.2");
        this.checkNodeJoinFails(2, false, "thinClient", "trusttwo", CIPHER_SUITE, "TLSv1.2");
        this.checkNodeJoinFails(2, true, "client", "trustone", UNSUPPORTED_CIPHER_SUITE, "TLSv1.2");
        this.checkNodeJoinFails(2, false, "node01", "trustone", UNSUPPORTED_CIPHER_SUITE, "TLSv1.2");
        this.checkNodeJoinFails(2, true, "client", "trustone", null, "TLSv1.1");
        this.checkNodeJoinFails(2, false, "node01", "trustone", null, "TLSv1.1");
        this.waitForMetricGreaterOrEqual("RejectedSslConnectionsCount", 12, () -> ((IntMetric)reg.findMetric("RejectedSslConnectionsCount")).value());
    }

    @Test
    public void testCommunication() throws Exception {
        MetricRegistry reg = this.mreg(this.startClusterNode(0), TcpCommunicationSpi.COMMUNICATION_METRICS_GROUP_NAME);
        NodeSslConnectionMetricTest.assertEquals((long)0L, (long)((LongMetric)reg.findMetric("sentBytes")).value());
        NodeSslConnectionMetricTest.assertEquals((long)0L, (long)((LongMetric)reg.findMetric("receivedBytes")).value());
        this.checkSslCommunicationMetrics(reg, 0, 0, 0);
        try (IgniteEx cliNode = this.startGrid(this.nodeConfiguration(1, true, "client", "trustone", CIPHER_SUITE, "TLSv1.2"));
             IgniteEx srvNode = this.startGrid(this.nodeConfiguration(2, false, "node01", "trustone", CIPHER_SUITE, "TLSv1.2"));){
            this.checkSslCommunicationMetrics(reg, 2, 2, 0);
            MetricRegistry cliNodeReg = this.mreg(cliNode, TcpCommunicationSpi.COMMUNICATION_METRICS_GROUP_NAME);
            this.checkSslCommunicationMetrics(cliNodeReg, 0, 1, 0);
            NodeSslConnectionMetricTest.assertTrue((((LongMetric)cliNodeReg.findMetric("sentBytes")).value() > 0L ? 1 : 0) != 0);
            NodeSslConnectionMetricTest.assertTrue((((LongMetric)cliNodeReg.findMetric("receivedBytes")).value() > 0L ? 1 : 0) != 0);
            MetricRegistry srvNodeReg = this.mreg(srvNode, TcpCommunicationSpi.COMMUNICATION_METRICS_GROUP_NAME);
            this.checkSslCommunicationMetrics(srvNodeReg, 0, 1, 0);
            NodeSslConnectionMetricTest.assertTrue((((LongMetric)srvNodeReg.findMetric("sentBytes")).value() > 0L ? 1 : 0) != 0);
            NodeSslConnectionMetricTest.assertTrue((((LongMetric)srvNodeReg.findMetric("receivedBytes")).value() > 0L ? 1 : 0) != 0);
        }
        NodeSslConnectionMetricTest.assertTrue((((LongMetric)reg.findMetric("sentBytes")).value() > 0L ? 1 : 0) != 0);
        NodeSslConnectionMetricTest.assertTrue((((LongMetric)reg.findMetric("receivedBytes")).value() > 0L ? 1 : 0) != 0);
        this.checkSslCommunicationMetrics(reg, 2, 0, 0);
    }

    @Test
    public void testClientConnector() throws Exception {
        MetricRegistry reg = this.mreg(this.startClusterNode(0), GridMetricManager.CLIENT_CONNECTOR_METRICS);
        NodeSslConnectionMetricTest.assertEquals((long)0L, (long)((LongMetric)reg.findMetric("sentBytes")).value());
        NodeSslConnectionMetricTest.assertEquals((long)0L, (long)((LongMetric)reg.findMetric("receivedBytes")).value());
        try (IgniteClient ignored = Ignition.startClient((ClientConfiguration)this.clientConfiguration("thinClient", "trusttwo", CIPHER_SUITE, "TLSv1.2"));){
            this.checkSslCommunicationMetrics(reg, 1, 1, 0);
        }
        NodeSslConnectionMetricTest.assertTrue((((LongMetric)reg.findMetric("sentBytes")).value() > 0L ? 1 : 0) != 0);
        NodeSslConnectionMetricTest.assertTrue((((LongMetric)reg.findMetric("receivedBytes")).value() > 0L ? 1 : 0) != 0);
        this.checkSslCommunicationMetrics(reg, 1, 0, 0);
        GridTestUtils.assertThrowsWithCause(() -> Ignition.startClient((ClientConfiguration)this.clientConfiguration("client", "trustboth", CIPHER_SUITE, "TLSv1.2")), ClientConnectionException.class);
        this.checkSslCommunicationMetrics(reg, 2, 0, 1);
        GridTestUtils.assertThrowsWithCause(() -> Ignition.startClient((ClientConfiguration)this.clientConfiguration("thinClient", "trusttwo", UNSUPPORTED_CIPHER_SUITE, "TLSv1.2")), ClientConnectionException.class);
        this.checkSslCommunicationMetrics(reg, 3, 0, 2);
        GridTestUtils.assertThrowsWithCause(() -> Ignition.startClient((ClientConfiguration)this.clientConfiguration("thinClient", "trusttwo", null, "TLSv1.1")), ClientConnectionException.class);
        this.checkSslCommunicationMetrics(reg, 4, 0, 3);
    }

    private IgniteEx startClusterNode(int idx) throws Exception {
        IgniteConfiguration cfg = this.getConfiguration(this.getTestIgniteInstanceName(idx));
        cfg.setSslContextFactory((Factory)this.sslContextFactory("server", "trustone", CIPHER_SUITE, "TLSv1.2"));
        cfg.setClientConnectorConfiguration(new ClientConnectorConfiguration().setSslEnabled(true).setSslClientAuth(true).setUseIgniteSslContextFactory(false).setSslContextFactory((Factory)this.sslContextFactory("thinServer", "trusttwo", CIPHER_SUITE, "TLSv1.2")));
        cfg.setConnectorConfiguration(new ConnectorConfiguration().setSslClientAuth(true).setSslEnabled(true).setSslFactory((Factory)this.sslContextFactory("connectorServer", "trustthree", CIPHER_SUITE, "TLSv1.2")));
        return this.startGrid(cfg);
    }

    private String jdbcConfiguration(String keyStore, String trustStore, String cipherSuite, String protocol) {
        String res = "jdbc:ignite:thin://127.0.0.1:10800?sslMode=require&sslClientCertificateKeyStoreUrl=" + GridTestUtils.keyStorePath((String)keyStore) + "&sslClientCertificateKeyStorePassword=" + GridTestUtils.keyStorePassword() + "&sslTrustCertificateKeyStoreUrl=" + GridTestUtils.keyStorePath((String)trustStore) + "&sslTrustCertificateKeyStorePassword=" + GridTestUtils.keyStorePassword() + "&sslProtocol=" + protocol;
        if (cipherSuite != null) {
            res = res + "&sslCipherSuites=" + cipherSuite;
        }
        return res;
    }

    private IgniteConfiguration nodeConfiguration(int idx, boolean client, String keyStore, String trustStore, String cipherSuite, String protocol) throws Exception {
        return this.getConfiguration(this.getTestIgniteInstanceName(idx)).setSslContextFactory((Factory)this.sslContextFactory(keyStore, trustStore, cipherSuite, protocol)).setClientMode(client);
    }

    private GridClientConfiguration gridClientConfiguration(String keyStore, String trustStore, String cipherSuite, String protocol) {
        SslContextFactory sslCtxFactory = this.sslContextFactory(keyStore, trustStore, cipherSuite, protocol);
        return new GridClientConfiguration().setServers(Collections.singleton("127.0.0.1:11211")).setTopologyRefreshFrequency(Long.MAX_VALUE).setSslContextFactory(() -> ((SslContextFactory)sslCtxFactory).create());
    }

    private ClientConfiguration clientConfiguration(String keyStore, String trustStore, String cipherSuite, String protocol) {
        int port = (Integer)((Ignite)Ignition.allGrids().get(0)).cluster().localNode().attributes().get("clientListenerPort");
        return new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:" + port}).setAffinityAwarenessEnabled(false).setSslMode(SslMode.REQUIRED).setSslContextFactory((Factory)this.sslContextFactory(keyStore, trustStore, cipherSuite, protocol));
    }

    private void checkNodeJoinFails(int idx, boolean client, String keyStore, String trustStore, String cipherSuite, String protocol) throws Exception {
        IgniteConfiguration cfg = this.nodeConfiguration(idx, client, keyStore, trustStore, cipherSuite, protocol);
        if (client) {
            ((TcpDiscoverySpi)cfg.getDiscoverySpi()).setJoinTimeout(1L);
        }
        GridTestUtils.assertThrowsWithCause(() -> this.startGrid(cfg), IgniteCheckedException.class);
    }

    private MetricRegistry mreg(IgniteEx ignite, String name) {
        return ignite.context().metric().registry(name);
    }

    private void checkSslCommunicationMetrics(MetricRegistry mreg, int handshakeCnt, int sesCnt, int rejectedSesCnt) throws Exception {
        NodeSslConnectionMetricTest.assertEquals((boolean)true, (boolean)((BooleanMetric)mreg.findMetric("SslEnabled")).value());
        this.waitForMetric("ActiveSessionsCount", sesCnt, () -> ((IntMetric)mreg.findMetric("ActiveSessionsCount")).value());
        this.waitForMetric("SslHandshakeDurationHistogram", handshakeCnt, () -> (int)Arrays.stream((long[])((HistogramMetric)mreg.findMetric("SslHandshakeDurationHistogram")).value()).sum());
        this.waitForMetric("RejectedSslSessionsCount", rejectedSesCnt, () -> ((IntMetric)mreg.findMetric("RejectedSslSessionsCount")).value());
    }

    private void waitForMetric(String name, int expected, Supplier<Integer> supplier) throws Exception {
        NodeSslConnectionMetricTest.assertTrue((String)("Metric " + name + " expected " + expected + " but was " + supplier.get()), (boolean)GridTestUtils.waitForCondition(() -> expected == (Integer)supplier.get(), (long)7000L));
    }

    private void waitForMetricGreaterOrEqual(String name, int expected, Supplier<Integer> supplier) throws Exception {
        NodeSslConnectionMetricTest.assertTrue((String)("Metric " + name + " expected greater or equal than " + expected + " but was " + supplier.get()), (boolean)GridTestUtils.waitForCondition(() -> expected <= (Integer)supplier.get(), (long)7000L));
    }

    private SslContextFactory sslContextFactory(String keyStore, String trustStore, String cipherSuite, String protocol) {
        SslContextFactory res = GridTestUtils.sslTrustedFactory((String)keyStore, (String)trustStore);
        if (cipherSuite != null) {
            res.setCipherSuites(new String[]{cipherSuite});
        }
        res.setProtocols(new String[]{protocol});
        return res;
    }
}

