/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ignite.client.RetryLimitPolicy;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.WriteContext;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.client.sql.ClientSql;
import org.apache.ignite.internal.client.table.AbstractClientView;
import org.apache.ignite.internal.client.table.ClientContinuousQuery;
import org.apache.ignite.internal.client.table.ClientDataStreamer;
import org.apache.ignite.internal.client.table.ClientNearCacheKeyImpl;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientSerializedTuple;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.table.ClientTuple;
import org.apache.ignite.internal.client.table.ClientTupleSerializer;
import org.apache.ignite.internal.client.table.MapFunction;
import org.apache.ignite.internal.client.table.PartitionAwarenessProvider;
import org.apache.ignite.internal.client.table.TupleStreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.lang.IgniteTriConsumer;
import org.apache.ignite.internal.streamer.StreamerBatchSender;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.Pair;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.table.ContinuousQueryOptions;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.TableRowEventBatch;
import org.apache.ignite.table.TableRowEventType;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.tx.Transaction;
import org.gridgain.internal.table.nearcache.NearCacheEntriesProvider;
import org.gridgain.internal.table.nearcache.NearCacheKey;
import org.gridgain.internal.table.nearcache.NearCacheRecordRowEventSubscriber;
import org.gridgain.internal.table.nearcache.NearCacheSchemaVersionAwareSubscriber;
import org.gridgain.internal.table.nearcache.NearCacheValue;
import org.jetbrains.annotations.Nullable;

public class ClientRecordBinaryView
extends AbstractClientView<Tuple>
implements RecordView<Tuple>,
NearCacheEntriesProvider<Tuple, Tuple, ClientSerializedTuple> {
    private final ClientTupleSerializer ser;

    ClientRecordBinaryView(ClientTable tbl, ClientSql sql) {
        super(tbl, sql);
        this.ser = new ClientTupleSerializer(tbl.tableId(), tbl::qualifiedName);
    }

    public Tuple get(@Nullable Transaction tx, Tuple keyRec) {
        return (Tuple)ViewUtils.sync(this.getAsync(tx, keyRec));
    }

    public CompletableFuture<Tuple> getAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(12, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readTuple(s, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(keyRec), tx);
    }

    public List<Tuple> getAll(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        return (List)ViewUtils.sync(this.getAllAsync(tx, keyRecs));
    }

    public CompletableFuture<List<Tuple>> getAllAsync(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        ViewUtils.checkCollectionForNulls(keyRecs, (String)"keyRecs", (String)"key");
        if (keyRecs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        ArrayList<Transaction> txns = new ArrayList<Transaction>();
        MapFunction clo = (batch, provider, txRequired) -> {
            Transaction tx0 = this.tbl.startTxIfNeeded(tx, txns, txRequired);
            return this.tbl.doSchemaOutInOpAsync(15, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx0, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readTuplesNullable(s, r.in()), Collections.emptyList(), provider, tx0);
        };
        return this.tbl.splitAndRun(keyRecs, clo, ClientTupleSerializer::getColocationHash, txns);
    }

    public boolean contains(@Nullable Transaction tx, Tuple key) {
        return (Boolean)ViewUtils.sync(this.containsAsync(tx, key));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(33, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public boolean containsAll(@Nullable Transaction tx, Collection<Tuple> keys) {
        return (Boolean)ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<Tuple> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        ArrayList<Transaction> txns = new ArrayList<Transaction>();
        MapFunction clo = (batch, provider, txRequired) -> {
            Transaction tx0 = this.tbl.startTxIfNeeded(tx, txns, txRequired);
            return this.tbl.doSchemaOutOpAsync(67, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx0, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), r -> r.in().unpackBoolean(), provider, tx0);
        };
        return this.tbl.splitAndRun(keys, clo, Boolean.TRUE, (agg, cur) -> agg != false && cur != false, ClientTupleSerializer::getColocationHash, txns);
    }

    public void upsert(@Nullable Transaction tx, Tuple rec) {
        ViewUtils.sync(this.upsertAsync(tx, rec));
    }

    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(10, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n)), r -> null, ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    public void upsertAll(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.sync(this.upsertAllAsync(tx, recs));
    }

    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.checkCollectionForNulls(recs, (String)"recs", (String)"rec");
        if (recs.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        MapFunction clo = (batch, provider, txRequired) -> this.tbl.doSchemaOutOpAsync(13, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), r -> null, provider, tx);
        if (tx == null) {
            return clo.apply(recs, ClientTupleSerializer.getPartitionAwarenessProvider(recs.iterator().next()), false);
        }
        return this.tbl.splitAndRun(recs, clo, null, (agg, cur) -> null, ClientTupleSerializer::getColocationHash);
    }

    public Tuple getAndUpsert(@Nullable Transaction tx, Tuple rec) {
        return (Tuple)ViewUtils.sync(this.getAndUpsertAsync(tx, rec));
    }

    public CompletableFuture<Tuple> getAndUpsertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(16, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), (s, r) -> ClientTupleSerializer.readTuple(s, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    public boolean insert(@Nullable Transaction tx, Tuple rec) {
        return (Boolean)ViewUtils.sync(this.insertAsync(tx, rec));
    }

    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(18, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    public List<Tuple> insertAll(@Nullable Transaction tx, Collection<Tuple> recs) {
        return (List)ViewUtils.sync(this.insertAllAsync(tx, recs));
    }

    public CompletableFuture<List<Tuple>> insertAllAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.checkCollectionForNulls(recs, (String)"recs", (String)"rec");
        if (recs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        MapFunction clo = (batch, provider, txRequired) -> this.tbl.doSchemaOutInOpAsync(20, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), (s, r) -> ClientTupleSerializer.readTuples(s, r.in()), Collections.emptyList(), provider, tx);
        if (tx == null) {
            return clo.apply(recs, ClientTupleSerializer.getPartitionAwarenessProvider(recs.iterator().next()), false);
        }
        return this.tbl.splitAndRun(recs, clo, new ArrayList(recs.size()), (agg, cur) -> {
            agg.addAll(cur);
            return agg;
        }, ClientTupleSerializer::getColocationHash);
    }

    public boolean replace(@Nullable Transaction tx, Tuple rec) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, rec));
    }

    public boolean replace(@Nullable Transaction tx, Tuple oldRec, Tuple newRec) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, oldRec, newRec));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(22, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple oldRec, Tuple newRec) {
        Objects.requireNonNull(oldRec);
        Objects.requireNonNull(newRec);
        return this.tbl.doSchemaOutOpAsync(24, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> {
            this.ser.writeTuple(tx, oldRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false, false);
            this.ser.writeTuple(tx, newRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false, true);
        }), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(oldRec), tx);
    }

    public Tuple getAndReplace(@Nullable Transaction tx, Tuple rec) {
        return (Tuple)ViewUtils.sync(this.getAndReplaceAsync(tx, rec));
    }

    public CompletableFuture<Tuple> getAndReplaceAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(26, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), (s, r) -> ClientTupleSerializer.readTuple(s, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    public boolean delete(@Nullable Transaction tx, Tuple keyRec) {
        return (Boolean)ViewUtils.sync(this.deleteAsync(tx, keyRec));
    }

    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutOpAsync(28, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(keyRec), tx);
    }

    public boolean deleteExact(@Nullable Transaction tx, Tuple rec) {
        return (Boolean)ViewUtils.sync(this.deleteExactAsync(tx, rec));
    }

    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(30, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    public Tuple getAndDelete(@Nullable Transaction tx, Tuple keyRec) {
        return (Tuple)ViewUtils.sync(this.getAndDeleteAsync(tx, keyRec));
    }

    public CompletableFuture<Tuple> getAndDeleteAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(32, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readTuple(s, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(keyRec), tx);
    }

    public List<Tuple> deleteAll(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        return (List)ViewUtils.sync(this.deleteAllAsync(tx, keyRecs));
    }

    public void deleteAll(@Nullable Transaction tx) {
        ViewUtils.sync(this.deleteAllAsync(tx));
    }

    public CompletableFuture<List<Tuple>> deleteAllAsync(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        Objects.requireNonNull(keyRecs);
        if (keyRecs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        MapFunction clo = (batch, provider, txRequired) -> this.tbl.doSchemaOutInOpAsync(29, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readTuples(s, r.in(), true), Collections.emptyList(), provider, tx);
        if (tx == null) {
            return clo.apply(keyRecs, ClientTupleSerializer.getPartitionAwarenessProvider(keyRecs.iterator().next()), false);
        }
        return this.tbl.splitAndRun(keyRecs, clo, new ArrayList(keyRecs.size()), (agg, cur) -> {
            agg.addAll(cur);
            return agg;
        }, ClientTupleSerializer::getColocationHash);
    }

    public CompletableFuture<Void> deleteAllAsync(@Nullable Transaction tx) {
        return this.sql.executeAsync(tx, "DELETE FROM " + this.tbl.name(), new Object[0]).thenApply(r -> null);
    }

    public List<Tuple> deleteAllExact(@Nullable Transaction tx, Collection<Tuple> recs) {
        return (List)ViewUtils.sync(this.deleteAllExactAsync(tx, recs));
    }

    public CompletableFuture<List<Tuple>> deleteAllExactAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        Objects.requireNonNull(recs);
        if (recs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        MapFunction clo = (batch, provider, txRequired) -> this.tbl.doSchemaOutInOpAsync(31, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), (s, r) -> ClientTupleSerializer.readTuples(s, r.in()), Collections.emptyList(), provider, tx);
        if (tx == null) {
            return clo.apply(recs, ClientTupleSerializer.getPartitionAwarenessProvider(recs.iterator().next()), false);
        }
        return this.tbl.splitAndRun(recs, clo, new ArrayList(recs.size()), (agg, cur) -> {
            agg.addAll(cur);
            return agg;
        }, ClientTupleSerializer::getColocationHash);
    }

    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Tuple>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        TupleStreamerPartitionAwarenessProvider provider = new TupleStreamerPartitionAwarenessProvider(this.tbl);
        DataStreamerOptions opts = options == null ? DataStreamerOptions.DEFAULT : options;
        StreamerBatchSender batchSender = (partitionId, items, deleted) -> this.tbl.doSchemaOutOpAsync(62, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeStreamerTuples((int)partitionId, items, deleted, (ClientSchema)s, (PayloadOutputChannel)w)), r -> null, PartitionAwarenessProvider.of(partitionId), new RetryLimitPolicy().retryLimit(opts.retryLimit()), null);
        return ClientDataStreamer.streamData(publisher, opts, batchSender, provider, this.tbl);
    }

    public <E, V, A, R> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V, A, R> receiver, Function<E, Tuple> keyFunc, Function<E, V> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        return ClientDataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options == null ? DataStreamerOptions.DEFAULT : options, new TupleStreamerPartitionAwarenessProvider(this.tbl), this.tbl, resultSubscriber, receiver, receiverArg);
    }

    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<Tuple>> subscriber, @Nullable ContinuousQueryOptions options) {
        BiFunction<byte[], ClientSchema, Tuple> mapper = (row, schema) -> {
            int colCnt = schema.columns().length;
            BinaryTupleReader binTuple = new BinaryTupleReader(colCnt, row);
            return new ClientTuple((ClientSchema)schema, TuplePart.KEY_AND_VAL, binTuple);
        };
        ClientContinuousQuery.queryContinuously(subscriber, options, mapper, this.tbl);
    }

    public Class<Tuple> valueType() {
        return Tuple.class;
    }

    public CompletableFuture<NearCacheKey<Tuple, ClientSerializedTuple>> getNearCacheKeyAsync(Tuple key, boolean enforceKeyOnly) {
        return this.tbl.getLatestSchema().thenApply(schema -> new ClientNearCacheKeyImpl<Tuple>(key, this.ser.serializeTupleRaw(key, (ClientSchema)schema, true)));
    }

    public CompletableFuture<Collection<NearCacheKey<Tuple, ClientSerializedTuple>>> getNearCacheKeysAsync(Iterable<? extends Tuple> keys, boolean enforceKeyOnly) {
        return this.tbl.getLatestSchema().thenApply(schema -> {
            ArrayList<ClientNearCacheKeyImpl<Tuple>> serializedKeys = new ArrayList<ClientNearCacheKeyImpl<Tuple>>();
            for (Tuple key : keys) {
                serializedKeys.add(new ClientNearCacheKeyImpl<Tuple>(key, this.ser.serializeTupleRaw(key, (ClientSchema)schema, true)));
            }
            return serializedKeys;
        });
    }

    public CompletableFuture<Pair<NearCacheKey<Tuple, ClientSerializedTuple>, NearCacheValue<Tuple>>> getNearCacheValueAsync(@Nullable Transaction tx, NearCacheKey<Tuple, ClientSerializedTuple> key) {
        Objects.requireNonNull(key, "key");
        AtomicReference serializedKey = new AtomicReference();
        return this.tbl.doSchemaOutInOpAsync(12, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> {
            ClientSerializedTuple keyTuple = (ClientSerializedTuple)key.serializedKey();
            if (keyTuple == null || keyTuple.schemaVersion() != s.version()) {
                keyTuple = this.ser.serializeTupleRaw((Tuple)key.key(), (ClientSchema)s, true);
            }
            serializedKey.set(keyTuple);
            this.ser.writeTuple(tx, keyTuple, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n);
        }), (s, r) -> new Pair(new ClientNearCacheKeyImpl<Tuple>((Tuple)key.key(), (ClientSerializedTuple)serializedKey.get()), (Object)new NearCacheValue((Object)ClientTupleSerializer.readTuple(s, r.in(), false))), new Pair(key, (Object)new NearCacheValue()), ClientTupleSerializer.getPartitionAwarenessProvider((Tuple)key.key()), tx);
    }

    public CompletableFuture<Map<NearCacheKey<Tuple, ClientSerializedTuple>, NearCacheValue<Tuple>>> getNearCacheValuesAsync(@Nullable Transaction tx, Collection<NearCacheKey<Tuple, ClientSerializedTuple>> nearCacheKeys) {
        ViewUtils.checkKeysForNulls(nearCacheKeys);
        if (nearCacheKeys.isEmpty()) {
            return CompletableFutures.emptyMapCompletedFuture();
        }
        PartitionAwarenessProvider provider = ClientTupleSerializer.getPartitionAwarenessProvider((Tuple)nearCacheKeys.iterator().next().key());
        AtomicReference serializedKeyHolder = new AtomicReference();
        return this.tbl.doSchemaOutInOpAsync(15, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> {
            ArrayList<ClientNearCacheKeyImpl> keys = new ArrayList<ClientNearCacheKeyImpl>(nearCacheKeys.size());
            ArrayList<ClientSerializedTuple> serializedTuples = new ArrayList<ClientSerializedTuple>(nearCacheKeys.size());
            for (NearCacheKey nearCacheKey : nearCacheKeys) {
                ClientSerializedTuple keyTuple = (ClientSerializedTuple)nearCacheKey.serializedKey();
                if (keyTuple == null || keyTuple.schemaVersion() != s.version()) {
                    keyTuple = this.ser.serializeTupleRaw((Tuple)nearCacheKey.key(), (ClientSchema)s, true);
                    keys.add(new ClientNearCacheKeyImpl<Tuple>((Tuple)nearCacheKey.key(), keyTuple));
                    serializedTuples.add(keyTuple);
                    continue;
                }
                keys.add((ClientNearCacheKeyImpl)nearCacheKey);
                serializedTuples.add(keyTuple);
            }
            serializedKeyHolder.set(keys);
            this.ser.writeTuples(tx, (Collection<ClientSerializedTuple>)serializedTuples, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n);
        }), (s, r) -> {
            List<Tuple> resp = ClientTupleSerializer.readTuplesNullable(s, r.in());
            List serializedKeys = (List)serializedKeyHolder.get();
            assert (resp.size() == serializedKeys.size()) : "Size of the response must match with the size of the request";
            LinkedHashMap<ClientNearCacheKeyImpl, NearCacheValue> ret = new LinkedHashMap<ClientNearCacheKeyImpl, NearCacheValue>(resp.size());
            for (int i = 0; i < serializedKeys.size(); ++i) {
                ClientNearCacheKeyImpl nearCacheKey = (ClientNearCacheKeyImpl)((Object)((Object)serializedKeys.get(i)));
                Tuple val = resp.get(i);
                NearCacheValue nearCacheValue = val != null ? new NearCacheValue((Object)val) : new NearCacheValue();
                ret.put(nearCacheKey, nearCacheValue);
            }
            return ret;
        }, Collections.emptyMap(), provider, tx);
    }

    public void subscribeToNearCacheUpdates(Flow.Subscriber<TableRowEventBatch<Map.Entry<Tuple, Tuple>>> subscriber, int updateInterval) {
        ContinuousQueryOptions opts = ContinuousQueryOptions.builder().pollIntervalMs(updateInterval).eventTypes(new TableRowEventType[]{TableRowEventType.CREATED, TableRowEventType.UPDATED, TableRowEventType.REMOVED}).build();
        this.queryContinuously((Flow.Subscriber<TableRowEventBatch<Tuple>>)new NearCacheSchemaVersionAwareSubscriber((Flow.Subscriber)new NearCacheRecordRowEventSubscriber(subscriber), () -> this.tbl.getLatestSchema().thenApply(ClientSchema::version)), opts);
    }

    public void close() throws Exception {
    }
}

