/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ignite.client.RetryLimitPolicy;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.WriteContext;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.client.sql.ClientSql;
import org.apache.ignite.internal.client.table.AbstractClientView;
import org.apache.ignite.internal.client.table.ClientContinuousQuery;
import org.apache.ignite.internal.client.table.ClientDataStreamer;
import org.apache.ignite.internal.client.table.ClientNearCacheKeyImpl;
import org.apache.ignite.internal.client.table.ClientRecordSerializer;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientSerializedTuple;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.table.ClientTupleSerializer;
import org.apache.ignite.internal.client.table.MapFunction;
import org.apache.ignite.internal.client.table.PartitionAwarenessProvider;
import org.apache.ignite.internal.client.table.PojoStreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.lang.IgniteTriConsumer;
import org.apache.ignite.internal.marshaller.Marshaller;
import org.apache.ignite.internal.marshaller.MarshallerReader;
import org.apache.ignite.internal.marshaller.TupleReader;
import org.apache.ignite.internal.streamer.StreamerBatchSender;
import org.apache.ignite.internal.table.criteria.SqlRowProjection;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.Pair;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.table.ContinuousQueryOptions;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.TableRowEventBatch;
import org.apache.ignite.table.TableRowEventType;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.gridgain.internal.table.nearcache.NearCacheEntriesProvider;
import org.gridgain.internal.table.nearcache.NearCacheKey;
import org.gridgain.internal.table.nearcache.NearCacheRecordRowEventSubscriber;
import org.gridgain.internal.table.nearcache.NearCacheSchemaVersionAwareSubscriber;
import org.gridgain.internal.table.nearcache.NearCacheValue;
import org.jetbrains.annotations.Nullable;

public class ClientRecordView<R>
extends AbstractClientView<R>
implements RecordView<R>,
NearCacheEntriesProvider<R, R, ClientSerializedTuple> {
    private final ClientRecordSerializer<R> ser;

    ClientRecordView(ClientTable tbl, ClientSql sql, Mapper<R> recMapper) {
        super(tbl, sql);
        this.ser = new ClientRecordSerializer<R>(tbl.tableId(), recMapper);
    }

    public R get(@Nullable Transaction tx, R keyRec) {
        return (R)ViewUtils.sync(this.getAsync(tx, keyRec));
    }

    public CompletableFuture<R> getAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(12, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeRec(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY, true)), (s, r) -> this.ser.readValRec(keyRec, (ClientSchema)s, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), keyRec), tx);
    }

    public List<R> getAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        return (List)ViewUtils.sync(this.getAllAsync(tx, keyRecs));
    }

    public CompletableFuture<List<R>> getAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        ViewUtils.checkCollectionForNulls(keyRecs, (String)"keyRecs", (String)"key");
        if (keyRecs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        ArrayList<Transaction> txns = new ArrayList<Transaction>();
        MapFunction clo = (batch, provider, txRequired) -> {
            Transaction tx0 = this.tbl.startTxIfNeeded(tx, txns, txRequired);
            return this.tbl.doSchemaOutInOpAsync(15, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeRecs(tx0, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY, true)), (s, r) -> this.ser.readRecs((ClientSchema)s, r.in(), true, TuplePart.KEY_AND_VAL), Collections.emptyList(), provider, tx0);
        };
        return this.tbl.splitAndRun(keyRecs, clo, (schema, entry) -> ClientTupleSerializer.getColocationHash(schema, this.ser.mapper(), entry), txns);
    }

    public boolean contains(@Nullable Transaction tx, R key) {
        return (Boolean)ViewUtils.sync(this.containsAsync(tx, key));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, R key) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(33, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeRec(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY, true)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), key), tx);
    }

    public boolean containsAll(@Nullable Transaction tx, Collection<R> keys) {
        return (Boolean)ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<R> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        ArrayList<Transaction> txns = new ArrayList<Transaction>();
        MapFunction clo = (batch, provider, txRequired) -> {
            Transaction tx0 = this.tbl.startTxIfNeeded(tx, txns, txRequired);
            return this.tbl.doSchemaOutOpAsync(67, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeRecs(tx0, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY, true)), r -> r.in().unpackBoolean(), provider, tx0);
        };
        return this.tbl.splitAndRun(keys, clo, Boolean.TRUE, (agg, cur) -> agg != false && cur != false, (schema, entry) -> ClientTupleSerializer.getColocationHash(schema, this.ser.mapper(), entry), txns);
    }

    public void upsert(@Nullable Transaction tx, R rec) {
        ViewUtils.sync(this.upsertAsync(tx, rec));
    }

    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(10, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL)), r -> null, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), rec), tx);
    }

    public void upsertAll(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.sync(this.upsertAllAsync(tx, recs));
    }

    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.checkCollectionForNulls(recs, (String)"recs", (String)"rec");
        if (recs.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        MapFunction clo = (batch, provider, txRequired) -> this.tbl.doSchemaOutOpAsync(13, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeRecs(tx, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL)), r -> null, provider, tx);
        if (tx == null) {
            return clo.apply(recs, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), recs.iterator().next()), false);
        }
        return this.tbl.splitAndRun(recs, clo, null, (agg, cur) -> null, (schema, entry) -> ClientTupleSerializer.getColocationHash(schema, this.ser.mapper(), entry));
    }

    public R getAndUpsert(@Nullable Transaction tx, R rec) {
        return (R)ViewUtils.sync(this.getAndUpsertAsync(tx, rec));
    }

    public CompletableFuture<R> getAndUpsertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(16, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL)), (s, r) -> this.ser.readValRec(rec, (ClientSchema)s, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), rec), tx);
    }

    public boolean insert(@Nullable Transaction tx, R rec) {
        return (Boolean)ViewUtils.sync(this.insertAsync(tx, rec));
    }

    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(18, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), rec), tx);
    }

    public List<R> insertAll(@Nullable Transaction tx, Collection<R> recs) {
        return (List)ViewUtils.sync(this.insertAllAsync(tx, recs));
    }

    public CompletableFuture<List<R>> insertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.checkCollectionForNulls(recs, (String)"recs", (String)"rec");
        if (recs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        MapFunction clo = (batch, provider, txRequired) -> this.tbl.doSchemaOutInOpAsync(20, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeRecs(tx, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL)), (s, r) -> this.ser.readRecs((ClientSchema)s, r.in(), false, TuplePart.KEY_AND_VAL), Collections.emptyList(), provider, tx);
        if (tx == null) {
            return clo.apply(recs, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), recs.iterator().next()), false);
        }
        return this.tbl.splitAndRun(recs, clo, new ArrayList(recs.size()), (agg, cur) -> {
            agg.addAll(cur);
            return agg;
        }, (schema, entry) -> ClientTupleSerializer.getColocationHash(schema, this.ser.mapper(), entry));
    }

    public boolean replace(@Nullable Transaction tx, R rec) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, rec));
    }

    public boolean replace(@Nullable Transaction tx, R oldRec, R newRec) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, oldRec, newRec));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(22, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), rec), tx);
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R oldRec, R newRec) {
        Objects.requireNonNull(oldRec);
        Objects.requireNonNull(newRec);
        return this.tbl.doSchemaOutOpAsync(24, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeRecs(tx, oldRec, newRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), oldRec), tx);
    }

    public R getAndReplace(@Nullable Transaction tx, R rec) {
        return (R)ViewUtils.sync(this.getAndReplaceAsync(tx, rec));
    }

    public CompletableFuture<R> getAndReplaceAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(26, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL)), (s, r) -> this.ser.readValRec(rec, (ClientSchema)s, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), rec), tx);
    }

    public boolean delete(@Nullable Transaction tx, R keyRec) {
        return (Boolean)ViewUtils.sync(this.deleteAsync(tx, keyRec));
    }

    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutOpAsync(28, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeRec(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY, true)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), keyRec), tx);
    }

    public boolean deleteExact(@Nullable Transaction tx, R rec) {
        return (Boolean)ViewUtils.sync(this.deleteExactAsync(tx, rec));
    }

    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(30, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), rec), tx);
    }

    public R getAndDelete(@Nullable Transaction tx, R keyRec) {
        return (R)ViewUtils.sync(this.getAndDeleteAsync(tx, keyRec));
    }

    public CompletableFuture<R> getAndDeleteAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(32, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeRec(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY, true)), (s, r) -> this.ser.readValRec(keyRec, (ClientSchema)s, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), keyRec), tx);
    }

    public List<R> deleteAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        return (List)ViewUtils.sync(this.deleteAllAsync(tx, keyRecs));
    }

    public void deleteAll(@Nullable Transaction tx) {
        ViewUtils.sync(this.deleteAllAsync(tx));
    }

    public CompletableFuture<List<R>> deleteAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        Objects.requireNonNull(keyRecs);
        if (keyRecs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        MapFunction clo = (batch, provider, txRequired) -> this.tbl.doSchemaOutInOpAsync(29, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeRecs(tx, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY, true)), (s, r) -> this.ser.readRecs((ClientSchema)s, r.in(), false, TuplePart.KEY), Collections.emptyList(), provider, tx);
        if (tx == null) {
            return clo.apply(keyRecs, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), keyRecs.iterator().next()), false);
        }
        return this.tbl.splitAndRun(keyRecs, clo, new ArrayList(keyRecs.size()), (agg, cur) -> {
            agg.addAll(cur);
            return agg;
        }, (schema, entry) -> ClientTupleSerializer.getColocationHash(schema, this.ser.mapper(), entry));
    }

    public CompletableFuture<Void> deleteAllAsync(@Nullable Transaction tx) {
        return this.sql.executeAsync(tx, "DELETE FROM " + this.tbl.name(), new Object[0]).thenApply(r -> null);
    }

    public List<R> deleteAllExact(@Nullable Transaction tx, Collection<R> recs) {
        return (List)ViewUtils.sync(this.deleteAllExactAsync(tx, recs));
    }

    public CompletableFuture<List<R>> deleteAllExactAsync(@Nullable Transaction tx, Collection<R> recs) {
        Objects.requireNonNull(recs);
        if (recs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        MapFunction clo = (batch, provider, txRequired) -> this.tbl.doSchemaOutInOpAsync(31, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeRecs(tx, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY_AND_VAL)), (s, r) -> this.ser.readRecs((ClientSchema)s, r.in(), false, TuplePart.KEY_AND_VAL), Collections.emptyList(), provider, tx);
        if (tx == null) {
            return clo.apply(recs, ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), recs.iterator().next()), false);
        }
        return this.tbl.splitAndRun(recs, clo, new ArrayList(recs.size()), (agg, cur) -> {
            agg.addAll(cur);
            return agg;
        }, (schema, entry) -> ClientTupleSerializer.getColocationHash(schema, this.ser.mapper(), entry));
    }

    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<R>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        PojoStreamerPartitionAwarenessProvider<R> provider = new PojoStreamerPartitionAwarenessProvider<R>(this.tbl, this.ser.mapper());
        DataStreamerOptions opts = options == null ? DataStreamerOptions.DEFAULT : options;
        StreamerBatchSender batchSender = (partition, items, deleted) -> this.tbl.doSchemaOutOpAsync(62, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeStreamerRecs((int)partition, items, deleted, (ClientSchema)s, (PayloadOutputChannel)w)), r -> null, PartitionAwarenessProvider.of(partition), new RetryLimitPolicy().retryLimit(opts.retryLimit()), null);
        return ClientDataStreamer.streamData(publisher, opts, batchSender, provider, this.tbl);
    }

    public <E, V, A, R1> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V, A, R1> receiver, Function<E, R> keyFunc, Function<E, V> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R1> resultSubscriber, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        return ClientDataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options == null ? DataStreamerOptions.DEFAULT : options, new PojoStreamerPartitionAwarenessProvider<R>(this.tbl, this.ser.mapper()), this.tbl, resultSubscriber, receiver, receiverArg);
    }

    @Override
    protected Function<SqlRow, R> queryMapper(ResultSetMetadata meta, ClientSchema schema) {
        String[] cols = ClientRecordView.columnNames(schema.columns());
        Marshaller marsh = schema.getMarshaller(this.ser.mapper(), TuplePart.KEY_AND_VAL, true);
        return row -> marsh.readObject((MarshallerReader)new TupleReader((Tuple)new SqlRowProjection(row, meta, cols)), null);
    }

    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<R>> subscriber, @Nullable ContinuousQueryOptions options) {
        BiFunction<byte[], ClientSchema, Object> mapper = (row, schema) -> {
            BinaryTupleReader binTuple = new BinaryTupleReader(schema.columns().length, row);
            return this.ser.readValRecImpl((ClientSchema)schema, binTuple);
        };
        ClientContinuousQuery.queryContinuously(subscriber, options, mapper, this.tbl);
    }

    public Class<R> valueType() {
        return this.ser.mapper().targetType();
    }

    public CompletableFuture<NearCacheKey<R, ClientSerializedTuple>> getNearCacheKeyAsync(R key, boolean enforceKeyOnly) {
        return this.tbl.getLatestSchema().thenApply(schema -> new ClientNearCacheKeyImpl<Object>(key, this.ser.serialize(key, (ClientSchema)schema, TuplePart.KEY, true)));
    }

    public CompletableFuture<Collection<NearCacheKey<R, ClientSerializedTuple>>> getNearCacheKeysAsync(Iterable<? extends R> keys, boolean enforceKeyOnly) {
        return this.tbl.getLatestSchema().thenApply(schema -> {
            ArrayList serializedKeys = new ArrayList();
            for (Object key : keys) {
                serializedKeys.add(new ClientNearCacheKeyImpl(key, this.ser.serialize(key, (ClientSchema)schema, TuplePart.KEY, true)));
            }
            return serializedKeys;
        });
    }

    public CompletableFuture<Pair<NearCacheKey<R, ClientSerializedTuple>, NearCacheValue<R>>> getNearCacheValueAsync(@Nullable Transaction tx, NearCacheKey<R, ClientSerializedTuple> key) {
        Objects.requireNonNull(key, "key");
        AtomicReference serializedKey = new AtomicReference();
        return this.tbl.doSchemaOutInOpAsync(12, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> {
            ClientSerializedTuple keyTuple = (ClientSerializedTuple)key.serializedKey();
            if (keyTuple == null || keyTuple.schemaVersion() != s.version()) {
                keyTuple = this.ser.serialize(key.key(), (ClientSchema)s, TuplePart.KEY, true);
            }
            serializedKey.set(keyTuple);
            this.ser.writeRec(tx, keyTuple, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n);
        }), (s, r) -> new Pair(new ClientNearCacheKeyImpl<Object>(key.key(), (ClientSerializedTuple)serializedKey.get()), (Object)new NearCacheValue(this.ser.readValRec(key.key(), (ClientSchema)s, r.in()))), new Pair(key, (Object)new NearCacheValue()), ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), key.key()), tx);
    }

    public CompletableFuture<Map<NearCacheKey<R, ClientSerializedTuple>, NearCacheValue<R>>> getNearCacheValuesAsync(@Nullable Transaction tx, Collection<NearCacheKey<R, ClientSerializedTuple>> nearCacheKeys) {
        ViewUtils.checkKeysForNulls(nearCacheKeys);
        if (nearCacheKeys.isEmpty()) {
            return CompletableFutures.emptyMapCompletedFuture();
        }
        PartitionAwarenessProvider provider = ClientTupleSerializer.getPartitionAwarenessProvider(this.ser.mapper(), nearCacheKeys.iterator().next().key());
        AtomicReference serializedKeyHolder = new AtomicReference();
        return this.tbl.doSchemaOutInOpAsync(15, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> {
            ArrayList<ClientNearCacheKeyImpl> keys = new ArrayList<ClientNearCacheKeyImpl>(nearCacheKeys.size());
            ArrayList<ClientSerializedTuple> serializedTuples = new ArrayList<ClientSerializedTuple>(nearCacheKeys.size());
            for (NearCacheKey nearCacheKey : nearCacheKeys) {
                ClientSerializedTuple keyTuple = (ClientSerializedTuple)nearCacheKey.serializedKey();
                if (keyTuple == null || keyTuple.schemaVersion() != s.version()) {
                    keyTuple = this.ser.serialize(nearCacheKey.key(), (ClientSchema)s, TuplePart.KEY, true);
                    keys.add(new ClientNearCacheKeyImpl<Object>(nearCacheKey.key(), keyTuple));
                    serializedTuples.add(keyTuple);
                    continue;
                }
                keys.add((ClientNearCacheKeyImpl)nearCacheKey);
                serializedTuples.add(keyTuple);
            }
            serializedKeyHolder.set(keys);
            this.ser.writeRecsRaw(tx, (Collection<ClientSerializedTuple>)serializedTuples, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, TuplePart.KEY);
        }), (s, r) -> {
            List<R> resp = this.ser.readRecs((ClientSchema)s, r.in(), true, TuplePart.KEY_AND_VAL);
            List serializedKeys = (List)serializedKeyHolder.get();
            assert (resp.size() == serializedKeys.size()) : "Size of the response must match with the size of the request";
            LinkedHashMap<ClientNearCacheKeyImpl, NearCacheValue> ret = new LinkedHashMap<ClientNearCacheKeyImpl, NearCacheValue>(resp.size());
            for (int i = 0; i < serializedKeys.size(); ++i) {
                ClientNearCacheKeyImpl nearCacheKey = (ClientNearCacheKeyImpl)((Object)((Object)serializedKeys.get(i)));
                R val = resp.get(i);
                NearCacheValue nearCacheValue = val != null ? new NearCacheValue(val) : new NearCacheValue();
                ret.put(nearCacheKey, nearCacheValue);
            }
            return ret;
        }, Collections.emptyMap(), provider, tx);
    }

    public void subscribeToNearCacheUpdates(Flow.Subscriber<TableRowEventBatch<Map.Entry<R, R>>> subscriber, int updateInterval) {
        ContinuousQueryOptions opts = ContinuousQueryOptions.builder().pollIntervalMs(updateInterval).eventTypes(new TableRowEventType[]{TableRowEventType.CREATED, TableRowEventType.UPDATED, TableRowEventType.REMOVED}).build();
        this.queryContinuously((Flow.Subscriber<TableRowEventBatch<R>>)new NearCacheSchemaVersionAwareSubscriber((Flow.Subscriber)new NearCacheRecordRowEventSubscriber(subscriber), () -> this.tbl.getLatestSchema().thenApply(ClientSchema::version)), opts);
    }

    public void close() throws Exception {
    }
}

