/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ignite.client.RetryLimitPolicy;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.WriteContext;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.client.sql.ClientSql;
import org.apache.ignite.internal.client.table.AbstractClientView;
import org.apache.ignite.internal.client.table.ClientContinuousQuery;
import org.apache.ignite.internal.client.table.ClientDataStreamer;
import org.apache.ignite.internal.client.table.ClientNearCacheKeyImpl;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientSerializedTuple;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.table.ClientTuple;
import org.apache.ignite.internal.client.table.ClientTupleSerializer;
import org.apache.ignite.internal.client.table.KeyValueTupleStreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.client.table.MapFunction;
import org.apache.ignite.internal.client.table.PartitionAwarenessProvider;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteTriConsumer;
import org.apache.ignite.internal.streamer.StreamerBatchSender;
import org.apache.ignite.internal.table.criteria.SqlRowProjection;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.Pair;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.lang.NullableValue;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.table.ContinuousQueryOptions;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.TableRowEventBatch;
import org.apache.ignite.table.TableRowEventType;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.tx.Transaction;
import org.gridgain.internal.table.nearcache.NearCacheEntriesProvider;
import org.gridgain.internal.table.nearcache.NearCacheKey;
import org.gridgain.internal.table.nearcache.NearCacheSchemaVersionAwareSubscriber;
import org.gridgain.internal.table.nearcache.NearCacheValue;
import org.jetbrains.annotations.Nullable;

public class ClientKeyValueBinaryView
extends AbstractClientView<Map.Entry<Tuple, Tuple>>
implements KeyValueView<Tuple, Tuple>,
NearCacheEntriesProvider<Tuple, Tuple, ClientSerializedTuple> {
    private final ClientTupleSerializer ser;

    ClientKeyValueBinaryView(ClientTable tbl, ClientSql sql) {
        super(tbl, sql);
        this.ser = new ClientTupleSerializer(tbl.tableId());
    }

    public Tuple get(@Nullable Transaction tx, Tuple key) {
        return (Tuple)ViewUtils.sync(this.getAsync(tx, key));
    }

    public CompletableFuture<Tuple> getAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutInOpAsync(12, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readValueTuple(s, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public Map<Tuple, Tuple> getAll(@Nullable Transaction tx, Collection<Tuple> keys) {
        return (Map)ViewUtils.sync(this.getAllAsync(tx, keys));
    }

    public CompletableFuture<Map<Tuple, Tuple>> getAllAsync(@Nullable Transaction tx, Collection<Tuple> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.emptyMapCompletedFuture();
        }
        ArrayList<Transaction> txns = new ArrayList<Transaction>();
        MapFunction clo = (batch, provider, txRequired) -> {
            Transaction tx0 = this.tbl.startTxIfNeeded(tx, txns, txRequired);
            return this.tbl.doSchemaOutInOpAsync(15, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx0, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readKvTuplesNullable(s, r.in()), Collections.emptyMap(), provider, tx0);
        };
        return this.tbl.splitAndRun(keys, clo, new HashMap(), (agg, cur) -> {
            agg.putAll(cur);
            return agg;
        }, ClientTupleSerializer::getColocationHash, txns);
    }

    public NullableValue<Tuple> getNullable(@Nullable Transaction tx, Tuple key) {
        return (NullableValue)ViewUtils.sync(this.getNullableAsync(tx, key));
    }

    public CompletableFuture<NullableValue<Tuple>> getNullableAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutInOpAsync(12, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> NullableValue.of((Object)ClientTupleSerializer.readValueTuple(s, r.in())), null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public Tuple getOrDefault(@Nullable Transaction tx, Tuple key, Tuple defaultValue) {
        return (Tuple)ViewUtils.sync(this.getOrDefaultAsync(tx, key, defaultValue));
    }

    public CompletableFuture<Tuple> getOrDefaultAsync(@Nullable Transaction tx, Tuple key, Tuple defaultValue) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutInOpAsync(12, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readValueTuple(s, r.in()), defaultValue, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public boolean contains(@Nullable Transaction tx, Tuple key) {
        return (Boolean)ViewUtils.sync(this.containsAsync(tx, key));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutOpAsync(33, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public boolean containsAll(@Nullable Transaction tx, Collection<Tuple> keys) {
        return (Boolean)ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<Tuple> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        ArrayList<Transaction> txns = new ArrayList<Transaction>();
        MapFunction clo = (batch, provider, txRequired) -> {
            Transaction tx0 = this.tbl.startTxIfNeeded(tx, txns, txRequired);
            return this.tbl.doSchemaOutOpAsync(67, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx0, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), r -> r.in().unpackBoolean(), provider, tx0);
        };
        return this.tbl.splitAndRun(keys, clo, Boolean.TRUE, (agg, cur) -> agg != false && cur != false, ClientTupleSerializer::getColocationHash, txns);
    }

    public void put(@Nullable Transaction tx, Tuple key, Tuple val) {
        ViewUtils.sync(this.putAsync(tx, key, val));
    }

    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.tbl.doSchemaOutOpAsync(10, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), r -> null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public void putAll(@Nullable Transaction tx, Map<Tuple, Tuple> pairs) {
        ViewUtils.sync(this.putAllAsync(tx, pairs));
    }

    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, Map<Tuple, Tuple> pairs) {
        Objects.requireNonNull(pairs, "pairs");
        for (Map.Entry<Tuple, Tuple> entry2 : pairs.entrySet()) {
            Objects.requireNonNull(entry2.getKey(), "key");
            Objects.requireNonNull(entry2.getValue(), "val");
        }
        if (pairs.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        MapFunction clo = (batch, provider, txRequired) -> this.tbl.doSchemaOutOpAsync(13, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuples(tx, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n)), r -> null, provider, tx);
        if (tx == null) {
            return clo.apply(pairs.entrySet(), ClientTupleSerializer.getPartitionAwarenessProvider(pairs.keySet().iterator().next()), false);
        }
        return this.tbl.splitAndRun(pairs.entrySet(), clo, null, (agg, cur) -> null, (schema, entry) -> ClientTupleSerializer.getColocationHash(schema, (Tuple)entry.getKey()));
    }

    public Tuple getAndPut(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (Tuple)ViewUtils.sync(this.getAndPutAsync(tx, key, val));
    }

    public CompletableFuture<Tuple> getAndPutAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.tbl.doSchemaOutInOpAsync(16, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), (s, r) -> ClientTupleSerializer.readValueTuple(s, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public NullableValue<Tuple> getNullableAndPut(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (NullableValue)ViewUtils.sync(this.getNullableAndPutAsync(tx, key, val));
    }

    public CompletableFuture<NullableValue<Tuple>> getNullableAndPutAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.tbl.doSchemaOutInOpAsync(16, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), (s, r) -> NullableValue.of((Object)ClientTupleSerializer.readValueTuple(s, r.in())), null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public boolean putIfAbsent(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (Boolean)ViewUtils.sync(this.putIfAbsentAsync(tx, key, val));
    }

    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, Tuple key, @Nullable Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.tbl.doSchemaOutOpAsync(18, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public boolean remove(@Nullable Transaction tx, Tuple key) {
        return (Boolean)ViewUtils.sync(this.removeAsync(tx, key));
    }

    public boolean remove(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (Boolean)ViewUtils.sync(this.removeAsync(tx, key, val));
    }

    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutOpAsync(28, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.tbl.doSchemaOutOpAsync(30, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public Collection<Tuple> removeAll(@Nullable Transaction tx, Collection<Tuple> keys) {
        return (Collection)ViewUtils.sync(this.removeAllAsync(tx, keys));
    }

    public void removeAll(@Nullable Transaction tx) {
        ViewUtils.sync(this.removeAllAsync(tx));
    }

    public CompletableFuture<Collection<Tuple>> removeAllAsync(@Nullable Transaction tx, Collection<Tuple> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.emptyCollectionCompletedFuture();
        }
        MapFunction clo = (batch, provider, txRequired) -> this.tbl.doSchemaOutInOpAsync(29, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readTuples(s, r.in(), true), Collections.emptyList(), provider, tx);
        if (tx == null) {
            return clo.apply(keys, ClientTupleSerializer.getPartitionAwarenessProvider(keys.iterator().next()), false);
        }
        return this.tbl.splitAndRun(keys, clo, new HashSet(), (agg, cur) -> {
            agg.addAll(cur);
            return agg;
        }, ClientTupleSerializer::getColocationHash);
    }

    public CompletableFuture<Void> removeAllAsync(@Nullable Transaction tx) {
        return this.sql.executeAsync(tx, "DELETE FROM " + this.tbl.name(), new Object[0]).thenApply(r -> null);
    }

    public Tuple getAndRemove(@Nullable Transaction tx, Tuple key) {
        return (Tuple)ViewUtils.sync(this.getAndRemoveAsync(tx, key));
    }

    public CompletableFuture<Tuple> getAndRemoveAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutInOpAsync(32, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readValueTuple(s, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public NullableValue<Tuple> getNullableAndRemove(@Nullable Transaction tx, Tuple key) {
        return (NullableValue)ViewUtils.sync(this.getNullableAndRemoveAsync(tx, key));
    }

    public CompletableFuture<NullableValue<Tuple>> getNullableAndRemoveAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutInOpAsync(32, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> NullableValue.of((Object)ClientTupleSerializer.readValueTuple(s, r.in())), null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public boolean replace(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, key, val));
    }

    public boolean replace(@Nullable Transaction tx, Tuple key, Tuple oldVal, Tuple newVal) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, key, oldVal, newVal));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.tbl.doSchemaOutOpAsync(22, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple key, Tuple oldVal, Tuple newVal) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(oldVal, "oldVal");
        Objects.requireNonNull(newVal, "newVal");
        return this.tbl.doSchemaOutOpAsync(24, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> {
            this.ser.writeKvTuple(tx, key, oldVal, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false);
            this.ser.writeKvTuple(tx, key, newVal, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true);
        }), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public Tuple getAndReplace(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (Tuple)ViewUtils.sync(this.getAndReplaceAsync(tx, key, val));
    }

    public CompletableFuture<Tuple> getAndReplaceAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.tbl.doSchemaOutInOpAsync(26, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), (s, r) -> ClientTupleSerializer.readValueTuple(s, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public NullableValue<Tuple> getNullableAndReplace(@Nullable Transaction tx, Tuple key, Tuple val) {
        return (NullableValue)ViewUtils.sync(this.getNullableAndReplaceAsync(tx, key, val));
    }

    public CompletableFuture<NullableValue<Tuple>> getNullableAndReplaceAsync(@Nullable Transaction tx, Tuple key, Tuple val) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        return this.tbl.doSchemaOutInOpAsync(26, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeKvTuple(tx, key, val, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), (s, r) -> NullableValue.of((Object)ClientTupleSerializer.readValueTuple(s, r.in())), null, ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Map.Entry<Tuple, Tuple>>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher, "publisher");
        KeyValueTupleStreamerPartitionAwarenessProvider provider = new KeyValueTupleStreamerPartitionAwarenessProvider(this.tbl);
        DataStreamerOptions opts = options == null ? DataStreamerOptions.DEFAULT : options;
        StreamerBatchSender batchSender = (partition, items, deleted) -> this.tbl.doSchemaOutOpAsync(62, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeStreamerKvTuples((int)partition, items, deleted, (ClientSchema)s, (PayloadOutputChannel)w)), r -> null, PartitionAwarenessProvider.of(partition), new RetryLimitPolicy().retryLimit(opts.retryLimit()), null);
        return ClientDataStreamer.streamData(publisher, opts, batchSender, provider, this.tbl);
    }

    public <E, V, A, R> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V, A, R> receiver, Function<E, Map.Entry<Tuple, Tuple>> keyFunc, Function<E, V> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        return ClientDataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options == null ? DataStreamerOptions.DEFAULT : options, new KeyValueTupleStreamerPartitionAwarenessProvider(this.tbl), this.tbl, resultSubscriber, receiver, receiverArg);
    }

    @Override
    protected Function<SqlRow, Map.Entry<Tuple, Tuple>> queryMapper(ResultSetMetadata meta, ClientSchema schema) {
        String[] keyCols = ClientKeyValueBinaryView.columnNames(schema.keyColumns());
        String[] valCols = ClientKeyValueBinaryView.columnNames(schema.valColumns());
        return row -> new IgniteBiTuple((Object)new SqlRowProjection(row, meta, keyCols), (Object)new SqlRowProjection(row, meta, valCols));
    }

    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<Map.Entry<Tuple, Tuple>>> subscriber, @Nullable ContinuousQueryOptions options) {
        BiFunction<byte[], ClientSchema, Map.Entry> mapper = (row, schema) -> {
            int colCnt = schema.columns().length;
            BinaryTupleReader binTuple = new BinaryTupleReader(colCnt, row);
            ClientTuple keyTuple = new ClientTuple((ClientSchema)schema, TuplePart.KEY, binTuple);
            ClientTuple valTuple = new ClientTuple((ClientSchema)schema, TuplePart.VAL, binTuple);
            return new IgniteBiTuple((Object)keyTuple, (Object)valTuple);
        };
        ClientContinuousQuery.queryContinuously(subscriber, options, mapper, this.tbl);
    }

    public Class<Tuple> valueType() {
        return Tuple.class;
    }

    public CompletableFuture<NearCacheKey<Tuple, ClientSerializedTuple>> getNearCacheKeyAsync(Tuple key, boolean enforceKeyOnly) {
        return this.tbl.getLatestSchema().thenApply(schema -> new ClientNearCacheKeyImpl<Tuple>(key, ClientTupleSerializer.serializeTupleRaw(key, schema, true)));
    }

    public CompletableFuture<Collection<NearCacheKey<Tuple, ClientSerializedTuple>>> getNearCacheKeysAsync(Iterable<? extends Tuple> keys, boolean enforceKeyOnly) {
        return this.tbl.getLatestSchema().thenApply(schema -> {
            ArrayList<ClientNearCacheKeyImpl<Tuple>> serializedKeys = new ArrayList<ClientNearCacheKeyImpl<Tuple>>();
            for (Tuple key : keys) {
                serializedKeys.add(new ClientNearCacheKeyImpl<Tuple>(key, ClientTupleSerializer.serializeTupleRaw(key, schema, true)));
            }
            return serializedKeys;
        });
    }

    public CompletableFuture<Pair<NearCacheKey<Tuple, ClientSerializedTuple>, NearCacheValue<Tuple>>> getNearCacheValueAsync(@Nullable Transaction tx, NearCacheKey<Tuple, ClientSerializedTuple> key) {
        Objects.requireNonNull(key, "key");
        AtomicReference serializedKey = new AtomicReference();
        return this.tbl.doSchemaOutInOpAsync(12, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> {
            ClientSerializedTuple keyTuple = (ClientSerializedTuple)key.serializedKey();
            if (keyTuple == null || keyTuple.schemaVersion() != s.version()) {
                keyTuple = ClientTupleSerializer.serializeTupleRaw((Tuple)key.key(), s, true);
            }
            serializedKey.set(keyTuple);
            this.ser.writeTuple(tx, keyTuple, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n);
        }), (s, r) -> new Pair(new ClientNearCacheKeyImpl<Tuple>((Tuple)key.key(), (ClientSerializedTuple)serializedKey.get()), (Object)new NearCacheValue((Object)ClientTupleSerializer.readValueTuple(s, r.in()))), new Pair(key, (Object)new NearCacheValue()), ClientTupleSerializer.getPartitionAwarenessProvider((Tuple)key.key()), tx);
    }

    public CompletableFuture<Map<NearCacheKey<Tuple, ClientSerializedTuple>, NearCacheValue<Tuple>>> getNearCacheValuesAsync(@Nullable Transaction tx, Collection<NearCacheKey<Tuple, ClientSerializedTuple>> nearCacheKeys) {
        ViewUtils.checkKeysForNulls(nearCacheKeys);
        if (nearCacheKeys.isEmpty()) {
            return CompletableFutures.emptyMapCompletedFuture();
        }
        PartitionAwarenessProvider provider = ClientTupleSerializer.getPartitionAwarenessProvider((Tuple)nearCacheKeys.iterator().next().key());
        AtomicReference serializedKeyHolder = new AtomicReference();
        return this.tbl.doSchemaOutInOpAsync(15, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> {
            ArrayList<ClientNearCacheKeyImpl> keys = new ArrayList<ClientNearCacheKeyImpl>(nearCacheKeys.size());
            ArrayList<ClientSerializedTuple> serializedTuples = new ArrayList<ClientSerializedTuple>(nearCacheKeys.size());
            for (NearCacheKey nearCacheKey : nearCacheKeys) {
                ClientSerializedTuple keyTuple = (ClientSerializedTuple)nearCacheKey.serializedKey();
                if (keyTuple == null || keyTuple.schemaVersion() != s.version()) {
                    keyTuple = ClientTupleSerializer.serializeTupleRaw((Tuple)nearCacheKey.key(), s, true);
                    keys.add(new ClientNearCacheKeyImpl<Tuple>((Tuple)nearCacheKey.key(), keyTuple));
                    serializedTuples.add(keyTuple);
                    continue;
                }
                keys.add((ClientNearCacheKeyImpl)nearCacheKey);
                serializedTuples.add(keyTuple);
            }
            serializedKeyHolder.set(keys);
            this.ser.writeTuples(tx, (Collection<ClientSerializedTuple>)serializedTuples, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n);
        }), (s, r) -> {
            Map<Tuple, Tuple> resp = ClientTupleSerializer.readKvTuplesNullable(s, r.in());
            List serializedKeys = (List)serializedKeyHolder.get();
            HashMap<ClientNearCacheKeyImpl, NearCacheValue> ret = new HashMap<ClientNearCacheKeyImpl, NearCacheValue>(resp.size());
            for (ClientNearCacheKeyImpl nearCacheKey : serializedKeys) {
                NearCacheValue nearCacheValue;
                if (resp.containsKey(nearCacheKey.key())) {
                    Tuple val = resp.get(nearCacheKey.key());
                    nearCacheValue = new NearCacheValue((Object)val);
                } else {
                    nearCacheValue = new NearCacheValue();
                }
                ret.put(nearCacheKey, nearCacheValue);
            }
            return ret;
        }, Collections.emptyMap(), provider, tx);
    }

    public void subscribeToNearCacheUpdates(Flow.Subscriber<TableRowEventBatch<Map.Entry<Tuple, Tuple>>> subscriber, int updateInterval) {
        ContinuousQueryOptions opts = ContinuousQueryOptions.builder().pollIntervalMs(updateInterval).eventTypes(new TableRowEventType[]{TableRowEventType.CREATED, TableRowEventType.UPDATED, TableRowEventType.REMOVED}).build();
        this.queryContinuously((Flow.Subscriber<TableRowEventBatch<Map.Entry<Tuple, Tuple>>>)new NearCacheSchemaVersionAwareSubscriber(subscriber, () -> this.tbl.getLatestSchema().thenApply(ClientSchema::version)), opts);
    }

    public void close() throws Exception {
    }
}

