/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.sql;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.client.ClientUtils;
import org.apache.ignite.internal.client.PartitionMapping;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.PayloadReader;
import org.apache.ignite.internal.client.PayloadWriter;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.WriteContext;
import org.apache.ignite.internal.client.proto.ClientBinaryTupleUtils;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.ProtocolBitmaskFeature;
import org.apache.ignite.internal.client.sql.ClientAsyncResultSet;
import org.apache.ignite.internal.client.sql.ClientDirectTxMode;
import org.apache.ignite.internal.client.sql.ClientPartitionAwarenessMetadata;
import org.apache.ignite.internal.client.sql.PartitionMappingProvider;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.tx.ClientLazyTransaction;
import org.apache.ignite.internal.client.tx.ClientTransaction;
import org.apache.ignite.internal.client.tx.ClientTransactions;
import org.apache.ignite.internal.client.tx.DirectTxUtils;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.apache.ignite.internal.sql.StatementBuilderImpl;
import org.apache.ignite.internal.sql.StatementImpl;
import org.apache.ignite.internal.sql.SyncResultSetAdapter;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.CancelHandleHelper;
import org.apache.ignite.lang.CancellationToken;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.TableNotFoundException;
import org.apache.ignite.sql.BatchedArguments;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.sql.ResultSet;
import org.apache.ignite.sql.SqlException;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.Statement;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.QualifiedNameHelper;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.apache.ignite.tx.TransactionException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ClientSql
implements IgniteSql {
    private static final Mapper<SqlRow> sqlRowMapper = () -> SqlRow.class;
    private final IgniteLogger log;
    private final ReliableChannel ch;
    private final MarshallersProvider marshallers;
    private final ClientTransactions transactions;
    private final boolean partitionAwarenessEnabled;
    private final Cache<PaCacheKey, PartitionMappingProvider> mappingProviderCache;
    private final Cache<Integer, ClientTable> tableCache;

    public ClientSql(ReliableChannel ch, MarshallersProvider marshallers, ClientTransactions transactions, int sqlPartitionAwarenessMetadataCacheSize) {
        this.ch = ch;
        this.marshallers = marshallers;
        this.transactions = transactions;
        this.log = ClientUtils.logger(ch.configuration(), ClientSql.class);
        this.partitionAwarenessEnabled = sqlPartitionAwarenessMetadataCacheSize > 0;
        this.mappingProviderCache = Caffeine.newBuilder().maximumSize((long)sqlPartitionAwarenessMetadataCacheSize).build();
        this.tableCache = Caffeine.newBuilder().maximumSize((long)sqlPartitionAwarenessMetadataCacheSize).build();
    }

    public Statement createStatement(String query) {
        return new StatementImpl(query);
    }

    public Statement.StatementBuilder statementBuilder() {
        return new StatementBuilderImpl();
    }

    public ResultSet<SqlRow> execute(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        Objects.requireNonNull(query);
        try {
            return new SyncResultSetAdapter(this.executeAsync(transaction, cancellationToken, query, arguments).join());
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)ExceptionUtils.copyExceptionWithCause((CompletionException)e));
        }
    }

    public ResultSet<SqlRow> execute(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        Objects.requireNonNull(statement);
        try {
            return new SyncResultSetAdapter(this.executeAsync(transaction, cancellationToken, statement, arguments).join());
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)ExceptionUtils.copyExceptionWithCause((CompletionException)e));
        }
    }

    public <T> ResultSet<T> execute(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        Objects.requireNonNull(query);
        try {
            return new SyncResultSetAdapter(this.executeAsync(transaction, mapper, cancellationToken, query, arguments).join());
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)ExceptionUtils.copyExceptionWithCause((CompletionException)e));
        }
    }

    public <T> ResultSet<T> execute(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        Objects.requireNonNull(statement);
        try {
            return new SyncResultSetAdapter(this.executeAsync(transaction, mapper, cancellationToken, statement, arguments).join());
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)ExceptionUtils.copyExceptionWithCause((CompletionException)e));
        }
    }

    public long[] executeBatch(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String dmlQuery, BatchedArguments batch) {
        return this.executeBatch(transaction, cancellationToken, (Statement)new StatementImpl(dmlQuery), batch);
    }

    public long[] executeBatch(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement dmlStatement, BatchedArguments batch) {
        try {
            return this.executeBatchAsync(transaction, cancellationToken, dmlStatement, batch).join();
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)ExceptionUtils.copyExceptionWithCause((CompletionException)e));
        }
    }

    public void executeScript(String query, Object ... arguments) {
        this.executeScript(null, query, arguments);
    }

    public void executeScript(@Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        Objects.requireNonNull(query);
        try {
            this.executeScriptAsync(cancellationToken, query, arguments).join();
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)ExceptionUtils.copyExceptionWithCause((CompletionException)e));
        }
    }

    public CompletableFuture<AsyncResultSet<SqlRow>> executeAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        Objects.requireNonNull(query);
        StatementImpl statement = new StatementImpl(query);
        return this.executeAsync(transaction, cancellationToken, (Statement)statement, arguments);
    }

    public CompletableFuture<AsyncResultSet<SqlRow>> executeAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return this.executeAsync(transaction, sqlRowMapper, cancellationToken, statement, arguments);
    }

    public <T> CompletableFuture<AsyncResultSet<T>> executeAsync(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        Objects.requireNonNull(query);
        StatementImpl statement = new StatementImpl(query);
        return this.executeAsync(transaction, mapper, cancellationToken, (Statement)statement, arguments);
    }

    public <T> CompletableFuture<AsyncResultSet<T>> executeAsync(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        Objects.requireNonNull(statement);
        PartitionMappingProvider mappingProvider = (PartitionMappingProvider)this.mappingProviderCache.getIfPresent((Object)new PaCacheKey(statement));
        PartitionMapping mapping = mappingProvider != null ? mappingProvider.get(arguments) : null;
        WriteContext ctx = new WriteContext(this.ch.observableTimestamp(), 50);
        boolean directTxSupported = mappingProvider != null && (mappingProvider.directTxMode() == ClientDirectTxMode.SUPPORTED || mappingProvider.directTxMode() == ClientDirectTxMode.SUPPORTED_TRACKING_REQUIRED);
        boolean shouldTrackOperation = directTxSupported && mappingProvider.directTxMode() == ClientDirectTxMode.SUPPORTED_TRACKING_REQUIRED;
        CompletableFuture<@Nullable ClientTransaction> txStartFut = DirectTxUtils.ensureStarted(this.ch, transaction, mapping, ctx, ch -> {
            boolean supports;
            boolean bl = supports = directTxSupported && mapping != null && ch.protocolContext().isFeatureSupported(ProtocolBitmaskFeature.SQL_DIRECT_TX_MAPPING) && ch.protocolContext().clusterNode().name().equals(mapping.nodeConsistentId());
            assert (!supports || ch.protocolContext().allFeaturesSupported(ProtocolBitmaskFeature.TX_DIRECT_MAPPING, ProtocolBitmaskFeature.TX_DELAYED_ACKS, ProtocolBitmaskFeature.TX_PIGGYBACK));
            return supports;
        });
        return ((CompletableFuture)txStartFut.thenCompose(tx -> this.ch.serviceAsync(50, this.payloadWriter(ctx, transaction, cancellationToken, statement, arguments, shouldTrackOperation), this.payloadReader(ctx, mapper, (ClientTransaction)tx, statement), () -> DirectTxUtils.resolveChannel(ctx, this.ch, shouldTrackOperation, tx, mapping), null, false))).exceptionally(ClientSql::handleException);
    }

    private <T> PayloadReader<AsyncResultSet<T>> payloadReader(WriteContext ctx, @Nullable Mapper<T> mapper, @Nullable ClientTransaction tx, Statement statement) {
        return r -> {
            boolean tryUnpackPaMeta = this.partitionAwarenessEnabled && r.clientChannel().protocolContext().isFeatureSupported(ProtocolBitmaskFeature.SQL_PARTITION_AWARENESS);
            boolean sqlDirectMappingSupported = r.clientChannel().protocolContext().isFeatureSupported(ProtocolBitmaskFeature.SQL_DIRECT_TX_MAPPING);
            DirectTxUtils.readTx(r, ctx, tx, this.ch.observableTimestamp());
            ClientAsyncResultSet rs = new ClientAsyncResultSet(r.clientChannel(), this.marshallers, r.in(), mapper, tryUnpackPaMeta, sqlDirectMappingSupported);
            ClientPartitionAwarenessMetadata partitionAwarenessMetadata = rs.partitionAwarenessMetadata();
            if (this.partitionAwarenessEnabled && partitionAwarenessMetadata != null) {
                int tableId = partitionAwarenessMetadata.tableId();
                QualifiedName tableName = QualifiedNameHelper.fromNormalized((String)"DUMMY", (String)String.valueOf(tableId));
                ClientTable table = (ClientTable)this.tableCache.get((Object)tableId, id -> new ClientTable(this.ch, this.marshallers, tableId, tableName, false, this.transactions, 0));
                assert (table != null);
                PaCacheKey key = new PaCacheKey(statement);
                this.mappingProviderCache.put((Object)key, (Object)PartitionMappingProvider.create(table, partitionAwarenessMetadata, th -> {
                    this.log.debug("Unable to derive node for partition-aware query.", th);
                    if (th instanceof TableNotFoundException) {
                        this.tableCache.invalidate((Object)tableId);
                    }
                    this.mappingProviderCache.invalidate((Object)key);
                }));
            }
            return rs;
        };
    }

    private PayloadWriter payloadWriter(WriteContext ctx, @Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, @Nullable Object[] arguments, boolean requestAck) {
        return w -> {
            if (w.clientChannel().protocolContext().isFeatureSupported(ProtocolBitmaskFeature.SQL_DIRECT_TX_MAPPING)) {
                w.out().packBoolean(requestAck);
            }
            DirectTxUtils.writeTx(transaction, w, ctx);
            w.out().packString(statement.defaultSchema());
            w.out().packInt(statement.pageSize());
            w.out().packLong(statement.queryTimeout(TimeUnit.MILLISECONDS));
            w.out().packLongNullable(Long.valueOf(0L));
            w.out().packString(statement.timeZoneId().getId());
            ClientSql.packProperties(w, null);
            w.out().packString(statement.query());
            w.out().packObjectArrayAsBinaryTuple(arguments);
            w.out().packLong(this.ch.observableTimestamp().get().longValue());
            if (w.clientChannel().protocolContext().isFeatureSupported(ProtocolBitmaskFeature.SQL_PARTITION_AWARENESS)) {
                w.out().packBoolean(this.partitionAwarenessEnabled);
            }
            if (cancellationToken != null) {
                ClientSql.addCancelAction(cancellationToken, w);
            }
        };
    }

    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, BatchedArguments batch) {
        return this.executeBatchAsync(transaction, cancellationToken, (Statement)new StatementImpl(query), batch);
    }

    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, BatchedArguments batch) {
        PayloadWriter payloadWriter = w -> {
            DirectTxUtils.writeTx(transaction, w, null);
            w.out().packString(statement.defaultSchema());
            w.out().packInt(statement.pageSize());
            w.out().packLong(statement.queryTimeout(TimeUnit.MILLISECONDS));
            w.out().packNil();
            w.out().packString(statement.timeZoneId().getId());
            ClientSql.packProperties(w, null);
            w.out().packString(statement.query());
            w.out().packBatchedArgumentsAsBinaryTupleArray(batch);
            w.out().packLong(this.ch.observableTimestamp().get().longValue());
            if (cancellationToken != null) {
                ClientSql.addCancelAction(cancellationToken, w);
            }
        };
        PayloadReader<long[]> payloadReader = r -> {
            ClientMessageUnpacker unpacker = r.in();
            unpacker.skipValues(4);
            return unpacker.unpackLongArray();
        };
        if (transaction != null) {
            try {
                return ((CompletableFuture)((CompletableFuture)ClientLazyTransaction.ensureStarted(transaction, this.ch).get1()).thenCompose(tx -> tx.channel().serviceAsync(63, payloadWriter, payloadReader))).exceptionally(ClientSql::handleException);
            }
            catch (TransactionException e) {
                return CompletableFuture.failedFuture((Throwable)new SqlException(e.traceId(), e.code(), e.getMessage(), (Throwable)e));
            }
        }
        return this.ch.serviceAsync(63, payloadWriter, payloadReader);
    }

    public CompletableFuture<Void> executeScriptAsync(String query, Object ... arguments) {
        return this.executeScriptAsync(null, query, arguments);
    }

    public CompletableFuture<Void> executeScriptAsync(@Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        Objects.requireNonNull(query);
        PayloadWriter payloadWriter = w -> {
            w.out().packNil();
            w.out().packNil();
            w.out().packNil();
            w.out().packNil();
            w.out().packString(ZoneId.systemDefault().getId());
            ClientSql.packProperties(w, null);
            w.out().packString(query);
            w.out().packObjectArrayAsBinaryTuple(arguments);
            w.out().packLong(this.ch.observableTimestamp().get().longValue());
            if (cancellationToken != null) {
                ClientSql.addCancelAction(cancellationToken, w);
            }
        };
        return this.ch.serviceAsync(56, payloadWriter, null);
    }

    private static void addCancelAction(CancellationToken cancellationToken, PayloadOutputChannel ch) {
        CompletableFuture cancelFuture = new CompletableFuture();
        if (CancelHandleHelper.isCancelled((CancellationToken)cancellationToken)) {
            throw new SqlException(ErrorGroups.Sql.EXECUTION_CANCELLED_ERR, "The query was cancelled while executing.");
        }
        long correlationToken = ch.requestId();
        Runnable cancelAction = () -> ch.clientChannel().serviceAsync(70, w -> w.out().packLong(correlationToken), null).whenComplete((r, e) -> {
            if (e != null) {
                cancelFuture.completeExceptionally((Throwable)e);
            } else {
                cancelFuture.complete(null);
            }
        });
        ch.onSent(() -> CancelHandleHelper.addCancelAction((CancellationToken)cancellationToken, (Runnable)cancelAction, (CompletableFuture)cancelFuture));
    }

    private static void packProperties(PayloadOutputChannel w, @Nullable Map<String, Object> statementProps) {
        int size = 0;
        if (statementProps != null) {
            size += statementProps.size();
        }
        w.out().packInt(size);
        BinaryTupleBuilder builder = new BinaryTupleBuilder(size * 4);
        if (statementProps != null) {
            for (Map.Entry<String, Object> entry : statementProps.entrySet()) {
                builder.appendString(entry.getKey());
                ClientBinaryTupleUtils.appendObject((BinaryTupleBuilder)builder, (Object)entry.getValue());
            }
        }
        w.out().packBinaryTuple(builder);
    }

    private static <T> T handleException(Throwable e) {
        Throwable ex = ExceptionUtils.unwrapCause((Throwable)e);
        if (ex instanceof TransactionException) {
            TransactionException te = (TransactionException)ex;
            throw new SqlException(te.traceId(), te.code(), te.getMessage(), (Throwable)te);
        }
        throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)ex);
    }

    @TestOnly
    public List<PartitionMappingProvider> partitionAwarenessCachedMetas() {
        return List.copyOf(this.mappingProviderCache.asMap().values());
    }

    private static class PaCacheKey {
        private final String defaultSchema;
        private final String query;
        private final int hash;

        private PaCacheKey(Statement statement) {
            this(statement.defaultSchema(), statement.query());
        }

        private PaCacheKey(String defaultSchema, String query) {
            this.defaultSchema = defaultSchema;
            this.query = query;
            this.hash = Objects.hash(defaultSchema, query);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PaCacheKey that = (PaCacheKey)o;
            return this.hash == that.hash && Objects.equals(this.query, that.query) && Objects.equals(this.defaultSchema, that.defaultSchema);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

