/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.Ignite;
import org.apache.ignite.client.ClientCacheConfiguration;
import org.apache.ignite.client.IgniteClientAddressFinder;
import org.apache.ignite.client.IgniteClientAuthenticator;
import org.apache.ignite.client.IgniteClientConfiguration;
import org.apache.ignite.client.RetryPolicy;
import org.apache.ignite.client.RetryReadPolicy;
import org.apache.ignite.client.SslConfiguration;
import org.apache.ignite.internal.client.IgniteClientConfigurationImpl;
import org.apache.ignite.internal.client.TcpIgniteClient;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.lang.LoggerFactory;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public interface IgniteClient
extends Ignite,
AutoCloseable {
    public IgniteClientConfiguration configuration();

    public List<ClusterNode> connections();

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void close();

    public static class Builder {
        private String[] addresses;
        private IgniteClientAddressFinder addressFinder;
        private long connectTimeout = 5000L;
        private long backgroundReconnectInterval = 30000L;
        private Executor asyncContinuationExecutor;
        private long heartbeatInterval = 30000L;
        private long heartbeatTimeout = 5000L;
        @Nullable
        private RetryPolicy retryPolicy = new RetryReadPolicy();
        @Nullable
        private LoggerFactory loggerFactory;
        @Nullable
        private SslConfiguration sslConfiguration;
        private boolean metricsEnabled;
        @Nullable
        private IgniteClientAuthenticator authenticator;
        private long operationTimeout = 0L;
        @Nullable
        private ClientCacheConfiguration cacheConfiguration;
        private int sqlPartitionAwarenessMetadataCacheSize = 1024;
        @Nullable
        private String name;

        public Builder addresses(String ... addrs) {
            Objects.requireNonNull(addrs, "addrs is null");
            this.addresses = (String[])addrs.clone();
            return this;
        }

        public Builder retryPolicy(@Nullable RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder loggerFactory(@Nullable LoggerFactory loggerFactory) {
            this.loggerFactory = loggerFactory;
            return this;
        }

        public Builder connectTimeout(long connectTimeout) {
            if (connectTimeout < 0L) {
                throw new IllegalArgumentException("Connect timeout [" + connectTimeout + "] must be a non-negative integer value.");
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder addressFinder(IgniteClientAddressFinder addressFinder) {
            this.addressFinder = addressFinder;
            return this;
        }

        public Builder backgroundReconnectInterval(long backgroundReconnectInterval) {
            if (backgroundReconnectInterval < 0L) {
                throw new IllegalArgumentException("backgroundReconnectInterval [" + backgroundReconnectInterval + "] must be a non-negative integer value.");
            }
            this.backgroundReconnectInterval = backgroundReconnectInterval;
            return this;
        }

        public Builder asyncContinuationExecutor(Executor asyncContinuationExecutor) {
            this.asyncContinuationExecutor = asyncContinuationExecutor;
            return this;
        }

        public Builder heartbeatInterval(long heartbeatInterval) {
            if (heartbeatInterval < 0L) {
                throw new IllegalArgumentException("Heartbeat interval [" + heartbeatInterval + "] must be a non-negative integer value.");
            }
            this.heartbeatInterval = heartbeatInterval;
            return this;
        }

        public Builder heartbeatTimeout(long heartbeatTimeout) {
            if (heartbeatTimeout < 0L) {
                throw new IllegalArgumentException("Heartbeat timeout [" + heartbeatTimeout + "] must be a non-negative integer value.");
            }
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        public Builder ssl(@Nullable SslConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            return this;
        }

        public Builder metricsEnabled(boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
            return this;
        }

        public Builder authenticator(@Nullable IgniteClientAuthenticator authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public Builder operationTimeout(long operationTimeout) {
            if (operationTimeout < 0L) {
                throw new IllegalArgumentException("Operation timeout [" + operationTimeout + "] must be a non-negative integer value.");
            }
            this.operationTimeout = operationTimeout;
            return this;
        }

        public Builder cache(@Nullable ClientCacheConfiguration cacheConfiguration) {
            this.cacheConfiguration = cacheConfiguration;
            return this;
        }

        public Builder sqlPartitionAwarenessMetadataCacheSize(int size) {
            if (size < 0) {
                throw new IllegalArgumentException("Partition awareness metadata cache size [" + size + "] must be a non-negative integer value.");
            }
            this.sqlPartitionAwarenessMetadataCacheSize = size;
            return this;
        }

        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public IgniteClient build() {
            return (IgniteClient)ViewUtils.sync(this.buildAsync());
        }

        public CompletableFuture<IgniteClient> buildAsync() {
            IgniteClientConfigurationImpl cfg = new IgniteClientConfigurationImpl(this.addressFinder, this.addresses, this.connectTimeout, this.backgroundReconnectInterval, this.asyncContinuationExecutor, this.heartbeatInterval, this.heartbeatTimeout, this.retryPolicy, this.loggerFactory, this.sslConfiguration, this.metricsEnabled, this.authenticator, this.operationTimeout, this.cacheConfiguration, this.sqlPartitionAwarenessMetadataCacheSize, this.name);
            return TcpIgniteClient.startAsync(cfg);
        }
    }
}

