/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.ignite.cache.CacheStore;
import org.apache.ignite.cache.CacheStoreSession;
import org.apache.ignite.cache.CacheWriteMode;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientTable;

public class InternalCacheStore<K, V>
implements CacheStore<K, V> {
    private final CacheStore<K, V> delegate;
    private final ClientTable table;

    InternalCacheStore(CacheStore<K, V> delegate, ClientTable table) {
        this.delegate = delegate;
        this.table = table;
        assert (table.cache());
    }

    public int tableId() {
        return this.table.tableId();
    }

    public CacheWriteMode cacheWriteMode() {
        return this.latestSchema().cacheWriteMode();
    }

    private ClientSchema latestSchema() {
        return this.table.getLatestSchema().join();
    }

    public CacheStoreSession beginSession() {
        return this.delegate.beginSession();
    }

    public CompletableFuture<V> loadAsync(K key) {
        return this.delegate.loadAsync(key);
    }

    public CompletableFuture<Map<K, V>> loadAllAsync(Iterable<? extends K> keys) {
        return this.delegate.loadAllAsync(keys);
    }

    public CompletableFuture<Void> writeAsync(CacheStoreSession session, Map.Entry<? extends K, ? extends V> entry) {
        return this.delegate.writeAsync(session, entry);
    }

    public CompletableFuture<Void> writeAllAsync(CacheStoreSession session, Collection<Map.Entry<? extends K, ? extends V>> entries) {
        return this.delegate.writeAllAsync(session, entries);
    }

    public CompletableFuture<Void> deleteAsync(CacheStoreSession session, K key) {
        return this.delegate.deleteAsync(session, key);
    }

    public CompletableFuture<Void> deleteAllAsync(CacheStoreSession session, Collection<? extends K> keys) {
        return this.delegate.deleteAllAsync(session, keys);
    }

    public CompletableFuture<Void> loadCacheAsync(BiConsumer<K, V> clo, Object ... args) {
        return this.delegate.loadCacheAsync(clo, args);
    }
}

