/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.tx;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ClientHandlerMetricSource;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.client.handler.requests.tx.ClientTransactionCommitRequest;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.impl.ReadWriteTransactionImpl;

public class ClientTransactionRollbackRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, ClientResourceRegistry resources, ClientHandlerMetricSource metrics, IgniteTablesInternal igniteTables, boolean enableDirectMapping, boolean sendRemoteWritesFlag) throws IgniteInternalCheckedException {
        long resourceId = in.unpackLong();
        InternalTransaction tx = resources.remove(resourceId).get(InternalTransaction.class);
        if (enableDirectMapping && !tx.isReadOnly()) {
            int cnt = in.unpackInt();
            for (int i = 0; i < cnt; ++i) {
                int tableId = in.unpackInt();
                int partId = in.unpackInt();
                String consistentId = in.unpackString();
                long token = in.unpackLong();
                TableViewInternal table = igniteTables.cachedTable(tableId);
                if (table == null) continue;
                ClientTransactionCommitRequest.merge(table.internalTable(), partId, consistentId, token, tx, false);
            }
            if (cnt > 0) {
                in.unpackLong();
                ReadWriteTransactionImpl tx0 = (ReadWriteTransactionImpl)tx;
                tx0.noRemoteWrites(sendRemoteWritesFlag && in.unpackBoolean());
            }
        }
        return tx.rollbackAsync().handle((res, err) -> {
            metrics.transactionsActiveDecrement();
            return null;
        });
    }
}

