/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.sql;

import java.time.ZoneId;
import java.util.Set;
import org.apache.ignite.client.handler.requests.sql.ClientSqlCommon;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.sql.QueryModifier;
import org.apache.ignite.internal.sql.engine.SqlProperties;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.jetbrains.annotations.Nullable;

class ClientSqlProperties {
    @Nullable
    private final String schema;
    private final int pageSize;
    private final long queryTimeout;
    private final long idleTimeout;
    @Nullable
    private final String timeZoneId;
    private final Set<QueryModifier> queryModifiers;

    ClientSqlProperties(ClientMessageUnpacker in, boolean unpackQueryModifiers) {
        this.schema = in.tryUnpackNil() ? null : IgniteNameUtils.parseIdentifier((String)in.unpackString());
        this.pageSize = in.tryUnpackNil() ? 1024 : in.unpackInt();
        this.queryTimeout = in.tryUnpackNil() ? 0L : in.unpackLong();
        this.idleTimeout = in.tryUnpackNil() ? 0L : in.unpackLong();
        this.timeZoneId = in.tryUnpackNil() ? null : in.unpackString();
        in.unpackInt();
        in.readBinaryUnsafe();
        this.queryModifiers = unpackQueryModifiers ? QueryModifier.unpack((byte)in.unpackByte()) : QueryModifier.SINGLE_STMT_MODIFIERS;
    }

    @Nullable
    public String schema() {
        return this.schema;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public long queryTimeout() {
        return this.queryTimeout;
    }

    public long idleTimeout() {
        return this.idleTimeout;
    }

    SqlProperties toSqlProps() {
        SqlProperties sqlProperties = new SqlProperties().queryTimeout(this.queryTimeout).allowedQueryTypes(ClientSqlCommon.convertQueryModifierToQueryType(this.queryModifiers)).allowMultiStatement(this.queryModifiers.contains(QueryModifier.ALLOW_MULTISTATEMENT));
        if (this.schema != null) {
            sqlProperties.defaultSchema(this.schema);
        }
        if (this.timeZoneId != null) {
            sqlProperties.timeZoneId(ZoneId.of(this.timeZoneId));
        }
        return sqlProperties;
    }
}

