/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.sql;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.apache.ignite.client.handler.ClientHandlerMetricSource;
import org.apache.ignite.client.handler.ClientResource;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.client.handler.requests.sql.ClientSqlCommon;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.sql.api.AsyncResultSetImpl;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;

public class ClientSqlCursorNextResultRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, ClientResourceRegistry resources, Executor operationExecutor, ClientHandlerMetricSource metrics) throws IgniteInternalCheckedException {
        long resourceId = in.unpackLong();
        ClientResource resource = resources.remove(resourceId);
        ClientSqlCommon.CursorWithPageSize cursorWithPageSize = resource.get(ClientSqlCommon.CursorWithPageSize.class);
        int pageSize = cursorWithPageSize.pageSize();
        CompletionStage f = cursorWithPageSize.cursorFuture().thenComposeAsync(cur -> ((CompletableFuture)((CompletableFuture)cur.requestNextAsync(pageSize).thenApply(batchRes -> new AsyncResultSetImpl(cur, batchRes, pageSize))).thenCompose(asyncResultSet -> ClientSqlCommon.writeResultSetAsync(resources, asyncResultSet, metrics, pageSize, false, false, true, operationExecutor))).thenApply(rsWriter -> rsWriter), operationExecutor);
        ((CompletableFuture)f).whenCompleteAsync((r, t) -> {
            if (t != null) {
                cursorWithPageSize.cursorFuture().thenAccept(cur -> ClientSqlCursorNextResultRequest.closeRemainingCursors(cur, false, operationExecutor));
            }
        }, operationExecutor);
        return f;
    }

    private static void closeRemainingCursors(AsyncSqlCursor<?> cursor, boolean closeCursor, Executor operationExecutor) {
        if (cursor.hasNextResult()) {
            cursor.nextResult().whenCompleteAsync((c, err) -> {
                if (c != null) {
                    cursor.closeAsync();
                    ClientSqlCursorNextResultRequest.closeRemainingCursors(c, true, operationExecutor);
                }
            }, operationExecutor);
        } else if (closeCursor) {
            cursor.closeAsync();
        }
    }
}

