/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.table;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.table.Table;

public class ClientTablesGetRequest {
    public static CompletableFuture<ResponseWriter> process(IgniteTablesInternal igniteTables) {
        return igniteTables.tablesAsync().thenApply(tables -> out -> {
            out.packInt(tables.size());
            for (Table table : tables) {
                TableViewInternal tableImpl = (TableViewInternal)table;
                out.packInt(tableImpl.tableId());
                out.packString(ClientTablesGetRequest.quoteTableNameIfNotAllUpper(table.qualifiedName().objectName()));
            }
        });
    }

    private static String quoteTableNameIfNotAllUpper(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (i > 0 && (Character.isDigit(ch) || ch == '_') || Character.isUpperCase(ch)) continue;
            return IgniteNameUtils.quoteIfNeeded((String)name);
        }
        return name;
    }
}

