/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.sql;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Period;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.ignite.client.handler.ClientHandlerMetricSource;
import org.apache.ignite.client.handler.ClientResource;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.client.handler.requests.sql.ClientSqlResultSet;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleContainer;
import org.apache.ignite.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.sql.QueryModifier;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.sql.SqlCommon;
import org.apache.ignite.internal.sql.api.AsyncResultSetImpl;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.prepare.partitionawareness.PartitionAwarenessMetadata;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.jetbrains.annotations.Nullable;

class ClientSqlCommon {
    ClientSqlCommon() {
    }

    static void packCurrentPage(ClientMessagePacker out, AsyncResultSet<SqlRow> asyncResultSet) {
        ResultSetMetadata meta = asyncResultSet.metadata();
        assert (meta != null) : "Metadata can't be null when row set is present.";
        List cols = meta.columns();
        out.packInt(asyncResultSet.currentPageSize());
        for (SqlRow row : asyncResultSet.currentPage()) {
            BinaryTupleReader binaryTuple;
            if (row instanceof BinaryTupleContainer && (binaryTuple = ((BinaryTupleContainer)row).binaryTuple()) != null) {
                out.packBinaryTuple((BinaryTupleParser)binaryTuple);
                continue;
            }
            BinaryTupleBuilder builder = new BinaryTupleBuilder(row.columnCount());
            for (int i = 0; i < cols.size(); ++i) {
                ClientSqlCommon.packValue(builder, (ColumnMetadata)cols.get(i), row, i);
            }
            out.packBinaryTuple(builder);
        }
        if (!asyncResultSet.hasMorePages()) {
            asyncResultSet.closeAsync();
        }
    }

    private static void packValue(BinaryTupleBuilder out, ColumnMetadata col, SqlRow row, int idx) {
        if (row.value(idx) == null) {
            out.appendNull();
            return;
        }
        switch (col.type()) {
            case BOOLEAN: {
                out.appendByte((Boolean)row.value(idx) != false ? (byte)1 : 0);
                break;
            }
            case INT8: {
                out.appendByte(row.byteValue(idx));
                break;
            }
            case INT16: {
                out.appendShort(row.shortValue(idx));
                break;
            }
            case INT32: {
                out.appendInt(row.intValue(idx));
                break;
            }
            case INT64: {
                out.appendLong(row.longValue(idx));
                break;
            }
            case FLOAT: {
                out.appendFloat(row.floatValue(idx));
                break;
            }
            case DOUBLE: {
                out.appendDouble(row.doubleValue(idx));
                break;
            }
            case DECIMAL: {
                out.appendDecimal((BigDecimal)row.value(idx), col.scale());
                break;
            }
            case DATE: {
                out.appendDate(row.dateValue(idx));
                break;
            }
            case TIME: {
                out.appendTime(row.timeValue(idx));
                break;
            }
            case DATETIME: {
                out.appendDateTime(row.datetimeValue(idx));
                break;
            }
            case TIMESTAMP: {
                out.appendTimestamp(row.timestampValue(idx));
                break;
            }
            case UUID: {
                out.appendUuid(row.uuidValue(idx));
                break;
            }
            case STRING: {
                out.appendString(row.stringValue(idx));
                break;
            }
            case BYTE_ARRAY: {
                out.appendBytes((byte[])row.value(idx));
                break;
            }
            case PERIOD: {
                out.appendPeriod((Period)row.value(idx));
                break;
            }
            case DURATION: {
                out.appendDuration((Duration)row.value(idx));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported column type: " + col.type());
            }
        }
    }

    static void packColumns(ClientMessagePacker out, List<ColumnMetadata> cols) {
        out.packInt(cols.size());
        HashMap<String, Integer> schemas = new HashMap<String, Integer>();
        HashMap<String, Integer> tables = new HashMap<String, Integer>();
        for (int i = 0; i < cols.size(); ++i) {
            ColumnMetadata col = cols.get(i);
            ColumnMetadata.ColumnOrigin origin = col.origin();
            int fieldsNum = origin == null ? 6 : 9;
            out.packInt(fieldsNum);
            out.packString(SqlCommon.normalizedColumnName((ColumnMetadata)col));
            out.packBoolean(col.nullable());
            out.packInt(col.type().id());
            out.packInt(col.scale());
            out.packInt(col.precision());
            if (origin == null) {
                out.packBoolean(false);
                continue;
            }
            out.packBoolean(true);
            if (col.name().equals(origin.columnName())) {
                out.packNil();
            } else {
                out.packString(IgniteNameUtils.parseIdentifier((String)origin.columnName()));
            }
            String schemaName = IgniteNameUtils.parseIdentifier((String)origin.schemaName());
            Integer schemaIdx = (Integer)schemas.get(schemaName);
            if (schemaIdx == null) {
                schemas.put(schemaName, i);
                out.packString(schemaName);
            } else {
                out.packInt(schemaIdx.intValue());
            }
            String tableName = IgniteNameUtils.parseIdentifier((String)origin.tableName());
            Integer tableIdx = (Integer)tables.get(tableName);
            if (tableIdx == null) {
                tables.put(tableName, i);
                out.packString(tableName);
                continue;
            }
            out.packInt(tableIdx.intValue());
        }
    }

    static Set<SqlQueryType> convertQueryModifierToQueryType(Collection<QueryModifier> queryModifiers) {
        EnumSet<SqlQueryType> queryTypes = EnumSet.noneOf(SqlQueryType.class);
        block7: for (QueryModifier queryModifier : queryModifiers) {
            switch (queryModifier) {
                case ALLOW_ROW_SET_RESULT: {
                    queryTypes.addAll(SqlQueryType.HAS_ROW_SET_TYPES);
                    continue block7;
                }
                case ALLOW_AFFECTED_ROWS_RESULT: {
                    queryTypes.addAll(SqlQueryType.RETURNS_AFFECTED_ROWS_TYPES);
                    continue block7;
                }
                case ALLOW_APPLIED_RESULT: {
                    queryTypes.addAll(SqlQueryType.SUPPORT_WAS_APPLIED_TYPES);
                    continue block7;
                }
                case ALLOW_TX_CONTROL: {
                    queryTypes.add(SqlQueryType.TX_CONTROL);
                    continue block7;
                }
                case ALLOW_MULTISTATEMENT: {
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Unexpected modifier " + queryModifier);
        }
        return queryTypes;
    }

    static CompletableFuture<ResponseWriter> writeResultSetAsync(ClientResourceRegistry resources, AsyncResultSetImpl asyncResultSet, ClientHandlerMetricSource metrics, int pageSize, boolean includePartitionAwarenessMeta, boolean sqlDirectTxMappingSupported, boolean sqlMultiStatementSupported, Executor executor) {
        try {
            Long nextResultResourceId;
            Long l = nextResultResourceId = sqlMultiStatementSupported && asyncResultSet.cursor().hasNextResult() ? ClientSqlCommon.saveNextResultResource(asyncResultSet.cursor().nextResult(), pageSize, resources, executor) : null;
            if (asyncResultSet.hasRowSet() && asyncResultSet.hasMorePages()) {
                metrics.cursorsActiveIncrement();
                ClientSqlResultSet clientResultSet = new ClientSqlResultSet((AsyncResultSet<SqlRow>)asyncResultSet, metrics);
                ClientResource resource = new ClientResource(clientResultSet, clientResultSet::closeAsync);
                long resourceId = resources.put(resource);
                return CompletableFuture.completedFuture(out -> ClientSqlCommon.writeResultSet(out, asyncResultSet, resourceId, includePartitionAwarenessMeta, sqlDirectTxMappingSupported, sqlMultiStatementSupported, nextResultResourceId));
            }
            return asyncResultSet.closeAsync().thenApply(v -> out -> ClientSqlCommon.writeResultSet(out, asyncResultSet, null, includePartitionAwarenessMeta, sqlDirectTxMappingSupported, sqlMultiStatementSupported, nextResultResourceId));
        }
        catch (IgniteInternalCheckedException e) {
            return asyncResultSet.closeAsync().thenRun(() -> {
                throw new IgniteInternalException(e.getMessage(), (Throwable)e);
            });
        }
    }

    private static Long saveNextResultResource(CompletableFuture<AsyncSqlCursor<InternalSqlRow>> nextResultFuture, int pageSize, ClientResourceRegistry resources, Executor executor) throws IgniteInternalCheckedException {
        ClientResource resource = new ClientResource(new CursorWithPageSize(nextResultFuture, pageSize), () -> nextResultFuture.thenAccept(cur -> ClientSqlCommon.iterateThroughResultsAndCloseThem((AsyncSqlCursor<InternalSqlRow>)cur, executor)));
        return resources.put(resource);
    }

    private static void iterateThroughResultsAndCloseThem(AsyncSqlCursor<InternalSqlRow> cursor, final Executor executor) {
        Function<AsyncSqlCursor<InternalSqlRow>, CompletableFuture<AsyncSqlCursor<InternalSqlRow>>> traverser = new Function<AsyncSqlCursor<InternalSqlRow>, CompletableFuture<AsyncSqlCursor<InternalSqlRow>>>(){

            @Override
            public CompletableFuture<AsyncSqlCursor<InternalSqlRow>> apply(AsyncSqlCursor<InternalSqlRow> cur) {
                return cur.closeAsync().thenComposeAsync(none -> {
                    if (cur.hasNextResult()) {
                        return cur.nextResult().thenComposeAsync((Function)this, executor);
                    }
                    return CompletableFuture.completedFuture(cur);
                }, executor);
            }
        };
        CompletableFuture.completedFuture(cursor).thenCompose(traverser);
    }

    private static void writeResultSet(ClientMessagePacker out, AsyncResultSetImpl res, @Nullable Long resourceId, boolean includePartitionAwarenessMeta, boolean sqlDirectTxMappingSupported, boolean sqlMultiStatementsSupported, @Nullable Long nextResultResourceId) {
        out.packLongNullable(resourceId);
        out.packBoolean(res.hasRowSet());
        out.packBoolean(res.hasMorePages());
        out.packBoolean(res.wasApplied());
        out.packLong(res.affectedRows());
        ClientSqlCommon.packMeta(out, res.metadata());
        if (includePartitionAwarenessMeta) {
            ClientSqlCommon.packPartitionAwarenessMeta(out, res.partitionAwarenessMetadata(), sqlDirectTxMappingSupported);
        }
        if (sqlMultiStatementsSupported) {
            out.packLongNullable(nextResultResourceId);
        }
        if (res.hasRowSet()) {
            ClientSqlCommon.packCurrentPage(out, (AsyncResultSet<SqlRow>)res);
        }
    }

    private static void packMeta(ClientMessagePacker out, @Nullable ResultSetMetadata meta) {
        if (meta == null || meta.columns() == null) {
            out.packInt(0);
            return;
        }
        ClientSqlCommon.packColumns(out, meta.columns());
    }

    private static void packPartitionAwarenessMeta(ClientMessagePacker out, @Nullable PartitionAwarenessMetadata meta, boolean sqlDirectTxMappingSupported) {
        if (meta == null) {
            out.packNil();
            return;
        }
        out.packInt(meta.tableId());
        out.packIntArray(meta.indexes());
        out.packIntArray(meta.hash());
        if (sqlDirectTxMappingSupported) {
            out.packByte(meta.directTxMode().id);
        }
    }

    static class CursorWithPageSize {
        private final CompletableFuture<AsyncSqlCursor<InternalSqlRow>> cursorFuture;
        private final int pageSize;

        CursorWithPageSize(CompletableFuture<AsyncSqlCursor<InternalSqlRow>> cursorFuture, int pageSize) {
            this.cursorFuture = cursorFuture;
            this.pageSize = pageSize;
        }

        CompletableFuture<AsyncSqlCursor<InternalSqlRow>> cursorFuture() {
            return this.cursorFuture;
        }

        int pageSize() {
            return this.pageSize;
        }
    }
}

