/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.compute;

import java.util.BitSet;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ClientContext;
import org.apache.ignite.client.handler.NotificationSender;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.client.handler.requests.compute.ClientComputeExecuteRequest;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.internal.client.proto.ClientComputeJobUnpacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.ProtocolBitmaskFeature;
import org.apache.ignite.internal.compute.ExecutionContext;
import org.apache.ignite.internal.compute.IgniteComputeInternal;
import org.apache.ignite.internal.compute.events.ComputeEventMetadata;
import org.apache.ignite.internal.compute.events.ComputeEventMetadataBuilder;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.table.IgniteTables;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;

public class ClientComputeExecuteColocatedRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteComputeInternal compute, IgniteTablesInternal tables, ClusterService cluster, NotificationSender notificationSender, ClientContext clientContext) {
        SecurityContext securityContext = SecurityContextHolder.getOrThrow();
        int tableId = in.unpackInt();
        int schemaId = in.unpackInt();
        BitSet noValueSet = in.unpackBitSet();
        byte[] tupleBytes = in.readBinary();
        ClientComputeJobUnpacker.Job job = ClientComputeJobUnpacker.unpackJob((ClientMessageUnpacker)in, (boolean)clientContext.hasFeature(ProtocolBitmaskFeature.PLATFORM_COMPUTE_JOB));
        ClientComputeJobUnpacker.unpackTaskId((ClientMessageUnpacker)in, (boolean)clientContext.hasFeature(ProtocolBitmaskFeature.COMPUTE_TASK_ID));
        return ClientTableCommon.readTableAsync(tableId, (IgniteTables)tables).thenCompose(table -> ClientTableCommon.readTuple(schemaId, noValueSet, tupleBytes, table, true).thenCompose(keyTuple -> {
            ComputeEventMetadataBuilder metadataBuilder = ComputeEventMetadata.builder((ComputeEventMetadata.Type)ComputeEventMetadata.Type.SINGLE).eventUser(clientContext.userDetails()).tableName(table.name()).clientAddress(clientContext.remoteAddress().toString());
            CompletableFuture jobExecutionFut = compute.submitColocatedInternal(table, keyTuple, new ExecutionContext(job.options(), job.deploymentUnits(), job.jobClassName(), metadataBuilder, securityContext, job.arg()), null);
            ClientComputeExecuteRequest.sendResultAndState(jobExecutionFut, notificationSender);
            return jobExecutionFut.thenCompose(execution -> execution.idAsync().thenApply(jobId -> out -> {
                out.packInt(table.schemaView().lastKnownSchemaVersion());
                ClientComputeExecuteRequest.packSubmitResult(out, jobId, execution.node());
            }));
        }));
    }
}

