/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.client.handler.ClientResource;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.jetbrains.annotations.TestOnly;

public class ClientResourceRegistry {
    private final Map<Long, ClientResource> res = new ConcurrentHashMap<Long, ClientResource>();
    private final AtomicLong idGen = new AtomicLong();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long put(ClientResource obj) throws IgniteInternalCheckedException {
        this.enter();
        try {
            long id = this.idGen.incrementAndGet();
            this.res.put(id, obj);
            long l = id;
            return l;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientResource get(long id) throws IgniteInternalCheckedException {
        this.enter();
        try {
            ClientResource res = this.res.get(id);
            if (res == null) {
                throw new IgniteException(ErrorGroups.Client.RESOURCE_NOT_FOUND_ERR, "Failed to find resource with id: " + id);
            }
            ClientResource clientResource = res;
            return clientResource;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientResource remove(long id) throws IgniteInternalCheckedException {
        this.enter();
        try {
            ClientResource res = this.res.remove(id);
            if (res == null) {
                throw new IgniteException(ErrorGroups.Client.RESOURCE_NOT_FOUND_ERR, "Failed to find resource with id: " + id);
            }
            ClientResource clientResource = res;
            return clientResource;
        }
        finally {
            this.leave();
        }
    }

    public void close() {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        IgniteInternalException ex = null;
        for (ClientResource r : this.res.values()) {
            try {
                r.release();
            }
            catch (Exception e) {
                if (ex == null) {
                    ex = new IgniteInternalException((Throwable)e);
                    continue;
                }
                ex.addSuppressed((Throwable)e);
            }
        }
        this.res.clear();
        if (ex != null) {
            throw ex;
        }
    }

    @TestOnly
    public int size() {
        return this.res.size();
    }

    private void enter() throws IgniteInternalCheckedException {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalCheckedException("Resource registry is closed.");
        }
    }

    private void leave() {
        this.busyLock.leaveBusy();
    }
}

