/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.structure;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogMapDescriptor;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.table.QualifiedName;
import org.gridgain.structure.IgniteStructures;
import org.gridgain.structure.MapConfiguration;
import org.gridgain.structure.StructureUtils;
import org.jetbrains.annotations.Nullable;

public class ClientGetOrCreateMapRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteStructures structures, CatalogService catalogService) {
        String name = in.unpackString();
        String keyClassName = in.unpackStringNullable();
        String valueClassName = in.unpackStringNullable();
        String distributionZoneName = in.unpackStringNullable();
        String storageProfileName = in.unpackStringNullable();
        Class keyClass = StructureUtils.nativeOrByteArray(ClientGetOrCreateMapRequest.getClass(keyClassName));
        Class valueClass = StructureUtils.nativeOrByteArray(ClientGetOrCreateMapRequest.getClass(valueClassName));
        MapConfiguration conf = MapConfiguration.builder((String)name, (Class)keyClass, (Class)valueClass).distributionZone(distributionZoneName).storageProfile(storageProfileName).build();
        return structures.getOrCreateMapAsync(conf).thenCompose(map -> {
            QualifiedName mapName = conf.getName();
            QualifiedName tableName = QualifiedName.of((String)"SYSTEM", (String)IgniteNameUtils.quoteIfNeeded((String)mapName.objectName()));
            CatalogMapDescriptor mapDescriptor = ClientGetOrCreateMapRequest.getCatalogMapDescriptor(catalogService, mapName);
            return CompletableFuture.completedFuture(out -> {
                out.packQualifiedName(mapName);
                out.packQualifiedName(tableName);
                out.packInt(mapDescriptor.tableId());
            });
        });
    }

    private static Class<?> getClass(@Nullable String className) {
        if (className == null) {
            return byte[].class;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Class " + className + " not found: " + e.getMessage(), (Throwable)e);
        }
    }

    private static CatalogMapDescriptor getCatalogMapDescriptor(CatalogService catalogService, QualifiedName qualifiedName) {
        CatalogMapDescriptor mapDescriptor = catalogService.catalog(catalogService.latestCatalogVersion()).map(qualifiedName.schemaName(), qualifiedName.objectName());
        if (mapDescriptor == null) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Map descriptor not found for: " + qualifiedName);
        }
        return mapDescriptor;
    }
}

