/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.sql;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.client.handler.requests.sql.ClientSqlProperties;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.sql.api.IgniteSqlImpl;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.sql.engine.SqlProperties;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.lang.CancelHandle;
import org.apache.ignite.lang.CancellationToken;
import org.apache.ignite.sql.BatchedArguments;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;

public class ClientSqlExecuteBatchRequest {
    public static CompletableFuture<ResponseWriter> process(Executor operationExecutor, ClientMessageUnpacker in, QueryProcessor sql, ClientResourceRegistry resources, LicenseFeatureChecker licenseFeatureChecker, long requestId, Map<Long, CancelHandle> cancelHandleMap, HybridTimestampTracker tsTracker, String username) {
        SecurityContext context = SecurityContextHolder.getOrThrow();
        CancelHandle cancelHandle = CancelHandle.create();
        cancelHandleMap.put(requestId, cancelHandle);
        CompletableFuture<InternalTransaction> txFut = ClientTableCommon.readTx(in, tsTracker, resources, null, null, null, licenseFeatureChecker, null);
        ClientSqlProperties props = new ClientSqlProperties(in, false);
        String statement = in.unpackString();
        BatchedArguments arguments = ClientSqlExecuteBatchRequest.readArgs(in);
        HybridTimestamp clientTs = HybridTimestamp.nullableHybridTimestamp((long)in.unpackLong());
        tsTracker.update(clientTs);
        return txFut.thenComposeAsync(tx -> ((CompletableFuture)IgniteSqlImpl.executeBatchCore((QueryProcessor)sql, (HybridTimestampTracker)tsTracker, (InternalTransaction)tx, (CancellationToken)cancelHandle.token(), (String)statement, (BatchedArguments)arguments, (SqlProperties)props.toSqlProps().userName(username), () -> true, () -> {}, cursor -> 0, cursorId -> {}, (SecurityContext)context).whenComplete((none2, error) -> cancelHandleMap.remove(requestId))).thenApply(affectedRows -> out -> {
            out.packNil();
            out.packBoolean(false);
            out.packBoolean(false);
            out.packBoolean(false);
            out.packLongArray(affectedRows);
        }));
    }

    private static BatchedArguments readArgs(ClientMessageUnpacker in) {
        BatchedArguments arguments = in.unpackBatchedArgumentsFromBinaryTupleArray();
        if (arguments == null) {
            arguments = BatchedArguments.of((Object[])ArrayUtils.OBJECT_EMPTY_ARRAY);
        }
        return arguments;
    }
}

