/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.DropTableEventParameters;
import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.lowwatermark.event.ChangeLowWatermarkEventParameters;
import org.apache.ignite.internal.lowwatermark.event.LowWatermarkEvent;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEvent;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEventParameters;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.schema.SchemaSyncService;
import org.apache.ignite.internal.table.LongPriorityQueue;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteBusyLock;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.TableNotFoundException;
import org.jetbrains.annotations.Nullable;

public class ClientPrimaryReplicaTracker {
    private final ConcurrentMap<ReplicationGroupId, ReplicaHolder> primaryReplicas = new ConcurrentHashMap<ReplicationGroupId, ReplicaHolder>();
    private final AtomicLong maxStartTime = new AtomicLong();
    private final PlacementDriver placementDriver;
    private final ClockService clockService;
    private final CatalogService catalogService;
    private final SchemaSyncService schemaSyncService;
    private final LowWatermark lowWatermark;
    private final NodeProperties nodeProperties;
    private final EventListener<ChangeLowWatermarkEventParameters> lwmListener = EventListener.fromConsumer(this::onLwmChanged);
    private final EventListener<DropTableEventParameters> dropTableEventListener = EventListener.fromConsumer(this::onTableDrop);
    private final EventListener<PrimaryReplicaEventParameters> primaryReplicaEventListener = EventListener.fromConsumer(this::onPrimaryReplicaChanged);
    private final LongPriorityQueue<DestroyTableEvent> destructionEventsQueue = new LongPriorityQueue(DestroyTableEvent::catalogVersion);
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();

    public ClientPrimaryReplicaTracker(PlacementDriver placementDriver, CatalogService catalogService, ClockService clockService, SchemaSyncService schemaSyncService, LowWatermark lowWatermark, NodeProperties nodeProperties) {
        this.placementDriver = placementDriver;
        this.catalogService = catalogService;
        this.clockService = clockService;
        this.schemaSyncService = schemaSyncService;
        this.lowWatermark = lowWatermark;
        this.nodeProperties = nodeProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<PrimaryReplicasResult> primaryReplicasAsync(int tableId, @Nullable Long maxStartTime) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture((Throwable)new NodeStoppingException());
        }
        try {
            CompletableFuture<PrimaryReplicasResult> completableFuture = this.primaryReplicasAsyncInternal(tableId, maxStartTime);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private CompletableFuture<PrimaryReplicasResult> primaryReplicasAsyncInternal(int tableId, @Nullable Long maxStartTime) {
        HybridTimestamp timestamp = this.clockService.now();
        PrimaryReplicasResult fastRes = this.primaryReplicasNoWait(tableId, maxStartTime = maxStartTime == null ? Long.valueOf(this.maxStartTime.get()) : Long.valueOf(Math.max(maxStartTime, this.maxStartTime.get())), timestamp, false);
        if (fastRes != null) {
            return CompletableFuture.completedFuture(fastRes);
        }
        CompletionStage partitionsFut = this.partitionsAsync(tableId, timestamp).thenCompose(partitions -> {
            CompletableFuture[] futures = new CompletableFuture[partitions.intValue()];
            for (int partition = 0; partition < partitions; ++partition) {
                ReplicationGroupId replicationGroupId = this.replicationGroupId(tableId, partition, timestamp);
                futures[partition] = this.placementDriver.getPrimaryReplica(replicationGroupId, timestamp).thenAccept(replicaMeta -> {
                    if (replicaMeta != null && replicaMeta.getLeaseholder() != null) {
                        this.updatePrimaryReplica(replicationGroupId, replicaMeta.getStartTime(), replicaMeta.getLeaseholder());
                    }
                });
            }
            return CompletableFuture.allOf(futures).thenApply(v -> partitions);
        });
        long maxStartTime0 = maxStartTime;
        return ((CompletableFuture)partitionsFut).handle((partitions, err) -> {
            PrimaryReplicasResult res;
            if (err != null) {
                Throwable cause = ExceptionUtils.unwrapCause((Throwable)err);
                if (cause instanceof TableNotFoundException) {
                    throw new CompletionException(cause);
                }
                assert (false) : "Unexpected error: " + err;
            }
            if ((res = this.primaryReplicasNoWait(tableId, maxStartTime0, timestamp, true)) != null) {
                return res;
            }
            return new PrimaryReplicasResult((int)partitions);
        });
    }

    @Nullable
    private PrimaryReplicasResult primaryReplicasNoWait(int tableId, long maxStartTime, HybridTimestamp timestamp, boolean allowUnknownReplicas) {
        int partitions;
        long currentMaxStartTime = this.maxStartTime.get();
        if (currentMaxStartTime < maxStartTime) {
            return null;
        }
        try {
            partitions = this.partitionsNoWait(tableId, timestamp);
        }
        catch (IllegalStateException | TableNotFoundException e) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>(partitions);
        boolean hasKnown = false;
        for (int partition = 0; partition < partitions; ++partition) {
            ReplicationGroupId replicationGroupId = this.replicationGroupId(tableId, partition, timestamp);
            ReplicaHolder holder = (ReplicaHolder)this.primaryReplicas.get(replicationGroupId);
            if (holder == null || holder.nodeName == null || holder.leaseStartTime == null) {
                if (allowUnknownReplicas) {
                    res.add(null);
                    continue;
                }
                return null;
            }
            res.add(holder.nodeName);
            hasKnown = true;
        }
        return hasKnown ? new PrimaryReplicasResult(res, currentMaxStartTime) : null;
    }

    private ReplicationGroupId replicationGroupId(int tableId, int partition, HybridTimestamp timestamp) {
        if (this.nodeProperties.colocationEnabled()) {
            CatalogTableDescriptor table = this.requiredTable(tableId, timestamp);
            return new ZonePartitionId(table.zoneId(), partition);
        }
        return new TablePartitionId(tableId, partition);
    }

    private CompletableFuture<Integer> partitionsAsync(int tableId, HybridTimestamp timestamp) {
        return this.schemaSyncService.waitForMetadataCompleteness(timestamp).thenApply(v -> this.partitionsNoWait(tableId, timestamp));
    }

    private int partitionsNoWait(int tableId, HybridTimestamp timestamp) {
        CatalogTableDescriptor table;
        Catalog catalog = this.catalogService.activeCatalog(timestamp.longValue());
        CatalogZoneDescriptor zone = catalog.zone((table = this.requiredTable(tableId, timestamp)).zoneId());
        if (zone == null) {
            throw ClientTableCommon.tableIdNotFoundException(tableId);
        }
        return zone.partitions();
    }

    private CatalogTableDescriptor requiredTable(int tableId, HybridTimestamp timestamp) {
        Catalog catalog = this.catalogService.activeCatalog(timestamp.longValue());
        CatalogTableDescriptor table = catalog.table(tableId);
        if (table == null) {
            throw ClientTableCommon.tableIdNotFoundException(tableId);
        }
        return table;
    }

    long maxStartTime() {
        return this.maxStartTime.get();
    }

    void start() {
        this.maxStartTime.set(this.clockService.nowLong());
        this.placementDriver.listen((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_ELECTED, this.primaryReplicaEventListener);
        this.catalogService.listen((Event)CatalogEvent.TABLE_DROP, this.dropTableEventListener);
        this.lowWatermark.listen((Event)LowWatermarkEvent.LOW_WATERMARK_CHANGED, this.lwmListener);
    }

    void stop() {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        this.lowWatermark.removeListener((Event)LowWatermarkEvent.LOW_WATERMARK_CHANGED, this.lwmListener);
        this.catalogService.removeListener((Event)CatalogEvent.TABLE_DROP, this.dropTableEventListener);
        this.placementDriver.removeListener((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_ELECTED, this.primaryReplicaEventListener);
        this.primaryReplicas.clear();
    }

    private void onPrimaryReplicaChanged(PrimaryReplicaEventParameters primaryReplicaEvent) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> this.updatePrimaryReplica(primaryReplicaEvent.groupId(), primaryReplicaEvent.startTime(), primaryReplicaEvent.leaseholder()));
    }

    private void onTableDrop(DropTableEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            int tableId = parameters.tableId();
            int catalogVersion = parameters.catalogVersion();
            int previousVersion = catalogVersion - 1;
            int partitions = ClientPrimaryReplicaTracker.getTablePartitionsFromCatalog(this.catalogService, previousVersion, tableId);
            this.destructionEventsQueue.enqueue((Object)new DestroyTableEvent(catalogVersion, tableId, partitions));
        });
    }

    private void onLwmChanged(ChangeLowWatermarkEventParameters parameters) {
        IgniteUtils.inBusyLockSafe((IgniteBusyLock)this.busyLock, () -> {
            int earliestVersion = this.catalogService.activeCatalogVersion(parameters.newLowWatermark().longValue());
            List events = this.destructionEventsQueue.drainUpTo((long)earliestVersion);
            events.forEach(event -> this.removeTable(event.tableId(), event.partitions()));
        });
    }

    private void removeTable(int tableId, int partitions) {
        for (int partition = 0; partition < partitions; ++partition) {
            TablePartitionId tablePartitionId = new TablePartitionId(tableId, partition);
            this.primaryReplicas.remove(tablePartitionId);
        }
    }

    private void updatePrimaryReplica(ReplicationGroupId replicationGroupId, HybridTimestamp startTime, String nodeName) {
        long startTimeLong = startTime.longValue();
        this.primaryReplicas.compute(replicationGroupId, (key, existingVal) -> {
            if (existingVal != null && existingVal.leaseStartTime != null && existingVal.leaseStartTime.longValue() >= startTimeLong) {
                return existingVal;
            }
            return new ReplicaHolder(nodeName, startTime);
        });
        this.maxStartTime.updateAndGet(value -> Math.max(value, startTimeLong));
    }

    private static int getTablePartitionsFromCatalog(CatalogService catalogService, int catalogVersion, int tableId) {
        Catalog catalog = catalogService.catalog(catalogVersion);
        assert (catalog != null) : "catalogVersion=" + catalogVersion;
        CatalogTableDescriptor tableDescriptor = catalog.table(tableId);
        assert (tableDescriptor != null) : "tableId=" + tableId + ", catalogVersion=" + catalogVersion;
        int zoneId = tableDescriptor.zoneId();
        CatalogZoneDescriptor zoneDescriptor = catalog.zone(zoneId);
        assert (zoneDescriptor != null) : "zoneId=" + zoneId + ", catalogVersion=" + catalogVersion;
        return zoneDescriptor.partitions();
    }

    public static class PrimaryReplicasResult {
        private final int partitions;
        @Nullable
        private final List<String> nodeNames;
        private final long timestamp;

        PrimaryReplicasResult(int partitions) {
            this.partitions = partitions;
            this.nodeNames = null;
            this.timestamp = 0L;
        }

        PrimaryReplicasResult(List<String> nodeNames, long timestamp) {
            this.partitions = nodeNames.size();
            this.nodeNames = nodeNames;
            this.timestamp = timestamp;
        }

        @Nullable
        public List<String> nodeNames() {
            return this.nodeNames;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public int partitions() {
            return this.partitions;
        }
    }

    private static class ReplicaHolder {
        final String nodeName;
        final HybridTimestamp leaseStartTime;

        ReplicaHolder(String nodeName, HybridTimestamp leaseStartTime) {
            this.nodeName = nodeName;
            this.leaseStartTime = leaseStartTime;
        }
    }

    private static class DestroyTableEvent {
        final int catalogVersion;
        final int tableId;
        final int partitions;

        DestroyTableEvent(int catalogVersion, int tableId, int partitions) {
            this.catalogVersion = catalogVersion;
            this.tableId = tableId;
            this.partitions = partitions;
        }

        public int catalogVersion() {
            return this.catalogVersion;
        }

        public int tableId() {
            return this.tableId;
        }

        public int partitions() {
            return this.partitions;
        }
    }
}

