/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.table;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.ignite.cache.CacheStoreFactory;
import org.apache.ignite.internal.continuousquery.ContinuousQueryRequest;
import org.apache.ignite.internal.continuousquery.ContinuousQueryScanResultWithSchema;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.ColumnsExtractor;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.table.distributed.IndexLocker;
import org.apache.ignite.internal.table.distributed.PartitionSet;
import org.apache.ignite.internal.table.distributed.TableIndexStoragesSupplier;
import org.apache.ignite.internal.table.distributed.TableStatsStalenessConfiguration;
import org.apache.ignite.internal.table.metrics.TableMetricSource;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.TableViewOptions;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.table.partition.PartitionManager;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.table.SecuredRecordView;
import org.jetbrains.annotations.Nullable;

class TableViewWrapper
implements TableViewInternal {
    private final TableViewInternal delegate;
    private final SecuredRecordView<Tuple> view;

    TableViewWrapper(TableViewInternal delegate, Authorizer authorizer, SecurityContext context) {
        this.delegate = delegate;
        this.view = new SecuredRecordView(delegate.recordView(), authorizer, context, delegate.qualifiedName());
    }

    public int partitionId(Tuple key) {
        return this.delegate.partitionId(key);
    }

    public <K> int partitionId(K key, Mapper<K> keyMapper) {
        return this.delegate.partitionId(key, keyMapper);
    }

    public TableIndexStoragesSupplier indexStorageAdapters(int partitionId) {
        return this.delegate.indexStorageAdapters(partitionId);
    }

    public Supplier<Map<Integer, IndexLocker>> indexesLockers(int partId) {
        return this.delegate.indexesLockers(partId);
    }

    public void registerHashIndex(StorageHashIndexDescriptor indexDescriptor, boolean unique, ColumnsExtractor searchRowResolver, PartitionSet partitions) {
        this.delegate.registerHashIndex(indexDescriptor, unique, searchRowResolver, partitions);
    }

    public void registerSortedIndex(StorageSortedIndexDescriptor indexDescriptor, boolean unique, ColumnsExtractor searchRowResolver, PartitionSet partitions) {
        this.delegate.registerSortedIndex(indexDescriptor, unique, searchRowResolver, partitions);
    }

    public void unregisterIndex(int indexId) {
        this.delegate.unregisterIndex(indexId);
    }

    public TableMetricSource metrics() {
        return this.delegate.metrics();
    }

    public int tableId() {
        return this.delegate.tableId();
    }

    public int zoneId() {
        return this.delegate.zoneId();
    }

    public int pkId() {
        return this.delegate.pkId();
    }

    public InternalTable internalTable() {
        return this.delegate.internalTable();
    }

    public SchemaRegistry schemaView() {
        return this.delegate.schemaView();
    }

    public void schemaView(SchemaRegistry schemaReg) {
        this.delegate.schemaView(schemaReg);
    }

    public String name() {
        return this.delegate.name();
    }

    public QualifiedName qualifiedName() {
        return this.delegate.qualifiedName();
    }

    public PartitionManager partitionManager() {
        return this.delegate.partitionManager();
    }

    public <R> RecordView<R> recordView(Mapper<R> recMapper) {
        throw new UnsupportedOperationException();
    }

    public RecordView<Tuple> recordView() {
        return this.view;
    }

    public <R> RecordView<R> recordView(Mapper<R> recMapper, TableViewOptions tableViewOptions) {
        throw new UnsupportedOperationException();
    }

    public RecordView<Tuple> recordView(TableViewOptions tableViewOptions) {
        throw new UnsupportedOperationException();
    }

    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> keyMapper, Mapper<V> valMapper) {
        throw new UnsupportedOperationException();
    }

    public KeyValueView<Tuple, Tuple> keyValueView() {
        throw new UnsupportedOperationException();
    }

    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> keyMapper, Mapper<V> valMapper, TableViewOptions tableViewOptions) {
        throw new UnsupportedOperationException();
    }

    public KeyValueView<Tuple, Tuple> keyValueView(TableViewOptions tableViewOptions) {
        throw new UnsupportedOperationException();
    }

    public <K, V> KeyValueView<K, V> keyValueView(CacheStoreFactory fac, Mapper<K> keyMapper, Mapper<V> valMapper) {
        return this.delegate.keyValueView(fac, keyMapper, valMapper);
    }

    public KeyValueView<Tuple, Tuple> keyValueView(CacheStoreFactory fac) {
        return this.delegate.keyValueView(fac);
    }

    public CompletableFuture<ContinuousQueryScanResultWithSchema<BinaryRow, SchemaDescriptor>> sendContinuousQueryRequest(ContinuousQueryRequest req) {
        return this.view.authorizer().authorizeThenCompose(this.view.context(), this.view.selectPrivilege(), () -> this.delegate.sendContinuousQueryRequest(req));
    }

    public boolean cache() {
        return this.delegate.cache();
    }

    public void updateStalenessConfiguration(@Nullable Double staleRowsFraction, @Nullable Long minStaleRowsCount) {
        this.delegate.updateStalenessConfiguration(staleRowsFraction, minStaleRowsCount);
    }

    public TableStatsStalenessConfiguration stalenessConfiguration() {
        return this.delegate.stalenessConfiguration();
    }
}

