/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.table;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.cache.Cache;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.sql.SqlCommon;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.table.StreamerReceiverRunner;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.Table;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.Selector;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;
import org.gridgain.internal.table.TableViewWrapper;
import org.jetbrains.annotations.Nullable;

public class InternalTablesWrapper
implements IgniteTablesInternal {
    private static final Privilege READ_SCHEMA_PRIVILEGE = Privilege.builder().action(Action.READ_SCHEMA).selector(Selector.schema((String)SqlCommon.DEFAULT_SCHEMA_NAME)).build();
    private final IgniteTablesInternal delegate;
    private final Authorizer authorizer;

    public InternalTablesWrapper(IgniteTablesInternal delegate, Authorizer authorizer) {
        this.delegate = delegate;
        this.authorizer = authorizer;
    }

    public List<Table> tables() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<Table>> tablesAsync() {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, () -> ((IgniteTablesInternal)this.delegate).tablesAsync());
    }

    public Table table(QualifiedName name) {
        throw new UnsupportedOperationException();
    }

    public TableViewInternal table(int id) throws NodeStoppingException {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Table> tableAsync(QualifiedName name) {
        return this.tableViewAsync(name).thenApply(res -> res);
    }

    public CompletableFuture<TableViewInternal> tableAsync(int id) throws NodeStoppingException {
        SecurityContext context = SecurityContextHolder.getOrThrow();
        return this.delegate.tableAsync(id).thenApply(table -> table != null ? new TableViewWrapper((TableViewInternal)table, this.authorizer, context) : null);
    }

    public TableViewInternal tableView(QualifiedName name) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<TableViewInternal> tableViewAsync(QualifiedName name) {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, () -> {
            SecurityContext context = SecurityContextHolder.getOrNull();
            return this.delegate.tableViewAsync(name).thenApply(table -> table != null ? new TableViewWrapper((TableViewInternal)table, this.authorizer, context) : null);
        });
    }

    public List<Cache> caches() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<Cache>> cachesAsync() {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, () -> ((IgniteTablesInternal)this.delegate).cachesAsync());
    }

    public Cache cache(String name) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Cache cache(QualifiedName name) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Cache> cacheAsync(String name) {
        return this.tableViewAsync(QualifiedName.parse((String)name)).thenApply(res -> res);
    }

    public CompletableFuture<Cache> cacheAsync(QualifiedName name) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public TableViewInternal cachedTable(int tableId) {
        SecurityContext context = SecurityContextHolder.getOrThrow();
        TableViewInternal cachedTable = this.delegate.cachedTable(tableId);
        return cachedTable == null ? null : new TableViewWrapper(cachedTable, this.authorizer, context);
    }

    public void setStreamerReceiverRunner(StreamerReceiverRunner runner) {
        this.delegate.setStreamerReceiverRunner(runner);
    }
}

