/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.table;

import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ClientResource;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.NotificationSender;
import org.apache.ignite.client.handler.requests.table.ClientHandlerTuple;
import org.apache.ignite.client.handler.requests.table.ClientTupleRequestBase;
import org.apache.ignite.client.handler.requests.table.ClientTuplesRequestBase;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleContainer;
import org.apache.ignite.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.proto.ClientBinaryTupleUtils;
import org.apache.ignite.internal.client.proto.ClientMessageCommon;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.client.proto.tx.ClientInternalTxOptions;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaAware;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.InternalTxOptions;
import org.apache.ignite.internal.tx.PendingTxPartitionEnlistment;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.TxPriority;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.type.DecimalNativeType;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.TemporalNativeType;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.TableNotFoundException;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.TupleHelper;
import org.apache.ignite.tx.TransactionException;
import org.jetbrains.annotations.Nullable;

public class ClientTableCommon {
    static void writeSchema(ClientMessagePacker packer, int schemaVer, SchemaDescriptor schema) {
        packer.packInt(schemaVer);
        if (schema == null) {
            packer.packNil();
            return;
        }
        int colCnt = schema.columns().size();
        packer.packInt(colCnt);
        for (int colIdx = 0; colIdx < colCnt; ++colIdx) {
            Column col = schema.column(colIdx);
            packer.packInt(7);
            packer.packString(col.name());
            packer.packInt(col.type().spec().id());
            packer.packInt(col.positionInKey());
            packer.packBoolean(col.nullable());
            packer.packInt(col.positionInColocation());
            packer.packInt(ClientTableCommon.getDecimalScale(col.type()));
            packer.packInt(ClientTableCommon.getPrecision(col.type()));
        }
        packer.packInt(schema.writeMode().ordinal());
    }

    static void writeTupleOrNil(ClientMessagePacker packer, Tuple tuple, TuplePart part, SchemaRegistry schemaRegistry) {
        if (tuple == null) {
            packer.packInt(schemaRegistry.lastKnownSchemaVersion());
            packer.packNil();
            return;
        }
        ClientTableCommon.writeTuple(packer, tuple, false, part);
    }

    private static void writeTuple(ClientMessagePacker packer, Tuple tuple, boolean skipHeader, TuplePart part) {
        int elementCount;
        assert (tuple != null);
        assert (tuple instanceof SchemaAware) : "Tuple must be a SchemaAware: " + tuple.getClass();
        assert (part != TuplePart.VAL) : "TuplePart.VAL is not supported";
        SchemaDescriptor schema = ((SchemaAware)tuple).schema();
        assert (schema != null) : "Schema must not be null: " + tuple.getClass();
        if (!skipHeader) {
            packer.packInt(schema.version());
        }
        assert (tuple instanceof BinaryTupleContainer) : "Tuple must be a BinaryTupleContainer: " + tuple.getClass();
        BinaryTupleReader binaryTuple = ((BinaryTupleContainer)tuple).binaryTuple();
        int n = elementCount = part == TuplePart.KEY ? schema.keyColumns().size() : schema.length();
        if (binaryTuple != null) {
            assert (elementCount == binaryTuple.elementCount()) : "Tuple element count mismatch: " + elementCount + " != " + binaryTuple.elementCount() + " (" + tuple.getClass() + ")";
            packer.packBinaryTuple((BinaryTupleParser)binaryTuple);
        } else {
            BinaryTupleBuilder builder = new BinaryTupleBuilder(elementCount);
            for (int i = 0; i < elementCount; ++i) {
                Column col = schema.column(i);
                Object v = TupleHelper.valueOrDefault((Tuple)tuple, (String)col.name(), (Object)ClientMessageCommon.NO_VALUE);
                ClientBinaryTupleUtils.appendValue((BinaryTupleBuilder)builder, (ColumnType)col.type().spec(), (String)col.name(), (int)ClientTableCommon.getDecimalScale(col.type()), (Object)v);
            }
            packer.packBinaryTuple(builder);
        }
    }

    static void writeTuples(ClientMessagePacker packer, Collection<Tuple> tuples, SchemaRegistry schemaRegistry) {
        ClientTableCommon.writeTuples(packer, tuples, TuplePart.KEY_AND_VAL, schemaRegistry);
    }

    static void writeTuples(ClientMessagePacker packer, Collection<Tuple> tuples, TuplePart part, SchemaRegistry schemaRegistry) {
        if (tuples == null || tuples.isEmpty()) {
            packer.packInt(schemaRegistry.lastKnownSchemaVersion());
            packer.packInt(0);
            return;
        }
        Integer schemaVer = null;
        for (Tuple tuple : tuples) {
            assert (tuple != null);
            int tupleSchemaVer = ((SchemaAware)tuple).schema().version();
            if (schemaVer == null) {
                schemaVer = tupleSchemaVer;
                packer.packInt(tupleSchemaVer);
                packer.packInt(tuples.size());
            } else assert (schemaVer.equals(tupleSchemaVer)) : "All tuples must have the same schema version";
            ClientTableCommon.writeTuple(packer, tuple, true, part);
        }
    }

    static void writeTuplesNullable(ClientMessagePacker packer, Collection<Tuple> tuples, TuplePart part, SchemaRegistry schemaRegistry) {
        if (tuples == null || tuples.isEmpty()) {
            packer.packInt(schemaRegistry.lastKnownSchemaVersion());
            packer.packInt(0);
            return;
        }
        Integer schemaVer = null;
        for (Tuple tuple : tuples) {
            if (tuple == null) continue;
            schemaVer = ((SchemaAware)tuple).schema().version();
            break;
        }
        packer.packInt(schemaVer == null ? schemaRegistry.lastKnownSchemaVersion() : schemaVer.intValue());
        packer.packInt(tuples.size());
        for (Tuple tuple : tuples) {
            if (tuple == null) {
                packer.packBoolean(false);
                continue;
            }
            assert (schemaVer.equals(((SchemaAware)tuple).schema().version())) : "All tuples must have the same schema version";
            packer.packBoolean(true);
            ClientTableCommon.writeTuple(packer, tuple, true, part);
        }
    }

    public static CompletableFuture<Tuple> readTuple(int schemaId, BitSet noValueSet, byte[] tupleBytes, TableViewInternal table, boolean keyOnly) {
        return ClientTableCommon.readSchema(schemaId, table).thenApply(schema -> ClientTableCommon.readTuple(noValueSet, tupleBytes, keyOnly, schema));
    }

    public static Tuple readTuple(BitSet noValueSet, byte[] tupleBytes, boolean keyOnly, SchemaDescriptor schema) {
        int cnt = keyOnly ? schema.keyColumns().size() : schema.length();
        BinaryTupleReader binaryTupleReader = new BinaryTupleReader(cnt, tupleBytes);
        return new ClientHandlerTuple(schema, noValueSet, binaryTupleReader, keyOnly);
    }

    static CompletableFuture<SchemaDescriptor> readSchema(int schemaId, TableViewInternal table) {
        return table.schemaView().schemaAsync(schemaId);
    }

    public static CompletableFuture<TableViewInternal> readTableAsync(int tableId, IgniteTablesInternal tables) {
        try {
            TableViewInternal cachedTable = tables.cachedTable(tableId);
            if (cachedTable != null) {
                return CompletableFuture.completedFuture(cachedTable);
            }
            return tables.tableAsync(tableId).thenApply(t -> {
                if (t == null) {
                    throw ClientTableCommon.tableIdNotFoundException(tableId);
                }
                return t;
            });
        }
        catch (NodeStoppingException e) {
            throw new IgniteException(e.traceId(), e.code(), e.getMessage(), (Throwable)e);
        }
    }

    static void writeTxMeta(ClientMessagePacker out, HybridTimestampTracker tsTracker, @Nullable ClockService clockService, ClientTupleRequestBase req) {
        ClientTableCommon.writeTxMeta(out, tsTracker, clockService, req.tx(), req.resourceId());
    }

    static void writeTxMeta(ClientMessagePacker out, HybridTimestampTracker tsTracker, @Nullable ClockService clockService, ClientTuplesRequestBase req) {
        ClientTableCommon.writeTxMeta(out, tsTracker, clockService, req.tx(), req.resourceId());
    }

    public static void writeTxMeta(ClientMessagePacker out, HybridTimestampTracker tsTracker, @Nullable ClockService clockService, InternalTransaction tx, long resourceId) {
        if (resourceId != 0L) {
            out.packLong(resourceId);
            out.packUuid(tx.id());
            out.packUuid(tx.coordinatorId());
            out.packLong(tx.getTimeout());
        } else if (tx.remote()) {
            PendingTxPartitionEnlistment token = tx.enlistedPartition(null);
            out.packString(token.primaryNodeConsistentId());
            out.packLong(token.consistencyToken());
            out.packBoolean(TxState.ABORTED == tx.state());
            if (clockService != null) {
                tsTracker.update(clockService.current());
            }
        }
    }

    public static TableNotFoundException tableIdNotFoundException(Integer tableId) {
        return new TableNotFoundException(UUID.randomUUID(), ErrorGroups.Client.TABLE_ID_NOT_FOUND_ERR, "Table does not exist: " + tableId, null);
    }

    @Nullable
    public static InternalTransaction readTx(ClientMessageUnpacker in, HybridTimestampTracker tsUpdater, ClientResourceRegistry resources, @Nullable TxManager txManager, @Nullable NotificationSender notificationSender, long[] resourceIdHolder) {
        return ClientTableCommon.readTx(in, tsUpdater, resources, txManager, notificationSender, resourceIdHolder, EnumSet.noneOf(ClientTupleRequestBase.RequestOptions.class));
    }

    @Nullable
    public static InternalTransaction readTx(ClientMessageUnpacker in, HybridTimestampTracker tsUpdater, ClientResourceRegistry resources, @Nullable TxManager txManager, @Nullable NotificationSender notificationSender, long[] resourceIdHolder, EnumSet<ClientTupleRequestBase.RequestOptions> options) {
        if (in.tryUnpackNil()) {
            return null;
        }
        try {
            long id = in.unpackLong();
            if (id == -1L) {
                boolean external;
                boolean readOnly;
                long timeoutMillis;
                long observableTs = in.unpackLong();
                InternalTxOptions.Builder builder = InternalTxOptions.builder();
                if (options.contains((Object)ClientTupleRequestBase.RequestOptions.HAS_OPTIONS)) {
                    timeoutMillis = in.unpackLong();
                    int flags = in.unpackInt();
                    EnumSet txOptions = ClientInternalTxOptions.unpack((int)flags);
                    readOnly = txOptions.contains(ClientInternalTxOptions.READ_ONLY);
                    external = txOptions.contains(ClientInternalTxOptions.EXTERNAL);
                    if (txOptions.contains(ClientInternalTxOptions.LOW_PRIORITY)) {
                        builder.priority(TxPriority.LOW);
                    }
                    builder = builder.timeoutMillis(timeoutMillis);
                } else {
                    readOnly = in.unpackBoolean();
                    timeoutMillis = in.unpackLong();
                    external = in.unpackBoolean();
                    builder = builder.timeoutMillis(timeoutMillis);
                }
                InternalTxOptions txOptions = builder.build();
                InternalTransaction tx = ClientTableCommon.startExplicitTx(tsUpdater, txManager, HybridTimestamp.nullableHybridTimestamp((long)observableTs), readOnly, txOptions, external);
                resourceIdHolder[0] = resources.put(new ClientResource(tx, () -> ((InternalTransaction)tx).rollbackAsync()));
                return tx;
            }
            if (id == 0L) {
                boolean external;
                long timeout;
                UUID coord;
                int commitPart;
                int commitTableId;
                long token = in.unpackLong();
                UUID txId = in.unpackUuid();
                InternalTransaction remote = txManager.beginRemote(txId, new TablePartitionId(commitTableId = in.unpackInt(), commitPart = in.unpackInt()), coord = in.unpackUuid(), token, timeout = in.unpackLong(), external = in.unpackBoolean(), err -> notificationSender.sendNotification(w -> w.packUuid(txId), (Throwable)err, 0L));
                if (remote.isRolledBackWithTimeoutExceeded()) {
                    throw new TransactionException(ErrorGroups.Transactions.TX_ALREADY_FINISHED_WITH_TIMEOUT_ERR, "Transaction is already finished [tx=" + remote + "].");
                }
                return remote;
            }
            InternalTransaction tx = resources.get(id).get(InternalTransaction.class);
            if (tx != null && tx.isReadOnly()) {
                tsUpdater.update(tx.readTimestamp());
            }
            return tx;
        }
        catch (IgniteInternalCheckedException e) {
            throw new IgniteException(e.traceId(), e.code(), e.getMessage(), (Throwable)e);
        }
    }

    static InternalTransaction readOrStartImplicitTx(ClientMessageUnpacker in, HybridTimestampTracker readTs, ClientResourceRegistry resources, TxManager txManager, EnumSet<ClientTupleRequestBase.RequestOptions> options, @Nullable NotificationSender notificationSender, long[] resourceIdHolder) {
        InternalTransaction tx = ClientTableCommon.readTx(in, readTs, resources, txManager, notificationSender, resourceIdHolder, options);
        if (tx == null) {
            tx = ClientTableCommon.startImplicitTx(readTs, txManager, options.contains((Object)ClientTupleRequestBase.RequestOptions.READ_ONLY));
        }
        return tx;
    }

    public static InternalTransaction startExplicitTx(HybridTimestampTracker tsTracker, TxManager txManager, @Nullable HybridTimestamp currentTs, boolean readOnly, InternalTxOptions options, boolean external) {
        if (external) {
            return txManager.beginExternal(tsTracker, false, TxPriority.NORMAL);
        }
        if (readOnly) {
            tsTracker.update(currentTs);
            return txManager.beginExplicitRo(tsTracker, options);
        }
        return txManager.beginExplicitRw(tsTracker, options);
    }

    private static InternalTransaction startImplicitTx(HybridTimestampTracker tsTracker, TxManager txManager, boolean readOnly) {
        return txManager.beginImplicit(tsTracker, readOnly);
    }

    public static int getDecimalScale(NativeType type) {
        return type instanceof DecimalNativeType ? ((DecimalNativeType)type).scale() : 0;
    }

    public static int getPrecision(NativeType type) {
        if (type instanceof TemporalNativeType) {
            return ((TemporalNativeType)type).precision();
        }
        if (type instanceof DecimalNativeType) {
            return ((DecimalNativeType)type).precision();
        }
        return 0;
    }
}

