/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.table;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.table.distributed.schema.SchemaVersions;
import org.jetbrains.annotations.Nullable;

public class ClientSchemasGetRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteTablesInternal tables, SchemaVersions schemaVersions) {
        int tableId = in.unpackInt();
        List<Integer> schemaVers = ClientSchemasGetRequest.readSchemaVersions(in);
        return ClientTableCommon.readTableAsync(tableId, tables).thenCompose(table -> {
            if (schemaVers == null) {
                return schemaVersions.schemaVersionAtCurrentTime(table.tableId()).thenApply(version -> {
                    SchemaDescriptor schema = table.schemaView().schema(version.intValue());
                    return out -> {
                        out.packInt(1);
                        ClientTableCommon.writeSchema(out, schema.version(), schema);
                    };
                });
            }
            CompletableFuture[] schemaFutures = new CompletableFuture[schemaVers.size()];
            for (int i = 0; i < schemaVers.size(); ++i) {
                Integer schemaVer = (Integer)schemaVers.get(i);
                schemaFutures[i] = table.schemaView().schemaAsync(schemaVer.intValue());
            }
            return CompletableFuture.allOf(schemaFutures).thenApply(v -> out -> {
                out.packInt(schemaFutures.length);
                for (CompletableFuture schemaFuture : schemaFutures) {
                    SchemaDescriptor schema = (SchemaDescriptor)schemaFuture.join();
                    ClientTableCommon.writeSchema(out, schema.version(), schema);
                }
            });
        });
    }

    @Nullable
    private static List<Integer> readSchemaVersions(ClientMessageUnpacker in) {
        if (in.tryUnpackNil()) {
            return null;
        }
        int cnt = in.unpackInt();
        ArrayList<Integer> res = new ArrayList<Integer>(cnt);
        for (int i = 0; i < cnt; ++i) {
            res.add(in.unpackInt());
        }
        return res;
    }
}

