/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.sql;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.client.handler.requests.sql.ClientSqlExecuteRequest;
import org.apache.ignite.client.handler.requests.sql.ClientSqlProperties;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.sql.api.IgniteSqlImpl;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.sql.engine.SqlProperties;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.CancelHandle;
import org.apache.ignite.lang.CancellationToken;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;

public class ClientSqlExecuteScriptRequest {
    public static CompletableFuture<ResponseWriter> process(Executor operationExecutor, ClientMessageUnpacker in, QueryProcessor sql, long requestId, Map<Long, CancelHandle> cancelHandleMap, HybridTimestampTracker tsTracker, String username) {
        CancelHandle cancelHandle = CancelHandle.create();
        cancelHandleMap.put(requestId, cancelHandle);
        SecurityContext context = SecurityContextHolder.getOrThrow();
        ClientSqlProperties props = new ClientSqlProperties(in);
        String script = in.unpackString();
        Object[] arguments = ClientSqlExecuteRequest.readArgsNotNull(in);
        HybridTimestamp clientTs = HybridTimestamp.nullableHybridTimestamp((long)in.unpackLong());
        tsTracker.update(clientTs);
        return CompletableFutures.nullCompletedFuture().thenComposeAsync(none -> IgniteSqlImpl.executeScriptCore((QueryProcessor)sql, (HybridTimestampTracker)tsTracker, () -> true, () -> {}, (String)script, (CancellationToken)cancelHandle.token(), (Object[])arguments, (SqlProperties)props.toSqlProps().userName(username), (Executor)operationExecutor, (SecurityContext)context).handle((none2, error) -> {
            cancelHandleMap.remove(requestId);
            if (error != null) {
                ExceptionUtils.sneakyThrow((Throwable)error);
            }
            return null;
        }), operationExecutor);
    }
}

