/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.apache.ignite.client.handler.ClientResource;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.internal.jdbc.proto.event.JdbcColumnMeta;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQuerySingleResult;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.util.AsyncCursor;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.TraceableException;
import org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.sql.ResultSetMetadata;
import org.jetbrains.annotations.Nullable;

abstract class JdbcHandlerBase {
    public static final Set<SqlQueryType> SELECT_STATEMENT_QUERIES = EnumSet.of(SqlQueryType.QUERY, SqlQueryType.EXPLAIN, SqlQueryType.SHOW, SqlQueryType.COPY);
    public static final Set<SqlQueryType> ZERO_UPDATE_COUNT_QUERIES = EnumSet.of(SqlQueryType.DDL, SqlQueryType.RBAC_DDL, SqlQueryType.KILL, SqlQueryType.TX_CONTROL);
    private final IgniteLogger log;
    protected final ClientResourceRegistry resources;

    JdbcHandlerBase(ClientResourceRegistry resources) {
        this.resources = resources;
        this.log = Loggers.forClass(this.getClass());
    }

    CompletionStage<JdbcQuerySingleResult> createJdbcResult(AsyncSqlCursor<InternalSqlRow> cur, int pageSize) {
        return cur.requestNextAsync(pageSize).thenApply(batch -> {
            SqlQueryType queryType;
            Long cursorId = null;
            if (cur.hasNextResult()) {
                try {
                    cursorId = this.resources.put(new ClientResource(cur, () -> ((AsyncSqlCursor)cur).closeAsync()));
                }
                catch (IgniteInternalCheckedException e) {
                    cur.closeAsync();
                    return new JdbcQuerySingleResult(1, "Unable to store query cursor.");
                }
            }
            if ((queryType = cur.queryType()).hasRowSet()) {
                if (cursorId == null && batch.hasMore()) {
                    try {
                        cursorId = this.resources.put(new ClientResource(cur, () -> ((AsyncSqlCursor)cur).closeAsync()));
                    }
                    catch (IgniteInternalCheckedException e) {
                        cur.closeAsync();
                        return new JdbcQuerySingleResult(1, "Unable to store query cursor.");
                    }
                }
                List columns = cur.metadata().columns();
                return JdbcHandlerBase.buildSingleRequest((AsyncCursor.BatchedResult<InternalSqlRow>)batch, columns, cursorId, cur.hasNextResult());
            }
            if (queryType.returnsAffectedRows()) {
                boolean hasMoreData = batch.hasMore();
                if (!JdbcHandlerBase.validateDmlResult(cur.metadata(), hasMoreData)) {
                    return new JdbcQuerySingleResult(1, "Unexpected result for DML query");
                }
                long updCount = (Long)((InternalSqlRow)batch.items().get(0)).get(0);
                return new JdbcQuerySingleResult(cursorId, updCount, cur.hasNextResult());
            }
            if (ZERO_UPDATE_COUNT_QUERIES.contains(queryType)) {
                return new JdbcQuerySingleResult(cursorId, 0L, cur.hasNextResult());
            }
            return new JdbcQuerySingleResult(1002, "Query type is not supported yet [queryType=" + queryType + "]");
        });
    }

    private static JdbcQuerySingleResult buildSingleRequest(AsyncCursor.BatchedResult<InternalSqlRow> batch, List<ColumnMetadata> columns, @Nullable Long cursorId, boolean hasNextResult) {
        ArrayList<BinaryTuple> rows = new ArrayList<BinaryTuple>(batch.items().size());
        for (InternalSqlRow item : batch.items()) {
            rows.add(item.asBinaryTuple());
        }
        ArrayList<JdbcColumnMeta> meta = new ArrayList<JdbcColumnMeta>(columns.size());
        for (ColumnMetadata column : columns) {
            meta.add(JdbcHandlerBase.createColumnMetadata(column));
        }
        return new JdbcQuerySingleResult(cursorId, rows, meta, batch.hasMore(), hasNextResult);
    }

    JdbcQuerySingleResult createErrorResult(String logMessage, Throwable origin, @Nullable String errMessagePrefix) {
        Throwable ex = ExceptionUtils.unwrapCause((Throwable)origin);
        this.log.info(logMessage, ex);
        String errorMessage = ex instanceof TraceableException && ((TraceableException)ex).code() == ErrorGroups.Sql.TX_CONTROL_INSIDE_EXTERNAL_TX_ERR ? "Transaction control statements are not supported when autocommit mode is disabled" : JdbcHandlerBase.getErrorMessage(ex);
        return new JdbcQuerySingleResult(1, (errMessagePrefix == null ? "" : errMessagePrefix) + errorMessage);
    }

    private static boolean validateDmlResult(ResultSetMetadata meta, boolean next) {
        if (next) {
            return false;
        }
        if (meta.columns().size() != 1) {
            return false;
        }
        return ((ColumnMetadata)meta.columns().get(0)).type() == ColumnType.INT64;
    }

    @Nullable
    static String getErrorMessage(Throwable t) {
        Throwable cause = ExceptionUtils.unwrapCause((Throwable)t);
        return cause.getMessage();
    }

    private static JdbcColumnMeta createColumnMetadata(ColumnMetadata fldMeta) {
        ColumnMetadata.ColumnOrigin origin = fldMeta.origin();
        String schemaName = null;
        String tblName = null;
        String colName = null;
        if (origin != null) {
            schemaName = origin.schemaName();
            tblName = origin.tableName();
            colName = origin.columnName();
        }
        return new JdbcColumnMeta(fldMeta.name(), schemaName, tblName, colName, fldMeta.type(), fldMeta.precision(), fldMeta.scale(), fldMeta.nullable());
    }
}

