/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.table;

import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite.internal.table.RecordViewInternal;
import org.apache.ignite.lang.AsyncCursor;
import org.apache.ignite.lang.Cursor;
import org.apache.ignite.table.ContinuousQueryOptions;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.TableRowEventBatch;
import org.apache.ignite.table.criteria.Criteria;
import org.apache.ignite.table.criteria.CriteriaQueryOptions;
import org.apache.ignite.tx.Transaction;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.Selector;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;

class SecuredRecordView<R>
implements RecordView<R>,
RecordViewInternal<R> {
    private final RecordView<R> delegate;
    private final Authorizer authorizer;
    private final SecurityContext context;
    private final QualifiedName name;
    private volatile Privilege select;
    private volatile Privilege insert;
    private volatile Privilege update;
    private volatile Privilege delete;
    private volatile Set<Privilege> upsert;
    private volatile Set<Privilege> replace;
    private volatile Set<Privilege> getAndDelete;

    SecuredRecordView(RecordView<R> delegate, Authorizer authorizer, SecurityContext context, QualifiedName name) {
        this.delegate = delegate;
        this.authorizer = authorizer;
        this.context = context;
        this.name = name;
    }

    Authorizer authorizer() {
        return this.authorizer;
    }

    SecurityContext context() {
        return this.context;
    }

    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<R>> publisher, @Nullable DataStreamerOptions options) {
        throw new UnsupportedOperationException();
    }

    public <E, V, A, R1> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V, A, R1> receiver, Function<E, R> keyFunc, Function<E, V> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R1> resultSubscriber, @Nullable DataStreamerOptions options) {
        throw new UnsupportedOperationException();
    }

    public R get(@Nullable Transaction tx, R keyRec) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<R> getAsync(@Nullable Transaction tx, R keyRec) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.getAsync(tx, keyRec));
    }

    public List<R> getAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<R>> getAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.getAllAsync(tx, keyRecs));
    }

    public boolean contains(@Nullable Transaction tx, R keyRec) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, R keyRec) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.containsAsync(tx, keyRec));
    }

    public boolean containsAll(@Nullable Transaction tx, Collection<R> keys) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<R> keys) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.containsAllAsync(tx, keys));
    }

    public void upsert(@Nullable Transaction tx, R rec) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, R rec) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.upsertAsync(tx, rec));
    }

    public void upsertAll(@Nullable Transaction tx, Collection<R> recs) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.upsertAllAsync(tx, recs));
    }

    public R getAndUpsert(@Nullable Transaction tx, R rec) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<R> getAndUpsertAsync(@Nullable Transaction tx, R rec) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.getAndUpsertAsync(tx, rec));
    }

    public boolean insert(@Nullable Transaction tx, R rec) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, R rec) {
        return this.authorizer.authorizeThenCompose(this.context, this.insertPrivilege(), () -> this.delegate.insertAsync(tx, rec));
    }

    public List<R> insertAll(@Nullable Transaction tx, Collection<R> recs) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<R>> insertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        return this.authorizer.authorizeThenCompose(this.context, this.insertPrivilege(), () -> this.delegate.insertAllAsync(tx, recs));
    }

    public boolean replace(@Nullable Transaction tx, R rec) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(@Nullable Transaction tx, R oldRec, R newRec) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R rec) {
        return this.authorizer.authorizeThenCompose(this.context, this.replacePrivilege(), () -> this.delegate.replaceAsync(tx, rec));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R oldRec, R newRec) {
        return this.authorizer.authorizeThenCompose(this.context, this.replacePrivilege(), () -> this.delegate.replaceAsync(tx, oldRec, newRec));
    }

    public R getAndReplace(@Nullable Transaction tx, R rec) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<R> getAndReplaceAsync(@Nullable Transaction tx, R rec) {
        return this.authorizer.authorizeThenCompose(this.context, this.replacePrivilege(), () -> this.delegate.getAndReplaceAsync(tx, rec));
    }

    public boolean delete(@Nullable Transaction tx, R keyRec) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, R keyRec) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.deleteAsync(tx, keyRec));
    }

    public boolean deleteExact(@Nullable Transaction tx, R rec) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, R rec) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.deleteExactAsync(tx, rec));
    }

    public R getAndDelete(@Nullable Transaction tx, R keyRec) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<R> getAndDeleteAsync(@Nullable Transaction tx, R keyRec) {
        return this.authorizer.authorizeThenCompose(this.context, this.getAndDeletePrivilege(), () -> this.delegate.getAndDeleteAsync(tx, keyRec));
    }

    public List<R> deleteAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        throw new UnsupportedOperationException();
    }

    public void deleteAll(@Nullable Transaction tx) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<R>> deleteAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.deleteAllAsync(tx, keyRecs));
    }

    public CompletableFuture<Void> deleteAllAsync(@Nullable Transaction tx) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.deleteAllAsync(tx));
    }

    public List<R> deleteAllExact(@Nullable Transaction tx, Collection<R> recs) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<R>> deleteAllExactAsync(@Nullable Transaction tx, Collection<R> recs) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.deleteAllExactAsync(tx, recs));
    }

    public Cursor<R> query(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<AsyncCursor<R>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.queryAsync(tx, criteria, indexName, opts));
    }

    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<R>> subscriber, @Nullable ContinuousQueryOptions options) {
        this.authorizer.authorizeAsync(this.selectPrivilege()).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                subscriber.onError((Throwable)throwable);
            } else {
                this.delegate.queryContinuously(subscriber, options);
            }
        });
    }

    public CompletableFuture<Void> updateAll(int partitionId, Collection<R> rows, @Nullable BitSet deleted) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> ((RecordViewInternal)this.delegate).updateAll(partitionId, rows, deleted));
    }

    Privilege selectPrivilege() {
        if (this.select == null) {
            this.select = this.getPrivilege(Action.SELECT_FROM_TABLE);
        }
        return this.select;
    }

    private Privilege insertPrivilege() {
        if (this.insert == null) {
            this.insert = this.getPrivilege(Action.INSERT_INTO_TABLE);
        }
        return this.insert;
    }

    private Privilege updatePrivilege() {
        if (this.update == null) {
            this.update = this.getPrivilege(Action.UPDATE_TABLE);
        }
        return this.update;
    }

    private Privilege deletePrivilege() {
        if (this.delete == null) {
            this.delete = this.getPrivilege(Action.DELETE_FROM_TABLE);
        }
        return this.delete;
    }

    private Set<Privilege> upsertPrivilege() {
        if (this.upsert == null) {
            this.upsert = Set.of(this.selectPrivilege(), this.insertPrivilege(), this.updatePrivilege());
        }
        return this.upsert;
    }

    private Set<Privilege> replacePrivilege() {
        if (this.replace == null) {
            this.replace = Set.of(this.selectPrivilege(), this.updatePrivilege());
        }
        return this.replace;
    }

    private Set<Privilege> getAndDeletePrivilege() {
        if (this.getAndDelete == null) {
            this.getAndDelete = Set.of(this.selectPrivilege(), this.deletePrivilege());
        }
        return this.getAndDelete;
    }

    private Privilege getPrivilege(Action action) {
        return Privilege.builder().action(action).selector(Selector.table((String)this.name.schemaName(), (String)this.name.objectName())).build();
    }

    public void close() throws Exception {
        this.delegate.close();
    }
}

