/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.cache;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.table.QualifiedName;

public class ClientCacheGetRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteTablesInternal tables) {
        QualifiedName qualifiedName;
        String tableName = in.unpackString();
        try {
            qualifiedName = QualifiedName.parse((String)tableName);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture((Throwable)new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Unable to parse qualified name", (Throwable)e));
        }
        return tables.tableViewAsync(qualifiedName).thenApply(table -> out -> {
            if (table == null || !table.cache()) {
                out.packNil();
            } else {
                out.packInt(table.tableId());
            }
        });
    }
}

