/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.channels.UnresolvedAddressException;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.ignite.client.handler.ClientHandlerMetricSource;
import org.apache.ignite.client.handler.ClientInboundMessageHandler;
import org.apache.ignite.client.handler.ClientPrimaryReplicaTracker;
import org.apache.ignite.client.handler.ClusterInfo;
import org.apache.ignite.client.handler.IdleChannelHandler;
import org.apache.ignite.client.handler.configuration.ClientConnectorConfiguration;
import org.apache.ignite.client.handler.configuration.ClientConnectorView;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.client.proto.ClientMessageDecoder;
import org.apache.ignite.internal.client.proto.ProtocolBitmaskFeature;
import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.compute.IgniteComputeInternal;
import org.apache.ignite.internal.compute.executor.platform.PlatformComputeConnection;
import org.apache.ignite.internal.compute.executor.platform.PlatformComputeTransport;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.NettyBootstrapFactory;
import org.apache.ignite.internal.network.configuration.SslView;
import org.apache.ignite.internal.network.handshake.HandshakeEventLoopSwitcher;
import org.apache.ignite.internal.network.ssl.SslContextProvider;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.schema.SchemaSyncService;
import org.apache.ignite.internal.security.authentication.AuthenticationManager;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.structure.IgniteStructures;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ClientHandlerModule
implements IgniteComponent,
PlatformComputeTransport {
    private static final IgniteLogger LOG = Loggers.forClass(ClientHandlerModule.class);
    private static final BitSet SUPPORTED_FEATURES = ProtocolBitmaskFeature.featuresAsBitSet(EnumSet.of(ProtocolBitmaskFeature.TABLE_GET_REQS_USE_QUALIFIED_NAME, new ProtocolBitmaskFeature[]{ProtocolBitmaskFeature.TX_DIRECT_MAPPING, ProtocolBitmaskFeature.PLATFORM_COMPUTE_JOB, ProtocolBitmaskFeature.COMPUTE_TASK_ID, ProtocolBitmaskFeature.STREAMER_RECEIVER_EXECUTION_OPTIONS, ProtocolBitmaskFeature.TX_DELAYED_ACKS, ProtocolBitmaskFeature.TX_PIGGYBACK, ProtocolBitmaskFeature.TX_ALLOW_NOOP_ENLIST, ProtocolBitmaskFeature.SQL_PARTITION_AWARENESS, ProtocolBitmaskFeature.SQL_DIRECT_TX_MAPPING, ProtocolBitmaskFeature.CQ_EVENT_TYPE, ProtocolBitmaskFeature.CQ_PARTITION_SCAN_STATUS, ProtocolBitmaskFeature.CQ_SKIP_OLD_ENTRIES}));
    private static final AtomicLong CONNECTION_ID_GEN = new AtomicLong();
    private final IgniteTablesInternal igniteTables;
    private final TxManager txManager;
    private final Supplier<ClusterInfo> clusterInfoSupplier;
    private final ClientHandlerMetricSource metrics;
    private final MetricManager metricManager;
    @Nullable
    private volatile Channel channel;
    private final QueryProcessor queryProcessor;
    private final IgniteComputeInternal igniteCompute;
    private final ClusterService clusterService;
    private final NettyBootstrapFactory bootstrapFactory;
    private final AuthenticationManager authenticationManager;
    private final Authorizer authorizer;
    private final ClockService clockService;
    private final SchemaSyncService schemaSyncService;
    private final CatalogService catalogService;
    private final ClientPrimaryReplicaTracker primaryReplicaTracker;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final ClientConnectorConfiguration clientConnectorConfiguration;
    private final Executor partitionOperationsExecutor;
    private final ConcurrentHashMap<String, CompletableFuture<PlatformComputeConnection>> computeExecutors = new ConcurrentHashMap();
    private final IgniteStructures structures;
    @TestOnly
    private volatile ClientInboundMessageHandler handler;

    public ClientHandlerModule(QueryProcessor queryProcessor, IgniteTablesInternal igniteTables, TxManager txManager, IgniteComputeInternal igniteCompute, ClusterService clusterService, NettyBootstrapFactory bootstrapFactory, Supplier<ClusterInfo> clusterInfoSupplier, MetricManager metricManager, ClientHandlerMetricSource metrics, AuthenticationManager authenticationManager, ClockService clockService, SchemaSyncService schemaSyncService, CatalogService catalogService, PlacementDriver placementDriver, ClientConnectorConfiguration clientConnectorConfiguration, LowWatermark lowWatermark, NodeProperties nodeProperties, Executor partitionOperationsExecutor, Authorizer authorizer, IgniteStructures structures) {
        assert (igniteTables != null);
        assert (queryProcessor != null);
        assert (txManager != null);
        assert (igniteCompute != null);
        assert (clusterService != null);
        assert (bootstrapFactory != null);
        assert (clusterInfoSupplier != null);
        assert (metricManager != null);
        assert (metrics != null);
        assert (authenticationManager != null);
        assert (clockService != null);
        assert (schemaSyncService != null);
        assert (catalogService != null);
        assert (placementDriver != null);
        assert (clientConnectorConfiguration != null);
        assert (lowWatermark != null);
        assert (nodeProperties != null);
        assert (partitionOperationsExecutor != null);
        assert (authorizer != null);
        this.queryProcessor = queryProcessor;
        this.igniteTables = igniteTables;
        this.txManager = txManager;
        this.igniteCompute = igniteCompute;
        this.clusterService = clusterService;
        this.bootstrapFactory = bootstrapFactory;
        this.clusterInfoSupplier = clusterInfoSupplier;
        this.metricManager = metricManager;
        this.metrics = metrics;
        this.authenticationManager = authenticationManager;
        this.clockService = clockService;
        this.schemaSyncService = schemaSyncService;
        this.catalogService = catalogService;
        this.primaryReplicaTracker = new ClientPrimaryReplicaTracker(placementDriver, catalogService, clockService, schemaSyncService, lowWatermark, nodeProperties);
        this.clientConnectorConfiguration = clientConnectorConfiguration;
        this.partitionOperationsExecutor = partitionOperationsExecutor;
        this.authorizer = authorizer;
        this.structures = structures;
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        if (this.channel != null) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "ClientHandlerModule is already started.");
        }
        ClientConnectorView configuration = (ClientConnectorView)this.clientConnectorConfiguration.value();
        this.metricManager.registerSource((MetricSource)this.metrics);
        if (configuration.metricsEnabled()) {
            this.metricManager.enable((MetricSource)this.metrics);
        }
        this.primaryReplicaTracker.start();
        return this.startEndpoint(configuration).thenAccept(ch -> {
            this.channel = ch;
        });
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        this.metricManager.unregisterSource((MetricSource)this.metrics);
        this.primaryReplicaTracker.stop();
        Channel ch = this.channel;
        if (ch != null) {
            try {
                ch.close().await();
            }
            catch (InterruptedException e) {
                return CompletableFuture.failedFuture(e);
            }
            this.channel = null;
        }
        return CompletableFutures.nullCompletedFuture();
    }

    public InetSocketAddress localAddress() {
        Channel ch = this.channel;
        if (ch == null) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "ClientHandlerModule has not been started");
        }
        return (InetSocketAddress)ch.localAddress();
    }

    public void enable() {
        Channel ch = this.channel;
        if (ch == null) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "ClientHandlerModule has not been started");
        }
        ch.config().setAutoRead(true);
    }

    private CompletableFuture<Channel> startEndpoint(final ClientConnectorView configuration) {
        ChannelFuture channelFuture;
        ServerBootstrap bootstrap = this.bootstrapFactory.createServerBootstrap();
        CompletableFuture<Channel> result = new CompletableFuture<Channel>();
        final SslContext sslContext = configuration.ssl().enabled() ? SslContextProvider.createServerSslContext((SslView)configuration.ssl()) : null;
        ((ServerBootstrap)bootstrap.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void initChannel(Channel ch) {
                if (!ClientHandlerModule.this.busyLock.enterBusy()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Client handler stopped, dropping client connection [remoteAddress=" + ch.remoteAddress() + "]", new Object[0]);
                    }
                    ch.close();
                    return;
                }
                long connectionId = CONNECTION_ID_GEN.incrementAndGet();
                try {
                    ClientInboundMessageHandler messageHandler;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("New client connection [connectionId=" + connectionId + ", remoteAddress=" + ch.remoteAddress() + "]", new Object[0]);
                    }
                    if (configuration.idleTimeoutMillis() > 0L) {
                        IdleStateHandler idleStateHandler = new IdleStateHandler(configuration.idleTimeoutMillis(), 0L, 0L, TimeUnit.MILLISECONDS);
                        ch.pipeline().addLast(new ChannelHandler[]{idleStateHandler});
                        ch.pipeline().addLast(new ChannelHandler[]{new IdleChannelHandler(configuration.idleTimeoutMillis(), ClientHandlerModule.this.metrics, connectionId)});
                    }
                    if (sslContext != null) {
                        ch.pipeline().addFirst("ssl", (ChannelHandler)sslContext.newHandler(ch.alloc()));
                    }
                    ClientHandlerModule.this.handler = messageHandler = ClientHandlerModule.this.createInboundMessageHandler(ClientHandlerModule.this.bootstrapFactory.handshakeEventLoopSwitcher(), configuration, connectionId);
                    ch.pipeline().addLast(new ChannelHandler[]{new FlushConsolidationHandler(256, true), new ClientMessageDecoder(), messageHandler});
                    ClientHandlerModule.this.metrics.connectionsInitiatedIncrement();
                }
                catch (Throwable t) {
                    LOG.error("Failed to initialize client connection [connectionId=" + connectionId + ", remoteAddress=" + ch.remoteAddress() + "]:" + t.getMessage(), t);
                    ch.close();
                }
                finally {
                    ClientHandlerModule.this.busyLock.leaveBusy();
                }
            }
        }).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)configuration.connectTimeoutMillis())).option(ChannelOption.AUTO_READ, (Object)false);
        int port = configuration.port();
        String[] addresses = configuration.listenAddresses();
        if (addresses.length == 0) {
            channelFuture = bootstrap.bind(port);
        } else {
            if (addresses.length > 1) {
                throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Only one listen address is allowed for now, but got " + List.of(addresses));
            }
            channelFuture = bootstrap.bind(addresses[0], port);
        }
        channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)bindFut -> {
            if (bindFut.isSuccess()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Thin client connector endpoint started successfully [{}]", new Object[]{(String)(addresses.length == 0 ? "" : "address=" + addresses[0] + ",") + "port=" + port});
                }
                result.complete(bindFut.channel());
            } else if (bindFut.cause() instanceof BindException) {
                String address = addresses.length == 0 ? "" : addresses[0];
                result.completeExceptionally((Throwable)new IgniteException(ErrorGroups.Network.BIND_ERR, "Cannot start thin client connector endpoint at address=" + address + ", port=" + port, bindFut.cause()));
            } else if (bindFut.cause() instanceof UnresolvedAddressException) {
                result.completeExceptionally((Throwable)new IgniteException(ErrorGroups.Network.ADDRESS_UNRESOLVED_ERR, "Failed to start thin connector endpoint, unresolved socket address \"" + addresses[0] + "\"", bindFut.cause()));
            } else {
                result.completeExceptionally((Throwable)new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Failed to start thin client connector endpoint: " + bindFut.cause().getMessage(), bindFut.cause()));
            }
        }));
        return result;
    }

    private ClientInboundMessageHandler createInboundMessageHandler(HandshakeEventLoopSwitcher handshakeEventLoopSwitcher, ClientConnectorView configuration, long connectionId) {
        return new ClientInboundMessageHandler(this.igniteTables, this.txManager, this.queryProcessor, configuration, this.igniteCompute, this.clusterService, this.clusterInfoSupplier, this.metrics, this.authenticationManager, this.clockService, this.schemaSyncService, this.catalogService, connectionId, this.primaryReplicaTracker, this.partitionOperationsExecutor, SUPPORTED_FEATURES, Map.of(), this.authorizer, this.computeExecutors::remove, this.structures, handshakeEventLoopSwitcher);
    }

    @TestOnly
    public ClientInboundMessageHandler handler() {
        return this.handler;
    }

    public String serverAddress() {
        return "127.0.0.1:" + this.localAddress().getPort();
    }

    public boolean sslEnabled() {
        return ((ClientConnectorView)this.clientConnectorConfiguration.value()).ssl().enabled();
    }

    public CompletableFuture<PlatformComputeConnection> registerComputeExecutorId(String computeExecutorId) {
        return this.computeExecutors.computeIfAbsent(computeExecutorId, k -> new CompletableFuture());
    }
}

